/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.skins;

import edu.xtec.util.ExtendedJDialog;
import edu.xtec.util.Html;
import edu.xtec.util.Messages;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class AboutWindow
extends ExtendedJDialog
implements HyperlinkListener {
    protected ResourceBridge rb;
    protected JTabbedPane tPane;
    private static URL urlBase;

    public AboutWindow(Component parent, ResourceBridge rb, Dimension setSize) {
        super(parent, rb.getMsg("about_window_caption"), true);
        this.rb = rb;
        JPanel mainPane = new JPanel();
        mainPane.setLayout(new BorderLayout());
        mainPane.setPreferredSize(setSize);
        this.tPane = new JTabbedPane();
        mainPane.add((Component)this.tPane, "Center");
        JPanel btPanel = new JPanel();
        btPanel.setLayout(new GridLayout(1, 2));
        JButton btClose = new JButton(rb.getMsg("about_window_close_button"), ResourceManager.getImageIcon("icons/exit_small.gif"));
        btClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutWindow.this.setVisible(false);
            }
        });
        btPanel.add(btClose);
        mainPane.add((Component)btPanel, "South");
        this.getContentPane().add(mainPane);
        this.pack();
        this.centerOver(parent);
    }

    public JTabbedPane getTabbedPane() {
        return this.tPane;
    }

    public void addUrlDocumentTab(URL url, String tabTitle, Icon icon) {
        try {
            final JEditorPane ep = new JEditorPane(url);
            ep.setEditable(false);
            ep.addHyperlinkListener(this);
            this.tPane.addTab(tabTitle, icon, new JScrollPane(ep));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ep.scrollRectToVisible(new Rectangle(0, 0));
                }
            });
        }
        catch (IOException ex) {
            System.err.println("Error building about window:\n" + ex);
            this.tPane.addTab(tabTitle, new JLabel("ERROR"));
        }
    }

    public void addStrDocumentTab(String src, String tabTitle, URL base, Icon icon) {
        final JEditorPane ep = new JEditorPane();
        ep.setEditorKit(ep.getEditorKitForContentType("text/html"));
        if (base == null) {
            base = AboutWindow.getAboutUrlBase();
        }
        if (base != null) {
            ((HTMLDocument)ep.getDocument()).setBase(base);
        }
        ep.setText(src);
        ep.setEditable(false);
        ep.addHyperlinkListener(this);
        this.tPane.addTab(tabTitle, icon, new JScrollPane(ep));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ep.scrollRectToVisible(new Rectangle(0, 0));
            }
        });
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            final String sUrl = e.getURL().toString();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AboutWindow.this.rb.displayUrl(sUrl, true);
                }
            });
        }
    }

    public static URL getAboutUrlBase() {
        if (urlBase == null) {
            try {
                URL rootDocUrl = ResourceManager.getResource("about/about.html");
                String s = rootDocUrl.toString();
                urlBase = new URL(s.substring(0, s.lastIndexOf(47) + 1));
            }
            catch (Exception ex) {
                System.err.println("Resource missing: about.html");
            }
        }
        return urlBase;
    }

    public void buildAboutTab(String appName, String appVersion, String logoIcon, String creditsDoc, String otherCreditsDoc, String licenseDoc, String sponsorsDoc) throws Exception {
        String doc = ResourceManager.getResourceText("about/about.html", false);
        if (appName == null) {
            appName = "JClic";
        }
        if (logoIcon == null) {
            logoIcon = "logo_small.png";
        }
        if (creditsDoc == null) {
            creditsDoc = "about/credits.html";
        }
        String credits = ResourceManager.getResourceText(creditsDoc, false);
        String translationCredits = this.rb.getMsg("html_translation_credits");
        if (otherCreditsDoc == null) {
            otherCreditsDoc = this.rb.getMsg("about_otherCreditsDoc");
        }
        String otherCredits = ResourceManager.getResourceText(otherCreditsDoc, false);
        String license = this.rb.getMsg("html_gpl_license");
        if (licenseDoc != null) {
            license = ResourceManager.getResourceText(licenseDoc, false);
        }
        if (sponsorsDoc == null) {
            sponsorsDoc = this.rb.getMsg("about_sponsorsDoc");
        }
        String sponsors = ResourceManager.getResourceText(sponsorsDoc, false);
        URL iconUrl = ResourceManager.getResource("about/" + logoIcon);
        doc = StrUtils.replace(doc, "%LOGO", iconUrl.toExternalForm());
        StringBuilder sb = new StringBuilder(appName);
        if (appVersion != null) {
            sb.append(" ").append(this.rb.getMsg("VERSION")).append(" ").append(appVersion);
        }
        doc = StrUtils.replace(doc, "%APPVERSION", sb.substring(0));
        doc = StrUtils.replace(doc, "%CREDITS", credits);
        doc = StrUtils.replace(doc, "%TRANSLATION", translationCredits);
        sb.setLength(0);
        sb.append(this.rb.getMsg("about_otherCreditsCaption")).append("<BR>&nbsp;<BR>").append(otherCredits);
        doc = StrUtils.replace(doc, "%OTHERCREDITS", sb.substring(0));
        doc = StrUtils.replace(doc, "%LICENSE", license);
        sb.setLength(0);
        if (sponsors != null && sponsors.length() > 0) {
            sb.append(this.rb.getMsg("about_sponsorsCaption")).append("<BR>").append(sponsors);
        }
        doc = StrUtils.replace(doc, "%SPONSORS", sb.substring(0));
        this.addStrDocumentTab(doc, this.rb.getMsg("ABOUT"), AboutWindow.getAboutUrlBase(), ResourceManager.getImageIcon("icons/about_small.gif"));
    }

    public void buildStandardTab(String htmlContent, String titleKey, String labelKey, String icon) {
        String htmlBgColor = this.rb.getMsg("about_window_html_bgcolor");
        String htmlStyle = this.rb.getMsg("about_window_html_style");
        String header = this.rb.getMsg("about_window_html_header");
        StringBuilder sb = new StringBuilder(4096);
        sb.append(header);
        if (titleKey != null) {
            sb.append("<br><b>").append(this.rb.getMsg(titleKey)).append("</b><hr>");
        }
        sb.append(htmlContent);
        String s = Html.table(sb.substring(0), "100%", 0, 5, -1, htmlStyle, true);
        this.addStrDocumentTab(Html.getHtmlDoc(s, htmlBgColor), this.rb.getMsg(labelKey), AboutWindow.getAboutUrlBase(), ResourceManager.getImageIcon(icon));
    }

    public String getHtmlSystemInfo() {
        Messages msg = this.rb.getOptions().getMessages();
        Html html = new Html(3000);
        html.doubleCell(msg.get("about_window_lb_os"), true, System.getProperty("os.name") + " " + System.getProperty("os.version") + " - " + System.getProperty("os.arch"), false);
        html.doubleCell(msg.get("about_window_lb_java_version"), true, System.getProperty("java.version"), false);
        html.doubleCell(msg.get("about_window_lb_java_vm"), true, System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + "\n" + System.getProperty("java.vm.vendor"), false);
        html.doubleCell(msg.get("about_window_lb_java_home"), true, System.getProperty("java.home"), false);
        html.doubleCell(msg.get("about_window_lb_free_mem"), true, msg.kValue(Runtime.getRuntime().freeMemory()), false);
        html.doubleCell(msg.get("about_window_lb_total_mem"), true, msg.kValue(Runtime.getRuntime().totalMemory()), false);
        Object o = this.rb.getOptions().get("mediaSystem");
        String s = "Java Media Framework".equals(o) ? "Java Media Framework" : ("QuickTime 6.1".equals(o) ? "QuickTime for Java 6.1+" : "-");
        html.doubleCell(msg.get("about_window_lb_mediaSystem"), true, s, false);
        if (this.rb.getOptions().getBoolean("trace")) {
            for (String string : System.getProperties().keySet()) {
                html.doubleCell(string, true, System.getProperty(string), false);
            }
        }
        return Html.table(html.toString(), null, 0, 5, -1, null, false);
    }
}

