/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.BrowserLauncher;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class Check {
    private static final String DLG_KEY = "CHECK_DIALOG";

    private Check() {
    }

    public static void showUrlPane(final Options options, String urlKey) {
        JScrollPane scroll;
        final Messages msg = options.getMessages();
        HyperlinkListener hlst = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    final URL sUrl = e.getURL();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (options.getApplet() != null) {
                                    options.getApplet().getAppletContext().showDocument(sUrl);
                                } else {
                                    BrowserLauncher.openURL(sUrl.toExternalForm());
                                }
                            }
                            catch (Exception ex) {
                                msg.showErrorWarning((JDialog)options.get(Check.DLG_KEY), "URL_LAUNCH_ERROR", ex);
                            }
                        }
                    });
                }
            }
        };
        try {
            URL url = ResourceManager.getResource(msg.get(urlKey));
            JEditorPane ep = new JEditorPane(url);
            ep.setEditable(false);
            ep.addHyperlinkListener(hlst);
            scroll = new JScrollPane(ep);
            scroll.setPreferredSize(new Dimension(500, 400));
        }
        catch (Exception ex) {
            msg.showErrorWarning(options.getMainComponent(), "URL_ERROR", ex);
            return;
        }
        JOptionPane pane = new JOptionPane(new Object[]{scroll}, 2);
        JDialog dialog = pane.createDialog(options.getMainComponent(), msg.get("WARNING"));
        options.put(DLG_KEY, dialog);
        dialog.setVisible(true);
        options.remove(DLG_KEY);
    }

    public static boolean checkSignature(Options options, boolean showWarning) {
        boolean result;
        block2: {
            result = false;
            try {
                System.getProperty("java.class.path");
                result = true;
            }
            catch (SecurityException ex) {
                if (!showWarning) break block2;
                Check.showUrlPane(options, "CHECK_SIGNATURE_URL");
            }
        }
        return result;
    }
}

