/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class CustomListCellRenderer
extends JLabel
implements ListCellRenderer {
    protected String[] labels = null;
    protected Icon[] icons = null;

    public CustomListCellRenderer() {
        this(null, null);
    }

    public CustomListCellRenderer(String[] labels, Icon[] icons) {
        this.setObjects(labels, icons);
        this.setOpaque(true);
        if (labels == null) {
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }
        this.setHorizontalAlignment(2);
    }

    public void setObjects(String[] labels, Icon[] icons) {
        this.labels = labels;
        this.icons = icons;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        String s = "";
        if (value instanceof String) {
            s = (String)value;
        } else if (this.labels != null && index >= 0 && index < this.labels.length) {
            s = this.labels[index];
        }
        Icon icon = null;
        if (value instanceof Icon) {
            icon = (Icon)value;
        } else if (this.icons != null && index >= 0 && index < this.icons.length) {
            icon = this.icons[index];
        } else if (this.icons != null && this.labels != null && index < 0 && value != null) {
            for (int i = 0; i < this.labels.length; ++i) {
                if (!value.equals(this.labels[i])) continue;
                if (i >= this.icons.length) break;
                icon = this.icons[i];
                break;
            }
        }
        this.setText(s);
        this.setIcon(icon);
        return this;
    }
}

