/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util.db;

import edu.xtec.util.db.ConnectionBean;
import edu.xtec.util.db.ConnectionBeanProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Date;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class JNDIConnectionBeanProvider
extends ConnectionBeanProvider {
    public static final String DB_CONTEXT = "dbContext";
    public static final String JNDI = "JNDI";
    protected DataSource ds;
    protected String dbContext;
    private int totalCBRequests;
    private Date started;
    private Date lastUse;
    private String logFileString;
    private PrintWriter log;
    private int debugLevel;
    private int totalStatements;
    private String lastRequest;

    @Override
    protected void setUp(Map<String, String> map) throws Exception {
        super.setUp(map);
        this.started = new Date();
        this.dbDriver = JNDI;
        if (this.dbServer == null) {
            throw new Exception("JNDI datasource name not specified!");
        }
        this.dbContext = this.getValue(map, DB_CONTEXT, null);
        this.debugLevel = Integer.parseInt(this.getValue(map, "dbDebugLevel", "2"));
        if (this.debugLevel > 0) {
            try {
                this.logFileString = this.getValue(map, "dbLogFile", null);
                if (this.logFileString != null) {
                    File f = new File(this.logFileString);
                    if (!f.isAbsolute()) {
                        f = new File(System.getProperty("user.home"));
                        f = new File(f, this.logFileString);
                        this.logFileString = f.getAbsolutePath();
                    }
                    boolean logAppend = Boolean.valueOf(this.getValue(map, "dbLogAppend", "true"));
                    this.log = new PrintWriter(new FileOutputStream(this.logFileString, logAppend), true);
                }
            }
            catch (IOException ioex) {
                System.err.println(new Date().toString() + " - Error creating log file for JNDIConnectionProvider - " + ioex);
            }
        }
        Context ctx = new InitialContext();
        if (this.dbContext != null && this.dbContext.trim().length() > 0) {
            ctx = (Context)ctx.lookup(this.dbContext);
        }
        this.ds = (DataSource)ctx.lookup(this.dbServer);
        if (this.log != null) {
            this.log.println("-----------------------------------------");
            this.log.println(this.started);
            this.log.println("Starting JNDIConnectionBeanProvider");
            this.log.println("dbContext = " + this.dbContext);
            this.log.println("dbServer = " + this.dbServer);
            this.log.println("Context = " + ctx);
            this.log.println("Datasource = " + this.ds);
            this.log.println("-----------------------------------------");
        }
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("<b>JNDIConnectionBeanProvider ").append(this.hashCode()).append("</b><br>\n");
        sb.append(super.getInfo());
        sb.append("started: ").append(this.started).append("<br>\n");
        sb.append("dbContext: ").append(this.dbContext).append("<br>\n");
        sb.append("Total requests: ").append(this.totalCBRequests).append("<br>\n");
        sb.append("Total statements: ").append(this.totalStatements).append("<br>\n");
        sb.append("Last use: ").append(this.lastUse).append("<br>\n");
        sb.append("Last request: ").append(this.lastRequest).append("<br>\n");
        return sb.toString();
    }

    @Override
    protected void destroy() {
    }

    @Override
    public String freeConnectionBean(ConnectionBean conn) {
        block3: {
            if (conn != null) {
                try {
                    this.lastRequest = conn.getLastStatement();
                    this.totalStatements += conn.getNumStatements();
                    conn.closeConnection();
                }
                catch (Exception ex) {
                    if (this.log == null) break block3;
                    this.log.println(new Date().toString() + " Unable to close DB connection: " + ex);
                }
            }
        }
        return "";
    }

    @Override
    public ConnectionBean getConnectionBean() {
        ConnectionBean result;
        block4: {
            result = null;
            try {
                if (this.ds != null) {
                    Connection con = this.ds.getConnection();
                    result = new ConnectionBean(con, this.mapStatements);
                    ++this.totalCBRequests;
                    this.lastUse = new Date();
                }
                if (this.log != null && this.debugLevel > 2) {
                    this.log.println(new Date().toString() + " - connection request");
                }
            }
            catch (Exception ex) {
                if (this.log == null) break block4;
                this.log.println(new Date().toString() + " Unable to get DB connection: " + ex.getMessage());
            }
        }
        return result;
    }
}

