/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util.db;

import edu.xtec.util.db.ConnectionBean;
import edu.xtec.util.db.ConnectionBeanProvider;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class PooledConnectionBeanProvider
extends ConnectionBeanProvider
implements Runnable {
    public static final String MIN_CONNS = "dbMinConns";
    private static final String DEFAULT_MIN_CONNS = "1";
    public static final String MAX_CONNS = "dbMaxConns";
    private static final String DEFAULT_MAX_CONNS = "3";
    public static final String LOG_FILE = "dbLogFile";
    private static final String DEFAULT_LOG_FILE = "connectionPool.log";
    public static final String MAX_CONN_TIME = "dbMaxConnDays";
    private static final String DEFAULT_MAX_CONN_TIME = "1.0";
    public static final String LOG_APPEND = "dbLogAppend";
    private static final String DEFAULT_LOG_APPEND = "true";
    public static final String MAX_CHECKOUT_SECONDS = "dbMaxCheckoutSeconds";
    private static final String DEFAULT_MAX_CHECKOUT_SECONDS = "60";
    public static final String DEBUG_LEVEL = "dbDebugLevel";
    private static final String DEFAULT_DEBUG_LEVEL = "2";
    private Thread runner;
    private ConnectionBean[] connPool;
    private int[] connStatus;
    private long[] connLockTime;
    private long[] connCreateDate;
    private String[] connID;
    private String logFileString;
    private String logPIDFileString;
    private int currConnections;
    private int connLast;
    private int minConns;
    private int maxConns;
    private int maxConnMSec;
    private int maxCheckoutSeconds;
    private int debugLevel;
    private boolean available = true;
    private PrintWriter log;
    private SQLWarning currSQLWarning;
    private String pid;
    public int globalUsageCount;

    @Override
    protected void setUp(Map<String, String> map) throws Exception {
        super.setUp(map);
        if (this.dbDriver == null || this.dbDriver.length() == 0) {
            throw new Exception("Parameter dbDriver is null!");
        }
        Class.forName(this.dbDriver);
        if (this.dbServer == null || this.dbServer.length() == 0) {
            throw new Exception("Parameter dbServer is null!");
        }
        this.minConns = Math.max(1, Integer.parseInt(this.getValue(map, MIN_CONNS, DEFAULT_MIN_CONNS)));
        this.maxConns = Math.max(this.minConns, Math.min(15, Integer.parseInt(this.getValue(map, MAX_CONNS, DEFAULT_MAX_CONNS))));
        this.logFileString = this.getValue(map, LOG_FILE, DEFAULT_LOG_FILE);
        double maxConnTime = new Double(this.getValue(map, MAX_CONN_TIME, DEFAULT_MAX_CONN_TIME));
        boolean logAppend = Boolean.valueOf(this.getValue(map, LOG_APPEND, DEFAULT_LOG_APPEND));
        this.maxCheckoutSeconds = Integer.parseInt(this.getValue(map, MAX_CHECKOUT_SECONDS, DEFAULT_MAX_CHECKOUT_SECONDS));
        this.debugLevel = Integer.parseInt(this.getValue(map, DEBUG_LEVEL, DEFAULT_DEBUG_LEVEL));
        this.connPool = new ConnectionBean[this.maxConns];
        this.connStatus = new int[this.maxConns];
        this.connLockTime = new long[this.maxConns];
        this.connCreateDate = new long[this.maxConns];
        this.connID = new String[this.maxConns];
        this.currConnections = this.minConns;
        File f = new File(this.logFileString);
        if (!f.isAbsolute()) {
            f = new File(System.getProperty("user.home"));
            f = new File(f, this.logFileString);
            this.logFileString = f.getAbsolutePath();
        }
        this.logPIDFileString = this.logFileString + ".pid";
        this.maxConnMSec = (int)(maxConnTime * 8.64E7);
        if (this.maxConnMSec < 30000) {
            this.maxConnMSec = 30000;
        }
        if (this.debugLevel > 0) {
            try {
                this.log = new PrintWriter(new FileOutputStream(this.logFileString, logAppend), true);
            }
            catch (IOException e1) {
                try {
                    this.log = new PrintWriter(new FileOutputStream("DBConn_" + System.currentTimeMillis() + ".log", logAppend), true);
                }
                catch (IOException e2) {
                    throw new IOException("Can't open any log file");
                }
            }
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd G 'at' hh:mm:ss a zzz");
        Date nowc = new Date();
        this.pid = formatter.format(nowc);
        BufferedWriter pidout = new BufferedWriter(new FileWriter(this.logPIDFileString));
        pidout.write(this.pid);
        pidout.close();
        if (this.log != null) {
            this.log.println("-----------------------------------------");
            this.log.println(new Date());
            this.log.println("Starting DbConnectionBeanBroker Version 1.0.13:");
            this.log.println("dbDriver = " + this.dbDriver);
            this.log.println("dbServer = " + this.dbServer);
            this.log.println("dbLogin = " + this.dbLogin);
            this.log.println("log file = " + this.logFileString);
            this.log.println("minconnections = " + this.minConns);
            this.log.println("maxconnections = " + this.maxConns);
            this.log.println("Total refresh interval = " + maxConnTime + " days");
            this.log.println("logAppend = " + logAppend);
            this.log.println("maxCheckoutSeconds = " + this.maxCheckoutSeconds);
            this.log.println("debugLevel = " + this.debugLevel);
            this.log.println("mapStatements = " + this.mapStatements);
            this.log.println("-----------------------------------------");
        }
        boolean connectionsSucceeded = false;
        Exception sqlEx = null;
        int dbLoop = 3;
        for (int i = 1; i < dbLoop; ++i) {
            try {
                for (int j = 0; j < this.currConnections; ++j) {
                    this.createConn(j);
                }
                connectionsSucceeded = true;
                break;
            }
            catch (SQLException e) {
                sqlEx = e;
                if (this.log != null && this.debugLevel > 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(new Date()).append(" ->Attempt (").append(i);
                    sb.append(" of ").append(dbLoop).append(") failed to create new connections set at startup:\n");
                    sb.append(e).append("\n");
                    sb.append("Will try again in 15 seconds...");
                    this.log.println(sb.substring(0));
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (!connectionsSucceeded) {
            if (this.log != null && this.debugLevel > 0) {
                this.log.println("\r\nAll attempts at connecting to Database exhausted");
            }
            if (sqlEx == null) {
                sqlEx = new IOException("Unable to connect to Database");
            }
            throw sqlEx;
        }
        this.runner = new Thread(this);
        this.runner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        boolean forever = true;
        Statement stmt = null;
        Object currCatalog = null;
        long maxCheckoutMillis = this.maxCheckoutSeconds * 1000;
        while (forever) {
            int i;
            for (i = 0; i < this.currConnections; ++i) {
                try {
                    this.currSQLWarning = this.connPool[i].getConnection().getWarnings();
                    if (this.currSQLWarning == null) continue;
                    if (this.log != null && this.debugLevel > 1) {
                        this.log.println(new Date().toString() + " - Warnings on connection " + String.valueOf(i) + " " + this.currSQLWarning);
                    }
                    this.connPool[i].getConnection().clearWarnings();
                    continue;
                }
                catch (SQLException e) {
                    if (this.log == null || this.debugLevel <= 1) continue;
                    this.log.println("Cannot access Warnings: " + e);
                }
            }
            for (i = 0; i < this.currConnections; ++i) {
                long age = System.currentTimeMillis() - this.connCreateDate[i];
                try {
                    int[] nArray = this.connStatus;
                    // MONITORENTER : this.connStatus
                    if (this.connStatus[i] > 0) {
                        long timeInUse = System.currentTimeMillis() - this.connLockTime[i];
                        if (this.log != null && this.debugLevel > 2) {
                            this.log.println(new Date().toString() + " - Warning. Connection " + i + " in use for " + timeInUse + " ms");
                        }
                        if (maxCheckoutMillis != 0L && timeInUse > maxCheckoutMillis) {
                            if (this.log == null) throw new SQLException();
                            if (this.debugLevel <= 1) throw new SQLException();
                            this.log.println(new Date().toString() + " Warning. Connection " + i + " failed to be returned in time.  Recycling...");
                            throw new SQLException();
                        }
                        // MONITOREXIT : nArray
                        continue;
                    }
                    this.connStatus[i] = 2;
                    // MONITOREXIT : nArray
                    if (age > (long)this.maxConnMSec) {
                        throw new SQLException();
                    }
                    stmt = this.connPool[i].getConnection().createStatement();
                    this.connStatus[i] = 0;
                    if (!this.connPool[i].getConnection().isClosed()) continue;
                    throw new SQLException();
                }
                catch (SQLException e) {
                    block36: {
                        if (this.log != null && this.debugLevel > 1) {
                            this.log.println(new Date().toString() + " ***** Recycling connection " + String.valueOf(i) + ":");
                        }
                        try {
                            this.connPool[i].closeConnection();
                        }
                        catch (SQLException e0) {
                            if (this.log == null || this.debugLevel <= 0) break block36;
                            this.log.println(new Date().toString() + " - Error! Can't close connection! Might have been closed already. Trying to recycle anyway... (" + e0 + ")");
                        }
                    }
                    try {
                        this.createConn(i);
                    }
                    catch (SQLException e1) {
                        if (this.log != null && this.debugLevel > 0) {
                            this.log.println(new Date().toString() + " - Failed to create connection: " + e1);
                        }
                        this.connStatus[i] = 0;
                    }
                    continue;
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e1) {
                        System.err.println(e1.getMessage());
                    }
                }
            }
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public ConnectionBean getConnectionBean() {
        ConnectionBean conn = null;
        if (!this.available) {
            if (this.log != null && this.debugLevel > 0) {
                this.log.println(new Date().toString() + " - Unsuccessful getConnection() request during destroy()");
            }
        } else {
            boolean gotOne = false;
            for (int outerloop = 1; outerloop <= 10; ++outerloop) {
                block21: {
                    block20: {
                        try {
                            int loop = 0;
                            int roundRobin = this.connLast + 1;
                            if (roundRobin >= this.currConnections) {
                                roundRobin = 0;
                            }
                            do {
                                int[] nArray = this.connStatus;
                                // MONITORENTER : this.connStatus
                                if (this.connStatus[roundRobin] < 1 && !this.connPool[roundRobin].getConnection().isClosed()) {
                                    conn = this.connPool[roundRobin];
                                    this.connStatus[roundRobin] = 1;
                                    this.connLockTime[roundRobin] = System.currentTimeMillis();
                                    this.connLast = roundRobin;
                                    gotOne = true;
                                    // MONITOREXIT : nArray
                                    break;
                                }
                                ++loop;
                                if (++roundRobin >= this.currConnections) {
                                    roundRobin = 0;
                                }
                                // MONITOREXIT : nArray
                            } while (!gotOne && loop < this.currConnections);
                        }
                        catch (SQLException e1) {
                            if (this.log == null) break block20;
                            this.log.println(new Date().toString() + " - Error: " + e1);
                        }
                    }
                    if (gotOne) break;
                    PooledConnectionBeanProvider pooledConnectionBeanProvider = this;
                    // MONITORENTER : pooledConnectionBeanProvider
                    if (this.currConnections < this.maxConns) {
                        try {
                            this.createConn(this.currConnections);
                            ++this.currConnections;
                        }
                        catch (SQLException e) {
                            if (this.log == null || this.debugLevel <= 0) break block21;
                            this.log.println(new Date().toString() + " - Error: Unable to create new connection: " + e);
                        }
                    }
                }
                // MONITOREXIT : pooledConnectionBeanProvider
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.log == null || this.debugLevel <= 0) continue;
                this.log.println(new Date().toString() + " --> Connections Exhausted!  Will wait and try again in loop " + String.valueOf(outerloop));
            }
        }
        if (this.log != null && this.debugLevel > 2) {
            this.log.println(new Date().toString() + " - Handing out connection " + this.idOfConnection(conn));
        }
        if (conn == null) return conn;
        ++conn.usageCount;
        return conn;
    }

    public int idOfConnection(ConnectionBean conn) {
        String tag;
        try {
            tag = conn.getConnection().toString();
        }
        catch (NullPointerException e1) {
            tag = "none";
        }
        int match = -1;
        for (int i = 0; i < this.currConnections; ++i) {
            if (!this.connID[i].equals(tag)) continue;
            match = i;
            break;
        }
        return match;
    }

    @Override
    public String freeConnectionBean(ConnectionBean conn) {
        StringBuilder res = new StringBuilder();
        int thisconn = this.idOfConnection(conn);
        if (thisconn >= 0) {
            this.connStatus[thisconn] = 0;
            res.append("freed ").append(conn.getConnection().toString());
        } else if (this.log != null && this.debugLevel > 0) {
            this.log.println(new Date().toString() + " --> Error: Could not free connection!!!");
        }
        return res.substring(0);
    }

    public long getAge(ConnectionBean conn) {
        int thisconn = this.idOfConnection(conn);
        return System.currentTimeMillis() - this.connLockTime[thisconn];
    }

    private void createConn(int i) throws SQLException {
        Date now;
        block4: {
            if (this.connPool[i] != null) {
                this.globalUsageCount += this.connPool[i].usageCount;
            }
            now = new Date();
            try {
                Class.forName(this.dbDriver);
                this.connPool[i] = new ConnectionBean(DriverManager.getConnection(this.dbServer, this.dbLogin, this.dbPassword), this.mapStatements);
                this.connStatus[i] = 0;
                this.connID[i] = this.connPool[i].getConnection().toString();
                this.connLockTime[i] = 0L;
                this.connCreateDate[i] = now.getTime();
            }
            catch (ClassNotFoundException e2) {
                if (this.log == null || this.debugLevel <= 0) break block4;
                this.log.println(now.toString() + " - Error creating connection: " + e2);
            }
        }
        if (this.log != null) {
            this.log.println(now.toString() + "  Opening connection " + String.valueOf(i) + " " + this.connPool[i].getConnection().toString() + ":");
        }
    }

    public void destroy(int millis) throws SQLException {
        int useCount;
        this.available = false;
        this.runner.interrupt();
        try {
            this.runner.join(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long startTime = System.currentTimeMillis();
        while ((useCount = this.getUseCount()) > 0 && System.currentTimeMillis() - startTime <= (long)millis) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (int i = 0; i < this.currConnections; ++i) {
            try {
                this.connPool[i].closeConnection();
                continue;
            }
            catch (SQLException e1) {
                if (this.log == null || this.debugLevel <= 0) continue;
                this.log.println(new Date().toString() + " - Cannot close connections on Destroy");
            }
        }
        if (useCount > 0) {
            String msg = new Date().toString() + " - Unsafe shutdown: Had to close " + useCount + " active DB connections after " + millis + "ms";
            if (this.log != null) {
                this.log.println(msg);
                this.log.close();
            }
            throw new SQLException(msg);
        }
        if (this.log != null) {
            this.log.close();
        }
    }

    @Override
    protected void destroy() {
        try {
            this.destroy(10000);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUseCount() {
        int useCount = 0;
        int[] nArray = this.connStatus;
        synchronized (this.connStatus) {
            for (int i = 0; i < this.currConnections; ++i) {
                if (this.connStatus[i] <= 0) continue;
                ++useCount;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return useCount;
        }
    }

    public int getSize() {
        return this.currConnections;
    }

    @Override
    public String getInfo() {
        int totalUsageCount = this.globalUsageCount;
        StringBuilder sb = new StringBuilder();
        sb.append("<b>PooledConnectionBeanProvider ").append(this.hashCode()).append("</b><br>\n").append(super.getInfo()).append("PID: ").append(this.pid).append("<br>\n").append("LogFileString: ").append(this.logFileString).append("<br>\n").append("currConnections: ").append(this.currConnections).append("<br>\n").append("connLast: ").append(this.connLast).append("<br>\n").append("minConns: ").append(this.minConns).append("<br>\n").append("maxConns: ").append(this.maxConns).append("<br>\n").append("maxConnMSec: ").append(this.maxConnMSec).append("<br>\n").append("maxCheckoutSeconds: ").append(this.maxCheckoutSeconds).append("<br>\n").append("debugLevel: ").append(this.debugLevel).append("<br>\n").append("CURRENT CONNECTIONS:<br>\n").append("<hr>\n");
        for (int i = 0; i < this.maxConns; ++i) {
            ConnectionBean cb = this.connPool[i];
            if (cb == null) {
                sb.append("Empty ConnectionBean<br>\n");
            } else {
                sb.append("Id: ").append(this.connID[i]).append("<br>\n").append("Status: ").append(this.connStatus[i]).append("<br>\n").append("LockTime: ").append(this.connLockTime[i]).append("<br>\n").append("CreateDate: ").append(new Date(this.connCreateDate[i])).append("<br>\n").append("------------\n").append(cb.getInfo());
                totalUsageCount += cb.usageCount;
            }
            sb.append("<hr>\n");
        }
        sb.append("TOTAL STATEMENTS USED: ").append(totalUsageCount).append("<br>\n");
        return sb.substring(0);
    }
}

