/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class IllegalAddException
extends IllegalArgumentException {
    private static final String CVS_ID = "@(#) $RCSfile: IllegalAddException.java,v $ $Revision: 1.2 $ $Date: 2013-09-20 15:11:33 $ $Name:  $";

    IllegalAddException(Element base, Attribute added, String reason) {
        super(new StringBuilder().append("The attribute \"").append(added.getQualifiedName()).append("\" could not be added to the element \"").append(base.getQualifiedName()).append("\": ").append(reason).substring(0));
    }

    IllegalAddException(Element base, Element added, String reason) {
        super(new StringBuilder().append("The element \"").append(added.getQualifiedName()).append("\" could not be added as a child of \"").append(base.getQualifiedName()).append("\": ").append(reason).substring(0));
    }

    IllegalAddException(Element added, String reason) {
        super(new StringBuilder().append("The element \"").append(added.getQualifiedName()).append("\" could not be added as the root of the document: ").append(reason).substring(0));
    }

    IllegalAddException(Element base, ProcessingInstruction added, String reason) {
        super(new StringBuilder().append("The PI \"").append(added.getTarget()).append("\" could not be added as content to \"").append(base.getQualifiedName()).append("\": ").append(reason).substring(0));
    }

    IllegalAddException(ProcessingInstruction added, String reason) {
        super(new StringBuilder().append("The PI \"").append(added.getTarget()).append("\" could not be added to the top level of the document: ").append(reason).substring(0));
    }

    IllegalAddException(Element base, Comment added, String reason) {
        super(new StringBuilder().append("The comment \"").append(added.getText()).append("\" could not be added as content to \"").append(base.getQualifiedName()).append("\": ").append(reason).substring(0));
    }

    IllegalAddException(Element base, CDATA added, String reason) {
        super(new StringBuilder().append("The CDATA \"").append(added.getText()).append("\" could not be added as content to \"").append(base.getQualifiedName()).append("\": ").append(reason).substring(0));
    }

    IllegalAddException(Element base, Text added, String reason) {
        super(new StringBuilder().append("The Text \"").append(added.getText()).append("\" could not be added as content to \"").append(base.getQualifiedName()).append("\": ").append(reason).substring(0));
    }

    IllegalAddException(Comment added, String reason) {
        super(new StringBuilder().append("The comment \"").append(added.getText()).append("\" could not be added to the top level of the document: ").append(reason).substring(0));
    }

    IllegalAddException(Element base, EntityRef added, String reason) {
        super(new StringBuilder().append("The entity reference\"").append(added.getName()).append("\" could not be added as content to \"").append(base.getQualifiedName()).append("\": ").append(reason).substring(0));
    }

    IllegalAddException(Element base, Namespace added, String reason) {
        super(new StringBuilder().append("The namespace xmlns").append(added.getPrefix() == null || added.getPrefix().equals("") ? "=" : ":" + added.getPrefix() + "=").append("\"").append(added.getURI()).append("\" could not be added as a namespace to \"").append(base.getQualifiedName()).append("\": ").append(reason).substring(0));
    }

    IllegalAddException(DocType added, String reason) {
        super(new StringBuilder().append("The DOCTYPE ").append(added.toString()).append(" could not be added to the document: ").append(reason).substring(0));
    }

    public IllegalAddException(String reason) {
        super(reason);
    }
}

