/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.midi;

import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import org.tritonus.share.TDebug;

public abstract class TMidiDevice
implements MidiDevice {
    private MidiDevice.Info m_info;
    private boolean m_bOpen;
    private boolean m_bUseIn;
    private boolean m_bUseOut;
    private int m_nNumReceivers;
    private List m_transmitters;

    public TMidiDevice(MidiDevice.Info info) {
        this(info, true, true);
    }

    public TMidiDevice(MidiDevice.Info info, boolean bUseIn, boolean bUseOut) {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.<init>(): begin");
        }
        this.m_info = info;
        this.m_bUseIn = bUseIn;
        this.m_bUseOut = bUseOut;
        this.m_bOpen = false;
        this.m_nNumReceivers = 0;
        this.m_transmitters = new ArrayList();
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.<init>(): end");
        }
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.getDeviceInfo(): begin");
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.getDeviceInfo(): end");
        }
        return this.m_info;
    }

    @Override
    public void open() throws MidiUnavailableException {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.open(): begin");
        }
        if (!this.isOpen()) {
            this.m_bOpen = true;
            this.openImpl();
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.open(): end");
        }
    }

    protected void openImpl() throws MidiUnavailableException {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.openImpl(): begin");
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.openImpl(): end");
        }
    }

    @Override
    public void close() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.close(): begin");
        }
        if (this.isOpen()) {
            this.closeImpl();
            this.m_bOpen = false;
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.close(): end");
        }
    }

    protected void closeImpl() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.closeImpl(): begin");
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.closeImpl(): end");
        }
    }

    @Override
    public boolean isOpen() {
        return this.m_bOpen;
    }

    protected boolean getUseIn() {
        return this.m_bUseIn;
    }

    protected boolean getUseOut() {
        return this.m_bUseOut;
    }

    @Override
    public long getMicrosecondPosition() {
        return -1L;
    }

    @Override
    public int getMaxReceivers() {
        int nMaxReceivers = 0;
        if (this.getUseOut()) {
            nMaxReceivers = -1;
        }
        return nMaxReceivers;
    }

    @Override
    public int getMaxTransmitters() {
        int nMaxTransmitters = 0;
        if (this.getUseIn()) {
            nMaxTransmitters = -1;
        }
        return nMaxTransmitters;
    }

    @Override
    public Receiver getReceiver() throws MidiUnavailableException {
        if (!this.getUseOut()) {
            throw new MidiUnavailableException("Receivers are not supported by this device");
        }
        return new TReceiver();
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        if (!this.getUseIn()) {
            throw new MidiUnavailableException("Transmitters are not supported by this device");
        }
        return new TTransmitter();
    }

    protected void receive(MidiMessage message, long lTimeStamp) {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("### [should be overridden] TMidiDevice.receive(): message " + message);
        }
    }

    private void addReceiver() {
        ++this.m_nNumReceivers;
    }

    private void removeReceiver() {
        --this.m_nNumReceivers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTransmitter(Transmitter transmitter) {
        List list = this.m_transmitters;
        synchronized (list) {
            this.m_transmitters.add(transmitter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTransmitter(Transmitter transmitter) {
        List list = this.m_transmitters;
        synchronized (list) {
            this.m_transmitters.remove(transmitter);
        }
    }

    protected void sendImpl(MidiMessage message, long lTimeStamp) {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.sendImpl(): begin");
        }
        for (TTransmitter transmitter : this.m_transmitters) {
            MidiMessage copiedMessage = null;
            if (message instanceof MetaMessage) {
                MetaMessage metaMessage;
                block10: {
                    MetaMessage origMessage = (MetaMessage)message;
                    metaMessage = new MetaMessage();
                    try {
                        metaMessage.setMessage(origMessage.getType(), origMessage.getData(), origMessage.getData().length);
                    }
                    catch (InvalidMidiDataException e) {
                        if (!TDebug.TraceAllExceptions) break block10;
                        TDebug.out(e);
                    }
                }
                copiedMessage = metaMessage;
            } else {
                copiedMessage = (MidiMessage)message.clone();
            }
            if (message instanceof MetaMessage) {
                if (TDebug.TraceMidiDevice) {
                    TDebug.out("TMidiDevice.sendImpl(): MetaMessage.getData().length (original): " + ((MetaMessage)message).getData().length);
                }
                if (TDebug.TraceMidiDevice) {
                    TDebug.out("TMidiDevice.sendImpl(): MetaMessage.getData().length (cloned): " + ((MetaMessage)copiedMessage).getData().length);
                }
            }
            transmitter.send(copiedMessage, lTimeStamp);
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.sendImpl(): end");
        }
    }

    public static class Info
    extends MidiDevice.Info {
        public Info(String a, String b, String c, String d) {
            super(a, b, c, d);
        }
    }

    public class TTransmitter
    implements Transmitter {
        private Receiver m_receiver;

        public TTransmitter() {
            TMidiDevice.this.addTransmitter(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setReceiver(Receiver receiver) {
            TTransmitter tTransmitter = this;
            synchronized (tTransmitter) {
                this.m_receiver = receiver;
            }
        }

        @Override
        public Receiver getReceiver() {
            return this.m_receiver;
        }

        public void send(MidiMessage message, long lTimeStamp) {
            if (this.getReceiver() != null) {
                this.getReceiver().send(message, lTimeStamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            TMidiDevice.this.removeTransmitter(this);
            TTransmitter tTransmitter = this;
            synchronized (tTransmitter) {
                this.m_receiver = null;
            }
        }
    }

    public class TReceiver
    implements Receiver {
        private boolean m_bOpen;

        public TReceiver() {
            TMidiDevice.this.addReceiver();
            this.m_bOpen = true;
        }

        protected boolean isOpen() {
            return this.m_bOpen;
        }

        @Override
        public void send(MidiMessage message, long lTimeStamp) {
            if (TDebug.TraceMidiDevice) {
                TDebug.out("TMidiDevice.TReceiver.send(): message " + message);
            }
            if (!this.m_bOpen) {
                throw new IllegalStateException("receiver is not open");
            }
            TMidiDevice.this.receive(message, lTimeStamp);
        }

        @Override
        public void close() {
            TMidiDevice.this.removeReceiver();
            this.m_bOpen = false;
        }
    }
}

