/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.report.ActivityData;
import edu.xtec.jclic.report.BasicJDBCBridge;
import edu.xtec.jclic.report.GroupData;
import edu.xtec.jclic.report.ReportUtils;
import edu.xtec.jclic.report.SessionData;
import edu.xtec.jclic.report.UserData;
import edu.xtec.util.StrUtils;
import edu.xtec.util.db.ConnectionBean;
import edu.xtec.util.db.ConnectionBeanProvider;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ReportServerJDBCBridge
extends BasicJDBCBridge {
    public static final String[] KCC = new String[]{"SESSION_KEY", "SESSION_CODE", "SESSION_CONTEXT"};
    public String GROUP_SESSION_DATE_STRING = null;
    public String ORDER_QUALIFICATION_1_STRING = null;
    public String ORDER_QUALIFICATION_2_STRING = null;
    private static Date FIRST_DATE = null;

    public ReportServerJDBCBridge(ConnectionBeanProvider cbp, boolean createTables, String tablePrefix) throws Exception {
        super(cbp, createTables, tablePrefix);
        ConnectionBean cb = cbp.getConnectionBean();
        switch (this.DBMSType) {
            case 3: {
                this.GROUP_SESSION_DATE_STRING = "Format(s.SESSION_DATETIME,'yyyy/mm/dd')";
                this.ORDER_QUALIFICATION_2_STRING = this.ORDER_QUALIFICATION_1_STRING = "sum(QUALIFICATION)/count(*)";
                break;
            }
            case 2: {
                this.GROUP_SESSION_DATE_STRING = "trunc(s.SESSION_DATETIME)";
                this.ORDER_QUALIFICATION_1_STRING = "sum(QUALIFICATION)/count(*) AS qf";
                this.ORDER_QUALIFICATION_2_STRING = "qf";
                break;
            }
            default: {
                this.GROUP_SESSION_DATE_STRING = "s.SESSION_DATETIME";
                this.ORDER_QUALIFICATION_1_STRING = "sum(QUALIFICATION)/count(*) AS qf";
                this.ORDER_QUALIFICATION_2_STRING = "qf";
            }
        }
    }

    public static Date getFirstDate() {
        if (FIRST_DATE == null) {
            Calendar c = Calendar.getInstance();
            c.set(1992, 0, 1);
            FIRST_DATE = c.getTime();
        }
        return FIRST_DATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getMinSessionDate() throws Exception {
        Date d;
        block7: {
            Exception ex = null;
            d = ReportServerJDBCBridge.getFirstDate();
            ConnectionBean cb = this.cbp.getConnectionBean();
            PreparedStatement pstmt = null;
            try {
                pstmt = cb.getPreparedStatement("SELECT min(SESSION_DATETIME) FROM " + this.getTableName("SESSIONS"));
                ResultSet result = pstmt.executeQuery();
                if (result.next()) {
                    d = result.getDate(1);
                }
                result.close();
                cb.closeStatement(pstmt);
                this.cbp.freeConnectionBean(cb);
            }
            catch (Exception e) {
                ex = e;
                return ex;
            }
            finally {
                cb.closeStatement(pstmt);
                this.cbp.freeConnectionBean(cb);
                if (ex == null) break block7;
                throw ex;
            }
            if (ex != null) {
                throw ex;
            }
        }
        return d;
    }

    private String getFilteringStringQuery(String[] kcc, boolean and) {
        StringBuilder sb = new StringBuilder(200);
        if (kcc != null) {
            for (int i = 0; i < KCC.length; ++i) {
                if (kcc[i] == null || kcc[i].length() <= 0) continue;
                sb.append(and ? " AND s." : " s.").append(KCC[i]).append("=?");
                and = true;
            }
        }
        return sb.substring(0);
    }

    private int updateFiltering(PreparedStatement pstmt, String[] kcc, int n) throws SQLException {
        if (kcc != null) {
            for (int i = 0; i < KCC.length; ++i) {
                if (kcc[i] == null || kcc[i].length() <= 0) continue;
                pstmt.setString(n++, kcc[i]);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SessionData> getInfoSessionUser(String userId, String projectName, Date dateFrom, Date dateTo, String[] kcc, boolean groupByDate) throws Exception {
        Exception ex = null;
        ArrayList<SessionData> vInfoSessions = new ArrayList<SessionData>();
        String proj = null;
        if (projectName != null && projectName.length() > 0 && !projectName.equals("-1")) {
            proj = projectName;
        }
        StringBuilder sb = new StringBuilder(300);
        sb.append("SELECT ").append(this.GROUP_SESSION_DATE_STRING).append(", s.SESSION_ID, s.PROJECT_NAME, count(*)").append(", sum(QUALIFICATION), sum(a.ACTIVITY_SOLVED), sum(a.TOTAL_TIME)").append(" FROM ").append(this.getTableName("SESSIONS", "s")).append(", ").append(this.getTableName("ACTIVITIES", "a")).append(",").append(this.getTableName("USERS", "u")).append(" WHERE u.USER_ID=? AND s.USER_ID=u.USER_ID").append(this.getFilteringStringQuery(kcc, true)).append(" AND s.SESSION_DATETIME>=? AND s.SESSION_DATETIME<=?").append(" AND s.SESSION_ID=a.SESSION_ID");
        if (proj != null) {
            sb.append(" AND s.PROJECT_NAME=?");
        }
        sb.append(" GROUP BY s.SESSION_ID, s.PROJECT_NAME, ").append(this.GROUP_SESSION_DATE_STRING).append(" ORDER BY ").append(this.GROUP_SESSION_DATE_STRING);
        ConnectionBean cb = this.cbp.getConnectionBean();
        PreparedStatement pstmt = null;
        try {
            pstmt = cb.getPreparedStatement(sb.substring(0));
            int n = 1;
            pstmt.setString(n++, userId);
            n = this.updateFiltering(pstmt, kcc, n);
            pstmt.setTimestamp(n++, new Timestamp(dateFrom.getTime()));
            pstmt.setTimestamp(n++, new Timestamp(dateTo.getTime()));
            if (proj != null) {
                pstmt.setString(n++, proj);
            }
            ResultSet rs = pstmt.executeQuery();
            SessionData sdx = null;
            while (rs.next()) {
                SessionData sd = new SessionData(rs.getString(2), userId, rs.getString(3), ReportUtils.strToDate(rs.getString(1)), rs.getInt(4), rs.getInt(6), rs.getInt(5), Math.max(0, rs.getInt(7)));
                if (groupByDate) {
                    if (sd.sameDate(sdx)) {
                        if (sdx == null) continue;
                        sdx.acumula(sd);
                        continue;
                    }
                    if (sdx != null) {
                        vInfoSessions.add(sdx);
                    }
                    sdx = sd;
                    continue;
                }
                vInfoSessions.add(sd);
            }
            if (sdx != null) {
                vInfoSessions.add(sdx);
            }
            rs.close();
            cb.closeStatement(pstmt);
            this.cbp.freeConnectionBean(cb);
        }
        catch (Exception e) {
            try {
                ex = e;
                cb.closeStatement(pstmt);
                this.cbp.freeConnectionBean(cb);
            }
            catch (Throwable throwable) {
                cb.closeStatement(pstmt);
                this.cbp.freeConnectionBean(cb);
                if (ex != null) {
                    throw ex;
                }
                throw throwable;
            }
            if (ex != null) {
                throw ex;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return vInfoSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SessionData> getInfoSessionGroup(String groupId, String projectName, Date dateFrom, Date dateTo, String[] kcc, boolean groupByDate) throws Exception {
        Exception ex = null;
        ArrayList<SessionData> vInfoSessions = new ArrayList<SessionData>();
        String proj = null;
        if (projectName != null && projectName.length() > 0 && !projectName.equals("-1")) {
            proj = projectName;
        }
        StringBuilder sb = new StringBuilder(300);
        sb.append("SELECT ").append(this.GROUP_SESSION_DATE_STRING).append(", s.SESSION_ID, s.PROJECT_NAME, count(*), sum(QUALIFICATION), sum(a.ACTIVITY_SOLVED), sum(a.TOTAL_TIME), s.USER_ID").append(" FROM ").append(this.getTableName("SESSIONS", "s")).append(", ").append(this.getTableName("ACTIVITIES", "a")).append(", ").append(this.getTableName("USERS", "u")).append(" WHERE u.GROUP_ID=? AND s.USER_ID=u.USER_ID").append(this.getFilteringStringQuery(kcc, true)).append(" AND s.SESSION_DATETIME>=? AND s.SESSION_DATETIME<=?").append(" AND s.SESSION_ID=a.SESSION_ID");
        if (proj != null) {
            sb.append(" AND s.PROJECT_NAME=?");
        }
        sb.append(" GROUP BY s.SESSION_ID, s.USER_ID, s.PROJECT_NAME, ").append(this.GROUP_SESSION_DATE_STRING).append(" ORDER BY ").append(this.GROUP_SESSION_DATE_STRING);
        ConnectionBean cb = this.cbp.getConnectionBean();
        PreparedStatement pstmt = null;
        try {
            pstmt = cb.getPreparedStatement(sb.substring(0));
            int n = 1;
            pstmt.setString(n++, groupId);
            n = this.updateFiltering(pstmt, kcc, n);
            pstmt.setTimestamp(n++, new Timestamp(dateFrom.getTime()));
            pstmt.setTimestamp(n++, new Timestamp(dateTo.getTime()));
            if (proj != null) {
                pstmt.setString(n++, proj);
            }
            ResultSet rs = pstmt.executeQuery();
            SessionData sdx = null;
            while (rs.next()) {
                SessionData sd = new SessionData(rs.getString(2), rs.getString(8), rs.getString(3), ReportUtils.strToDate(rs.getString(1)), rs.getInt(4), rs.getInt(6), rs.getInt(5), Math.max(0, rs.getInt(7)));
                if (groupByDate) {
                    if (sd.sameDate(sdx)) {
                        if (sdx == null) continue;
                        sdx.acumula(sd);
                        continue;
                    }
                    if (sdx != null) {
                        vInfoSessions.add(sdx);
                    }
                    sdx = sd;
                    continue;
                }
                vInfoSessions.add(sd);
            }
            if (sdx != null) {
                vInfoSessions.add(sdx);
            }
            rs.close();
            cb.closeStatement(pstmt);
            this.cbp.freeConnectionBean(cb);
        }
        catch (Exception e) {
            try {
                ex = e;
                cb.closeStatement(pstmt);
                this.cbp.freeConnectionBean(cb);
            }
            catch (Throwable throwable) {
                cb.closeStatement(pstmt);
                this.cbp.freeConnectionBean(cb);
                if (ex != null) {
                    throw ex;
                }
                throw throwable;
            }
            if (ex != null) {
                throw ex;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return vInfoSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SessionData> getInfoSessionAct(String projectName, String activityName, Date dateFrom, Date dateTo, String[] kcc, boolean groupByDate) throws Exception {
        Exception ex = null;
        ArrayList<SessionData> vInfoSessions = new ArrayList<SessionData>();
        String act = null;
        if (activityName != null && activityName.length() > 0 && !activityName.equals("-1")) {
            act = activityName;
        }
        StringBuilder sb = new StringBuilder(300);
        sb.append("SELECT ").append(this.GROUP_SESSION_DATE_STRING).append(", s.SESSION_ID, s.PROJECT_NAME, count(*), sum(QUALIFICATION), sum(a.ACTIVITY_SOLVED), sum(a.TOTAL_TIME), s.USER_ID").append(" FROM ").append(this.getTableName("SESSIONS", "s")).append(", ").append(this.getTableName("ACTIVITIES", "a")).append(" WHERE s.PROJECT_NAME=?").append(this.getFilteringStringQuery(kcc, true)).append(" AND s.SESSION_DATETIME>=? AND s.SESSION_DATETIME<=?").append(" AND s.SESSION_ID=a.SESSION_ID");
        if (act != null) {
            sb.append(" AND a.ACTIVITY_NAME=?");
        }
        sb.append(" GROUP BY s.SESSION_ID, s.USER_ID, s.PROJECT_NAME, ").append(this.GROUP_SESSION_DATE_STRING).append(" ORDER BY ").append(this.GROUP_SESSION_DATE_STRING);
        ConnectionBean cb = this.cbp.getConnectionBean();
        PreparedStatement pstmt = null;
        try {
            pstmt = cb.getPreparedStatement(sb.substring(0));
            int n = 1;
            pstmt.setString(n++, projectName);
            n = this.updateFiltering(pstmt, kcc, n);
            pstmt.setTimestamp(n++, new Timestamp(dateFrom.getTime()));
            pstmt.setTimestamp(n++, new Timestamp(dateTo.getTime()));
            if (act != null) {
                pstmt.setString(n++, act);
            }
            ResultSet rs = pstmt.executeQuery();
            SessionData sdx = null;
            while (rs.next()) {
                SessionData sd = new SessionData(rs.getString(2), rs.getString(8), rs.getString(3), ReportUtils.strToDate(rs.getString(1)), rs.getInt(4), rs.getInt(6), rs.getInt(5), Math.max(0, rs.getInt(7)));
                if (groupByDate) {
                    if (sd.sameDate(sdx)) {
                        if (sdx == null) continue;
                        sdx.acumula(sd);
                        continue;
                    }
                    if (sdx != null) {
                        vInfoSessions.add(sdx);
                    }
                    sdx = sd;
                    continue;
                }
                vInfoSessions.add(sd);
            }
            if (sdx != null) {
                vInfoSessions.add(sdx);
            }
            rs.close();
            cb.closeStatement(pstmt);
            this.cbp.freeConnectionBean(cb);
        }
        catch (Exception e) {
            try {
                ex = e;
                cb.closeStatement(pstmt);
                this.cbp.freeConnectionBean(cb);
            }
            catch (Throwable throwable) {
                cb.closeStatement(pstmt);
                this.cbp.freeConnectionBean(cb);
                if (ex != null) {
                    throw ex;
                }
                throw throwable;
            }
            if (ex != null) {
                throw ex;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return vInfoSessions;
    }

    public boolean hasUserTables() throws Exception {
        String s = this.getProperty("USER_TABLES", null);
        boolean result = s == null || !s.trim().toLowerCase().equals("false");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getProjList(String userId, Date dateFrom, Date dateTo, String[] kcc) throws Exception {
        Exception ex = null;
        ArrayList<String> pl = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(300);
        sb.append("SELECT distinct(PROJECT_NAME)").append(" FROM ").append(this.getTableName("SESSIONS", "s")).append(" WHERE s.SESSION_DATETIME>=? AND s.SESSION_DATETIME<=?");
        if (userId != null) {
            sb.append(" AND s.USER_ID=?");
        }
        sb.append(this.getFilteringStringQuery(kcc, true)).append(" ORDER BY PROJECT_NAME");
        ConnectionBean cb = this.cbp.getConnectionBean();
        PreparedStatement stmt = null;
        try {
            stmt = cb.getPreparedStatement(sb.substring(0));
            int n = 1;
            stmt.setTimestamp(n++, new Timestamp(dateFrom.getTime()));
            stmt.setTimestamp(n++, new Timestamp(dateTo.getTime()));
            if (userId != null) {
                stmt.setString(n++, userId);
            }
            this.updateFiltering(stmt, kcc, n);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                pl.add(result.getString("PROJECT_NAME"));
            }
            result.close();
            cb.closeStatement(stmt);
            this.cbp.freeConnectionBean(cb);
        }
        catch (Exception e) {
            try {
                ex = e;
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
            }
            catch (Throwable throwable) {
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
                if (ex != null) {
                    throw ex;
                }
                throw throwable;
            }
            if (ex != null) {
                throw ex;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return pl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getProjListGrup(String groupId, Date dateFrom, Date dateTo, String[] kcc) throws Exception {
        Exception ex = null;
        ArrayList<String> pl = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(300);
        sb.append("SELECT distinct(PROJECT_NAME)").append(" FROM ").append(this.getTableName("SESSIONS", "s")).append(", ").append(this.getTableName("GROUPS", "g")).append(", ").append(this.getTableName("USERS", "u")).append(" WHERE SESSION_DATETIME>=? AND SESSION_DATETIME<=?").append(" AND u.GROUP_ID=g.GROUP_ID AND s.USER_ID=u.USER_ID");
        if (groupId != null) {
            sb.append(" AND g.GROUP_ID=?");
        }
        sb.append(this.getFilteringStringQuery(kcc, true)).append(" ORDER BY PROJECT_NAME");
        ConnectionBean cb = this.cbp.getConnectionBean();
        PreparedStatement stmt = null;
        try {
            stmt = cb.getPreparedStatement(sb.substring(0));
            int n = 1;
            stmt.setTimestamp(n++, new Timestamp(dateFrom.getTime()));
            stmt.setTimestamp(n++, new Timestamp(dateTo.getTime()));
            if (groupId != null) {
                stmt.setString(n++, groupId);
            }
            this.updateFiltering(stmt, kcc, n);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                pl.add(result.getString("PROJECT_NAME"));
            }
            result.close();
            cb.closeStatement(stmt);
            this.cbp.freeConnectionBean(cb);
        }
        catch (Exception e) {
            try {
                ex = e;
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
            }
            catch (Throwable throwable) {
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
                if (ex != null) {
                    throw ex;
                }
                throw throwable;
            }
            if (ex != null) {
                throw ex;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return pl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getActList(String prj, Date dateFrom, Date dateTo, String[] kcc) throws Exception {
        Exception ex = null;
        ArrayList<String> pl = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(300);
        sb.append("SELECT distinct(ACTIVITY_NAME)").append(" FROM ").append(this.getTableName("ACTIVITIES", "a")).append(", ").append(this.getTableName("SESSIONS", "s")).append(" WHERE s.SESSION_DATETIME>=? AND s.SESSION_DATETIME<=?").append(" AND a.SESSION_ID=s.SESSION_ID");
        if (prj != null) {
            sb.append(" AND s.PROJECT_NAME=?");
        }
        sb.append(this.getFilteringStringQuery(kcc, true)).append(" ORDER BY ACTIVITY_NAME");
        ConnectionBean cb = this.cbp.getConnectionBean();
        PreparedStatement stmt = null;
        try {
            stmt = cb.getPreparedStatement(sb.substring(0));
            int n = 1;
            stmt.setTimestamp(n++, new Timestamp(dateFrom.getTime()));
            stmt.setTimestamp(n++, new Timestamp(dateTo.getTime()));
            if (prj != null) {
                stmt.setString(n++, prj);
            }
            this.updateFiltering(stmt, kcc, n);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                pl.add(result.getString("ACTIVITY_NAME"));
            }
            result.close();
            cb.closeStatement(stmt);
            this.cbp.freeConnectionBean(cb);
        }
        catch (Exception e) {
            try {
                ex = e;
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
            }
            catch (Throwable throwable) {
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
                if (ex != null) {
                    throw ex;
                }
                throw throwable;
            }
            if (ex != null) {
                throw ex;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return pl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActivityData> getPacSessionList(String userId, String proj, String sessionId, Date dFrom, Date dTo, String[] kcc) throws Exception {
        Exception ex = null;
        ArrayList<ActivityData> v = new ArrayList<ActivityData>();
        StringBuilder sb = new StringBuilder(300);
        sb.append("SELECT s.PROJECT_NAME, a.ACTIVITY_ID, a.ACTIVITY_NAME, a.NUM_ACTIONS").append(" ,a.SCORE, a.ACTIVITY_SOLVED, a.QUALIFICATION, a.TOTAL_TIME").append(" FROM ").append(this.getTableName("ACTIVITIES", "a")).append(", ").append(this.getTableName("SESSIONS", "s")).append(" WHERE a.SESSION_ID=s.SESSION_ID");
        if (dFrom != null && dTo != null) {
            sb.append(" AND SESSION_DATETIME>=? AND SESSION_DATETIME<=?");
        }
        if (userId != null) {
            sb.append(" AND s.USER_ID=?");
        }
        sb.append(this.getFilteringStringQuery(kcc, true));
        if (sessionId != null) {
            sb.append(" AND a.SESSION_ID=?");
        }
        if (proj != null && !proj.equals("-1")) {
            sb.append(" AND s.PROJECT_NAME=?");
        }
        sb.append(" ORDER BY s.SESSION_DATETIME, a.ACTIVITY_ID");
        ConnectionBean cb = this.cbp.getConnectionBean();
        PreparedStatement stmt = null;
        try {
            stmt = cb.getPreparedStatement(sb.substring(0));
            int n = 1;
            if (dFrom != null && dTo != null) {
                stmt.setTimestamp(n++, new Timestamp(dFrom.getTime()));
                stmt.setTimestamp(n++, new Timestamp(dTo.getTime()));
            }
            if (userId != null) {
                stmt.setString(n++, userId);
            }
            n = this.updateFiltering(stmt, kcc, n);
            if (sessionId != null) {
                stmt.setString(n++, sessionId);
            }
            if (proj != null && !proj.equals("-1")) {
                stmt.setString(n++, proj);
            }
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                ActivityData ad = new ActivityData(result.getString("PROJECT_NAME"), result.getString("ACTIVITY_NAME"), result.getString("ACTIVITY_ID"), Math.max(0, result.getInt("TOTAL_TIME")), result.getInt("NUM_ACTIONS"), result.getInt("SCORE"), result.getInt("ACTIVITY_SOLVED") != 0, result.getInt("QUALIFICATION"));
                v.add(ad);
            }
            result.close();
            cb.closeStatement(stmt);
            this.cbp.freeConnectionBean(cb);
        }
        catch (Exception e) {
            try {
                ex = e;
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
            }
            catch (Throwable throwable) {
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
                if (ex != null) {
                    throw ex;
                }
                throw throwable;
            }
            if (ex != null) {
                throw ex;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUser(UserData ud, boolean create) throws Exception {
        boolean result;
        block9: {
            Exception ex = null;
            result = false;
            ConnectionBean cb = this.cbp.getConnectionBean();
            PreparedStatement stmt = null;
            try {
                String tn = this.getTableName("USERS");
                stmt = cb.getPreparedStatement(create ? "INSERT INTO " + tn + " (USER_NAME,USER_ICON,USER_PWD,USER_ID,GROUP_ID) VALUES (?,?,?,?,?)" : "UPDATE " + tn + " SET USER_NAME=?, USER_ICON=?, USER_PWD=? WHERE USER_ID=?");
                stmt.setString(1, StrUtils.limitStrLen(ud.getText(), 80));
                if (ud.getIconUrl() != null && ud.getIconUrl().length() == 0) {
                    ud.setIconUrl(null);
                }
                stmt.setString(2, StrUtils.limitStrLen(ud.getIconUrl(), 255));
                stmt.setString(3, StrUtils.limitStrLen(ud.pwd, 255));
                stmt.setString(4, StrUtils.limitStrLen(ud.getId(), 50));
                if (create) {
                    stmt.setString(5, ud.groupId);
                }
                result = stmt.executeUpdate() > 0;
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
            }
            catch (Exception e) {
                ex = e;
            }
            finally {
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
                if (ex == null) break block9;
                throw ex;
            }
            if (ex != null) {
                throw ex;
            }
        }
        if (!result) {
            throw new Exception("SQL \"UPDATE\" statement returns 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGroup(GroupData gd, boolean create) throws Exception {
        boolean result;
        block8: {
            Exception ex = null;
            result = false;
            ConnectionBean cb = this.cbp.getConnectionBean();
            PreparedStatement stmt = null;
            try {
                String tn = this.getTableName("GROUPS");
                stmt = cb.getPreparedStatement(create ? "INSERT INTO " + tn + " (GROUP_NAME,GROUP_ICON,GROUP_ID) VALUES (?,?,?)" : "UPDATE " + tn + " SET GROUP_NAME=?, GROUP_ICON=? WHERE GROUP_ID=?");
                stmt.setString(1, StrUtils.limitStrLen(gd.getText(), 80));
                if (gd.getIconUrl() != null && gd.getIconUrl().length() == 0) {
                    gd.setIconUrl(null);
                }
                stmt.setString(2, StrUtils.limitStrLen(gd.getIconUrl(), 255));
                stmt.setString(3, StrUtils.limitStrLen(gd.getId(), 50));
                result = stmt.executeUpdate() > 0;
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
            }
            catch (Exception e) {
                ex = e;
            }
            finally {
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
                if (ex == null) break block8;
                throw ex;
            }
            if (ex != null) {
                throw ex;
            }
        }
        if (!result) {
            throw new Exception("SQL \"UPDATE\" statement returns 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUserReportData(String userId, Date dFrom, Date dTo) throws Exception {
        Exception ex = null;
        StringBuilder sb = new StringBuilder(300);
        sb.append("SELECT SESSION_ID").append(" FROM ").append(this.getTableName("SESSIONS")).append(" WHERE USER_ID=?");
        if (dFrom != null && dTo != null) {
            sb.append(" AND SESSION_DATETIME>=? AND SESSION_DATETIME<=?");
        }
        ConnectionBean cb = this.cbp.getConnectionBean();
        PreparedStatement stmt = null;
        try {
            stmt = cb.getPreparedStatement(sb.substring(0));
            stmt.setString(1, userId);
            if (dFrom != null && dTo != null) {
                stmt.setTimestamp(2, new Timestamp(dFrom.getTime()));
                stmt.setTimestamp(3, new Timestamp(dTo.getTime()));
            }
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                this.deleteSession(rs.getString(1));
            }
            cb.closeStatement(stmt);
            this.cbp.freeConnectionBean(cb);
        }
        catch (Exception e) {
            try {
                ex = e;
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
            }
            catch (Throwable throwable) {
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
                if (ex != null) {
                    throw ex;
                }
                throw throwable;
            }
            if (ex != null) {
                throw ex;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGroupReportData(String groupId, Date dFrom, Date dTo) throws Exception {
        Exception ex = null;
        StringBuilder sb = new StringBuilder(300);
        sb.append("SELECT SESSION_ID").append(" FROM ").append(this.getTableName("SESSIONS", "s")).append(", ").append(this.getTableName("USERS", "u")).append(" WHERE u.GROUP_ID=?").append(" AND u.USER_ID=s.USER_ID");
        if (dFrom != null && dTo != null) {
            sb.append(" AND s.SESSION_DATETIME>=? AND s.SESSION_DATETIME<=?");
        }
        ConnectionBean cb = this.cbp.getConnectionBean();
        PreparedStatement stmt = null;
        try {
            stmt = cb.getPreparedStatement(sb.substring(0));
            stmt.setString(1, groupId);
            if (dFrom != null && dTo != null) {
                stmt.setTimestamp(2, new Timestamp(dFrom.getTime()));
                stmt.setTimestamp(3, new Timestamp(dTo.getTime()));
            }
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                this.deleteSession(rs.getString(1));
            }
            cb.closeStatement(stmt);
            this.cbp.freeConnectionBean(cb);
        }
        catch (Exception e) {
            try {
                ex = e;
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
            }
            catch (Throwable throwable) {
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
                if (ex != null) {
                    throw ex;
                }
                throw throwable;
            }
            if (ex != null) {
                throw ex;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteSession(String sessionId) throws Exception {
        block6: {
            Exception ex = null;
            ConnectionBean cb = this.cbp.getConnectionBean();
            PreparedStatement stmt = null;
            try {
                stmt = cb.getPreparedStatement("DELETE FROM " + this.getTableName("ACTIONS") + " WHERE SESSION_ID=?");
                stmt.setString(1, sessionId);
                stmt.executeUpdate();
                cb.closeStatement(stmt);
                stmt = cb.getPreparedStatement("DELETE FROM " + this.getTableName("ACTIVITIES") + " WHERE SESSION_ID=?");
                stmt.setString(1, sessionId);
                stmt.executeUpdate();
                cb.closeStatement(stmt);
                stmt = cb.getPreparedStatement("DELETE FROM " + this.getTableName("SESSIONS") + " WHERE SESSION_ID=?");
                stmt.setString(1, sessionId);
                stmt.executeUpdate();
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
            }
            catch (Exception e) {
                ex = e;
            }
            finally {
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
                if (ex == null) break block6;
                throw ex;
            }
            if (ex != null) {
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUser(String userId) throws Exception {
        block6: {
            Exception ex = null;
            this.clearUserReportData(userId, null, null);
            ConnectionBean cb = this.cbp.getConnectionBean();
            PreparedStatement stmt = null;
            try {
                cb.getConnection().commit();
                stmt = cb.getPreparedStatement("DELETE FROM " + this.getTableName("USERS") + " WHERE USER_ID=?");
                stmt.setString(1, userId);
                stmt.executeUpdate();
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
            }
            catch (Exception e) {
                ex = e;
            }
            finally {
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
                if (ex == null) break block6;
                throw ex;
            }
            if (ex != null) {
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroup(String groupId) throws Exception {
        block6: {
            Exception ex = null;
            this.clearGroupReportData(groupId, null, null);
            ConnectionBean cb = this.cbp.getConnectionBean();
            PreparedStatement stmt = null;
            try {
                cb.getConnection().commit();
                stmt = cb.getPreparedStatement("DELETE FROM " + this.getTableName("USERS") + " WHERE GROUP_ID=?");
                stmt.setString(1, groupId);
                stmt.executeUpdate();
                cb.closeStatement(stmt);
                cb.getConnection().commit();
                stmt = cb.getPreparedStatement("DELETE FROM " + this.getTableName("GROUPS") + " WHERE GROUP_ID=?");
                stmt.setString(1, groupId);
                stmt.executeUpdate();
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
            }
            catch (Exception e) {
                ex = e;
            }
            finally {
                cb.closeStatement(stmt);
                this.cbp.freeConnectionBean(cb);
                if (ex == null) break block6;
                throw ex;
            }
            if (ex != null) {
                throw ex;
            }
        }
    }
}

