/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.ReportUtils;
import edu.xtec.jclic.report.rp.Login;
import edu.xtec.jclic.report.rp.ReportsRequestProcessor;
import edu.xtec.util.CompoundObject;
import edu.xtec.util.Encryption;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public abstract class Basic
extends ReportsRequestProcessor {
    public static final String BUNDLE = "edu.xtec.resources.messages.reportMessages";
    public static final String LANG = "lang";
    public static final long DEFAULT_SESSION_LIFETIME = 20L;
    public static final String ACTION = "action";
    public static final String PWD = "pwd";
    public static final String RETRY = "retry";
    public static final String ON = "on";
    public static final String MAIN_FORM = "mainForm";
    public static final String AUTH = "AUTH";
    protected static Map<String, Object[]> localeObjects = new HashMap<String, Object[]>();
    protected static Map<String, Long> sessions = new HashMap<String, Long>();
    protected boolean retry;
    protected String auth;
    protected ResourceBundle bundle;
    protected String[] months;
    protected DateFormat shortDateFormat;
    protected DateFormat veryShortDateFormat;
    protected NumberFormat numberFormat;
    protected String lang;
    private static String[] F_NUMBERS;

    public static String[] getFormattedNumbers() {
        if (F_NUMBERS == null) {
            DecimalFormat df = new DecimalFormat("00");
            ArrayList<String> v = new ArrayList<String>(100);
            for (int i = 0; i < 100; ++i) {
                v.add(df.format(i));
            }
            F_NUMBERS = v.toArray(new String[100]);
        }
        return F_NUMBERS;
    }

    public abstract String getTitle(ResourceBundle var1);

    public abstract String getUrl();

    public String getMsg(String key) {
        return Basic.filter(this.bundle.getString(key));
    }

    @Override
    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        this.lang = this.getParam(LANG);
        this.lang = this.lang == null || this.lang.length() != 2 ? prop.getProperty("language", Locale.getDefault().getLanguage()) : this.lang.toLowerCase();
        Object[] obj = localeObjects.get(this.lang);
        if (obj != null) {
            this.bundle = (ResourceBundle)obj[0];
            this.months = (String[])obj[1];
            this.shortDateFormat = (DateFormat)obj[2];
            this.veryShortDateFormat = (DateFormat)obj[3];
            this.numberFormat = (NumberFormat)obj[4];
        } else {
            Locale l = new Locale(this.lang, "");
            this.bundle = ResourceBundle.getBundle(BUNDLE, l);
            if (this.bundle == null) {
                throw new Exception("Internal error!");
            }
            this.months = new String[12];
            for (int i = 0; i < 12; ++i) {
                this.months[i] = this.bundle.getString("month_" + (i + 1));
            }
            this.shortDateFormat = DateFormat.getDateInstance(3, l);
            this.veryShortDateFormat = new SimpleDateFormat("dd/MM", l);
            this.numberFormat = NumberFormat.getInstance(l);
            obj = new Object[]{this.bundle, this.months, this.shortDateFormat, this.veryShortDateFormat, this.numberFormat};
            localeObjects.put(this.lang, obj);
        }
        this.checkAuth();
        if (this.auth != null) {
            this.setCookie(AUTH, this.auth);
        }
        return this.auth != null;
    }

    protected boolean checkAuth() {
        this.auth = this.getCookie(AUTH);
        if (this.auth != null) {
            Long timeCheck = sessions.get(this.auth);
            if (timeCheck != null) {
                long lifeTime;
                try {
                    lifeTime = Long.parseLong(prop.getProperty("session_lifetime", Long.toString(20L)));
                }
                catch (NumberFormatException ex) {
                    lifeTime = 20L;
                }
                lifeTime = Math.max(1L, lifeTime);
                if (timeCheck < System.currentTimeMillis() - lifeTime * 60L * 1000L) {
                    this.auth = null;
                    sessions.remove(this.auth);
                } else {
                    sessions.put(this.auth, new Long(System.currentTimeMillis()));
                }
            } else {
                this.auth = null;
            }
        }
        if (this.auth == null) {
            boolean ok = false;
            try {
                String sPwd = bridge.getProperty("PASSWORD", null);
                if (sPwd != null && sPwd.length() > 0) {
                    String sTypedPwd = this.getParam(PWD);
                    if (sTypedPwd != null && sPwd.equals(Encryption.Encrypt(sTypedPwd))) {
                        ok = true;
                    } else {
                        this.retry = true;
                    }
                } else {
                    ok = true;
                }
            }
            catch (Exception ex) {
                ok = false;
            }
            if (ok) {
                char[] key = new char[12];
                for (int i = 0; i < 12; ++i) {
                    char k = (char)(Math.random() * 36.0);
                    key[i] = k < '\n' ? (char)(48 + k) : (char)(65 + k - 10);
                }
                this.auth = new String(key);
                sessions.put(this.auth, new Long(System.currentTimeMillis()));
            }
        }
        return this.auth != null;
    }

    @Override
    public void header(List<String[]> v) {
        super.header(v);
        if (!this.checkAuth()) {
            v.add(new String[]{"REDIRECT", Basic.urlParam(Login.URL, RETRY, this.retry ? "true" : "false")});
        }
    }

    @Override
    public void head(PrintWriter out) throws Exception {
        super.head(out);
        this.title(this.bundle.getString("jclic_reports"), this.getTitle(this.bundle), out);
        this.linkStyle(Basic.resourceUrl("basic.css"), Basic.resourceUrl("basic_print.css"), out);
    }

    public void standardHeader(PrintWriter out, String title, String menu) throws Exception {
        StringBuilder sb = new StringBuilder(300);
        sb.append("<h1>").append(this.getMsg("jclic_reports")).append("<br>").append(title).append("</h1>\n");
        sb.append("<p class=\"topMenu\">").append(menu).append("</p>");
        out.println(sb.substring(0));
    }

    protected boolean getBoolParam(String paramStr, String expectedValue) {
        boolean result = false;
        String s = this.getParam(paramStr);
        if (s != null && s.length() > 0) {
            result = expectedValue == null ? true : expectedValue.toLowerCase().equals(s.trim().toLowerCase());
        }
        return result;
    }

    public static String linkTo(String url, String text, String style) {
        StringBuilder sb = new StringBuilder(url.length() + text.length() + 200);
        sb.append("<a href=\"");
        sb.append(url).append("\"");
        if (style != null) {
            sb.append(" class=\"").append(style).append("\"");
        }
        sb.append(">");
        sb.append(Basic.filter(text));
        sb.append("</a>");
        return sb.substring(0);
    }

    public static String buttonAction(String action, String text, String extra) {
        StringBuilder sb = new StringBuilder(text.length() + 200);
        sb.append("<input type=\"button\" value=\"").append(Basic.filter(text)).append("\"");
        if (action != null) {
            sb.append(" onClick=\"").append(action).append("\"");
        }
        if (extra != null) {
            sb.append(" ").append(extra);
        }
        sb.append(" id=\"noPrint\">");
        return sb.substring(0);
    }

    public static String buttonTo(String url, String text, String extra) {
        return Basic.buttonAction("window.location.href='" + Basic.escape(url) + "'", text, extra);
    }

    protected static String urlParam(String url, String key, String value) {
        return Basic.urlParamSb(new StringBuilder(url.length() + 100).append(url), key, value, url.indexOf(63) < 0).substring(0);
    }

    protected static StringBuilder urlParamSb(StringBuilder sb, String key, String value, boolean first) {
        if (value != null && value.length() > 0) {
            sb.append(first ? "?" : "&");
            sb.append(key).append("=").append(ReportUtils.urlEncode(value, false, false));
        }
        return sb;
    }

    protected int getAction(String[] actions, int defaultAction) {
        String action = this.getParam(ACTION);
        int result = defaultAction;
        if (action != null) {
            action = action.trim();
            for (int i = 0; i < actions.length; ++i) {
                if (!actions[i].equals(action)) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public String[][] vectorToArray(List v, boolean isCompoundObject) {
        return this.vectorToArray(v, isCompoundObject, null, null);
    }

    public String[][] vectorToArray(List v, boolean isCompoundObject, String wildCardKey, String wildCardMsg) {
        String[][] result = null;
        if (wildCardKey != null || v != null && v.size() > 0) {
            int l = v != null ? v.size() : 0;
            result = new String[l + (wildCardKey != null ? 1 : 0)][];
            int k = 0;
            if (wildCardKey != null) {
                String s = wildCardKey;
                if (wildCardMsg != null) {
                    s = this.getMsg(wildCardMsg);
                }
                result[k++] = new String[]{wildCardKey, s};
            }
            if (v != null) {
                for (int i = 0; i < l; ++i) {
                    String sValue;
                    String sKey;
                    if (isCompoundObject) {
                        CompoundObject co = (CompoundObject)v.get(i);
                        sKey = co.getId();
                        sValue = co.getText();
                    } else {
                        sValue = sKey = ((String)v.get(i)).trim();
                    }
                    result[k++] = new String[]{sKey, sValue};
                }
            }
        }
        return result;
    }
}

