/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.ReportUtils;
import edu.xtec.jclic.report.rp.Basic;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateManager {
    public static final String FROM = "from";
    public static final String TO = "to";
    protected Date dFrom;
    protected Date dTo;
    protected Date firstDate;
    protected Date today;
    private GregorianCalendar calendar;
    protected Basic rp;

    public DateManager(Basic rp) {
        this.rp = rp;
    }

    public boolean init() throws Exception {
        this.firstDate = Basic.bridge.getMinSessionDate();
        this.today = new Date();
        if (this.firstDate == null || this.firstDate.compareTo(this.today) > 0) {
            this.firstDate = this.today;
        }
        this.dFrom = this.rp.getDateParam(FROM, this.firstDate, false);
        this.dTo = this.rp.getDateParam(TO, this.today, true);
        if (this.dFrom.compareTo(this.dTo) > 0) {
            this.dFrom = this.dTo;
        }
        System.out.println("From: " + this.dFrom + " To: " + this.dTo);
        return true;
    }

    public GregorianCalendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = new GregorianCalendar();
        }
        return this.calendar;
    }

    public void writeHiddenFields(StringBuilder sb) throws Exception {
        sb.append("<input type=\"hidden\" name=\"").append(FROM).append("\" value=\"").append(ReportUtils.dateToStr(this.dFrom)).append("\">\n");
        sb.append("<input type=\"hidden\" name=\"").append(TO).append("\" value=\"").append(ReportUtils.dateToStr(this.dTo)).append("\">\n");
    }

    public void writeDateScript(StringBuilder sb) {
        sb.append("<script language=\"JavaScript\" type=\"text/javascript\">\n");
        sb.append("<!--\n");
        sb.append(" function updateDateFrom(){\n");
        sb.append("     mainForm.from.value=\n");
        sb.append("       \"\"+mainForm.yearFrom.options[mainForm.yearFrom.selectedIndex].value+\n");
        sb.append("       \"-\"+mainForm.monthFrom.options[mainForm.monthFrom.selectedIndex].value+\n");
        sb.append("       \"-\"+mainForm.dayFrom.options[mainForm.dayFrom.selectedIndex].value;\n");
        sb.append(" };\n");
        sb.append(" function updateDateTo(){\n");
        sb.append("     mainForm.to.value=\n");
        sb.append("       \"\"+mainForm.yearTo.options[mainForm.yearTo.selectedIndex].value+\n");
        sb.append("       \"-\"+mainForm.monthTo.options[mainForm.monthTo.selectedIndex].value+\n");
        sb.append("       \"-\"+mainForm.dayTo.options[mainForm.dayTo.selectedIndex].value;\n");
        sb.append(" };\n");
        sb.append("//-->\n");
        sb.append("</script>\n");
    }

    protected void zonaData(StringBuilder sb, String button) {
        this.liniaData(sb, true);
        this.liniaData(sb, false);
        if (button != null) {
            sb.append("<p>").append(button).append("</p>");
        }
    }

    protected void liniaData(StringBuilder sb, boolean bFrom) {
        int i;
        String[] n = Basic.getFormattedNumbers();
        String msgKey = bFrom ? "report_from" : "report_to";
        String type = bFrom ? "From" : "To";
        String ctrlName = "mainForm." + type;
        String actionStr = "\" onChange=updateDate" + type + "()";
        GregorianCalendar c = this.getCalendar();
        c.setTime(this.firstDate);
        int firstYear = c.get(1);
        c.setTime(this.today);
        int currentYear = c.get(1);
        c.setTime(bFrom ? this.dFrom : this.dTo);
        sb.append("<p><strong>").append(Basic.toNbsp(this.rp.getMsg(msgKey))).append("</strong> ");
        sb.append("<select name=\"day").append(type).append("\"  onChange=\"updateDate").append(type).append("()\">\n");
        int x = c.get(5);
        for (i = 1; i <= 31; ++i) {
            sb.append("<option");
            if (i == x) {
                sb.append(" selected");
            }
            sb.append(" value=\"").append(n[i]).append("\">").append(n[i]).append("</option>\n");
        }
        sb.append("</select> <select name=\"month").append(type).append("\"  onChange=\"updateDate").append(type).append("()\">\n");
        x = c.get(2);
        for (i = 0; i < 12; ++i) {
            sb.append("<option");
            if (i == x) {
                sb.append(" selected");
            }
            sb.append(" value=\"").append(n[i + 1]).append("\">").append(Basic.filter(this.rp.months[i])).append("</option>\n");
        }
        sb.append("</select> <select name=\"year").append(type).append("\"  onChange=\"updateDate").append(type).append("()\">\n");
        x = c.get(1);
        for (i = firstYear; i <= currentYear; ++i) {
            sb.append("<option");
            if (i == x) {
                sb.append(" selected");
            }
            sb.append(" value=\"").append(i).append("\">").append(i).append("</option>\n");
        }
        sb.append("</select></p>\n");
    }
}

