/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.GroupData;
import edu.xtec.jclic.report.UserData;
import edu.xtec.jclic.report.rp.Basic;
import edu.xtec.jclic.report.rp.DateManager;
import edu.xtec.jclic.report.rp.Main;
import edu.xtec.jclic.report.rp.UserAdmin;
import java.io.PrintWriter;
import java.util.List;
import java.util.ResourceBundle;

public class GroupAdmin
extends Basic {
    public static String TITLE = "group_admin_title";
    public static String URL = "groupAdmin";
    public static final String GROUP = "group";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final int MENU = 0;
    public static final int GROUP_MENU = 1;
    public static final int EDIT = 2;
    public static final int EDIT_UPDATE = 3;
    public static final int CREATE = 4;
    public static final int CREATE_UPDATE = 5;
    public static final int DELETE = 6;
    public static final int DELETE_UPDATE = 7;
    public static final int CLEAR = 8;
    public static final int CLEAR_UPDATE = 9;
    public static final int ERR = 10;
    public static final String[] ACTIONS = new String[]{"", "group", "edit", "editUpd", "create", "createUpd", "del", "delUpd", "clear", "clearUpd"};
    protected int page;
    protected DateManager dm;
    protected List<GroupData> groups;
    protected List<UserData> users;
    protected GroupData gd;
    protected String returnUrl;

    @Override
    public String getTitle(ResourceBundle bundle) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(bundle.getString(TITLE));
        if (this.gd != null && this.gd.getText() != null && this.gd.getText().length() > 0) {
            sb.append(": ").append(GroupAdmin.filter(this.gd.getText()));
        }
        return sb.substring(0);
    }

    @Override
    public String getUrl() {
        return GroupAdmin.urlParam(URL, "lang", this.lang);
    }

    public String getUrl(int action) {
        StringBuilder sb = new StringBuilder(300);
        sb.append(URL);
        GroupAdmin.urlParamSb(sb, "lang", this.lang, true);
        GroupAdmin.urlParamSb(sb, "action", ACTIONS[action], false);
        if (this.gd != null) {
            GroupAdmin.urlParamSb(sb, GROUP, this.gd.getId(), false);
        }
        return sb.substring(0);
    }

    @Override
    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        String gId = this.getParamNotNull(GROUP);
        if (gId.length() > 0) {
            this.gd = bridge.getGroupData(gId);
        }
        this.page = this.getAction(ACTIONS, 0);
        if (this.page == 8 || this.page == 9) {
            this.dm = new DateManager(this);
            if (!this.dm.init()) {
                return false;
            }
        }
        switch (this.page) {
            case 3: {
                this.edit();
                break;
            }
            case 5: {
                this.create();
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 9: {
                this.clear();
            }
        }
        if (this.page == 0) {
            this.groups = bridge.getGroups();
        } else if (this.page == 1 && this.gd != null) {
            this.users = bridge.getUsers(this.gd.getId());
        }
        return true;
    }

    protected void edit() throws Exception {
        this.returnUrl = this.getUrl(1);
        this.errMsg = this.getMsg("db_error") + "<BR>";
        String name = this.getParamNotNull(NAME).trim();
        if (name.length() == 0) {
            this.errMsg = this.errMsg + this.getMsg("group_admin_invalid_name");
        } else {
            this.gd.setText(name);
            this.gd.setIconUrl(this.getParamNotNull(ICON).trim());
            try {
                bridge.updateGroup(this.gd, false);
                this.page = 1;
            }
            catch (Exception ex) {
                this.errMsg = this.errMsg + ex.getLocalizedMessage();
            }
        }
    }

    protected void create() throws Exception {
        this.returnUrl = this.getUrl(0);
        this.errMsg = this.getMsg("db_error") + "<BR>";
        String name = this.getParamNotNull(NAME).trim();
        String id = this.getParamNotNull(ID).trim();
        String icon = this.getParamNotNull(ICON).trim();
        if (name.length() == 0) {
            this.errMsg = this.errMsg + this.getMsg("group_admin_invalid_name");
        } else if (id.length() == 0) {
            this.errMsg = this.errMsg + this.getMsg("group_admin_invalid_id");
        } else {
            this.gd = bridge.getGroupData(id);
            if (this.gd != null) {
                this.returnUrl = GroupAdmin.urlParam(GroupAdmin.urlParam(this.getUrl(4), NAME, name), ICON, icon);
                this.errMsg = this.errMsg + this.getMsg("group_admin_id_already_exists");
            } else {
                try {
                    this.gd = new GroupData(id, name, icon, null);
                    bridge.updateGroup(this.gd, true);
                    this.page = 1;
                }
                catch (Exception ex) {
                    this.gd = null;
                    this.errMsg = this.errMsg + ex.getLocalizedMessage();
                }
            }
        }
    }

    protected void delete() throws Exception {
        this.returnUrl = this.getUrl(1);
        try {
            bridge.deleteGroup(this.gd.getId());
            this.gd = null;
            this.page = 0;
        }
        catch (Exception ex) {
            this.returnUrl = this.getUrl(1);
            this.errMsg = this.getMsg("db_error") + "<BR>" + ex.getLocalizedMessage();
        }
    }

    protected void clear() throws Exception {
        this.returnUrl = this.getUrl(1);
        try {
            bridge.clearGroupReportData(this.gd.getId(), this.dm.dFrom, this.dm.dTo);
            this.page = 1;
        }
        catch (Exception ex) {
            this.errMsg = this.getMsg("db_error") + "<BR>" + ex.getLocalizedMessage();
        }
    }

    @Override
    public void head(PrintWriter out) throws Exception {
        super.head(out);
        if (this.page == 8) {
            StringBuilder sb = new StringBuilder(200);
            this.dm.writeDateScript(sb);
            out.println(sb.substring(0));
        }
    }

    @Override
    public void body(PrintWriter out) throws Exception {
        super.body(out);
        StringBuilder sb = new StringBuilder(2000);
        StringBuilder sb2 = new StringBuilder(500);
        boolean flag = false;
        sb.append(GroupAdmin.linkTo(GroupAdmin.urlParam(Main.URL, "lang", this.lang), this.bundle.getString(Main.TITLE), null));
        if (this.page != 0) {
            sb.append(" | ").append(GroupAdmin.linkTo(this.getUrl(), this.getMsg(TITLE), null));
        }
        this.standardHeader(out, GroupAdmin.filter(this.getTitle(this.bundle)), sb.substring(0));
        sb.setLength(0);
        if (this.gd == null && this.page != 4 && this.page != 0) {
            this.page = 10;
            if (this.errMsg == null) {
                this.errMsg = this.getMsg("bad_data");
            }
        }
        switch (this.page) {
            case 0: {
                sb.append("<table class=\"tblA\" width=400>\n");
                sb.append("<tr><th>").append(this.getMsg("group_admin_groups")).append("</th></tr>\n");
                for (GroupData gdata : this.groups) {
                    String url = GroupAdmin.urlParam(this.getUrl(1), GROUP, gdata.getId());
                    sb.append("<tr><td><a href=\"").append(url).append("\">").append(GroupAdmin.filter(gdata.getText()));
                    sb.append("</a></td></tr>\n");
                }
                sb.append("</table>\n");
                sb.append("<br clear=\"all\">\n");
                sb.append("<form>");
                sb.append(GroupAdmin.buttonTo(this.getUrl(4), this.getMsg("group_admin_new_button"), null));
                sb.append("</form>");
                break;
            }
            case 1: {
                sb.append("<form class=\"info\">\n");
                sb.append("<p><strong>").append(this.getMsg("group_admin_id")).append("</strong> ").append(GroupAdmin.filter(this.gd.getId())).append("</p>\n");
                sb.append("<p><strong>").append(this.getMsg("group_admin_name")).append("</strong> ").append(GroupAdmin.filter(this.gd.getText())).append("</p>\n");
                sb.append("<p><strong>").append(this.getMsg("group_admin_icon")).append(" ");
                if (this.gd.getIconUrl() != null && this.gd.getIconUrl().length() > 0) {
                    sb.append("<img src=\"").append(GroupAdmin.filter(this.gd.getIconUrl())).append("\" title=\"");
                    sb.append(GroupAdmin.filter(this.gd.getIconUrl())).append("\">");
                } else {
                    sb.append("---");
                }
                sb.append("</p>\n");
                sb.append("<p>");
                sb.append(GroupAdmin.buttonTo(this.getUrl(2), this.getMsg("group_admin_edit_button"), null));
                sb.append(GroupAdmin.buttonTo(this.getUrl(6), this.getMsg("group_admin_delete_button"), null));
                sb.append(GroupAdmin.buttonTo(this.getUrl(8), this.getMsg("group_admin_clear_button"), null));
                sb.append("</p>\n");
                sb.append("</form>\n<br clear=\"all\">\n");
                if (this.users != null && this.users.size() > 0) {
                    sb.append("<table class=\"tblA\" width=500>\n");
                    sb.append("<tr><th>").append(this.getMsg("group_admin_users")).append("</th></tr>\n");
                    for (UserData ud : this.users) {
                        sb2.setLength(0);
                        sb2.append(UserAdmin.URL);
                        GroupAdmin.urlParamSb(sb2, "lang", this.lang, true);
                        GroupAdmin.urlParamSb(sb2, GROUP, this.gd.getId(), false);
                        GroupAdmin.urlParamSb(sb2, "user", ud.getId(), false);
                        sb.append("<tr><td><a href=\"").append(sb2.substring(0)).append("\">").append(GroupAdmin.filter(ud.getText()));
                        sb.append("</a></td></tr>\n");
                    }
                    sb.append("</table>\n");
                    sb.append("<br clear=\"all\">");
                } else {
                    sb.append("<p><strong>").append(this.getMsg("group_admin_no_users")).append("</strong></p>\n");
                }
                sb.append("<form>");
                sb2.setLength(0);
                sb2.append(UserAdmin.URL);
                GroupAdmin.urlParamSb(sb2, "lang", this.lang, true);
                GroupAdmin.urlParamSb(sb2, "action", UserAdmin.ACTIONS[3], false);
                GroupAdmin.urlParamSb(sb2, GROUP, this.gd.getId(), false);
                sb.append(GroupAdmin.buttonTo(sb2.substring(0), this.getMsg("group_admin_create_user_button"), null));
                sb.append("</form>\n");
                break;
            }
            case 2: {
                flag = true;
            }
            case 4: {
                String id = this.gd != null ? this.gd.getId() : this.getParamNotNull(ID).trim();
                String name = this.gd != null ? this.gd.getText() : this.getParamNotNull(NAME).trim();
                String icon = this.gd != null ? this.gd.getIconUrl() : this.getParamNotNull(ICON).trim();
                sb.append("<form class=\"inputForm\" method=\"post\" action=\"").append(this.getUrl(flag ? 3 : 5)).append("\">\n");
                sb.append("<p><strong>").append(this.getMsg("group_admin_id")).append("</strong> ");
                sb.append("<input name=\"").append(ID).append("\" value=\"").append(GroupAdmin.filter(id)).append("\" size=40");
                if (flag) {
                    sb.append(" readonly");
                }
                sb.append("></p>\n");
                sb.append("<p><strong>").append(this.getMsg("group_admin_name")).append("</strong> ");
                sb.append("<input name=\"").append(NAME).append("\" value=\"").append(GroupAdmin.filter(name)).append("\" size=40></p>\n");
                sb.append("<p><strong>").append(this.getMsg("group_admin_icon")).append("</strong> ");
                sb.append("<input name=\"").append(ICON).append("\" value=\"").append(GroupAdmin.filter(icon)).append("\" size=40></p>\n");
                sb.append("<p><input type=\"submit\" value=\"").append(this.getMsg("submit")).append("\"> ");
                sb.append(GroupAdmin.buttonTo(this.getUrl(flag ? 1 : 0), this.getMsg("cancel"), null));
                sb.append("</p>\n");
                sb.append("</form>\n");
                sb.append("<br clear=\"all\">\n");
                break;
            }
            case 6: {
                sb.append("<p><strong>").append(this.getMsg("group_admin_delete_group")).append(" \"").append(GroupAdmin.filter(this.gd.getText())).append("\"</strong></p>\n");
                sb.append("<p>").append(this.getMsg("group_admin_delete_group_explain")).append("</p>\n");
                sb.append("<p>").append(this.getMsg("report_areyousure")).append("</p>\n");
                sb.append("<form method=\"post\" action=\"").append(this.getUrl(7)).append("\">\n");
                sb.append("<p><input type=\"submit\" value=\"").append(this.getMsg("YES")).append("\" width=50>\n");
                sb.append(GroupAdmin.buttonTo(this.getUrl(1), this.getMsg("NOT"), " width=50"));
                sb.append("</p>\n");
                sb.append("</form>\n");
                break;
            }
            case 8: {
                sb.append("<p><strong>").append(this.getMsg("group_admin_clear_group")).append(" \"").append(GroupAdmin.filter(this.gd.getText())).append("\"</strong></p>\n");
                sb.append("<p>").append(this.getMsg("group_admin_clear_group_explain")).append("</p>\n");
                sb.append("<form class=\"inputForm\" action=\"").append(this.getUrl(9)).append("\" method=\"post\" name=\"").append("mainForm").append("\">\n");
                this.dm.writeHiddenFields(sb);
                sb2.setLength(0);
                sb2.append("document.").append("mainForm").append(".submit()");
                this.dm.zonaData(sb, GroupAdmin.buttonAction(sb2.substring(0), this.getMsg("db_clear_reports_date"), null));
                sb.append("</form>\n");
                sb.append("<br clear=\"all\">\n");
                break;
            }
            default: {
                sb.append("<p><strong>").append(this.getMsg("error")).append("</strong></p>\n");
                if (this.errMsg != null) {
                    sb.append("<p>").append(this.errMsg).append("</p>\n");
                }
                if (this.returnUrl == null) break;
                sb.append("<p><a href=\"").append(this.returnUrl).append("\">").append(this.getMsg("return")).append("</a></p>\n");
            }
        }
        out.println(sb.substring(0));
    }
}

