/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.SessionData;
import edu.xtec.jclic.report.rp.Report;
import java.io.PrintWriter;
import java.util.List;
import java.util.ResourceBundle;

public class UserReport
extends Report {
    public static String TITLE = "user_report_title";
    public static String URL = "userReport";
    List<SessionData> sessionList;

    @Override
    public String getTitle(ResourceBundle bundle) {
        return bundle.getString(TITLE);
    }

    @Override
    public String getUrl() {
        return URL;
    }

    @Override
    public boolean init() throws Exception {
        int i;
        this.type = 0;
        if (!super.init()) {
            return false;
        }
        this.projects = bridge.getProjList(this.userId, this.dm.dFrom, this.dm.dTo, this.kcc);
        this.sessionList = this.getSessionList();
        if (this.session == null && this.sessionList != null && this.sessionList.size() > 0) {
            this.session = new Object[this.sessionList.size()];
            for (i = 0; i < this.sessionList.size(); ++i) {
                this.session[i] = "false";
            }
        }
        if (this.session != null && this.session.length > 0) {
            for (i = 0; i < this.session.length; ++i) {
                SessionData sd;
                if (!"true".equals(this.session[i]) || (sd = this.sessionList.get(i)) == null || sd.id == null || sd.id.length() <= 0) continue;
                sd.actData = bridge.getPacSessionList(null, null, sd.id, this.dm.dFrom, this.dm.dTo, this.kcc);
            }
        }
        return true;
    }

    @Override
    public void head(PrintWriter out) throws Exception {
        super.head(out);
        StringBuilder sb = new StringBuilder(200);
        this.writeSessionScript(sb);
        out.println(sb.substring(0));
    }

    @Override
    public void body(PrintWriter out) throws Exception {
        super.body(out);
        StringBuilder sb = new StringBuilder(3000);
        sb.append("<div class=\"inputForm\">\n");
        this.zona(sb, "report_group", "group", true, this.opcioDefecte, this.vectorToArray(this.groups, true), this.groupId, this.isEditable, 180);
        this.zona(sb, "report_user", "user", true, this.opcioDefecte, this.vectorToArray(this.users, true), this.userId, this.isEditable, 180);
        this.zona(sb, "report_project", "project", true, this.opcioDefecte, this.vectorToArray(this.projects, false, "-1", "report_all_projects"), this.projectName, this.isEditable, 180);
        sb.append("</div>\n");
        this.zonaParams(sb);
        sb.append("<div class=\"inputForm\">\n");
        this.zonaData(sb);
        sb.append("</div>\n");
        sb.append("</form>\n");
        sb.append("<br clear=\"all\">\n");
        sb.append("<p>\n");
        if (this.sessionList.isEmpty()) {
            sb.append(this.getMsg("report_no_data")).append("\n</p>\n");
        } else {
            this.grafic(sb, "userGraph", false, true);
            sb.append("\n");
            this.grafic(sb, "userGraph", true, true);
            sb.append("\n</p>\n");
            this.resumGlobal(sb, this.sessionList, "tblA", "float: left; margin-right: 10px;");
            this.llistaSessions(sb, this.sessionList, true, "tblA", null);
        }
        out.println(sb.substring(0));
    }
}

