/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.ActivityEditor;
import edu.xtec.jclic.AppletHtmlCreator;
import edu.xtec.jclic.AuthorSettings;
import edu.xtec.jclic.Constants;
import edu.xtec.jclic.Player;
import edu.xtec.jclic.PlayerSettings;
import edu.xtec.jclic.RunnableComponent;
import edu.xtec.jclic.TestPlayerContainer;
import edu.xtec.jclic.bags.ActivityBagEditor;
import edu.xtec.jclic.bags.ActivityBagEditorPanel;
import edu.xtec.jclic.bags.ActivityBagElement;
import edu.xtec.jclic.bags.ActivityBagElementEditor;
import edu.xtec.jclic.bags.ActivitySequenceEditor;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.bags.MediaBagElementEditor;
import edu.xtec.jclic.bags.MediaBagMultiEditorPanel;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.clic3.Clic3;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.ZipFileSystem;
import edu.xtec.jclic.media.CheckMediaSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.project.ExportTaskDlg;
import edu.xtec.jclic.project.ExportToJSDlg;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.jclic.project.NewProjectDlg;
import edu.xtec.jclic.project.ProjectInstallerEditPanel;
import edu.xtec.jclic.project.ProjectSettingsEditor;
import edu.xtec.jclic.skins.AboutWindow;
import edu.xtec.util.BrowserLauncher;
import edu.xtec.util.JDomTreePanel;
import edu.xtec.util.KJMenuItem;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ProgressDialog;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import edu.xtec.util.StreamIO;
import edu.xtec.util.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Document;
import org.jdom.Element;

public class AuthorSingleFrame
extends JPanel
implements ResourceBridge,
TestPlayerContainer,
RunnableComponent,
Constants,
ActionListener {
    protected Options options;
    protected Messages messages;
    protected JClicProject project;
    protected JFrame debugFrame = null;
    protected int recentFilesOffset;
    protected JMenuBar menuBar;
    protected JMenu fileMenu;
    protected JMenu recentFilesMenu;
    protected JMenu toolsMenu;
    protected JMenu helpMenu;
    protected JMenu editMenu;
    protected JMenu insertMenu;
    protected JMenu viewMenu;
    protected AuthorSettings settings;
    protected Player player;
    protected JTabbedPane tabbedPane;
    protected Action[] actions;
    protected Action[] projectActions;
    private SwingWorker worker = null;
    protected JDialog playerDlg;
    protected JClicProjectEditor projectEditor;
    protected EditorPanel mediaBagEditorPanel;
    protected EditorPanel activityBagEditorPanel;
    protected EditorPanel activitySequenceEditorPanel;
    protected EditorPanel projectSettingsEditorPanel;
    protected ProgressDialog progressDialog;
    public static final String MESSAGES_BUNDLE = "messages.AuthorMessages";
    public static final int ACTION_OPEN_FILE = 0;
    public static final int ACTION_OPEN_URL = 1;
    public static final int ACTION_SAVE_FILE = 2;
    public static final int ACTION_SAVE_FILE_AS = 3;
    public static final int ACTION_EXIT = 4;
    public static final int ACTION_SETTINGS = 5;
    public static final int ACTION_DOCTREE = 6;
    public static final int ACTION_ABOUT = 7;
    public static final int ACTION_NEW_PROJECT = 8;
    public static final int ACTION_EDIT_PROJECT = 9;
    public static final int ACTION_EDIT_MEDIA = 10;
    public static final int ACTION_EDIT_ACTIVITIES = 11;
    public static final int ACTION_EDIT_SEQ = 12;
    public static final int ACTION_CREATE_HTML = 13;
    public static final int ACTION_CREATE_INSTALLER = 14;
    public static final int ACTION_IMPORT_ACTIVITIES = 15;
    public static final int ACTION_EXPORT_HTML5 = 16;
    public static final int AUTHOR_NUM_ACTIONS = 17;
    public static final String[] ACTION_NAMES = new String[]{"openFile", "openUrl", "saveFile", "saveFileAs", "exit", "settings", "docTree", "helpAbout", "newProject", "editProject", "editMedia", "editActivities", "editSeq", "createHTML", "createInstaller", "importActivities", "exportProject"};
    public static final String[] ACTION_ICONS = new String[]{"icons/file_open.gif", "icons/world.gif", "icons/file_save.gif", "icons/file_save_as.gif", "icons/exit_small.gif", "icons/settings.gif", "icons/tree.gif", "icons/help.gif", "icons/project_new.gif", "icons/project_settings.gif", "icons/media_bag.gif", "icons/miniclic.png", "icons/sequence.gif", "icons/html_doc.gif", "icons/installer.gif", "icons/import_act.png", "icons/html_doc.gif"};
    static boolean saveResult;
    private EditorPanel lastFocusedPanel;
    protected FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent ev) {
            if (AuthorSingleFrame.this.playerDlg != null && AuthorSingleFrame.this.playerDlg.isShowing()) {
                AuthorSingleFrame.this.playerDlg.requestFocus();
            } else {
                AuthorSingleFrame.this.checkTabbedPaneFocus(false);
            }
        }

        @Override
        public void focusLost(FocusEvent ev) {
            AuthorSingleFrame.this.checkTabbedPaneFocus(true);
        }
    };

    public AuthorSingleFrame(Options options) {
        this.options = options;
        this.setLayout(new BorderLayout());
        this.init();
    }

    protected final void init() {
        this.settings = AuthorSettings.loadAuthorSettings(this);
        this.options.setLookAndFeel();
        Utils.checkRenderingHints(this.options);
        CheckMediaSystem.check(this.options, false);
        this.setMessages();
        this.buildActions();
        this.setActionsText();
        this.progressDialog = new ProgressDialog(this, this.options);
        ActiveBox.compressImages = this.options.getBoolean("compressImages", true);
        this.createFrames();
    }

    @Override
    public void activate() {
        this.focusListener.focusGained(null);
    }

    @Override
    public InputStream getProgressInputStream(InputStream is, int expectedLength, String name) {
        return this.progressDialog == null ? is : this.progressDialog.getProgressInputStream(is, expectedLength, name);
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public String getMsg(String key) {
        return this.messages.get(key);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void addTo(RootPaneContainer cont, Object constraints) {
        cont.setContentPane(this);
        this.checkMenu(false);
    }

    @Override
    public boolean start(String fullPath, String sequence) {
        boolean result = false;
        if (fullPath != null) {
            result = this.load(fullPath, sequence);
        }
        return result;
    }

    @Override
    public void stop() {
    }

    @Override
    public void end() {
    }

    public Messages setMessages() {
        this.messages = Messages.getMessages(this.options, "messages.JClicMessages");
        this.messages.addBundle("commonSettings");
        this.messages.addBundle("messages.PlayerMessages");
        this.messages.addBundle(MESSAGES_BUNDLE);
        this.setLocale(this.messages.getLocale());
        return this.messages;
    }

    public boolean load(String fullPath, String sequence) {
        this.load(fullPath, sequence, null);
        return true;
    }

    public void load(final String sFullPath, final String sSequence, final String sActivity) {
        if (this.worker != null) {
            return;
        }
        if (sFullPath != null && this.project != null) {
            if (this.project != null) {
                this.project.mediaBag.clearData();
            }
            if (this.player != null) {
                this.player.activeMediaBag.removeAll();
            }
            System.gc();
        }
        this.worker = new SwingWorker(){
            ActivityBagElement abe = null;
            Exception exception = null;
            AuthorSingleFrame thisAuthor = AuthorSingleFrame.this;
            String fullPath = null;
            String sequence = null;
            String activityName = null;
            boolean imported = false;

            @Override
            public Object construct() {
                AuthorSingleFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    this.fullPath = Clic3.pacNameToLowerCase(sFullPath);
                    this.sequence = Clic3.pacNameToLowerCase(sSequence);
                    this.activityName = sActivity;
                    boolean prompted = false;
                    while (!this.isCancelled()) {
                        FileSystem fileSystem;
                        String dn = this.fullPath != null ? this.fullPath : (this.sequence != null ? this.sequence : this.activityName);
                        AuthorSingleFrame.this.progressDialog.setText(AuthorSingleFrame.this.messages.get("msg_loading") + " " + dn);
                        FileSystem fileSystem2 = fileSystem = AuthorSingleFrame.this.project == null ? AuthorSingleFrame.this.createFileSystem() : AuthorSingleFrame.this.project.getFileSystem();
                        if (this.fullPath != null) {
                            String projectName;
                            if (fileSystem != null) {
                                this.fullPath = fileSystem.getUrl(this.fullPath);
                                if (this.fullPath.startsWith("file://")) {
                                    this.fullPath = this.fullPath.substring(7);
                                } else if (this.fullPath.indexOf(63) > 0) {
                                    this.fullPath = this.fullPath.substring(0, this.fullPath.indexOf(63));
                                }
                            }
                            if (this.sequence == null) {
                                this.sequence = "0";
                            }
                            if (this.fullPath.endsWith(".jclic.zip")) {
                                fileSystem = FileSystem.createFileSystem(this.fullPath, this.thisAuthor);
                                String[] projects = ((ZipFileSystem)fileSystem).getEntries(".jclic");
                                if (projects == null) {
                                    throw new Exception("File " + this.fullPath + " does not contain any jclic project");
                                }
                                projectName = projects[0];
                            } else {
                                fileSystem = new FileSystem(FileSystem.getPathPartOf(this.fullPath), this.thisAuthor);
                                projectName = FileSystem.getFileNameOf(this.fullPath);
                            }
                            if (projectName.endsWith(".jclic")) {
                                Document doc = fileSystem.getXMLDocument(projectName);
                                System.gc();
                                AuthorSingleFrame.this.setProject(JClicProject.getJClicProject(doc.getRootElement(), this.thisAuthor, fileSystem, this.fullPath));
                            } else {
                                this.sequence = projectName;
                                AuthorSingleFrame.this.setProject(new JClicProject(this.thisAuthor, fileSystem, this.fullPath));
                            }
                        }
                        if (this.sequence != null) {
                            int i;
                            ActivitySequenceElement ase = null;
                            String seqName = FileSystem.stdFn(this.sequence);
                            if (AuthorSingleFrame.this.project != null) {
                                ase = AuthorSingleFrame.this.project.activitySequence.getElementByTag(seqName, true);
                            }
                            if (ase == null && AuthorSingleFrame.this.project != null && (i = StrUtils.getAbsIntValueOf(seqName)) >= 0) {
                                ase = AuthorSingleFrame.this.project.activitySequence.getElement(i, true);
                            }
                            if (ase == null && AuthorSingleFrame.this.project != null) {
                                boolean firstPac = AuthorSingleFrame.this.project.activitySequence.getSize() == 0;
                                boolean isPcc = seqName.endsWith(".pcc");
                                boolean isPac = seqName.endsWith(".pac");
                                if (isPcc || isPac) {
                                    this.imported = true;
                                    if (isPcc) {
                                        String path = fileSystem.root + seqName;
                                        fileSystem = FileSystem.createFileSystem(path, this.thisAuthor);
                                        if (firstPac) {
                                            AuthorSingleFrame.this.project.setFileSystem(fileSystem);
                                            AuthorSingleFrame.this.project.setFullPath(path);
                                        } else {
                                            AuthorSingleFrame.this.setProject(new JClicProject(this.thisAuthor, fileSystem, path));
                                        }
                                        firstPac = true;
                                        Clic3.readPccFile(AuthorSingleFrame.this.project);
                                        ase = AuthorSingleFrame.this.project.activitySequence.getCurrentAct();
                                    } else if (isPac) {
                                        Clic3.addPacToSequence(AuthorSingleFrame.this.project, seqName);
                                        ase = AuthorSingleFrame.this.project.activitySequence.getElementByTag(seqName, true);
                                    }
                                    if (firstPac) {
                                        AuthorSingleFrame.this.project.setName(seqName);
                                    }
                                }
                            }
                            if (ase != null) {
                                this.activityName = ase.getActivityName();
                            }
                        }
                        if (this.activityName != null && AuthorSingleFrame.this.project != null) {
                            String actName = FileSystem.stdFn(this.activityName);
                            this.abe = AuthorSingleFrame.this.project.activityBag.getElement(actName);
                        }
                        this.fullPath = null;
                        this.sequence = null;
                        this.activityName = null;
                        if (AuthorSingleFrame.this.project != null) {
                            AuthorSingleFrame.this.project.activitySequence.checkAllElements();
                        }
                        if (AuthorSingleFrame.this.project != null) {
                            HashMap<String, String> hm = new HashMap<String, String>();
                            AuthorSingleFrame.this.project.activityBag.listReferences("sequence", hm);
                            AuthorSingleFrame.this.project.activityBag.listReferences("activity", hm);
                            AuthorSingleFrame.this.project.activitySequence.listReferences(null, hm);
                            Iterator it = hm.keySet().iterator();
                            while (it.hasNext() && !this.isCancelled()) {
                                String s = (String)it.next();
                                if ("sequence".equals(hm.get(s))) {
                                    if (AuthorSingleFrame.this.project.activitySequence.getElementByTag(s, false) != null) continue;
                                    this.sequence = Clic3.pacNameToLowerCase(s);
                                    break;
                                }
                                if (AuthorSingleFrame.this.project.activityBag.activityExists(s)) continue;
                                this.activityName = s;
                                break;
                            }
                        }
                        if (this.fullPath == null && this.sequence == null && this.activityName == null) break;
                        if (!prompted) {
                            boolean bl = prompted = AuthorSingleFrame.this.messages.showQuestionDlg(AuthorSingleFrame.this.progressDialog, "msg_prompt_loadReferences", null, "yn") == 1;
                            if (!prompted) break;
                        }
                        this.abe = null;
                    }
                    if (AuthorSingleFrame.this.project != null && !this.isCancelled()) {
                        AuthorSingleFrame.this.project.mediaBag.waitForAllImages();
                    }
                }
                catch (Exception ex) {
                    this.exception = ex;
                    System.err.println("Exception:" + ex);
                }
                AuthorSingleFrame.this.attachProject();
                if (this.imported && AuthorSingleFrame.this.projectEditor != null) {
                    AuthorSingleFrame.this.projectEditor.setModified(true);
                }
                return this.abe;
            }

            @Override
            public void finished() {
                AuthorSingleFrame.this.progressDialog.setVisible(false);
                AuthorSingleFrame.this.setCursor(null);
                if (AuthorSingleFrame.this.worker == null || this.exception != null) {
                    ArrayList<Object> v = new ArrayList<Object>();
                    if (this.fullPath != null) {
                        v.add(this.fullPath);
                    }
                    if (this.sequence != null) {
                        v.add(this.sequence);
                    }
                    if (this.activityName != null) {
                        v.add(this.activityName);
                    }
                    AuthorSingleFrame.this.messages.showErrorWarning((Component)this.thisAuthor, "err_reading_data", v, this.exception, null);
                }
                AuthorSingleFrame.this.worker = null;
                AuthorSingleFrame.this.setEnabled(true);
            }
        };
        this.setCursor(null);
        this.setEnabled(false);
        this.progressDialog.start("WORKING", "msg_loading_project", this.worker, true, true, false);
    }

    protected void setProject(JClicProject p) {
        if (this.project != null) {
            this.project.end();
        }
        this.project = p;
        this.setFrameTitle(null);
        this.checkActions();
    }

    protected void setFrameTitle(String s) {
        Frame fr = JOptionPane.getFrameForComponent(this);
        if (fr != null) {
            StringBuilder sb = new StringBuilder("JClic author");
            if (s != null && s.length() > 0) {
                sb.append(" - ").append(s);
            } else if (this.project != null) {
                sb.append(" - ").append(this.project.getName());
            }
            fr.setTitle(sb.substring(0));
        }
    }

    protected void checkActions() {
        if (this.projectActions != null) {
            for (int i = 0; i < this.projectActions.length; ++i) {
                this.projectActions[i].setEnabled(this.project != null);
            }
        }
    }

    protected FileSystem createFileSystem() {
        return this.settings.fileSystem;
    }

    protected void createMenu() {
        Editor.createBasicActions(this.options);
        MediaBagEditor.createActions(this.options);
        ActivityBagEditor.createBasicActions(this.options);
        ActivitySequenceEditor.createActions(this.options);
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu(this.messages.get("m_File"));
        this.fileMenu.setMnemonic(this.messages.get("m_File_Mnemonic").charAt(0));
        this.fileMenu.add(new KJMenuItem(this.getAction(8)));
        this.fileMenu.addSeparator();
        this.fileMenu.add(new KJMenuItem(this.getAction(0)));
        this.fileMenu.add(new KJMenuItem(this.getAction(1)));
        this.fileMenu.addSeparator();
        this.fileMenu.add(new KJMenuItem(this.getAction(2)));
        this.fileMenu.add(new KJMenuItem(this.getAction(3)));
        this.menuBar.add(this.fileMenu);
        this.editMenu = new JMenu(this.messages.get("m_Edit"));
        this.editMenu.setMnemonic(this.messages.get("m_Edit_Mnemonic").charAt(0));
        this.editMenu.add(new KJMenuItem(Editor.cutAction));
        this.editMenu.add(new KJMenuItem(Editor.copyAction));
        this.editMenu.add(new KJMenuItem(Editor.pasteAction));
        this.editMenu.add(new KJMenuItem(Editor.deleteAction));
        this.editMenu.addSeparator();
        this.editMenu.add(ActivityBagEditor.copyActivityAttributesAction);
        this.editMenu.addSeparator();
        this.editMenu.add(new KJMenuItem(Editor.moveUpAction));
        this.editMenu.add(new KJMenuItem(Editor.moveDownAction));
        this.menuBar.add(this.editMenu);
        this.insertMenu = new JMenu(this.messages.get("m_Insert"));
        this.insertMenu.setMnemonic(this.messages.get("m_Insert_Mnemonic").charAt(0));
        this.insertMenu.add(MediaBagEditor.newMediaBagElementAction);
        this.insertMenu.add(ActivityBagEditor.newActivityBagElementAction);
        this.insertMenu.add(ActivitySequenceEditor.newActivitySequenceElementAction);
        this.insertMenu.addSeparator();
        this.insertMenu.add(new KJMenuItem(this.getAction(15)));
        this.menuBar.add(this.insertMenu);
        this.toolsMenu = new JMenu(this.messages.get("m_Tools"));
        this.toolsMenu.setMnemonic(this.messages.get("m_Tools_Mnemonic").charAt(0));
        this.toolsMenu.add(new KJMenuItem(this.getAction(5)));
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(new KJMenuItem(this.getAction(6)));
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(new KJMenuItem(this.getAction(16)));
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(new KJMenuItem(this.getAction(13)));
        this.toolsMenu.add(new KJMenuItem(this.getAction(14)));
        this.menuBar.add(this.toolsMenu);
        this.viewMenu = new JMenu(this.messages.get("m_View"));
        this.viewMenu.setMnemonic(this.messages.get("m_View_Mnemonic").charAt(0));
        this.viewMenu.add(new KJMenuItem(this.getAction(9)));
        this.viewMenu.add(new KJMenuItem(this.getAction(10)));
        this.viewMenu.add(new KJMenuItem(this.getAction(11)));
        this.viewMenu.add(new KJMenuItem(this.getAction(12)));
        this.viewMenu.addSeparator();
        this.viewMenu.add(ActivityBagElementEditor.testActivityAction);
        this.viewMenu.add(MediaBagElementEditor.testMediaBagElementAction);
        this.menuBar.add(this.viewMenu);
        this.helpMenu = new JMenu(this.messages.get("m_Help"));
        this.helpMenu.setMnemonic(this.messages.get("m_Help_Mnemonic").charAt(0));
        this.helpMenu.add(new KJMenuItem(this.getAction(7)));
        this.menuBar.add(this.helpMenu);
    }

    protected void postCreateMenu() {
        this.fileMenu.addSeparator();
        this.fileMenu.add(new KJMenuItem(this.getAction(4)));
        this.fileMenu.addSeparator();
        this.recentFilesMenu = this.fileMenu;
        this.recentFilesOffset = this.fileMenu.getItemCount();
        this.updateRecentFilesMenu();
    }

    protected void checkMenu(boolean recreate) {
        JRootPane rp = this.getRootPane();
        if (rp == null) {
            return;
        }
        if (recreate || rp.getJMenuBar() == null) {
            if (recreate || this.menuBar == null) {
                this.createMenu();
                this.postCreateMenu();
            }
            rp.setJMenuBar(this.menuBar);
            rp.revalidate();
        }
    }

    protected void updateRecentFilesMenu() {
        if (this.recentFilesMenu != null && this.recentFilesOffset >= 0) {
            int i;
            int itemsToRemove = this.recentFilesMenu.getItemCount() - this.recentFilesOffset;
            for (i = 0; i < itemsToRemove; ++i) {
                this.recentFilesMenu.remove(this.recentFilesOffset);
            }
            for (i = 0; i < PlayerSettings.MAX_RECENT; ++i) {
                if (this.settings.recentFiles[i] == null) continue;
                String s = this.settings.recentFiles[i];
                int k = s.lastIndexOf(92);
                if (k < 0) {
                    k = s.lastIndexOf(47);
                }
                if (k >= 0) {
                    s = s.substring(k + 1);
                }
                this.createMenuItem(this.recentFilesMenu, Integer.toString(i + 1) + ". " + s, "recent" + i, true, KeyStroke.getKeyStroke(49 + i, 8));
            }
        }
    }

    JMenuItem createMenuItem(JComponent parent, String text, String actionCommand, boolean mnemonic, KeyStroke accelerator) {
        JMenuItem jmi = new JMenuItem(text);
        if (actionCommand != null) {
            jmi.setActionCommand(actionCommand);
            jmi.addActionListener(this);
        }
        if (mnemonic) {
            jmi.setMnemonic(jmi.getText().charAt(0));
        }
        if (accelerator != null) {
            jmi.setAccelerator(accelerator);
        }
        parent.add(jmi);
        return jmi;
    }

    protected int getNumActions() {
        return 17;
    }

    protected void buildActions() {
        this.actions = new Action[this.getNumActions()];
        this.actions[0] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String fileName;
                int[] filters;
                FileSystem fs;
                String result;
                if (AuthorSingleFrame.this.checkSaveChanges() && (result = (fs = AuthorSingleFrame.this.settings.fileSystem).chooseFile(null, false, filters = new int[]{5, 7, 4}, AuthorSingleFrame.this.options, null, AuthorSingleFrame.this, false)) != null && AuthorSingleFrame.this.load(fileName = fs.getFullFileNamePath(result), null)) {
                    AuthorSingleFrame.this.addRecentFile(fileName);
                }
            }
        };
        this.actions[1] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String url;
                if (AuthorSingleFrame.this.checkSaveChanges() && (url = AuthorSingleFrame.this.messages.showInputDlg((Component)AuthorSingleFrame.this, "URL_OPEN", "URL", "http://", "URL_OPEN", false)) != null) {
                    if ((url = url.trim()).startsWith("http://http://")) {
                        url = url.substring(7);
                    }
                    if (url.length() > 0 && !url.equals("http://") && AuthorSingleFrame.this.load(url, null)) {
                        AuthorSingleFrame.this.addRecentFile(url);
                    }
                }
            }
        };
        this.actions[2] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AuthorSingleFrame.this.saveFile(false);
            }
        };
        this.actions[3] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AuthorSingleFrame.this.saveFile(true);
            }
        };
        this.actions[4] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AuthorSingleFrame.this.exit();
            }
        };
        this.actions[5] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String currentLook = AuthorSingleFrame.this.options.getString("lookAndFeel");
                String currentLanguage = AuthorSingleFrame.this.options.getString("language");
                String currentCountry = AuthorSingleFrame.this.options.getString("country");
                String currentVariant = AuthorSingleFrame.this.options.getString("variant");
                String currentMediaSystem = AuthorSingleFrame.this.settings.mediaSystem;
                if (AuthorSingleFrame.this.settings.edit(AuthorSingleFrame.this)) {
                    AuthorSingleFrame.this.settings.save();
                    AuthorSingleFrame.this.options.syncProperties(AuthorSingleFrame.this.settings.getProperties(), false);
                    boolean recreateMenu = false;
                    if (!AuthorSingleFrame.this.settings.lookAndFeel.equals(currentLook)) {
                        AuthorSingleFrame.this.options.setLookAndFeel();
                        recreateMenu = true;
                    }
                    if (!(AuthorSingleFrame.this.settings.language == null || StrUtils.compareObjects(AuthorSingleFrame.this.settings.language, currentLanguage) && StrUtils.compareObjects(AuthorSingleFrame.this.settings.country, currentCountry) && StrUtils.compareObjects(AuthorSingleFrame.this.settings.variant, currentVariant))) {
                        AuthorSingleFrame.this.setMessages();
                        recreateMenu = true;
                    }
                    if (recreateMenu) {
                        AuthorSingleFrame.this.checkMenu(true);
                    }
                    if (!currentMediaSystem.equals(AuthorSingleFrame.this.settings.mediaSystem)) {
                        AuthorSingleFrame.this.options.put("mediaSystem", AuthorSingleFrame.this.settings.mediaSystem);
                        CheckMediaSystem.check(AuthorSingleFrame.this.options, false);
                    }
                }
            }
        };
        this.actions[6] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Element e;
                if (AuthorSingleFrame.this.project != null && (e = JDomTreePanel.editElement(AuthorSingleFrame.this, AuthorSingleFrame.this.project.getJDomElement(), AuthorSingleFrame.this, AuthorSingleFrame.this.project.getFileSystem(), AuthorSingleFrame.this.project.getName(), "edit_docTree_title")) != null) {
                    try {
                        String fullPath = AuthorSingleFrame.this.project.getFullPath();
                        JClicProject prj = JClicProject.getJClicProject(e, AuthorSingleFrame.this, FileSystem.createFileSystem(fullPath, AuthorSingleFrame.this), fullPath);
                        if (prj != null) {
                            AuthorSingleFrame.this.setProject(prj);
                            AuthorSingleFrame.this.attachProject();
                            AuthorSingleFrame.this.projectEditor.setModified(true);
                        }
                    }
                    catch (Exception ex) {
                        AuthorSingleFrame.this.messages.showErrorWarning(AuthorSingleFrame.this, "edit_tree_badFormat", ex);
                    }
                }
            }
        };
        this.actions[15] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int[] filters;
                FileSystem fs;
                String result;
                if (AuthorSingleFrame.this.project != null && (result = (fs = AuthorSingleFrame.this.settings.fileSystem).chooseFile(null, false, filters = new int[]{4}, AuthorSingleFrame.this.options, "import_selectProject", AuthorSingleFrame.this, false)) != null) {
                    String fullPath = fs.getFullFileNamePath(result);
                    if (new File(AuthorSingleFrame.this.project.getFileSystem().getFullRoot()).equals(new File(fullPath))) {
                        AuthorSingleFrame.this.messages.showAlert((Component)AuthorSingleFrame.this, "import_warn_samefile");
                    } else {
                        AuthorSingleFrame.this.doImportActivities(fullPath);
                    }
                }
            }
        };
        this.actions[7] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AboutWindow aw = new AboutWindow((Component)AuthorSingleFrame.this, AuthorSingleFrame.this, new Dimension(500, 400));
                try {
                    aw.buildAboutTab("JClic author", AuthorSingleFrame.this.getMsg("AUTHOR_VERSION"), "logo_author_small.png", null, null, null, null);
                    aw.buildStandardTab(aw.getHtmlSystemInfo(), "about_window_systemInfo", "about_window_lb_system", "icons/system_small.gif");
                    aw.setVisible(true);
                }
                catch (Exception ex) {
                    System.err.println("Error building about window: " + ex);
                }
            }
        };
        this.actions[8] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                JClicProject prj;
                if (AuthorSingleFrame.this.checkSaveChanges() && (prj = NewProjectDlg.prompt(AuthorSingleFrame.this, AuthorSingleFrame.this, AuthorSingleFrame.this.createFileSystem())) != null) {
                    AuthorSingleFrame.this.setProject(prj);
                    AuthorSingleFrame.this.attachProject();
                }
            }
        };
        this.actions[16] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String inputPath;
                String[] folders;
                if (AuthorSingleFrame.this.checkSaveChanges() && (folders = ExportToJSDlg.prompt(AuthorSingleFrame.this, AuthorSingleFrame.this, inputPath = AuthorSingleFrame.this.project.getFileSystem().getFullFileNamePath(""), AuthorSingleFrame.this.settings.rootExportPath, AuthorSingleFrame.this.settings.rootScormPath)) != null) {
                    String mainFile;
                    boolean exportAll = folders[2].equals("true");
                    String scormFile = folders[3];
                    if (!exportAll) {
                        inputPath = AuthorSingleFrame.this.project.getFileSystem().getFullRoot();
                    }
                    if ((mainFile = AuthorSingleFrame.this.project.getFileSystem().getRelativeFileNamePath(AuthorSingleFrame.this.project.getFullPath())).endsWith(".zip")) {
                        mainFile = mainFile.substring(0, mainFile.length() - 4);
                    }
                    ExportTaskDlg.doTask(AuthorSingleFrame.this, AuthorSingleFrame.this.settings, AuthorSingleFrame.this, inputPath, folders[0], mainFile, AuthorSingleFrame.this.project, exportAll, scormFile);
                }
            }
        };
        this.actions[9] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AuthorSingleFrame.this.tabbedPane != null) {
                    AuthorSingleFrame.this.tabbedPane.setSelectedComponent(AuthorSingleFrame.this.projectSettingsEditorPanel);
                }
            }
        };
        this.actions[10] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AuthorSingleFrame.this.tabbedPane != null) {
                    AuthorSingleFrame.this.tabbedPane.setSelectedComponent(AuthorSingleFrame.this.mediaBagEditorPanel);
                }
            }
        };
        this.actions[11] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AuthorSingleFrame.this.tabbedPane != null) {
                    AuthorSingleFrame.this.tabbedPane.setSelectedComponent(AuthorSingleFrame.this.activityBagEditorPanel);
                }
            }
        };
        this.actions[12] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AuthorSingleFrame.this.tabbedPane != null) {
                    AuthorSingleFrame.this.tabbedPane.setSelectedComponent(AuthorSingleFrame.this.activitySequenceEditorPanel);
                }
            }
        };
        this.actions[13] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AuthorSingleFrame.this.checkSaveChanges()) {
                    AppletHtmlCreator.createHtml(AuthorSingleFrame.this.project, AuthorSingleFrame.this.settings, AuthorSingleFrame.this);
                }
            }
        };
        this.actions[14] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AuthorSingleFrame.this.checkSaveChanges()) {
                    ProjectInstallerEditPanel.createInstaller(AuthorSingleFrame.this.project, AuthorSingleFrame.this);
                }
            }
        };
        this.projectActions = new Action[]{this.actions[2], this.actions[3], this.actions[6], this.actions[12], this.actions[11], this.actions[10], this.actions[9], this.actions[13], this.actions[14], this.actions[15], this.actions[16]};
        this.checkActions();
    }

    protected boolean saveFile(boolean saveAs) {
        boolean ok = false;
        if (this.project != null && this.projectEditor.checkProject(this.options, this, true)) {
            int[] filters = new int[]{1};
            FileSystem fs = this.project.getFileSystem();
            String path = StrUtils.secureString(this.project.getFullPath(), this.project.getName() + ".jclic.zip");
            String pLower = path.toLowerCase();
            if (!pLower.endsWith(".jclic.zip")) {
                if (pLower.endsWith(".jclic")) {
                    path = path + ".zip";
                } else if (pLower.endsWith(".pac") || pLower.endsWith(".pcc")) {
                    int dot = path.lastIndexOf(46);
                    if (dot >= 1) {
                        path = path.substring(0, dot);
                    }
                    path = path + ".jclic.zip";
                }
            }
            File f = new File(path);
            String result = !saveAs && f.exists() && f.canWrite() ? path : fs.chooseFile(path, true, filters, this.options, null, this, false);
            if (result != null) {
                ok = this.doSaveFile(result);
                this.setFrameTitle(null);
            }
        }
        return ok;
    }

    protected boolean doSaveFile(final String fName) {
        if (this.worker != null) {
            return false;
        }
        saveResult = false;
        this.worker = new SwingWorker(){
            Exception exception = null;
            AuthorSingleFrame thisAuthor = AuthorSingleFrame.this;

            @Override
            public Object construct() {
                Boolean o = null;
                AuthorSingleFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    AuthorSingleFrame.this.projectEditor.saveProject(fName);
                    saveResult = true;
                    AuthorSingleFrame.this.addRecentFile(AuthorSingleFrame.this.project.getFullPath());
                    o = true;
                }
                catch (Exception ex) {
                    this.exception = ex;
                }
                return o;
            }

            @Override
            public void finished() {
                AuthorSingleFrame.this.progressDialog.setVisible(false);
                AuthorSingleFrame.this.setCursor(null);
                if (AuthorSingleFrame.this.worker == null || this.exception != null) {
                    AuthorSingleFrame.this.messages.showErrorWarning((Component)this.thisAuthor, "FILE_ERR_SAVING", fName, this.exception, null);
                }
                AuthorSingleFrame.this.worker = null;
                AuthorSingleFrame.this.setEnabled(true);
            }
        };
        this.setCursor(null);
        this.setEnabled(false);
        this.progressDialog.start("WORKING", "msg_saving_project", this.worker, true, false, true);
        return saveResult;
    }

    protected void doImportActivities(final String fullPath) {
        if (this.worker != null) {
            return;
        }
        System.gc();
        this.worker = new SwingWorker(){
            Exception exception = null;
            AuthorSingleFrame thisAuthor = AuthorSingleFrame.this;

            @Override
            public Object construct() {
                Boolean o = null;
                AuthorSingleFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    JClicProject jcp = JClicProject.getJClicProject(this.thisAuthor, fullPath, AuthorSingleFrame.this.progressDialog);
                    if (jcp != null) {
                        AuthorSingleFrame.this.progressDialog.setText(AuthorSingleFrame.this.messages.get("import_importing"));
                        JClicProjectEditor jcped = (JClicProjectEditor)jcp.getEditor(null);
                        JList<ActivityBagElement> actList = new JList<ActivityBagElement>(jcp.activityBag.getElements());
                        JScrollPane pane = new JScrollPane(actList);
                        pane.setPreferredSize(new Dimension(300, 300));
                        if (AuthorSingleFrame.this.messages.showInputDlg((Component)this.thisAuthor, new String[]{"import_selectActivities"}, new String[0], new JComponent[]{pane}, "action_importActivities_caption") && actList.getSelectedIndices().length > 0) {
                            String rootName;
                            AuthorSingleFrame.this.progressDialog.setText(AuthorSingleFrame.this.messages.get("import_checkdep"));
                            Object[] selection = actList.getSelectedValues();
                            ArrayList<String> mediaNames = new ArrayList<String>();
                            for (int i = 0; i < selection.length; ++i) {
                                ActivityBagElement abe = (ActivityBagElement)selection[i];
                                Map<String, String> map = abe.getReferences();
                                for (String media : map.keySet()) {
                                    String mediaType = map.get(media);
                                    if (!"media".equals(mediaType) || mediaNames.contains(media)) continue;
                                    mediaNames.add(media);
                                }
                            }
                            ArrayList<MediaBagElement> mediaBagElements = new ArrayList<MediaBagElement>();
                            for (int i = 0; i < mediaNames.size(); ++i) {
                                MediaBagElement mb = jcp.mediaBag.getElement((String)mediaNames.get(i));
                                if (mb == null) continue;
                                mediaBagElements.add(mb);
                            }
                            for (MediaBagElement mbe : mediaBagElements) {
                                String fName;
                                String name;
                                rootName = name = mbe.getName();
                                AuthorSingleFrame.this.progressDialog.setText(AuthorSingleFrame.this.messages.get("import_impmedia") + " " + name);
                                int prefix = 0;
                                while (AuthorSingleFrame.this.project.mediaBag.getElement(name) != null) {
                                    name = "i0" + Integer.toString(++prefix) + "-" + rootName;
                                }
                                String rootFName = fName = mbe.getFileName();
                                prefix = 0;
                                while (AuthorSingleFrame.this.project.getFileSystem().fileExists(fName)) {
                                    fName = "i0" + Integer.toString(++prefix) + "-" + rootFName;
                                }
                                File outFile = new File(AuthorSingleFrame.this.project.getFileSystem().getFullFileNamePath(fName));
                                outFile.getParentFile().mkdirs();
                                FileOutputStream fos = new FileOutputStream(outFile);
                                StreamIO.writeStreamTo(jcp.mediaBag.getInputStream(mbe.getName()), fos);
                                if (!name.equals(rootName)) {
                                    jcped.getActivityBagEditor().nameChanged(18416, rootName, name);
                                    mbe.setName(name);
                                }
                                if (!fName.equals(rootFName)) {
                                    mbe.setFileName(fName);
                                }
                                mbe.setData(null);
                                AuthorSingleFrame.this.projectEditor.getMediaBagEditor().addMediaBagElement(mbe);
                            }
                            for (int i = 0; i < selection.length; ++i) {
                                String actName;
                                ActivityBagElement abe = (ActivityBagElement)selection[i];
                                rootName = actName = abe.toString();
                                AuthorSingleFrame.this.progressDialog.setText(AuthorSingleFrame.this.messages.get("import_impact") + " " + actName);
                                int prefix = 0;
                                while (AuthorSingleFrame.this.project.activityBag.getElementByName(actName) != null) {
                                    actName = "i0" + Integer.toString(++prefix) + rootName;
                                }
                                if (!actName.equals(rootName)) {
                                    jcped.nameChanged(1, rootName, actName);
                                }
                                ActivityBagElementEditor abeed = (ActivityBagElementEditor)abe.getEditor(null);
                                AuthorSingleFrame.this.projectEditor.getActivityBagEditor().insertEditor(abeed, true, -1, false);
                            }
                            o = true;
                        }
                    }
                }
                catch (Exception ex) {
                    this.exception = ex;
                }
                return o;
            }

            @Override
            public void finished() {
                AuthorSingleFrame.this.progressDialog.setVisible(false);
                AuthorSingleFrame.this.setCursor(null);
                if (AuthorSingleFrame.this.worker == null || this.exception != null) {
                    AuthorSingleFrame.this.messages.showErrorWarning((Component)this.thisAuthor, "FILE_ERR_OPENING", fullPath, this.exception, null);
                }
                AuthorSingleFrame.this.worker = null;
                AuthorSingleFrame.this.setEnabled(true);
            }
        };
        this.setCursor(null);
        this.setEnabled(false);
        this.progressDialog.start("WORKING", "import_importing", this.worker, true, false, true);
    }

    protected void setActionsText() {
        if (this.actions != null) {
            for (int i = 0; i < this.actions.length; ++i) {
                Icon icon;
                if (this.actions[i] == null) continue;
                String s = this.messages.get("action_" + this.getActionName(i) + "_caption");
                if (!s.equals(this.actions[i].getValue("Name"))) {
                    this.actions[i].putValue("Name", s);
                }
                if (!(s = this.messages.get("action_" + this.getActionName(i) + "_tooltip")).equals(this.actions[i].getValue("ShortDescription"))) {
                    this.actions[i].putValue("ShortDescription", s);
                }
                if ((s = this.messages.get("action_" + this.getActionName(i) + "_keys")) != null && s.length() == 2) {
                    this.actions[i].putValue("MnemonicKey", new Integer(s.charAt(0)));
                    if (s.charAt(1) != '*') {
                        this.actions[i].putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)s.charAt(1), 2));
                    }
                }
                if ((icon = this.getActionIcon(i)) == null || icon.equals(this.actions[i].getValue("SmallIcon"))) continue;
                this.actions[i].putValue("SmallIcon", icon);
            }
        }
    }

    protected String getActionName(int actionId) {
        if (actionId < 0 || actionId >= ACTION_NAMES.length) {
            return null;
        }
        return ACTION_NAMES[actionId];
    }

    protected Icon getActionIcon(int actionId) {
        if (actionId < 0 || actionId >= ACTION_ICONS.length) {
            return null;
        }
        return ResourceManager.getImageIcon(ACTION_ICONS[actionId]);
    }

    public Action getAction(int id) {
        if (this.actions == null || id < 0 || id >= this.actions.length) {
            return null;
        }
        return this.actions[id];
    }

    protected boolean processActionEvent(String ac) {
        if (ac.startsWith("recent") && ac.length() > 6) {
            try {
                int i = Integer.parseInt(ac.substring(6));
                if (i >= 0 && i < PlayerSettings.MAX_RECENT && this.settings.recentFiles[i] != null && this.checkSaveChanges()) {
                    this.load(this.settings.recentFiles[i], null);
                }
            }
            catch (Exception ex) {
                System.err.println("invalid command: " + ac);
            }
        } else {
            return !this.isEnabled();
        }
        return true;
    }

    protected void addRecentFile(String fName) {
        this.settings.addRecentFile(fName);
        this.updateRecentFilesMenu();
        this.settings.save();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String cmd = actionEvent.getActionCommand();
        if (cmd != null) {
            this.processActionEvent(cmd);
        }
    }

    public void exit() {
        if (this.checkSaveChanges()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (AuthorSingleFrame.this.options.getApplet() == null) {
                        try {
                            AuthorSingleFrame.this.end();
                            Frame fr = JOptionPane.getFrameForComponent(AuthorSingleFrame.this);
                            if (fr != null) {
                                fr.dispose();
                            } else {
                                System.exit(0);
                            }
                        }
                        catch (Exception ex) {
                            System.err.println("Unable to exit!\n" + ex);
                        }
                    }
                }
            });
        }
    }

    protected void attachProject() {
        this.lastFocusedPanel = null;
        if (this.projectSettingsEditorPanel != null && this.mediaBagEditorPanel != null && this.activityBagEditorPanel != null && this.activitySequenceEditorPanel != null) {
            if (this.project != null) {
                this.project.activityBag.sortByName();
            }
            this.projectEditor = this.project == null ? null : (JClicProjectEditor)this.project.getEditor(null);
            this.projectSettingsEditorPanel.attachEditor(this.projectEditor == null ? null : this.projectEditor.getProjectSettingsEditor(), true);
            this.mediaBagEditorPanel.attachEditor(this.projectEditor == null ? null : this.projectEditor.getMediaBagEditor(), true);
            this.activityBagEditorPanel.attachEditor(this.projectEditor == null ? null : this.projectEditor.getActivityBagEditor(), true);
            this.activitySequenceEditorPanel.attachEditor(this.projectEditor == null ? null : this.projectEditor.getActivitySequenceEditor(), true);
            if (this.project != null) {
                this.player.setProject(this.project);
                this.player.getHistory().clearHistory();
            }
            if (this.projectEditor != null) {
                this.projectEditor.setTestPlayerContainer(this);
            }
        }
        this.actions[6].setEnabled(this.project != null);
    }

    protected void checkTabbedPaneFocus(boolean focusLost) {
        if (this.tabbedPane != null) {
            Component o = this.tabbedPane.getSelectedComponent();
            if (!focusLost && o instanceof EditorPanel) {
                if (this.lastFocusedPanel != null) {
                    this.lastFocusedPanel.focusLost(null);
                }
                this.lastFocusedPanel = (EditorPanel)o;
                this.lastFocusedPanel.focusGained(null);
            } else {
                Editor.clearBasicActionsOwner();
            }
        }
    }

    protected void createFrames() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                AuthorSingleFrame.this.checkTabbedPaneFocus(false);
            }
        });
        JClicProject newProject = new JClicProject(this, new FileSystem(this), "");
        this.projectEditor = (JClicProjectEditor)newProject.getEditor(null);
        ProjectSettingsEditor psed = this.projectEditor.getProjectSettingsEditor();
        this.projectSettingsEditorPanel = psed.createEditorPanel(this.options);
        this.tabbedPane.addTab(this.messages.get("edit_project"), JClicProjectEditor.getIcon(), this.projectSettingsEditorPanel, this.messages.get("edit_project_tooltip"));
        this.mediaBagEditorPanel = new MediaBagMultiEditorPanel(this.options);
        this.tabbedPane.addTab(this.messages.get("edit_media"), MediaBagEditor.getIcon(), this.mediaBagEditorPanel, this.messages.get("edit_media_tooltip"));
        ActivityBagEditor abe = this.projectEditor.getActivityBagEditor();
        this.activityBagEditorPanel = abe.createEditorPanel(this.options);
        this.tabbedPane.addTab(this.messages.get("edit_activities"), ActivityEditor.getIcon(), this.activityBagEditorPanel, this.messages.get("edit_activities_tooltip"));
        this.activitySequenceEditorPanel = this.projectEditor.getActivitySequenceEditor().createEditorPanel(this.options);
        this.tabbedPane.addTab(this.messages.get("edit_sequences"), ActivitySequenceEditor.getIcon(), this.activitySequenceEditorPanel, this.messages.get("edit_sequences_tooltip"));
        this.playerDlg = new JDialog(JOptionPane.getFrameForComponent(this), "test player", true);
        this.player = new Player(this.options, newProject);
        this.player.getHistory().setTestMode(true);
        this.player.appName = "JClic test player";
        this.player.addTo(this.playerDlg, null);
        this.playerDlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                AuthorSingleFrame.this.player.closeHelpWindow();
                AuthorSingleFrame.this.player.removeActivity();
            }
        });
        this.playerDlg.pack();
        this.add((Component)this.tabbedPane, "Center");
    }

    @Override
    public Player getTestPlayer() {
        return this.player;
    }

    @Override
    public void test() {
        if (this.playerDlg != null && this.player != null) {
            this.player.initReporter();
            if (this.player.reporter != null && this.project != null) {
                this.player.reporter.newSession(this.project, this.player, this.messages);
            }
            this.playerDlg.setVisible(true);
        }
    }

    @Override
    public boolean newInstanceRequest(final String param1, final String param2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Frame frame = JOptionPane.getFrameForComponent(AuthorSingleFrame.this);
                if (frame != null) {
                    frame.toFront();
                }
                AuthorSingleFrame.this.messages.showAlert((Component)AuthorSingleFrame.this, new String[]{"new instance request", param1, param2});
            }
        });
        return true;
    }

    protected boolean checkSaveChanges() {
        boolean result = true;
        if (this.projectEditor != null) {
            this.projectEditor.collectData();
            if (this.projectEditor.isModified()) {
                switch (this.messages.showQuestionDlg(this, "warn_project_modified", "CONFIRM", "ync")) {
                    case 1: {
                        result = this.saveFile(false);
                        break;
                    }
                    case 5: {
                        result = false;
                        break;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean windowCloseRequested() {
        return this.checkSaveChanges();
    }

    @Override
    public void displayUrl(String url, boolean inFrame) {
        try {
            BrowserLauncher.openURL(url);
        }
        catch (Exception ex) {
            System.err.println("Unable to invoque URL " + url + "\n" + ex);
        }
    }

    @Override
    public void editActivity(String activityName) {
        if (this.tabbedPane != null && this.activityBagEditorPanel != null && ((ActivityBagEditorPanel)this.activityBagEditorPanel).editActivity(activityName)) {
            this.tabbedPane.setSelectedComponent(this.activityBagEditorPanel);
        }
    }
}

