/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityBaseEditor;
import edu.xtec.jclic.beans.BoxBaseButton;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.ActiveBoxContentEditor;
import edu.xtec.jclic.boxes.ActiveBoxPreviewPanel;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.util.Options;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EtchedBorder;

public class TextPrevScreenEditorPanel
extends JPanel
implements ActionListener {
    Options options;
    ActiveBoxPreviewPanel abpp;
    TextActivityBaseEditor tabe;
    private ButtonGroup mainGroup;
    private SmallIntEditor timeEdit;
    private JRadioButton btnSpecial;
    private JTextPane textEdit;
    private BoxBaseButton styleBtn;
    private JPanel prevMsgPanel;
    private JRadioButton btnOriginal;
    private JLabel timeLb;
    private JRadioButton btnNo;
    private static Map<Options, TextPrevScreenEditorPanel> panels = new HashMap<Options, TextPrevScreenEditorPanel>(1);

    public TextPrevScreenEditorPanel(Options options) {
        this.options = options;
        this.initComponents();
        this.styleBtn.setOptions(options);
        this.abpp = (ActiveBoxPreviewPanel)this.prevMsgPanel;
    }

    private void initComponents() {
        this.mainGroup = new ButtonGroup();
        this.btnNo = new JRadioButton();
        this.btnOriginal = new JRadioButton();
        this.btnSpecial = new JRadioButton();
        JScrollPane scroll = new JScrollPane();
        this.textEdit = new JTextPane();
        JLabel styleLb = new JLabel();
        this.styleBtn = new BoxBaseButton();
        JLabel prevMsgLb = new JLabel();
        this.prevMsgPanel = new ActiveBoxPreviewPanel(null);
        this.timeLb = new JLabel();
        this.timeEdit = new SmallIntEditor();
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(200, 300));
        this.btnNo.setText(this.options.getMsg("edit_text_act_prevScreen_no"));
        this.mainGroup.add(this.btnNo);
        this.btnNo.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.btnNo, gridBagConstraints);
        this.btnOriginal.setText(this.options.getMsg("edit_text_act_prevScreen_original"));
        this.mainGroup.add(this.btnOriginal);
        this.btnOriginal.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.btnOriginal, gridBagConstraints);
        this.btnSpecial.setText(this.options.getMsg("edit_text_act_prevScreen_special"));
        this.mainGroup.add(this.btnSpecial);
        this.btnSpecial.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.btnSpecial, gridBagConstraints);
        scroll.setPreferredSize(new Dimension(200, 100));
        scroll.setMinimumSize(new Dimension(100, 100));
        scroll.setViewportView(this.textEdit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)scroll, gridBagConstraints);
        styleLb.setText(this.options.getMsg("edit_style_title"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)styleLb, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.styleBtn, gridBagConstraints);
        prevMsgLb.setText(this.options.getMsg("edit_act_msg_prev"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)prevMsgLb, gridBagConstraints);
        this.prevMsgPanel.setBorder(new EtchedBorder());
        this.prevMsgPanel.setToolTipText(this.options.getMsg("edit_act_msg_prev_tooltip"));
        this.prevMsgPanel.setPreferredSize(new Dimension(200, 40));
        this.prevMsgPanel.setMinimumSize(new Dimension(100, 40));
        this.prevMsgPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 40));
        this.prevMsgPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TextPrevScreenEditorPanel.this.prevMsgPanelMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.prevMsgPanel, gridBagConstraints);
        this.timeLb.setText(this.options.getMsg("edit_text_act_prevScreen_time"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 2, 2, 2);
        this.add((Component)this.timeLb, gridBagConstraints);
        this.timeEdit.setMax(999);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 2, 2, 2);
        this.add((Component)this.timeEdit, gridBagConstraints);
    }

    private void prevMsgPanelMouseClicked(MouseEvent evt) {
        ActiveBoxContent abc;
        if (this.tabe != null && !this.btnNo.isSelected() && (abc = ActiveBoxContentEditor.getActiveBoxContent(this.abpp.getActiveBoxContent(), this, this.options, this.tabe.getMediaBagEditor(), this.abpp.getActiveBox())) != null) {
            this.abpp.setActiveBoxContent(abc);
        }
    }

    public void setTextActivityBaseEditor(TextActivityBaseEditor tabe) {
        this.tabe = tabe;
        if (tabe != null) {
            TextActivityBase tab = (TextActivityBase)tabe.getActivity();
            if (!tab.prevScreen) {
                this.btnNo.setSelected(true);
            } else if (tab.prevScreenText == null) {
                this.btnOriginal.setSelected(true);
            } else {
                this.btnSpecial.setSelected(true);
            }
            this.textEdit.setText(tab.prevScreenText != null ? tab.prevScreenText : "");
            this.timeEdit.setValue(tab.prevScreenMaxTime);
            this.styleBtn.setBoxBase(tab.prevScreenStyle);
            ActiveBoxContent abc = tab.getMessages()[0];
            if (abc != null) {
                this.abpp.setActiveBoxContent(abc);
            } else {
                ActiveBoxContent nabc = new ActiveBoxContent();
                nabc.setBoxBase(new BoxBase());
                this.abpp.setActiveBoxContent(nabc);
            }
            this.checkEnabled();
        }
    }

    public void checkEnabled() {
        this.textEdit.setEnabled(this.btnSpecial.isSelected());
        this.styleBtn.setEnabled(this.btnSpecial.isSelected());
        this.timeEdit.setEnabled(!this.btnNo.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.checkEnabled();
    }

    public static boolean editPrevScreen(Options options, TextActivityBaseEditor tabe, Component parent) {
        TextPrevScreenEditorPanel tpsep = panels.get(options);
        if (tpsep == null) {
            tpsep = new TextPrevScreenEditorPanel(options);
            panels.put(options, tpsep);
        }
        tpsep.setTextActivityBaseEditor(tabe);
        boolean result = options.getMessages().showInputDlg(parent, tpsep, "edit_text_act_prevScreen_title");
        if (result) {
            TextActivityBase tab = (TextActivityBase)tabe.getActivity();
            boolean bl = tab.prevScreen = !tpsep.btnNo.isSelected();
            if (tab.prevScreen) {
                tab.prevScreenText = tpsep.btnOriginal.isSelected() ? null : tpsep.textEdit.getText();
                tab.prevScreenStyle = tpsep.styleBtn.getBoxBase();
                tab.prevScreenMaxTime = tpsep.timeEdit.getValue();
                tab.getMessages()[0] = tpsep.abpp.getActiveBox().getContent();
            } else {
                tab.getMessages()[0] = null;
            }
        }
        return result;
    }
}

