/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.TextTarget;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.beans.TextListEditor;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.ActiveBoxContentEditor;
import edu.xtec.jclic.boxes.JPanelActiveBox;
import edu.xtec.util.Options;
import edu.xtec.util.Resizer;
import edu.xtec.util.ResizerPanel;
import edu.xtec.util.StrUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class TextTargetEditorPanel
extends JPanel
implements PropertyChangeListener,
ActionListener,
Resizer.ResizerListener {
    protected Options options;
    TextTarget textTarget;
    JPanelActiveBox jpab;
    Resizer resizer;
    MediaBagEditor mbe;
    protected static final int[] popValues = new int[]{0, 1, 2, 3};
    protected static final String[] popKeys = new String[]{"no", "always", "onError", "onDemand"};
    protected String[] popItems;
    protected static final Map<Options, TextTargetEditorPanel> panels = new HashMap<Options, TextTargetEditorPanel>(1);
    private JLabel answerLb;
    private TextListEditor answerListEditor;
    private JPanel cardPanel;
    private SmallIntEditor delayEditor;
    private JLabel delayLb;
    private JTextField fillingCh;
    private JLabel fillingChLb;
    private SmallIntEditor iniLenEditor;
    private JLabel iniLenLb;
    private JTextField iniText;
    private JLabel iniTextLb;
    private JCheckBox listChk;
    private TextListEditor listEditor;
    private SmallIntEditor maxLenEditor;
    private SmallIntEditor maxTimeEditor;
    private JLabel maxTimeLb;
    private JLabel maxlenLb;
    private JCheckBox onlyPlayChk;
    private ButtonGroup popupOptions;
    private JPanel popupPreview;
    private JComboBox typeCombo;

    public TextTargetEditorPanel(Options options, MediaBagEditor mbe) {
        this.options = options;
        this.mbe = mbe;
        this.popItems = new String[popKeys.length];
        for (int i = 0; i < this.popItems.length; ++i) {
            this.popItems[i] = options.getMsg("edit_text_act_popup_" + popKeys[i]);
        }
        this.initComponents();
        this.jpab = new JPanelActiveBox(null, null, this.popupPreview);
        this.jpab.catchMouseEvents = false;
        this.jpab.setPreferredSize(this.popupPreview.getPreferredSize());
        this.popupPreview.setBounds(0, 0, this.popupPreview.getPreferredSize().width, this.popupPreview.getPreferredSize().height);
        this.popupPreview.add(this.jpab);
        this.resizer = new Resizer(this.jpab, null, true, this);
    }

    private void initComponents() {
        this.popupOptions = new ButtonGroup();
        JPanel formatPanel = new JPanel();
        this.answerLb = new JLabel();
        this.answerListEditor = new TextListEditor(this.options);
        this.maxlenLb = new JLabel();
        this.maxLenEditor = new SmallIntEditor();
        this.fillingChLb = new JLabel();
        this.fillingCh = new JTextField();
        this.iniLenLb = new JLabel();
        this.iniLenEditor = new SmallIntEditor();
        this.iniTextLb = new JLabel();
        this.iniText = new JTextField();
        this.listChk = new JCheckBox();
        this.listEditor = new TextListEditor(this.options);
        JPanel popupPanel = new JPanel();
        this.typeCombo = new JComboBox<String>(this.popItems);
        this.cardPanel = new JPanel();
        JPanel nullPanel = new JPanel();
        JPanel editPanel = new JPanel();
        JScrollPane popupPreviewScroll = new JScrollPane();
        this.popupPreview = new ResizerPanel();
        this.onlyPlayChk = new JCheckBox();
        this.delayLb = new JLabel();
        this.delayEditor = new SmallIntEditor();
        this.maxTimeLb = new JLabel();
        this.maxTimeEditor = new SmallIntEditor();
        this.setLayout(new GridBagLayout());
        formatPanel.setLayout(new GridBagLayout());
        this.answerLb.setText(this.options.getMsg("edit_text_act_answer_label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        formatPanel.add((Component)this.answerLb, gridBagConstraints);
        this.answerListEditor.setPreferredSize(new Dimension(180, 100));
        this.answerListEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        formatPanel.add((Component)this.answerListEditor, gridBagConstraints);
        this.maxlenLb.setText(this.options.getMsg("edit_text_act_maxLen"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        formatPanel.add((Component)this.maxlenLb, gridBagConstraints);
        this.maxLenEditor.setToolTipText(this.options.getMsg("edit_text_act_maxLen_tooltip"));
        this.maxLenEditor.setMax(999);
        this.maxLenEditor.setMin(1);
        this.maxLenEditor.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        formatPanel.add((Component)this.maxLenEditor, gridBagConstraints);
        this.fillingChLb.setText(this.options.getMsg("edit_text_act_fillingChar"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        formatPanel.add((Component)this.fillingChLb, gridBagConstraints);
        this.fillingCh.setToolTipText(this.options.getMsg("edit_text_act_maxLen_tooltip"));
        this.fillingCh.setColumns(1);
        this.fillingCh.setText("_");
        this.fillingCh.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        formatPanel.add((Component)this.fillingCh, gridBagConstraints);
        this.iniLenLb.setText(this.options.getMsg("edit_text_act_iniLen"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        formatPanel.add((Component)this.iniLenLb, gridBagConstraints);
        this.iniLenEditor.setToolTipText(this.options.getMsg("edit_text_act_iniLen_tooltip"));
        this.iniLenEditor.setMax(999);
        this.iniLenEditor.setMin(1);
        this.iniLenEditor.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        formatPanel.add((Component)this.iniLenEditor, gridBagConstraints);
        this.iniTextLb.setText(this.options.getMsg("edit_text_act_iniText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        formatPanel.add((Component)this.iniTextLb, gridBagConstraints);
        this.iniText.setToolTipText(this.options.getMsg("edit_text_act_iniText_tooltip"));
        this.iniText.setPreferredSize(new Dimension(140, 21));
        this.iniText.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        formatPanel.add((Component)this.iniText, gridBagConstraints);
        this.listChk.setToolTipText(this.options.getMsg("edit_text_act_list_tooltip"));
        this.listChk.setText(this.options.getMsg("edit_text_act_list"));
        this.listChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        formatPanel.add((Component)this.listChk, gridBagConstraints);
        this.listEditor.setPreferredSize(new Dimension(180, 100));
        this.listEditor.setEnabled(false);
        this.listEditor.addPropertyChangeListener("list", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        formatPanel.add((Component)this.listEditor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)formatPanel, gridBagConstraints);
        popupPanel.setLayout(new GridBagLayout());
        popupPanel.setBorder(new TitledBorder(this.options.getMsg("edit_text_act_popup")));
        this.typeCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        popupPanel.add((Component)this.typeCombo, gridBagConstraints);
        this.cardPanel.setLayout(new CardLayout());
        this.cardPanel.add((Component)nullPanel, "card2");
        editPanel.setLayout(new GridBagLayout());
        popupPreviewScroll.setPreferredSize(new Dimension(200, 40));
        this.popupPreview.setLayout(null);
        this.popupPreview.setPreferredSize(new Dimension(300, 300));
        popupPreviewScroll.setViewportView(this.popupPreview);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        editPanel.add((Component)popupPreviewScroll, gridBagConstraints);
        this.onlyPlayChk.setText(this.options.getMsg("edit_text_act_popup_onlyPlay"));
        this.onlyPlayChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        editPanel.add((Component)this.onlyPlayChk, gridBagConstraints);
        this.delayLb.setText(this.options.getMsg("edit_text_act_popup_delay"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        editPanel.add((Component)this.delayLb, gridBagConstraints);
        this.delayEditor.setMax(9999);
        this.delayEditor.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 2, 4, 2);
        editPanel.add((Component)this.delayEditor, gridBagConstraints);
        this.maxTimeLb.setText(this.options.getMsg("edit_text_act_popup_maxTime"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        editPanel.add((Component)this.maxTimeLb, gridBagConstraints);
        this.maxTimeEditor.setMax(9999);
        this.maxTimeEditor.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 2, 4, 2);
        editPanel.add((Component)this.maxTimeEditor, gridBagConstraints);
        this.cardPanel.add((Component)editPanel, "card3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        popupPanel.add((Component)this.cardPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)popupPanel, gridBagConstraints);
    }

    public TextTarget getTextTarget() {
        this.collectData();
        return this.textTarget;
    }

    public void setTextTarget(TextTarget textTarget) {
        ActiveBoxContent abc;
        this.textTarget = textTarget;
        this.answerListEditor.setTextList(textTarget != null ? textTarget.answer : null);
        this.listChk.setSelected(textTarget != null && textTarget.isList);
        this.maxLenEditor.setValue(textTarget != null ? textTarget.maxLenResp : 1);
        this.fillingCh.setText(textTarget != null ? new String(new char[]{textTarget.iniChar}) : "_");
        this.iniLenEditor.setValue(textTarget != null ? textTarget.numIniChars : 1);
        this.iniText.setText(textTarget != null ? (textTarget.iniText != null ? textTarget.iniText : "") : "");
        this.listEditor.setTextList(textTarget != null ? textTarget.options : null);
        int v = 0;
        if (textTarget != null) {
            v = Math.max(Arrays.binarySearch(popValues, textTarget.infoMode), 0);
        }
        this.typeCombo.setSelectedIndex(v);
        this.delayEditor.setValue(textTarget != null ? textTarget.popupDelay : 0);
        this.maxTimeEditor.setValue(textTarget != null ? textTarget.popupMaxTime : 0);
        this.onlyPlayChk.setSelected(textTarget != null && textTarget.onlyPlay);
        ActiveBoxContent activeBoxContent = abc = textTarget != null ? textTarget.popupContent : null;
        if (abc == null && textTarget != null) {
            abc = new ActiveBoxContent();
            abc.setDimension(new Dimension(100, 40));
        }
        this.jpab.setActiveBoxContent(abc);
        if (abc != null && abc.dimension != null) {
            this.jpab.setBounds(0, 0, abc.dimension.width, abc.dimension.height);
        }
        this.checkEnabled();
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt != null) {
            this.checkEnabled();
        }
    }

    public void checkEnabled() {
        this.answerListEditor.setEnabled(this.textTarget != null);
        this.maxLenEditor.setEnabled(this.textTarget != null && !this.listChk.isSelected());
        this.fillingCh.setEnabled(this.textTarget != null && !this.listChk.isSelected());
        this.iniLenEditor.setEnabled(this.textTarget != null && !this.listChk.isSelected());
        this.iniText.setEnabled(this.textTarget != null);
        this.listChk.setEnabled(this.textTarget != null);
        this.listEditor.setEnabled(this.textTarget != null && this.listChk.isSelected());
        this.typeCombo.setEnabled(this.textTarget != null);
        int v = this.typeCombo.getSelectedIndex();
        this.delayEditor.setEnabled(this.textTarget != null && v > 0);
        this.maxTimeEditor.setEnabled(this.textTarget != null && v > 0);
        this.onlyPlayChk.setEnabled(this.textTarget != null && v > 0);
        this.resizer.setEnabled(this.textTarget != null && v > 0);
        if (this.typeCombo.isEnabled() && this.typeCombo.getSelectedIndex() > 0) {
            ((CardLayout)this.cardPanel.getLayout()).last(this.cardPanel);
        } else {
            ((CardLayout)this.cardPanel.getLayout()).first(this.cardPanel);
        }
    }

    public void collectData() {
        if (this.textTarget != null) {
            String[] answers = this.answerListEditor.getTextList();
            if (answers.length > 0) {
                this.textTarget.answer = answers;
            }
            if (this.listChk.isSelected()) {
                String[] textList = this.listEditor.getTextList();
                if (textList.length > 0) {
                    this.textTarget.isList = true;
                    this.textTarget.options = textList;
                }
            } else {
                this.textTarget.isList = false;
                this.textTarget.options = null;
                this.textTarget.numIniChars = Math.max(1, this.iniLenEditor.getValue());
                this.textTarget.maxLenResp = Math.max(1, this.maxLenEditor.getValue());
                this.textTarget.iniText = StrUtils.nullableString(this.iniText.getText());
                String s = this.fillingCh.getText();
                this.textTarget.iniChar = (char)(s != null && s.length() > 0 ? (int)s.charAt(0) : 95);
            }
            this.textTarget.infoMode = popValues[Math.max(0, this.typeCombo.getSelectedIndex())];
            this.textTarget.popupDelay = this.delayEditor.getValue();
            this.textTarget.popupMaxTime = this.maxTimeEditor.getValue();
            this.textTarget.onlyPlay = this.onlyPlayChk.isSelected();
            if (this.textTarget.infoMode != 0) {
                this.textTarget.popupContent = this.jpab.getActiveBoxContent();
            }
        }
    }

    @Override
    public void resizeObjectTo(Rectangle r, JComponent jc) {
        if (jc == this.jpab) {
            this.jpab.setBounds(r.x, r.y, r.width, r.height);
            Dimension d = new Dimension(r.width, r.height);
            this.jpab.getActiveBoxContent().setDimension(d);
            this.jpab.setPreferredSize(d);
            this.jpab.setMaximumSize(d);
        }
    }

    @Override
    public void editObject(Rectangle r, JComponent jc, Point pt) {
        ActiveBoxContent abc;
        if (jc == this.jpab && (abc = ActiveBoxContentEditor.getActiveBoxContent(this.jpab.ab.getContent(), this.jpab, this.options, this.mbe, this.jpab.ab)) != null) {
            Dimension d = abc.getDimension();
            this.jpab.setActiveBoxContent(abc);
            if (d != null) {
                this.jpab.setBounds(0, 0, d.width, d.height);
            }
        }
    }

    public static boolean editTextTarget(TextTarget tt, Options options, MediaBagEditor mbe, Component parent) {
        TextTargetEditorPanel ttep = panels.get(options);
        if (ttep == null) {
            ttep = new TextTargetEditorPanel(options, mbe);
            panels.put(options, ttep);
        }
        ttep.setTextTarget(tt);
        boolean result = options.getMessages().showInputDlg(parent, ttep, "edit_text_act_target");
        if (result) {
            ttep.collectData();
        }
        ttep.setTextTarget(null);
        return result;
    }
}

