/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.ActivitySequenceElementEditorPanel;
import edu.xtec.jclic.bags.ConditionalJumpInfo;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.util.CtrlPanel;
import edu.xtec.util.CustomListCellRenderer;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class ConditionalJumpPanel
extends CtrlPanel {
    Options options;
    protected String[] jmpOptions;
    protected Icon[] jmpIcons;
    ActivitySequenceElementEditorPanel asep;
    ConditionalJumpInfo ji;
    String sType;
    private static final String[] OPTIONS_KEYS = new String[]{"edit_seq_action_jump", "edit_seq_action_stop", "edit_seq_action_return", "edit_seq_action_exit"};
    private static final String[] OPTIONS_ICONS = new String[]{"seq_next_jump", "seq_next_stop", "seq_next_return", "seq_exit"};
    private JComboBox actionCombo;
    private JButton jumpBtn;
    private JLabel jumpLb;
    private SmallIntEditor thresholdInt;
    private SmallIntEditor timeInt;

    public ConditionalJumpPanel(Options options, ActivitySequenceElementEditorPanel asep, boolean up) {
        this.options = options;
        this.asep = asep;
        this.sType = up ? "up" : "down";
        this.ji = new ConditionalJumpInfo(2, null, 60);
        this.initObjects();
        this.initComponents();
    }

    private void initObjects() {
        int l = OPTIONS_KEYS.length;
        this.jmpOptions = new String[l];
        this.jmpIcons = new Icon[l];
        for (int i = 0; i < l; ++i) {
            this.jmpOptions[i] = this.options.getMsg(OPTIONS_KEYS[i]);
            this.jmpIcons[i] = ResourceManager.getImageIcon("icons/" + OPTIONS_ICONS[i] + ".gif");
        }
    }

    private void initComponents() {
        JLabel actionLb = new JLabel();
        this.actionCombo = new JComboBox<String>(this.jmpOptions);
        this.jumpBtn = new JButton();
        this.jumpLb = new JLabel();
        JLabel thresholdLb = new JLabel();
        this.thresholdInt = new SmallIntEditor();
        JLabel timeLb = new JLabel();
        this.timeInt = new SmallIntEditor();
        this.setLayout(new GridBagLayout());
        actionLb.setLabelFor(this.actionCombo);
        actionLb.setText(this.options.getMsg("edit_seq_action"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)actionLb, gridBagConstraints);
        this.actionCombo.setToolTipText(this.options.getMsg("edit_seq_action_tooltip"));
        this.actionCombo.setRenderer(new CustomListCellRenderer(this.jmpOptions, this.jmpIcons));
        this.actionCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.actionCombo, gridBagConstraints);
        this.jumpBtn.setText("...");
        this.jumpBtn.setToolTipText(this.options.getMsg("edit_seq_jump_tooltip"));
        this.jumpBtn.setMargin(new Insets(0, 3, 0, 3));
        this.jumpBtn.setEnabled(false);
        this.jumpBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jumpBtn, gridBagConstraints);
        this.jumpLb.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jumpLb, gridBagConstraints);
        thresholdLb.setLabelFor(this.thresholdInt);
        thresholdLb.setText(this.options.getMsg("edit_seq_threshold"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)thresholdLb, gridBagConstraints);
        this.thresholdInt.setToolTipText(this.options.getMsg("edit_seq_threshold_tooltip_" + this.sType));
        this.thresholdInt.setMax(100);
        this.thresholdInt.setMin(-1);
        this.thresholdInt.setValue(60);
        this.thresholdInt.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.thresholdInt, gridBagConstraints);
        timeLb.setLabelFor(this.timeInt);
        timeLb.setText(this.options.getMsg("edit_seq_time"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)timeLb, gridBagConstraints);
        this.timeInt.setToolTipText(this.options.getMsg("edit_seq_time_tooltip_" + this.sType));
        this.timeInt.setMax(9999);
        this.timeInt.setMin(-1);
        this.timeInt.setValue(-1);
        this.timeInt.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.timeInt, gridBagConstraints);
    }

    public void setJumpInfo(ConditionalJumpInfo ji, boolean up) {
        ji = ji == null ? new ConditionalJumpInfo(2, null, up ? 80 : 20) : new ConditionalJumpInfo(ji.action, ji.sequence, ji.threshold, ji.time);
        this.ji = ji;
        this.thresholdInt.setValue(ji.threshold);
        this.timeInt.setValue(ji.time);
        this.actionCombo.setSelectedIndex(ji.action);
        this.thresholdInt.setToolTipText(this.options.getMsg("edit_seq_threshold_tooltip_" + (up ? "up" : "down")));
        this.timeInt.setToolTipText(this.options.getMsg("edit_seq_time_tooltip_" + (up ? "up" : "down")));
        this.setJumpLabel();
        this.checkEnabled();
        this.setModified(false);
    }

    public ConditionalJumpInfo getJumpInfo() {
        this.ji.threshold = this.thresholdInt.getValue();
        this.ji.time = this.timeInt.getValue();
        return this.ji;
    }

    @Override
    public boolean eventPerformed(EventObject ev) {
        Object src;
        Object object = src = ev == null ? null : ev.getSource();
        if (src == null) {
            return false;
        }
        if (src == this.actionCombo || src == this.jumpBtn) {
            this.asep.checkJump(this.ji, this.actionCombo, false, src == this.jumpBtn);
            this.setJumpLabel();
        }
        this.checkEnabled();
        this.repaint();
        return true;
    }

    public void checkEnabled() {
        this.jumpBtn.setEnabled(this.ji.action == 0);
    }

    private void setJumpLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.ji.action == 0 && this.ji.sequence != null) {
            sb.append(this.ji.sequence);
            if (this.ji.projectPath != null) {
                sb.append(" (").append(this.ji.projectPath).append(")");
            }
        }
        this.jumpLb.setText(sb.append(' ').substring(0));
    }
}

