/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.bags.MediaBagElementEditor;
import edu.xtec.jclic.bags.MediaBagMultiEditorPanel;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.ZipFileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ProgressDialog;
import edu.xtec.util.StreamIO;
import edu.xtec.util.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MediaBagElementEditorPanel
extends EditorPanel {
    protected ZipFileSystem.ExtendedZipEntry zipEntry;
    protected ZipFileSystem zipFileSystem;
    protected FileSystem fileSystem;
    private JButton chFileBtn;
    private JButton chNameBtn;
    private JButton editActBtn;
    private JLabel fileText;
    private JPanel mainPanel;
    private JLabel nameText;
    private JList refList;
    private JPanel refPanel;
    private JScrollPane refScroll;
    private JButton refreshFileBtn;
    private JButton saveFileBtn;
    private JPanel settingsPanel;
    private JLabel sizeTx;
    private JLabel typeTx;
    private JCheckBox zipIncludeChk;

    public MediaBagElementEditorPanel(Options options) {
        super(options);
        this.initComponents();
        this.refList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    MediaBagElementEditorPanel.this.editActBtn.setEnabled(e.getFirstIndex() >= 0);
                }
            }
        });
        this.postInit(250, false, false);
    }

    @Override
    protected String getTitle() {
        return this.options.getMsg("edit_media_title");
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.settingsPanel = new JPanel();
        JLabel nameLb = new JLabel();
        this.nameText = new JLabel();
        this.chNameBtn = new JButton();
        this.chNameBtn.addActionListener(this);
        JLabel fileLb = new JLabel();
        this.fileText = new JLabel();
        this.chFileBtn = new JButton();
        this.chFileBtn.addActionListener(this);
        this.saveFileBtn = new JButton();
        this.refreshFileBtn = new JButton();
        this.refreshFileBtn.addActionListener(this);
        JLabel typeLb = new JLabel();
        this.typeTx = new JLabel();
        JLabel sizeLb = new JLabel();
        this.sizeTx = new JLabel();
        this.zipIncludeChk = new JCheckBox();
        this.zipIncludeChk.addActionListener(this);
        this.refPanel = new JPanel();
        this.refScroll = new JScrollPane();
        this.refList = new JList();
        this.editActBtn = new JButton();
        this.editActBtn.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.settingsPanel.setLayout(new GridBagLayout());
        nameLb.setText(this.options.getMsg("edit_name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)nameLb, gridBagConstraints);
        this.nameText.setBorder(BorderFactory.createTitledBorder(""));
        this.nameText.setMinimumSize(new Dimension(200, 21));
        this.nameText.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.nameText, gridBagConstraints);
        this.chNameBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/edit.gif")));
        this.chNameBtn.setToolTipText(this.options.getMsg("edit_media_change_name"));
        this.chNameBtn.setText("");
        this.chNameBtn.setMargin(new Insets(2, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.chNameBtn, gridBagConstraints);
        fileLb.setText(this.options.getMsg("edit_file"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)fileLb, gridBagConstraints);
        this.fileText.setBorder(BorderFactory.createTitledBorder(""));
        this.fileText.setMinimumSize(new Dimension(200, 21));
        this.fileText.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.fileText, gridBagConstraints);
        this.chFileBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/file_open.gif")));
        this.chFileBtn.setToolTipText(this.options.getMsg("edit_media_change_file"));
        this.chFileBtn.setText("");
        this.chFileBtn.setMargin(new Insets(2, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.chFileBtn, gridBagConstraints);
        this.saveFileBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/file_save.gif")));
        this.saveFileBtn.setToolTipText(this.options.getMsg("edit_media_save_file"));
        this.saveFileBtn.setText("");
        this.saveFileBtn.setMargin(new Insets(2, 2, 2, 2));
        this.saveFileBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.saveFileBtn, gridBagConstraints);
        this.refreshFileBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/reset.gif")));
        this.refreshFileBtn.setToolTipText(this.options.getMsg("edit_media_refresh_file"));
        this.refreshFileBtn.setText("");
        this.refreshFileBtn.setMargin(new Insets(2, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.refreshFileBtn, gridBagConstraints);
        typeLb.setText(this.options.getMsg("edit_media_type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)typeLb, gridBagConstraints);
        this.typeTx.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.typeTx, gridBagConstraints);
        sizeLb.setText(this.options.getMsg("edit_media_size"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)sizeLb, gridBagConstraints);
        this.sizeTx.setText("0 Kb");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.sizeTx, gridBagConstraints);
        this.zipIncludeChk.setText(this.options.getMsg("edit_media_includeInZip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.settingsPanel.add((Component)this.zipIncludeChk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.settingsPanel, gridBagConstraints);
        this.refPanel.setBorder(BorderFactory.createTitledBorder(this.options.getMsg("edit_media_referencedBy")));
        this.refPanel.setMinimumSize(new Dimension(180, 100));
        this.refPanel.setPreferredSize(new Dimension(180, 100));
        this.refPanel.setLayout(new BorderLayout());
        this.refList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MediaBagElementEditorPanel.this.refListMouseClicked(evt);
            }
        });
        this.refScroll.setViewportView(this.refList);
        this.refPanel.add((Component)this.refScroll, "Center");
        this.editActBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/miniclic.png")));
        this.editActBtn.setToolTipText(this.options.getMsg("edit_act_editActivity_tooltip"));
        this.editActBtn.setText(this.options.getMsg("edit_act_editActivity"));
        this.editActBtn.setHorizontalAlignment(2);
        this.refPanel.add((Component)this.editActBtn, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.refPanel, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
    }

    private void refListMouseClicked(MouseEvent evt) {
        if (this.refList.getSelectedValue() != null && evt.getClickCount() == 2) {
            this.editActivity(this.refList.getSelectedValue().toString());
        }
    }

    protected void editActivity(String activityName) {
        JClicProjectEditor prjed;
        MediaBagElementEditor mbed = this.getMediaBagElementEditor();
        if (mbed != null && activityName != null && (prjed = (JClicProjectEditor)mbed.getFirstParent(JClicProjectEditor.class)) != null && prjed.getTestPlayerContainer() != null) {
            prjed.getTestPlayerContainer().editActivity(activityName);
        }
    }

    @Override
    public boolean checkIfEditorValid(Editor e) {
        return e instanceof MediaBagElementEditor;
    }

    protected MediaBagElementEditor getMediaBagElementEditor() {
        return (MediaBagElementEditor)this.editor;
    }

    protected MediaBagElement getMediaBagElement() {
        if (this.editor == null) {
            return null;
        }
        return this.getMediaBagElementEditor().getMediaBagElement();
    }

    protected MediaBag getMediaBag() {
        if (this.editor == null) {
            return null;
        }
        return this.getMediaBagElementEditor().getMediaBag();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.chNameBtn.setEnabled(false);
            this.chFileBtn.setEnabled(false);
            this.saveFileBtn.setEnabled(false);
            this.refreshFileBtn.setEnabled(false);
            this.zipIncludeChk.setEnabled(false);
        }
        this.refList.setEnabled(enabled);
    }

    @Override
    protected void fillData() {
        MediaBagElementEditor mbed = this.getMediaBagElementEditor();
        String fileName = mbed == null ? "" : mbed.getMediaBagElement().getFileName();
        FileSystem fileSystem = this.fileSystem = mbed == null || mbed.getMediaBag() == null ? null : mbed.getMediaBag().getProject().getFileSystem();
        if (this.fileSystem instanceof ZipFileSystem) {
            this.zipFileSystem = (ZipFileSystem)this.fileSystem;
            this.zipEntry = this.zipFileSystem.getEntry(fileName);
        } else {
            this.zipFileSystem = null;
            this.zipEntry = null;
        }
        String name = mbed == null ? "" : mbed.getName();
        this.nameText.setText(name);
        this.nameText.setToolTipText(name);
        this.chNameBtn.setEnabled(mbed != null);
        this.fileText.setText(fileName);
        this.fileText.setToolTipText(fileName);
        this.chFileBtn.setEnabled(mbed != null);
        this.saveFileBtn.setEnabled(this.zipEntry != null);
        this.refreshFileBtn.setEnabled(mbed != null);
        this.typeTx.setText(mbed == null ? "" : mbed.getDescription(this.options));
        long fSize = -1L;
        if (mbed != null) {
            fSize = mbed.getFileSize();
        }
        this.sizeTx.setText(fSize < 0L ? "" : this.options.getMessages().fileSize(fSize));
        this.zipIncludeChk.setSelected(mbed == null ? true : mbed.getMediaBagElement().saveFlag);
        this.zipIncludeChk.setEnabled(mbed != null);
        this.checkReferences();
    }

    protected void checkReferences() {
        MediaBagElementEditor mbed = this.getMediaBagElementEditor();
        List<String> references = null;
        if (mbed != null) {
            references = mbed.listReferences();
        }
        this.refList.setListData(references == null ? new String[]{} : references.toArray());
        this.refList.setSelectedIndex(-1);
        this.editActBtn.setEnabled(false);
    }

    @Override
    protected void saveData() {
        MediaBagElementEditor mbed = this.getMediaBagElementEditor();
        if (mbed != null) {
            mbed.getMediaBagElement().saveFlag = this.zipIncludeChk.isSelected();
        }
    }

    @Override
    public boolean eventPerformed(EventObject ev) {
        if (ev != null) {
            if (ev.getSource() == this.refreshFileBtn) {
                this.refreshFile();
            } else if (ev.getSource() == this.saveFileBtn) {
                this.saveFile();
            } else if (ev.getSource() == this.chFileBtn) {
                this.changeFileName();
            } else if (ev.getSource() == this.chNameBtn) {
                this.changeName();
            } else if (ev.getSource() == this.editActBtn && this.refList.getSelectedValue() != null) {
                this.editActivity(this.refList.getSelectedValue().toString());
                return false;
            }
        }
        return true;
    }

    private void refreshFile() {
        MediaBagElementEditor mbed = this.getMediaBagElementEditor();
        if (mbed != null) {
            if (this.zipEntry != null) {
                if (!this.zipFileSystem.fileExists(this.getMediaBagElement().getFileName())) {
                    this.options.getMessages().showAlert((Component)this, "edit_media_warn_zipFileNotExternal");
                    return;
                }
                this.zipEntry.ignore = true;
                this.zipEntry = null;
                mbed.updateContent(this);
                this.notifyChangesToParentPanel();
                this.getEditor().setModified(true);
            }
            this.getMediaBagElement().setData(null);
        }
    }

    private void saveFile() {
        String fName;
        String fNameDest;
        if (this.zipEntry != null && (fNameDest = this.zipFileSystem.chooseFile(fName = this.getMediaBagElement().getFileName(), true, null, this.options, "FILE_SAVE", this, false)) != null) {
            try {
                FileOutputStream os = this.zipFileSystem.createSecureFileOutputStream(fNameDest);
                int len = (int)this.zipFileSystem.getFileLength(fName);
                InputStream is = this.zipFileSystem.getInputStream(fName);
                StreamIO.writeStreamDlg(is, os, len, this.options.getMessages().get("filesystem_copyFile"), this, this.options);
            }
            catch (Exception ex) {
                this.options.getMessages().showErrorWarning(this, "FILE_ERR_SAVING", ex);
            }
        }
    }

    private void changeFileName() {
        MediaBagElementEditor mbed = this.getMediaBagElementEditor();
        if (mbed != null) {
            MediaBagElement mbe = mbed.getMediaBagElement();
            Messages msg = this.options.getMessages();
            String oldFileName = mbe.getFileName();
            FileSystem fs = mbed.getMediaBag().getProject().getFileSystem();
            int[] fileFilters = new int[]{Utils.getFileFilterCode(oldFileName)};
            String newFileName = fs.chooseFile(oldFileName.replace('/', File.separatorChar), false, fileFilters, this.options, "edit_find_media", this, true);
            if (newFileName != null && mbed.changeFileName(newFileName = newFileName.replace(File.separatorChar, '/'), this, msg)) {
                this.notifyChangesToParentPanel();
            }
        }
    }

    private void changeName() {
        String oldName;
        Messages msg;
        String newName;
        final MediaBagElementEditor mbed = this.getMediaBagElementEditor();
        if (mbed != null && (newName = (msg = this.options.getMessages()).showInputDlg((Component)this, "edit_media_rename", "edit_media_rename_prompt", oldName = this.getMediaBagElement().getName(), "edit_media_rename_title", false)) != null) {
            final ProgressDialog progressDialog = new ProgressDialog(this, this.options);
            SwingWorker sw = new SwingWorker(){

                @Override
                public Object construct() {
                    mbed.rename(newName, MediaBagElementEditorPanel.this, MediaBagElementEditorPanel.this.options.getMessages());
                    return null;
                }

                @Override
                public void finished() {
                    MediaBagElementEditorPanel.this.notifyChangesToParentPanel();
                    progressDialog.setVisible(false);
                }
            };
            progressDialog.start("edit_media_rename", "edit_media_renaming", sw, false, false, false);
        }
    }

    private void notifyChangesToParentPanel() {
        MediaBagMultiEditorPanel mbep = (MediaBagMultiEditorPanel)this.getAWTAncestor(MediaBagMultiEditorPanel.class);
        if (mbep != null) {
            mbep.editorDataChanged(this.getEditor());
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.checkReferences();
    }
}

