/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBagElementEditor;
import edu.xtec.jclic.beans.ImgPanel;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.JPanelActiveBox;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.Options;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MediaPreviewPanel
extends JPanel {
    public static final int PREFERRED_CMP_WIDTH = 600;
    public static final int PREFERRED_CMP_HEIGHT = 400;
    public static final String SAMPLE_TEXT = "ABCDEFGHIJ\nKLMNOPQRST\nUVWXYZ\nabcdefghij\nklmnopqrst\nuvwxyz\n0123456789\n";
    MediaBagElementEditor mbed;
    Options options;
    PlayStation ps;
    int mediaType;

    public MediaPreviewPanel(MediaBagElementEditor mbed, Options options) {
        this.mbed = mbed;
        this.options = options;
        this.setLayout(new BoxLayout(this, 1));
        if (mbed != null) {
            JComponent cmp = null;
            this.mediaType = Utils.getFileType(mbed.getMediaBagElement().getFileName());
            switch (this.mediaType) {
                case 0: {
                    cmp = this.buildImgComponent();
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    cmp = this.buildMediaComponent();
                    break;
                }
                case 6: {
                    cmp = this.buildFontComponent();
                    break;
                }
            }
            if (cmp != null) {
                this.add(cmp);
            }
        }
    }

    public void end() {
        if (this.ps != null) {
            this.ps.stopMedia(1);
        }
    }

    protected JComponent buildImgComponent() {
        Image img = null;
        JScrollPane result = null;
        try {
            img = this.mbed.getMediaBagElement().prepareAndGetImage(this.mbed.getMediaBag().getProject().getFileSystem());
        }
        catch (Exception ex) {
            System.err.println("Error loading image " + this.mbed.getMediaBagElement().getFileName());
        }
        if (img != null) {
            result = new JScrollPane(new ImgPanel(new ImageIcon(img)));
            result.setPreferredSize(new Dimension(600, 400));
        }
        return result;
    }

    protected JComponent buildFontComponent() {
        Object o = this.mbed.getMediaBagElement().getData();
        JTextArea textArea = new JTextArea();
        if (o instanceof Font) {
            textArea.setFont(((Font)o).deriveFont(0, 48.0f));
            textArea.setText(SAMPLE_TEXT);
        } else {
            textArea.setText(this.options.getMsg("edit_media_font_error"));
        }
        return new JScrollPane(textArea);
    }

    protected JComponent buildMediaComponent() {
        ActiveBoxContent abc = new ActiveBoxContent();
        abc.mediaContent = new MediaContent();
        int mt = 0;
        switch (this.mediaType) {
            case 1: {
                mt = 1;
                break;
            }
            case 2: {
                mt = 3;
                break;
            }
            case 3: 
            case 4: {
                mt = 2;
            }
        }
        abc.mediaContent.mediaType = mt;
        abc.mediaContent.mediaFileName = this.mbed.getMediaBagElement().getFileName();
        abc.mediaContent.stretch = true;
        abc.mediaContent.free = false;
        abc.dimension = new Dimension(600, 400);
        JPanelActiveBox jpab = new JPanelActiveBox(null, null, this);
        JClicProjectEditor prjed = (JClicProjectEditor)this.mbed.getFirstParent(JClicProjectEditor.class);
        if (prjed != null && prjed.getTestPlayerContainer() != null) {
            this.ps = prjed.getTestPlayerContainer().getTestPlayer();
            jpab.setPlayStation(this.ps);
        }
        jpab.setActiveBoxContent(abc);
        try {
            abc.realizeContent(this.mbed.getMediaBag());
        }
        catch (Exception ex) {
            System.err.println("Error: " + ex);
        }
        JScrollPane result = new JScrollPane(jpab);
        result.setPreferredSize(new Dimension(600, 400));
        return result;
    }
}

