/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.beans;

import edu.xtec.jclic.beans.CheckBoxTreeObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class CheckBoxTree
extends JTree {
    public CheckBoxTree() {
        this.initComponents();
    }

    private void initComponents() {
        this.setCellRenderer(new CellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CheckBoxTree.this.treeMouseClicked(evt);
            }
        });
    }

    private void treeMouseClicked(MouseEvent evt) {
        Point pt = evt.getPoint();
        TreePath tp = this.getPathForLocation(pt.x, pt.y);
        if (tp != null && tp.getLastPathComponent() instanceof CheckBoxTreeObject) {
            ((CheckBoxTreeObject)tp.getLastPathComponent()).switchSelected();
            this.repaint(this.getPathBounds(tp));
        }
    }

    class CellRenderer
    extends DefaultTreeCellRenderer {
        JCheckBox checkBox = new JCheckBox(){

            @Override
            public void paint(Graphics g) {
                Color bsColor;
                if (CellRenderer.this.hasFocus && (bsColor = CellRenderer.this.getBorderSelectionColor()) != null) {
                    g.setColor(bsColor);
                    g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
                super.paint(g);
            }
        };

        public CellRenderer() {
            this.checkBox.setBackground(this.getBackground());
            this.checkBox.setOpaque(this.isOpaque());
            this.checkBox.setFont(this.getFont());
            this.checkBox.setForeground(this.getForeground());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component result = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof CheckBoxTreeObject) {
                CheckBoxTreeObject cho = (CheckBoxTreeObject)value;
                this.checkBox.setText(cho.getLabel());
                this.checkBox.setSelected(cho.isSelected());
                this.checkBox.setEnabled(tree.isEnabled());
                this.checkBox.setComponentOrientation(tree.getComponentOrientation());
                result = this.checkBox;
            }
            return result;
        }
    }
}

