/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.beans;

import edu.xtec.jclic.beans.AlphaColorChooserPanel;
import edu.xtec.util.Options;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JButton;

public class ColorButton
extends JButton {
    Options options;
    public static final String PROP_COLOR = "color";
    public static final int BT_PREF_WIDTH = 31;
    public static final int BT_PREF_HEIGHT = 21;
    public static final int SAMPLE_WIDTH = 21;
    public static final int SAMPLE_HEIGHT = 14;
    Color color;

    public ColorButton() {
        this.setPreferredSize(new Dimension(31, 21));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.setColor(Color.lightGray);
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        Color c;
        if (this.options != null && (c = AlphaColorChooserPanel.chooseColor(this.options, this, this.getColor())) != null) {
            this.changeColor(c);
        }
        super.fireActionPerformed(event);
    }

    public void setColor(Color c) {
        this.color = c;
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public void changeColor(Color c) {
        Color oldColor = this.getColor();
        this.setColor(c);
        if (!oldColor.equals(c)) {
            this.firePropertyChange(PROP_COLOR, oldColor, c);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle r = new Rectangle(3, 3, this.getWidth() - 6, this.getHeight() - 6);
        g.setColor(this.color);
        g.fillRect(r.x, r.y, r.width, r.height);
    }
}

