/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.boxes.ActiveBagContentEditor;
import edu.xtec.util.Options;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ActiveBagContentLayoutPanel
extends JPanel {
    ActiveBagContentEditor parent;
    Options options;
    int boxGridPos = 0;
    private JToggleButton abBtn;
    private JToggleButton aubBtn;
    private JToggleButton baBtn;
    private JToggleButton buaBtn;
    private ButtonGroup layoutGroup;

    public ActiveBagContentLayoutPanel(ActiveBagContentEditor parent) {
        this.parent = parent;
        this.options = parent.getOptions();
        this.initComponents();
    }

    private void initComponents() {
        this.layoutGroup = new ButtonGroup();
        this.abBtn = new JToggleButton();
        this.baBtn = new JToggleButton();
        this.aubBtn = new JToggleButton();
        this.buaBtn = new JToggleButton();
        this.setLayout(new GridBagLayout());
        this.abBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/ab_icon.gif")));
        this.abBtn.setToolTipText(this.options.getMsg("edit_act_gridLayout_tooltip"));
        this.layoutGroup.add(this.abBtn);
        this.abBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActiveBagContentLayoutPanel.this.abBtnActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.add((Component)this.abBtn, gridBagConstraints);
        this.baBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/ba_icon.gif")));
        this.baBtn.setToolTipText(this.options.getMsg("edit_act_gridLayout_tooltip"));
        this.layoutGroup.add(this.baBtn);
        this.baBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActiveBagContentLayoutPanel.this.baBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.baBtn, gridBagConstraints);
        this.aubBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/aub_icon.gif")));
        this.aubBtn.setToolTipText(this.options.getMsg("edit_act_gridLayout_tooltip"));
        this.layoutGroup.add(this.aubBtn);
        this.aubBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActiveBagContentLayoutPanel.this.aubBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.aubBtn, gridBagConstraints);
        this.buaBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/bua_icon.gif")));
        this.buaBtn.setToolTipText(this.options.getMsg("edit_act_gridLayout_tooltip"));
        this.layoutGroup.add(this.buaBtn);
        this.buaBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActiveBagContentLayoutPanel.this.buaBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.add((Component)this.buaBtn, gridBagConstraints);
    }

    private void buaBtnActionPerformed(ActionEvent evt) {
        this.resetPanel(evt);
    }

    private void aubBtnActionPerformed(ActionEvent evt) {
        this.resetPanel(evt);
    }

    private void baBtnActionPerformed(ActionEvent evt) {
        this.resetPanel(evt);
    }

    private void abBtnActionPerformed(ActionEvent evt) {
        this.resetPanel(evt);
    }

    private void resetPanel(EventObject ev) {
        if (ev != null && ev.getSource() != null) {
            int v;
            Object src = ev.getSource();
            int n = src == this.abBtn ? 0 : (src == this.baBtn ? 1 : (src == this.aubBtn ? 2 : (v = src == this.buaBtn ? 3 : this.boxGridPos)));
            if (v != this.boxGridPos) {
                this.boxGridPos = v;
                this.selectItem();
                this.parent.abcpp.setBoxGridPos(this.boxGridPos);
            }
            this.parent.setModified(true);
        }
    }

    private void selectItem() {
        this.abBtn.setSelected(this.boxGridPos == 0);
        this.baBtn.setSelected(this.boxGridPos == 1);
        this.aubBtn.setSelected(this.boxGridPos == 2);
        this.buaBtn.setSelected(this.boxGridPos == 3);
    }

    public void clear() {
        this.boxGridPos = 0;
    }

    public void fillData(Activity act) {
        if (act != null) {
            this.boxGridPos = act.boxGridPos;
            this.selectItem();
        }
    }

    public void saveData(Activity act) {
        if (act != null) {
            act.boxGridPos = this.boxGridPos;
        }
    }
}

