/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.beans.TextListEditor;
import edu.xtec.jclic.project.Author;
import edu.xtec.jclic.project.AuthorEditPanel;
import edu.xtec.jclic.project.Revision;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class RevisionEditPanel
extends JPanel {
    Options options;
    private AuthorEditPanel authorEditPanel;
    private TextListEditor authorListEditor;
    private JTextArea commentsText;
    private JTextField dateText;
    private JTextField descText;

    public RevisionEditPanel(Options options) {
        this.options = options;
        this.initComponents();
    }

    private void initComponents() {
        JLabel dateLb = new JLabel();
        this.dateText = new JTextField();
        JLabel descLb = new JLabel();
        this.descText = new JTextField();
        JLabel authorLb = new JLabel();
        this.authorListEditor = new TextListEditor(this.options){

            @Override
            protected Object editItem(Object currentValue, boolean newValue) {
                return RevisionEditPanel.this.editAuthor(currentValue, newValue);
            }
        };
        JLabel commentsLb = new JLabel();
        JScrollPane commentsScroll = new JScrollPane();
        this.commentsText = new JTextArea();
        this.setLayout(new GridBagLayout());
        dateLb.setLabelFor(this.dateText);
        dateLb.setText(this.options.getMsg("edit_project_rev_date"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)dateLb, gridBagConstraints);
        this.dateText.setToolTipText(this.options.getMsg("edit_project_rev_date_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.dateText, gridBagConstraints);
        descLb.setLabelFor(this.descText);
        descLb.setText(this.options.getMsg("edit_project_rev_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)descLb, gridBagConstraints);
        this.descText.setToolTipText(this.options.getMsg("edit_project_rev_description_tooltip"));
        this.descText.setPreferredSize(new Dimension(300, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.descText, gridBagConstraints);
        authorLb.setLabelFor(this.authorListEditor);
        authorLb.setText(this.options.getMsg("edit_project_rev_authors"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        this.add((Component)authorLb, gridBagConstraints);
        this.authorListEditor.setToolTipText(this.options.getMsg("edit_project_rev_authors_tooltip"));
        this.authorListEditor.setPreferredSize(new Dimension(400, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.authorListEditor, gridBagConstraints);
        commentsLb.setLabelFor(this.commentsText);
        commentsLb.setText(this.options.getMsg("edit_project_rev_comments"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        this.add((Component)commentsLb, gridBagConstraints);
        commentsScroll.setPreferredSize(new Dimension(300, 60));
        this.commentsText.setLineWrap(true);
        this.commentsText.setToolTipText(this.options.getMsg("edit_project_rev_comments_tooltip"));
        this.commentsText.setWrapStyleWord(true);
        commentsScroll.setViewportView(this.commentsText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        this.add((Component)commentsScroll, gridBagConstraints);
    }

    public void setRevision(Revision rev) {
        this.dateText.setText(this.options.getMessages().getShortDateStr(rev == null ? new Date() : rev.date));
        this.descText.setText(rev != null ? rev.description : "");
        this.commentsText.setText(rev != null ? rev.comments : "");
        ArrayList<Object> v = new ArrayList<Object>();
        if (rev != null && rev.authors != null) {
            for (Author a : rev.authors) {
                v.add(a);
            }
        }
        this.authorListEditor.setListData(v);
    }

    public Revision getRevision() {
        Revision rev = null;
        Date date = this.options.getMessages().parseShortDate(this.dateText.getText());
        String desc = StrUtils.nullableString(this.descText.getText().trim());
        if (date == null) {
            this.options.getMessages().showAlert((Component)this, "DATE_INCORRECT");
        } else if (desc == null) {
            this.options.getMessages().showAlert((Component)this, "edit_project_rev_err_nodesc");
        } else {
            rev = new Revision();
            rev.date = date;
            rev.description = desc;
            rev.comments = StrUtils.nullableString(this.commentsText.getText().trim());
            List<Object> v = this.authorListEditor.getListData();
            rev.authors = v.toArray(new Author[v.size()]);
        }
        return rev;
    }

    private Object editAuthor(Object currentValue, boolean newValue) {
        Author result = null;
        if (this.authorEditPanel == null) {
            this.authorEditPanel = new AuthorEditPanel(this.options);
        }
        if (newValue) {
            currentValue = null;
        }
        this.authorEditPanel.setAuthor((Author)currentValue);
        if (this.options.getMessages().showInputDlg((Component)this, new String[]{"edit_project_author_info"}, null, new JComponent[]{this.authorEditPanel}, newValue ? "edit_project_author_add" : "edit_project_author_edit")) {
            result = this.authorEditPanel.getAuthor();
            if (result.name.length() < 1) {
                result = null;
            }
        }
        return result;
    }
}

