/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.EditableCubicCurve2D;
import edu.xtec.jclic.shapers.EditableEllipse2D;
import edu.xtec.jclic.shapers.EditableLine2D;
import edu.xtec.jclic.shapers.EditableQuadCurve2D;
import edu.xtec.jclic.shapers.EditableRectangle;
import edu.xtec.jclic.shapers.EditableShape;
import edu.xtec.jclic.shapers.EditableShapeConstants;
import edu.xtec.jclic.shapers.HolesEditorPanel;
import edu.xtec.jclic.shapers.PointListener;
import edu.xtec.jclic.shapers.ShapeData;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class PolygonDrawPanel
implements MouseMotionListener,
MouseListener {
    private List<EditableShape> vShapes;
    private static List<EditableShape> vCopied;
    private List<EditableShape> vRedrawingLines;
    private List<EditableShape> vRedrawingLinesBeforeModify;
    private List<EditableShape> vShapeBeforeModify;
    private List<PointListener> vPointListeners;
    private double iniX;
    private double iniY;
    private double finX;
    private double finY;
    private double lastFinX;
    private double lastFinY;
    private Point2D iniPoint = null;
    private Point2D lastPoint = null;
    private boolean bSelectedPoint = false;
    private double zoomX = 0.0;
    private double zoomY = 0.0;
    private double zoomH = -1.0;
    private double zoomW = -1.0;
    private boolean creatingRect = false;
    private boolean creatingEllipse = false;
    private boolean creatingPolygon = false;
    private boolean bRedrawingLines = false;
    private boolean bSelectingArea = false;
    private boolean bResizing = false;
    private int resizingDirection = -1;
    private boolean bSpecialLine = false;
    private boolean bMoving = false;
    private EditableShape specialLine = null;
    private int drawingMode = 1;
    static double defaultSensibility;
    private AffineTransform at;
    private List<Rectangle> vDrawnBorders = null;
    private Shape current = null;
    private JComponent container;
    private short INITIAL = 0;
    private short END = 1;
    public static final int SELECTING = 1;
    public static final int MOVING = 2;
    public static final int NEW_POINT = 4;
    public static final int DRAWING_RECT = 5;
    public static final int DRAWING_ELLIPSE = 6;
    public static final int DRAWING_POLYGON = 7;
    public static final int ZOOM = 12;
    public static final int NO_RESIZING = -1;
    public static final int EAST = 0;
    public static final int SOUTH = 1;
    public static final int SOUTH_EAST = 2;
    private int backgroundComposite = 0;
    protected HolesEditorPanel hep;
    protected boolean canResize;
    protected Rectangle lastPreviewArea;
    static Cursor[] cursors;
    public static final int PEN_CURSOR = 0;
    public static final int CIRCLE_CURSOR = 1;
    protected Shape esborram = null;
    private double viewIniX = -1.0;
    private double viewIniY = -1.0;

    public PolygonDrawPanel(int width, int height, HolesEditorPanel hep, boolean canResize) {
        this.hep = hep;
        this.canResize = canResize;
        this.vShapes = new ArrayList<EditableShape>();
        if (vCopied == null) {
            vCopied = new ArrayList<EditableShape>();
        }
        this.vRedrawingLines = new ArrayList<EditableShape>();
        this.vRedrawingLinesBeforeModify = new ArrayList<EditableShape>();
        this.vPointListeners = new ArrayList<PointListener>();
        this.at = new AffineTransform();
        this.initDrawnBorders();
        if (cursors == null) {
            cursors = new Cursor[2];
            Toolkit tk = Toolkit.getDefaultToolkit();
            PolygonDrawPanel.cursors[0] = tk.createCustomCursor(ResourceManager.getImageIcon("cursors/llapis.gif").getImage(), new Point(12, 24), "pen");
            PolygonDrawPanel.cursors[1] = tk.createCustomCursor(ResourceManager.getImageIcon("cursors/cercle.gif").getImage(), new Point(16, 16), "circle");
        }
        hep.addKeyListener(new KeyHandler());
    }

    public void setDrawingMode(int drawingMode) {
        if (this.drawingMode != drawingMode) {
            this.drawingMode = drawingMode;
            if (this.creatingPolygon) {
                this.joinPolygon();
            }
            if (drawingMode != 4 && drawingMode != 1) {
                this.endPolygon();
            }
            this.hep.repaint(0L);
        }
    }

    public int getVisibleWidth() {
        return this.hep.getPreviewPanel().getWidth();
    }

    public int getVisibleHeight() {
        return this.hep.getPreviewPanel().getHeight();
    }

    public void initDrawnBorders() {
        if (this.vDrawnBorders != null) {
            this.vDrawnBorders.clear();
        } else {
            this.vDrawnBorders = new ArrayList<Rectangle>();
        }
        for (int i = 0; i < this.hep.getNumShapes(); ++i) {
            Shape s;
            if (i == this.hep.currentShape || (s = this.hep.getHoles().getShape(i, this.hep.previewArea)) == null) continue;
            this.vDrawnBorders.addAll(this.getBorders(s));
        }
    }

    private List<Rectangle> getBorders(Shape s) {
        boolean xIni = false;
        boolean yIni = false;
        if (s == null) {
            return null;
        }
        ArrayList<Rectangle> vPoints = new ArrayList<Rectangle>();
        if (s instanceof GeneralPath) {
            GeneralPath gp = (GeneralPath)s;
            PathIterator it = gp.getPathIterator(new AffineTransform());
            double[] coords = new double[6];
            while (!it.isDone()) {
                int type = it.currentSegment(coords);
                switch (type) {
                    case 0: {
                        double x = coords[0];
                        double y = coords[1];
                        vPoints.add(new Rectangle((int)(x + (double)xIni) - EditableShapeConstants.selectLength / 2, (int)(y + (double)yIni) - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength));
                        break;
                    }
                    case 1: {
                        double x = coords[0];
                        double y = coords[1];
                        vPoints.add(new Rectangle((int)(x + (double)xIni) - EditableShapeConstants.selectLength / 2, (int)(y + (double)yIni) - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength));
                        break;
                    }
                    case 3: {
                        double x = coords[4];
                        double y = coords[5];
                        vPoints.add(new Rectangle((int)(x + (double)xIni) - EditableShapeConstants.selectLength / 2, (int)(y + (double)yIni) - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength));
                        break;
                    }
                    case 2: {
                        double x = coords[2];
                        double y = coords[3];
                        vPoints.add(new Rectangle((int)(x + (double)xIni) - EditableShapeConstants.selectLength / 2, (int)(y + (double)yIni) - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength));
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                it.next();
            }
        }
        return vPoints;
    }

    public void paint(Graphics2D g) {
        Graphics2D g2d = g;
        if (EditableShapeConstants.showDrawnPoints) {
            this.paintDrawnBorders(g);
        }
        for (EditableShape esh : this.vShapes) {
            if (this.bSpecialLine && esh == this.specialLine) {
                esh.paintWithColor(g, this.drawingMode, EditableShapeConstants.CUT_COLOR);
                continue;
            }
            esh.paintWithColor(g, this.drawingMode, EditableShapeConstants.ACTIVE_COLOR);
        }
        if (this.bMoving) {
            this.paintMoved(g);
        }
        if (this.creatingRect) {
            g.setColor(EditableShapeConstants.selectedColor);
            EditableRectangle rect = new EditableRectangle((int)this.iniX, (int)this.iniY, (int)(this.finX - this.iniX), (int)(this.finY - this.iniY));
            rect.paintWithColor(g, this.drawingMode, EditableShapeConstants.selectedColor);
        }
        if (this.creatingEllipse) {
            g.setColor(EditableShapeConstants.selectedColor);
            EditableEllipse2D ellipse = new EditableEllipse2D((int)this.iniX, (int)this.iniY, (int)(this.finX - this.iniX), (int)(this.finY - this.iniY));
            ellipse.paintWithColor(g, this.drawingMode, EditableShapeConstants.selectedColor);
        }
        if (this.creatingPolygon && this.lastPoint != null) {
            EditableLine2D el = new EditableLine2D(this.lastPoint.getX(), this.lastPoint.getY(), this.finX, this.finY);
            el.paintWithColor(g, this.drawingMode, EditableShapeConstants.selectedColor);
        }
    }

    public void drawGrid(Graphics g, int gridWidth) {
        double i;
        if (gridWidth <= 1) {
            return;
        }
        int width = (int)this.hep.previewArea.getWidth();
        int height = (int)this.hep.previewArea.getHeight();
        g.setColor(EditableShapeConstants.gridColor);
        for (i = (double)this.hep.previewArea.x; i <= (double)(this.hep.previewArea.x + width); i += (double)gridWidth * this.hep.xFactor) {
            g.drawLine((int)i, this.hep.previewArea.y, (int)i, this.hep.previewArea.y + height);
        }
        for (i = (double)this.hep.previewArea.y; i <= (double)(this.hep.previewArea.y + height); i += (double)gridWidth * this.hep.yFactor) {
            g.drawLine(this.hep.previewArea.x, (int)i, this.hep.previewArea.x + width, (int)i);
        }
    }

    protected void paintDrawnBorders(Graphics2D g) {
        for (Rectangle r : this.vDrawnBorders) {
            double x = r.getX();
            double y = r.getY();
            double w = r.getWidth();
            double h = r.getHeight();
            x += w / 4.0;
            y += h / 4.0;
            g.setColor(EditableShapeConstants.DRAWN_BORDER_COLOR);
            g.fillRect((int)x, (int)y, (int)(w /= 2.0), (int)(h /= 2.0));
        }
    }

    private void paintMoved(Graphics2D g) {
        for (EditableShape esh : vCopied) {
            EditableShape copied = (EditableShape)esh.clone();
            copied.transform(AffineTransform.getTranslateInstance(this.finX - this.iniX, this.finY - this.iniY));
            copied.paintWithColor(g, this.drawingMode, EditableShapeConstants.movingColor);
        }
    }

    public void updateView() {
        List<GeneralPath> v = this.getGeneralPath();
        if (this.lastPreviewArea == null) {
            this.lastPreviewArea = this.hep.previewArea;
        }
        if (v.size() > 0) {
            this.move(this.hep.previewArea.x - this.lastPreviewArea.x, this.hep.previewArea.y - this.lastPreviewArea.y, false, false);
        }
        try {
            this.lastPreviewArea = (Rectangle)this.hep.previewArea.clone();
        }
        catch (Exception e) {
            System.err.println("Error updating view:\n" + e);
        }
    }

    public void setShapeData(ShapeData sd, double x, double y, double scaleX, double scaleY) {
        Shape s;
        this.clean();
        this.current = sd != null ? sd.getShape(this.hep.previewArea) : null;
        double firstX = -1.0;
        double firstY = -1.0;
        if (sd != null && sd.primitiveType >= 0 && sd.primitivePoints != null && sd.primitivePoints.length > 3) {
            double xTr = sd.primitivePoints[0] * this.hep.previewArea.getWidth() + this.hep.previewArea.getX();
            double yTr = sd.primitivePoints[1] * this.hep.previewArea.getHeight() + this.hep.previewArea.getY();
            double wSc = sd.primitivePoints[2] * this.hep.previewArea.getWidth();
            double hSc = sd.primitivePoints[3] * this.hep.previewArea.getHeight();
            switch (sd.primitiveType) {
                case 0: {
                    EditableRectangle es = new EditableRectangle((int)xTr, (int)yTr, (int)wSc, (int)hSc);
                    this.vShapes.add(es);
                    break;
                }
                case 1: {
                    EditableEllipse2D es = new EditableEllipse2D((int)xTr, (int)yTr, (int)wSc, (int)hSc);
                    this.vShapes.add(es);
                }
            }
        } else if (sd != null && (s = sd.getShape(this.hep.previewArea)) instanceof GeneralPath) {
            GeneralPath gp = (GeneralPath)s;
            PathIterator it = gp.getPathIterator(new AffineTransform());
            double[] coords = new double[6];
            while (!it.isDone()) {
                int type = it.currentSegment(coords);
                switch (type) {
                    case 0: {
                        x = coords[0];
                        y = coords[1];
                        if (firstX != -1.0) break;
                        firstX = x;
                        firstY = y;
                        break;
                    }
                    case 1: {
                        this.vShapes.add(new EditableLine2D(x, y, coords[0], coords[1]));
                        x = coords[0];
                        y = coords[1];
                        break;
                    }
                    case 3: {
                        this.vShapes.add(new EditableCubicCurve2D(x, y, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]));
                        x = coords[4];
                        y = coords[5];
                        break;
                    }
                    case 2: {
                        this.vShapes.add(new EditableQuadCurve2D(x, y, coords[0], coords[1], coords[2], coords[3]));
                        x = coords[2];
                        y = coords[3];
                        break;
                    }
                    case 4: {
                        if (firstX == -1.0 || x == firstX && y == firstY) break;
                        this.vShapes.add(new EditableLine2D(x, y, firstX, firstY));
                        x = firstX;
                        y = firstY;
                        break;
                    }
                }
                it.next();
            }
            if (firstX != -1.0 && (x != firstX || y != firstY)) {
                this.vShapes.add(new EditableLine2D(x, y, firstX, firstY));
            }
        }
        this.removeDrawnBorders(sd);
    }

    public void clean() {
        this.vShapes = new ArrayList<EditableShape>();
        this.vRedrawingLines = new ArrayList<EditableShape>();
        this.vRedrawingLinesBeforeModify = new ArrayList<EditableShape>();
    }

    public boolean selectDrawnShape(Point2D p) {
        this.endPolygon();
        for (int i = 0; i < this.hep.getNumShapes(); ++i) {
            Shape s = this.hep.getHoles().getShape(i, this.hep.previewArea);
            if (!s.contains(p) || this.hep.currentShape == i) continue;
            this.hep.setCurrentShape(i);
            this.setShapeData(this.hep.getHoles().getShapeData(i), 0.0, 0.0, 1.0, 1.0);
            return true;
        }
        this.hep.setCurrentShape(this.hep.getHoles().getNumCells() + 1);
        this.clean();
        return false;
    }

    public void selectShape(int iIndex) {
        if (iIndex < 0) {
            return;
        }
        ShapeData sd = this.hep.getHoles().getShapeData(iIndex);
        if (sd != null) {
            this.setShapeData(sd, 0.0, 0.0, 1.0, 1.0);
        }
    }

    private EditableShape aproximationToLine(double x, double y) {
        return this.aproximationToLine(x, y, null);
    }

    private EditableShape aproximationToLine(double x, double y, List<EditableShape> vRedrawingLines) {
        if (vRedrawingLines != null) {
            for (EditableShape esh : vRedrawingLines) {
                if (vRedrawingLines.contains(esh) || !esh.hasClickedBorder((int)x, (int)y, false)) continue;
                return esh;
            }
        }
        return null;
    }

    private Point2D getTransformedPoint(Point2D p, boolean mustBeOnGrid) {
        Point2D.Double mousePoint = new Point2D.Double(p.getX(), p.getY());
        if (EditableShapeConstants.gridWidth != -1 && EditableShapeConstants.pointsOnGrid && mustBeOnGrid) {
            this.moveToGrid(mousePoint);
        }
        return mousePoint;
    }

    private void moveToGrid(Point2D p) {
        int x = (int)p.getX();
        int y = (int)p.getY();
        x = (int)((double)x - this.hep.previewArea.getX());
        y = (int)((double)y - this.hep.previewArea.getY());
        double wd = (double)EditableShapeConstants.gridWidth * this.hep.xFactor;
        int w = (int)wd;
        if (w == -1) {
            return;
        }
        int xLeft = (int)((double)((int)((double)x / wd)) * wd);
        x = x - xLeft < w / 2 ? xLeft : (int)((double)((int)((double)(x + w - 1) / wd)) * wd);
        int yUp = (int)((double)((int)((double)y / wd)) * wd);
        y = y - yUp < w / 2 ? yUp : (int)((double)((int)((double)(y + w - 1) / wd)) * wd);
        x = (int)((double)x + this.hep.previewArea.getX());
        y = (int)((double)y + this.hep.previewArea.getY());
        p.setLocation(x, y);
    }

    public Point2D aproximationToDrawnBorder(double x, double y) {
        for (Rectangle2D rectangle2D : this.vDrawnBorders) {
            if (!rectangle2D.contains(x, y)) continue;
            return new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
        }
        return null;
    }

    protected void redrawingLines(double x, double y) {
        for (EditableShape esh : this.vRedrawingLines) {
            esh.changeBorder(x, y);
        }
    }

    private void cleanZoom() {
        this.zoomX = 0.0;
        this.zoomY = 0.0;
        this.zoomW = -1.0;
        this.zoomH = -1.0;
        this.at = new AffineTransform();
        this.cancelCurrentOperations();
        this.bSelectingArea = false;
        this.hep.repaint(0L);
    }

    public void cancelCurrentOperations() {
        this.creatingRect = false;
        this.creatingEllipse = false;
    }

    public void cut(double x, double y) {
        this.copy(false);
        this.clean();
        this.bMoving = true;
        this.iniX = x;
        this.iniY = y;
        this.finX = this.iniX;
        this.finY = this.iniY;
    }

    public void cut() {
        this.cut(-1.0, -1.0);
    }

    public void copy(boolean needSelected) {
        vCopied.clear();
        for (EditableShape esh : this.vShapes) {
            esh = (EditableShape)esh.clone();
            if (needSelected && !esh.isSelected()) continue;
            vCopied.add(esh);
        }
    }

    public void paste() {
        this.bMoving = true;
        this.iniX = -1.0;
        this.iniY = -1.0;
        this.finX = -1.0;
        this.finY = -1.0;
        this.paste(5.0, 5.0);
    }

    public void paste(double x, double y) {
        ArrayList<EditableShape> newCopied = new ArrayList<EditableShape>();
        this.deSelectAll();
        for (EditableShape esh : vCopied) {
            EditableShape copied = (EditableShape)esh.clone();
            copied.transform(AffineTransform.getTranslateInstance(x, y));
            copied.setSelected(true);
            this.vShapes.add(copied);
            newCopied.add(copied);
        }
        vCopied = newCopied;
    }

    public void deSelectAll() {
        for (EditableShape esh : this.vShapes) {
            esh.setSelected(false);
        }
        this.bSelectedPoint = false;
        this.hep.repaint(0L);
    }

    private EditableShape nearestLine(double x, double y) {
        EditableShape nearest = null;
        double distance = 0.0;
        for (EditableShape esh : this.vShapes) {
            double currentDistance = esh.distanceTo(x, y);
            if (nearest != null && !(currentDistance < distance)) continue;
            distance = currentDistance;
            nearest = esh;
        }
        return nearest;
    }

    private void clicatISeleccionada(int x, int y, boolean needSelected) {
        Point2D redrawingPoint = null;
        this.vRedrawingLines.clear();
        for (EditableShape esh : this.vShapes) {
            if (needSelected && !esh.isSelected() || !esh.hasClickedBorder(x, y, needSelected)) continue;
            Point2D p = esh.getNearestBorder(x, y);
            if (redrawingPoint != null && !redrawingPoint.equals(p)) continue;
            redrawingPoint = p;
            this.vRedrawingLines.add(esh);
        }
        this.vRedrawingLinesBeforeModify = this.cloneVector(this.vRedrawingLines);
    }

    private List<EditableShape> cloneVector(List<EditableShape> v) {
        ArrayList<EditableShape> vClone = new ArrayList<EditableShape>();
        if (v != null) {
            for (EditableShape es : v) {
                vClone.add((EditableShape)es.clone());
            }
        }
        return vClone;
    }

    private void divideShape(EditableShape specialLine, double x, double y) {
        if (specialLine != null) {
            EditableShape[] shapes = specialLine.divide(x, y);
            if (shapes != null) {
                ArrayList<EditableShape> vCheckPoint = new ArrayList<EditableShape>();
                vCheckPoint.addAll(this.vShapes);
                this.vShapes.remove(specialLine);
                for (int i = 0; i < shapes.length; ++i) {
                    if (shapes[i] == null) continue;
                    this.vShapes.add(shapes[i]);
                }
                boolean bValidate = this.validateShape();
                if (!bValidate) {
                    this.vShapes = vCheckPoint;
                }
            }
            this.hep.updateView();
        }
        this.hep.repaint(0L);
    }

    private boolean validateShape() {
        return this.getGeneralPath().size() == 1;
    }

    public List<GeneralPath> getGeneralPath() {
        ArrayList<GeneralPath> vGpaths = new ArrayList<GeneralPath>();
        GeneralPath currentPolygon = new GeneralPath();
        ArrayList<EditableShape> shapes = new ArrayList<EditableShape>();
        shapes.addAll(this.vShapes);
        if (shapes.size() <= 0) {
            return vGpaths;
        }
        EditableShape esh = (EditableShape)shapes.get(0);
        shapes.remove(esh);
        currentPolygon.append(esh, true);
        short notUsedPoint = this.END;
        while (shapes.size() > 0) {
            EditableShape shape = this.getAdjacent(shapes, esh, notUsedPoint);
            if (shape != null) {
                currentPolygon.append(shape, true);
                notUsedPoint = this.getNotUsed(esh, shape);
                shapes.remove(shape);
                esh = shape;
                continue;
            }
            vGpaths.add(currentPolygon);
            currentPolygon = new GeneralPath();
            notUsedPoint = this.END;
            esh = (EditableShape)shapes.get(0);
            shapes.remove(esh);
            currentPolygon.append(esh, true);
        }
        vGpaths.add(currentPolygon);
        return vGpaths;
    }

    private short getNotUsed(EditableShape current, EditableShape shape) {
        if (shape.getInitialPoint().equals(current.getInitialPoint()) || shape.getInitialPoint().equals(current.getEndPoint())) {
            return this.END;
        }
        return this.INITIAL;
    }

    private EditableShape getAdjacent(List<EditableShape> shapes, EditableShape sh, short notUsedPoint) {
        Point2D p = notUsedPoint == this.INITIAL ? sh.getInitialPoint() : sh.getEndPoint();
        for (EditableShape shape : shapes) {
            if (!shape.isAdjacentTo(p)) continue;
            return shape;
        }
        return null;
    }

    public boolean hasSelectedDrawnShape(Point2D p) {
        for (int i = 0; i < this.hep.getNumShapes(); ++i) {
            Shape s = this.hep.getHoles().getShape(i, this.hep.previewArea);
            if (!s.contains(p)) continue;
            return true;
        }
        return false;
    }

    private double distanceToNearest(double x, double y) {
        EditableShape nearest = this.nearestLine(x, y);
        if (nearest != null) {
            return nearest.distanceTo(x, y);
        }
        return -1.0;
    }

    public void deleteSelected(boolean isCut) {
        if (this.hasSelectedPoint()) {
            this.joinAdjacentsToSelectedPoint();
            this.bSelectedPoint = false;
        } else {
            ArrayList<EditableShape> vShapesCopy = new ArrayList<EditableShape>();
            boolean allSelected = true;
            boolean noneSelected = true;
            vShapesCopy.addAll(this.vShapes);
            for (EditableShape esh : vShapesCopy) {
                if (!esh.isSelected()) {
                    allSelected = false;
                    continue;
                }
                noneSelected = false;
                if (!isCut && this.vShapes.size() < 4) continue;
                this.vShapes.remove(esh);
                if (isCut) continue;
                this.joinAdjacentsTo(esh, this.vShapes);
            }
            if (allSelected || noneSelected) {
                this.vShapes.clear();
                this.current = null;
                this.hep.getHoles().removeShape(this.hep.currentShape);
                this.hep.setCurrentShape(this.hep.getHoles().getNumCells());
            }
        }
    }

    private void joinAdjacentsTo(EditableShape current, List<EditableShape> vShapes) {
        EditableShape s1 = this.getAdjacent(vShapes, current, this.INITIAL);
        if (s1 != null) {
            s1.hasClickedBorder(current.getInitialPoint().getX(), current.getInitialPoint().getY(), false);
            s1.changeBorder(current.getEndPoint().getX(), current.getEndPoint().getY());
        }
    }

    private void joinAdjacentsToSelectedPoint() {
        if (this.vShapes.size() != 1 && this.vShapes.size() <= 3) {
            return;
        }
        EditableShape other = null;
        int count = 0;
        for (EditableShape esh : this.vShapes) {
            if (!esh.hasSelectedBorder()) continue;
            if (esh instanceof EditableRectangle) {
                Point2D p = esh.getNotSelectedBorder();
                this.convertToSimpleShapes();
                this.selectBorder(p.getX(), p.getY());
                this.joinAdjacentsToSelectedPoint();
                break;
            }
            if (++count == 1) {
                other = esh;
                continue;
            }
            if (other == null) continue;
            Point2D p1 = esh.getNotSelectedBorder();
            Point2D p2 = other.getNotSelectedBorder();
            this.vShapes.add(new EditableLine2D(p1, p2));
            this.vShapes.remove(esh);
            this.vShapes.remove(other);
        }
        this.hep.repaint(0L);
    }

    private void setEndToVector(double finX, double finY, List<EditableShape> vRedrawingLines) {
        for (EditableShape esh : vRedrawingLines) {
            esh.aproximateNearestBorder(finX, finY);
        }
    }

    public boolean hasSelectedPoint() {
        return this.bSelectedPoint;
    }

    public List<EditableShape> getSelectedShapes() {
        ArrayList<EditableShape> v = new ArrayList<EditableShape>();
        for (EditableShape esh : this.vShapes) {
            if (!esh.isSelected()) continue;
            v.add(esh);
        }
        return v;
    }

    public int getNumShapes() {
        return this.vShapes.size();
    }

    public void deleteCurrent() {
        this.clean();
        this.current = null;
    }

    public ShapeData getShapeData() {
        ShapeData sd = null;
        AffineTransform aft = AffineTransform.getScaleInstance(1.0 / this.hep.previewArea.getWidth(), 1.0 / this.hep.previewArea.getHeight());
        aft.concatenate(AffineTransform.getTranslateInstance(-this.hep.previewArea.x, -this.hep.previewArea.y));
        if (this.getNumShapes() == 1) {
            EditableShape es = (EditableShape)this.vShapes.get(0).clone();
            es.transform(aft);
            Shape s = es instanceof EditableEllipse2D ? ((EditableEllipse2D)es).getEllipse() : es;
            sd = ShapeData.getShapeData(s, null, false);
        } else {
            List<GeneralPath> v = this.getGeneralPath();
            if (v.size() > 0) {
                GeneralPath gp = v.get(0);
                Shape s = gp.createTransformedShape(aft);
                sd = ShapeData.getShapeData(s, null);
            }
        }
        return sd;
    }

    public void endPolygon() {
        this.endPolygon(false, true);
    }

    public void endPolygon(boolean changeShape, boolean updateList) {
        this.endPolygon(changeShape, updateList, -1);
    }

    public void endPolygon(boolean changeShape, boolean updateList, int iNextShape) {
        ShapeData sd = this.getShapeData();
        this.addCurrentDrawnBorders(sd);
        this.endPolygon(sd, changeShape, updateList, iNextShape);
        if (sd != null) {
            this.clean();
        }
        this.bSelectedPoint = false;
    }

    private void addCurrentDrawnBorders(ShapeData sd) {
        if (sd != null && this.hep != null) {
            Shape s = sd.getShape(this.hep.previewArea);
            this.vDrawnBorders.addAll(this.getBorders(s));
        }
    }

    private void removeDrawnBorders(ShapeData sd) {
        Shape s = sd.getShape(this.hep.previewArea);
        this.vDrawnBorders.removeAll(this.getBorders(s));
    }

    public void endPolygon(ShapeData sd, boolean changeShape, boolean updateList, int iNextShape) {
        if (sd != null) {
            this.addCurrentDrawnBorders(sd);
            if (this.hep.currentShape < this.hep.getHoles().getNumCells()) {
                this.hep.getHoles().modifyShape(this.hep.currentShape, sd);
                this.hep.updateView();
            } else {
                sd.comment = StrUtils.secureString(sd.comment, "" + this.hep.currentShape);
                this.hep.getHoles().addShape(sd);
                this.hep.updateList();
                this.hep.updateView();
            }
        }
        int iCurrentShape = this.hep.currentShape + 1;
        iCurrentShape = changeShape ? (iNextShape >= 0 ? iNextShape : (iCurrentShape %= this.hep.getHoles().getNumCells())) : this.hep.getHoles().getNumCells();
        if (this.hep.currentShape != iCurrentShape) {
            this.hep.setCurrentShape(iCurrentShape);
        }
    }

    private void aplicateTransformation(AffineTransform aTransf, boolean needSelected) {
        for (EditableShape esh : this.vShapes) {
            if (needSelected && !esh.isSelected()) continue;
            esh.transform(aTransf);
        }
    }

    public void move(int xInc, int yInc, boolean needSelected, boolean moveAll) {
        AffineTransform aTransf = AffineTransform.getTranslateInstance(xInc, yInc);
        this.aplicateTransformation(aTransf, needSelected);
        this.hep.repaint(0L);
    }

    public void scale(double xInc, double yInc, boolean needSelected, boolean scaleAll) {
        Point2D center = this.getCenter(scaleAll);
        AffineTransform aTransf = AffineTransform.getTranslateInstance(center.getX(), center.getY());
        aTransf.concatenate(AffineTransform.getScaleInstance(xInc, yInc));
        aTransf.concatenate(AffineTransform.getTranslateInstance(-center.getX(), -center.getY()));
        this.aplicateTransformation(aTransf, needSelected);
        this.hep.repaint(0L);
    }

    public void rotate(double theta, boolean needSelected, boolean rotateAll) {
        this.convertToSimpleShapes();
        Point2D center = this.getCenter(rotateAll);
        AffineTransform aTransf = AffineTransform.getRotateInstance(theta, center.getX(), center.getY());
        this.aplicateTransformation(aTransf, needSelected);
        this.hep.repaint(0L);
    }

    private Point2D getCenter(boolean cellCenter) {
        if (!cellCenter) {
            GeneralPath gp = new GeneralPath();
            for (EditableShape esh : this.vShapes) {
                gp.append(esh, false);
            }
            Rectangle r = gp.getBounds();
            return new Point2D.Double(r.getCenterX(), r.getCenterY());
        }
        return new Point2D.Double(this.hep.getPreviewPanel().getX(), this.hep.getPreviewPanel().getY());
    }

    private void convertToSimpleShapes() {
        for (EditableShape esh : this.vShapes) {
            if (!(esh instanceof EditableRectangle)) continue;
            this.vShapes.remove(esh);
            EditableShape[] lines = ((EditableRectangle)esh).divide(-1.0, -1.0, false);
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i] == null) continue;
                this.vShapes.add(lines[i]);
            }
        }
    }

    private EditableShape getSelectedShape(boolean hasToBeALine) {
        EditableShape selected = null;
        int i = 0;
        for (EditableShape esh : this.vShapes) {
            if (esh.isSelected()) {
                if (!hasToBeALine || esh instanceof EditableLine2D) {
                    selected = esh;
                    ++i;
                } else {
                    i = 2;
                }
            }
            if (i < 2) continue;
            break;
        }
        if (i == 1) {
            return selected;
        }
        return null;
    }

    public void convertToBezier() {
        EditableShape selected = this.getSelectedShape(false);
        if (selected != null) {
            double x1 = selected.getInitialPoint().getX();
            double y1 = selected.getInitialPoint().getY();
            double x2 = selected.getEndPoint().getX();
            double y2 = selected.getEndPoint().getY();
            double ctrl1x = x1 + (x2 - x1) / 3.0;
            double ctrl2x = x1 + 2.0 * ((x2 - x1) / 3.0);
            double ctrl1y = y1 + (y2 - y1) / 3.0;
            double ctrl2y = y1 + 2.0 * ((y2 - y1) / 3.0);
            EditableCubicCurve2D bez = new EditableCubicCurve2D(x1, y1, ctrl1x, ctrl1y, ctrl2x, ctrl2y, x2, y2);
            bez.setSelected(true);
            this.vShapes.remove(selected);
            this.vShapes.add(bez);
        }
    }

    public void convertToQuad() {
        EditableShape selected = this.getSelectedShape(false);
        if (selected != null) {
            double x1 = selected.getInitialPoint().getX();
            double y1 = selected.getInitialPoint().getY();
            double x2 = selected.getEndPoint().getX();
            double y2 = selected.getEndPoint().getY();
            double ctrlx = x1 + (x2 - x1) / 2.0;
            double ctrly = y1 + (y2 - y1) / 2.0;
            EditableQuadCurve2D quad = new EditableQuadCurve2D(x1, y1, ctrlx, ctrly, x2, y2);
            quad.setSelected(true);
            this.vShapes.remove(selected);
            this.vShapes.add(quad);
        }
    }

    public void convertToLine() {
        EditableShape selected = this.getSelectedShape(false);
        if (selected != null && !(selected instanceof EditableRectangle)) {
            EditableLine2D line = new EditableLine2D(selected.getInitialPoint(), selected.getEndPoint());
            line.setSelected(true);
            this.vShapes.remove(selected);
            this.vShapes.add(line);
        } else if (selected != null && selected instanceof EditableRectangle) {
            this.vShapes.remove(selected);
            EditableShape[] lines = ((EditableRectangle)selected).divide(-1.0, -1.0, false);
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i] == null) continue;
                this.vShapes.add(lines[i]);
            }
        }
    }

    public void notifyShapeChanged() {
        for (PointListener pl : this.vPointListeners) {
            pl.shapeChanged();
        }
    }

    public void addPointListener(PointListener listener) {
        this.vPointListeners.add(listener);
    }

    public void undoLastMove(List<EditableShape> vRedrawingLines, List<EditableShape> vRedrawingLinesBeforeModify) {
        this.vShapes.removeAll(vRedrawingLines);
        this.vShapes.addAll(vRedrawingLinesBeforeModify);
        vRedrawingLines.clear();
    }

    private boolean isIntoArea(List<EditableShape> vShapes, boolean move) {
        boolean isInto = true;
        Rectangle2D.Double r = new Rectangle2D.Double(this.hep.previewArea.getX() - 1.0, this.hep.previewArea.getY() - 1.0, this.hep.previewArea.getWidth() + 2.0, this.hep.previewArea.getHeight() + 2.0);
        for (EditableShape esh : vShapes) {
            EditableShape es;
            if (!isInto) break;
            if (!move) {
                es = esh;
            } else {
                es = (EditableShape)esh.clone();
                es.transform(AffineTransform.getTranslateInstance(this.finX - this.iniX, this.finY - this.iniY));
            }
            Point2D[] borders = es.getBorders();
            if (borders == null) continue;
            for (int j = 0; j < borders.length && isInto; ++j) {
                isInto = r.contains(borders[j]);
            }
        }
        return isInto;
    }

    private void joinPolygon() {
        if (this.vShapes.size() >= 2) {
            this.vShapes.add(new EditableLine2D(this.lastPoint.getX(), this.lastPoint.getY(), this.iniPoint.getX(), this.iniPoint.getY()));
        } else {
            this.vShapes.clear();
        }
        this.creatingPolygon = false;
        this.lastPoint = null;
        this.iniPoint = null;
        if (this.bSelectedPoint) {
            this.deselectBorder();
        }
        this.bSelectedPoint = false;
        this.hep.setDrawingMode(1);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        boolean b;
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        Point2D mousePoint = this.getTransformedPoint(mouseEvent.getPoint(), true);
        if (this.bMoving) {
            this.hep.setCursor(Cursor.getPredefinedCursor(13));
        }
        if (mousePoint.getX() < (double)this.hep.previewArea.x || mousePoint.getY() < (double)this.hep.previewArea.y || mousePoint.getX() > (double)this.hep.previewArea.x + this.hep.previewArea.getWidth() || mousePoint.getY() > (double)this.hep.previewArea.y + this.hep.previewArea.getHeight()) {
            return;
        }
        this.vShapeBeforeModify = this.drawingMode == 1 && !this.bMoving ? this.cloneVector(this.vRedrawingLines) : this.cloneVector(vCopied);
        EditableShape near = null;
        Point2D nearDrawn = this.aproximationToDrawnBorder(mouseEvent.getX(), mouseEvent.getY());
        if (nearDrawn != null && EditableShapeConstants.pointsOnGrid) {
            this.finX = nearDrawn.getX();
            this.finY = nearDrawn.getY();
        } else {
            this.finX = mousePoint.getX();
            this.finY = mousePoint.getY();
        }
        if (this.creatingRect || this.creatingEllipse) {
            near = this.aproximationToLine(this.finX, this.finY);
            this.hep.getPreviewPanel().repaint(0L);
        } else if (this.bRedrawingLines) {
            this.redrawingLines(this.finX, this.finY);
            near = this.aproximationToLine(this.finX, this.finY, this.vRedrawingLines);
            this.hep.repaint(0L);
        } else if (this.bMoving || this.esInterior(this.finX, this.finY)) {
            near = this.nearestLine(this.finX, this.finY);
            if (near != null) {
                double d = near.distanceTo(this.finX, this.finY);
                if (!this.bMoving && d > (double)(EditableShapeConstants.selectLength / 2)) {
                    this.cut(this.finX, this.finY);
                }
            }
            this.hep.repaint(0L);
        }
        if (this.creatingRect || this.creatingEllipse || this.bRedrawingLines) {
            if ((near != null || nearDrawn != null) && EditableShapeConstants.pointsOnGrid) {
                this.hep.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.hep.setCursor(cursors[0]);
            }
        }
        if (!(b = this.isIntoArea(this.drawingMode == 1 && !this.bMoving ? this.vRedrawingLines : vCopied, this.bMoving))) {
            if (this.drawingMode == 1 && !this.bMoving) {
                this.undoLastMove(this.vRedrawingLines, this.vShapeBeforeModify);
                this.finX = this.lastFinX;
                this.finY = this.lastFinY;
            }
            if (this.bMoving) {
                this.finX = this.lastFinX;
                this.finY = this.lastFinY;
            }
        } else {
            this.lastFinX = this.finX;
            this.lastFinY = this.finY;
        }
        if (this.bResizing) {
            this.setResizingCursor(this.resizingDirection);
        }
    }

    protected boolean esCantonada(double x, double y) {
        EditableShape near = this.aproximationToLine(x, y);
        return near != null || this.aproximationToDrawnBorder(x, y) != null;
    }

    protected boolean esSobreFigura(double x, double y) {
        int minimumDistance = Math.max(Math.max(2, EditableShapeConstants.selectLength / 2), EditableShapeConstants.gridWidth);
        double dist = this.distanceToNearest(x, y);
        return dist >= 0.0 && dist < (double)minimumDistance;
    }

    protected boolean esInterior(double x, double y) {
        return this.current != null && this.current.contains(x, y);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        double y;
        double x;
        Point mousePoint = mouseEvent.getPoint();
        boolean esCantonada = this.esCantonada(mouseEvent.getPoint().getX(), mouseEvent.getPoint().getY());
        if (this.drawingMode == 4 || esCantonada && EditableShapeConstants.pointsOnGrid) {
            x = ((Point2D)mousePoint).getX();
            y = ((Point2D)mousePoint).getY();
        } else {
            x = ((Point2D)mousePoint).getX();
            y = ((Point2D)mousePoint).getY();
        }
        if (x < (double)this.hep.previewArea.x || y < (double)this.hep.previewArea.y || x > (double)this.hep.previewArea.x + this.hep.previewArea.getWidth() || y > (double)this.hep.previewArea.y + this.hep.previewArea.getHeight()) {
            return;
        }
        if (this.drawingMode != 4) {
            if (esCantonada && (!this.creatingPolygon || EditableShapeConstants.pointsOnGrid)) {
                this.hep.setCursor(Cursor.getPredefinedCursor(12));
            } else if (this.creatingPolygon) {
                this.hep.setCursor(cursors[0]);
            } else if (!this.bMoving && this.esSobreFigura(x, y)) {
                this.hep.setCursor(cursors[1]);
            } else if (this.esInterior(x, y)) {
                this.hep.setCursor(Cursor.getPredefinedCursor(13));
            } else {
                this.hep.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if (this.drawingMode == 4) {
            if (this.esSobreFigura(x, y)) {
                this.bSpecialLine = true;
                this.specialLine = this.nearestLine(x, y);
                this.hep.setCursor(cursors[0]);
                this.hep.repaint(0L);
            } else {
                boolean willRepaint = this.bSpecialLine;
                this.bSpecialLine = false;
                this.hep.setCursor(Cursor.getPredefinedCursor(0));
                if (willRepaint) {
                    this.hep.repaint(0L);
                }
            }
        }
        if (this.bMoving) {
            if (this.iniX == -1.0) {
                this.deleteSelected(true);
                this.iniX = x;
                this.iniY = y;
            }
            this.finX = x;
            this.finY = y;
            this.hep.repaint(0L);
        }
        if (this.creatingPolygon) {
            this.finX = x;
            this.finY = y;
            this.hep.repaint(0L);
        }
        if (this.canResize) {
            if (!this.bResizing) {
                int resizing = this.getResizing(mousePoint);
                if (resizing != -1) {
                    this.setResizingCursor(resizing);
                }
            } else {
                this.setResizingCursor(this.resizingDirection);
            }
        }
    }

    protected int getResizing(Point2D mousePoint) {
        if (!this.canResize) {
            return -1;
        }
        ShapeData sd = this.hep.getHoles().getEnclosingShapeData();
        Rectangle r = this.hep.getPreviewArea();
        double width = r.getWidth();
        double height = r.getHeight();
        AffineTransform aft = AffineTransform.getTranslateInstance(-this.hep.previewArea.x, -this.hep.previewArea.y);
        aft.transform(mousePoint, mousePoint);
        if (mousePoint.getX() == width - 1.0 && mousePoint.getY() == height - 1.0) {
            return 2;
        }
        if (mousePoint.getX() == width - 1.0) {
            return 0;
        }
        if (mousePoint.getY() == height - 1.0) {
            return 1;
        }
        return -1;
    }

    protected void setResizingCursor(int resizing) {
        if (resizing == 0) {
            this.hep.setCursor(Cursor.getPredefinedCursor(11), false);
        } else if (resizing == 1) {
            this.hep.setCursor(Cursor.getPredefinedCursor(9), false);
        } else if (resizing == 2) {
            this.hep.setCursor(Cursor.getPredefinedCursor(5), false);
        }
    }

    protected void selectBorder(double x, double y) {
        for (EditableShape s : this.vShapes) {
            s.selectBorder(x, y);
        }
    }

    protected void deselectBorder() {
        for (EditableShape s : this.vShapes) {
            s.deselectBorder();
        }
    }

    protected boolean removeNullLines(List<EditableShape> vRedrawingLines) {
        boolean canRemove = false;
        for (EditableShape s : vRedrawingLines) {
            Rectangle r;
            Point2D[] p;
            if (canRemove) break;
            if (!(s instanceof EditableLine2D) || (p = s.getBorders()).length <= 1 || !(r = new Rectangle((int)p[0].getX() - EditableShapeConstants.selectLength / 2, (int)p[0].getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength)).contains(p[1].getX(), p[1].getY()) || this.vShapes.size() < 4) continue;
            canRemove = true;
            this.vShapes.remove(s);
            this.joinAdjacentsTo(s, this.vShapes);
        }
        return canRemove;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        EditableShape line;
        Point2D mousePoint = mouseEvent.getPoint();
        boolean bSobreFigura = this.esSobreFigura(mousePoint.getX(), mousePoint.getY());
        if (this.drawingMode != 4 && this.drawingMode != 7 && !bSobreFigura && this.selectDrawnShape(mousePoint) && !this.creatingPolygon) {
            this.notifyShapeChanged();
            this.hep.repaint(0L);
        } else if (this.drawingMode != 4 && bSobreFigura && !this.creatingPolygon && (line = this.nearestLine(mousePoint.getX(), mousePoint.getY())) != null) {
            if (this.esCantonada(mousePoint.getX(), mousePoint.getY())) {
                Point2D p = line.getNearestBorder(mousePoint.getX(), mousePoint.getY());
                this.deSelectAll();
                this.bSelectedPoint = true;
                this.selectBorder(p.getX(), p.getY());
                this.hep.repaint(0L);
            } else {
                if (this.bSelectedPoint) {
                    this.deselectBorder();
                }
                this.bSelectedPoint = false;
                if (line.isSelected()) {
                    line.setSelected(false);
                } else {
                    if ((mouseEvent.getModifiers() & 1) == 0) {
                        this.deSelectAll();
                    }
                    line.setSelected(true);
                }
                this.notifyShapeChanged();
                this.hep.repaint(0L);
            }
        }
        if (this.creatingPolygon) {
            if (mouseEvent.getClickCount() == 2) {
                this.joinPolygon();
            } else {
                mousePoint = mouseEvent.getPoint();
                EditableShape near = this.aproximationToLine(mousePoint.getX(), mousePoint.getY(), this.vRedrawingLines);
                Point2D nearDrawn = null;
                Point2D nearDrawnOther = this.aproximationToDrawnBorder(mousePoint.getX(), mousePoint.getY());
                if (near != null) {
                    nearDrawn = near.getNearestBorder(mousePoint.getX(), mousePoint.getY());
                }
                if (nearDrawnOther != null && EditableShapeConstants.pointsOnGrid) {
                    this.finX = nearDrawnOther.getX();
                    this.finY = nearDrawnOther.getY();
                } else {
                    mousePoint = this.getTransformedPoint(mouseEvent.getPoint(), true);
                    this.finX = mousePoint.getX();
                    this.finY = mousePoint.getY();
                }
                if (this.lastPoint != null) {
                    if (nearDrawn != null && this.iniPoint.getX() == nearDrawn.getX() && this.iniPoint.getY() == nearDrawn.getY()) {
                        if (this.vShapes.size() >= 2) {
                            this.joinPolygon();
                        }
                    } else if (nearDrawn == null) {
                        this.vShapes.add(new EditableLine2D(this.lastPoint.getX(), this.lastPoint.getY(), this.finX, this.finY));
                        this.lastPoint = new Point2D.Double(this.finX, this.finY);
                    }
                } else {
                    this.lastPoint = this.iniPoint = new Point2D.Double(this.finX, this.finY);
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int resizing;
        Point2D mousePoint = this.getTransformedPoint(mouseEvent.getPoint(), this.drawingMode != 1);
        int x = (int)mousePoint.getX();
        int y = (int)mousePoint.getY();
        if (this.canResize && (resizing = this.getResizing(mousePoint)) != -1) {
            if (this.drawingMode != 1) {
                this.hep.setDrawingMode(1);
            }
            this.bResizing = true;
            this.resizingDirection = resizing;
        }
        if (x < this.hep.previewArea.x || y < this.hep.previewArea.y || (double)x > (double)this.hep.previewArea.x + this.hep.previewArea.getWidth() || (double)y > (double)this.hep.previewArea.y + this.hep.previewArea.getHeight()) {
            return;
        }
        if (this.bMoving) {
            this.paste(this.finX - this.iniX, this.finY - this.iniY);
            this.bMoving = false;
        }
        this.iniX = x;
        this.iniY = y;
        if (this.drawingMode == 1 && !this.bMoving) {
            this.clicatISeleccionada(x, y, false);
            if (this.vRedrawingLines.size() > 0) {
                this.bRedrawingLines = true;
            }
        } else if (!(this.drawingMode != 5 && this.drawingMode != 6 && this.drawingMode != 7 || this.hasSelectedDrawnShape(mouseEvent.getPoint()))) {
            if (this.drawingMode == 5) {
                this.creatingRect = true;
            } else if (this.drawingMode == 6) {
                this.creatingEllipse = true;
            } else {
                this.creatingPolygon = true;
            }
            EditableShape near = this.aproximationToLine(x, y);
            Point2D pNear = this.aproximationToDrawnBorder(x, y);
            if (near != null) {
                pNear = near.getNearestBorder(x, y);
            }
            if (pNear != null) {
                this.iniX = pNear.getX();
                this.iniY = pNear.getY();
            } else {
                this.iniX = x;
                this.iniY = y;
            }
            this.finX = this.iniX;
            this.finY = this.iniY;
            this.hep.repaint(0L);
        } else if (this.drawingMode == 4) {
            EditableShape lineToDivide = this.specialLine;
            EditableShape near = this.aproximationToLine(x, y, null);
            Point2D nearDrawn = null;
            boolean isSelect = false;
            if (near != null) {
                nearDrawn = near.getNearestBorder(x, y);
            }
            if (this.drawingMode == 4 && lineToDivide != null && this.bSpecialLine && (nearDrawn == null || lineToDivide instanceof EditableEllipse2D || lineToDivide instanceof EditableCubicCurve2D || lineToDivide instanceof EditableQuadCurve2D)) {
                this.divideShape(lineToDivide, x, y);
            } else {
                isSelect = this.selectDrawnShape(mouseEvent.getPoint());
            }
            if (!isSelect) {
                this.hep.setDrawingMode(1);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        ShapeData sd;
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if (this.bMoving) {
            this.paste(this.finX - this.iniX, this.finY - this.iniY);
            this.bMoving = false;
            this.deSelectAll();
        }
        Point2D mousePoint = mouseEvent.getPoint();
        EditableShape near = this.aproximationToLine(mousePoint.getX(), mousePoint.getY(), this.vRedrawingLines);
        Point2D nearDrawnPropi = null;
        Point2D nearDrawn = this.aproximationToDrawnBorder(mousePoint.getX(), mousePoint.getY());
        if (near != null || nearDrawn != null) {
            this.hep.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.hep.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (near != null) {
            nearDrawnPropi = near.getNearestBorder(mousePoint.getX(), mousePoint.getY());
        }
        if (!((mousePoint = this.getTransformedPoint(mouseEvent.getPoint(), true)).getX() < (double)this.hep.previewArea.x || mousePoint.getY() < (double)this.hep.previewArea.y || mousePoint.getX() > (double)this.hep.previewArea.x + this.hep.previewArea.getWidth() || mousePoint.getY() > (double)this.hep.previewArea.y + this.hep.previewArea.getHeight())) {
            if (nearDrawn != null && EditableShapeConstants.pointsOnGrid) {
                this.finX = nearDrawn.getX();
                this.finY = nearDrawn.getY();
            } else {
                this.finX = mousePoint.getX();
                this.finY = mousePoint.getY();
            }
        }
        if (this.drawingMode == 1 && !this.bMoving && nearDrawnPropi != null || !this.creatingPolygon && this.vShapes.size() > 1 && !this.validateShape()) {
            boolean canRemove = this.removeNullLines(this.vRedrawingLines);
            if (!canRemove) {
                this.undoLastMove(this.vRedrawingLines, this.vRedrawingLinesBeforeModify);
                this.finX = this.iniX;
                this.finY = this.iniY;
            }
        } else if (this.bRedrawingLines) {
            this.setEndToVector(this.finX, this.finY, this.vRedrawingLines);
            this.bRedrawingLines = false;
            this.vRedrawingLines.clear();
            this.vRedrawingLinesBeforeModify.clear();
        }
        if (this.creatingRect) {
            this.creatingRect = false;
            this.vShapes.add(new EditableRectangle((int)this.iniX, (int)this.iniY, (int)(this.finX - this.iniX), (int)(this.finY - this.iniY)));
            if (this.hep.currentShape >= this.hep.getHoles().getNumCells()) {
                ShapeData sd2 = new ShapeData();
                sd2.comment = "" + this.hep.currentShape;
                this.hep.getHoles().addShape(sd2);
                this.hep.updateList();
            }
        }
        if (this.creatingEllipse) {
            this.creatingEllipse = false;
            this.vShapes.add(new EditableEllipse2D((int)this.iniX, (int)this.iniY, (int)(this.finX - this.iniX), (int)(this.finY - this.iniY)));
            if (this.hep.currentShape >= this.hep.getHoles().getNumCells()) {
                ShapeData sd3 = new ShapeData();
                sd3.comment = "" + this.hep.currentShape;
                this.hep.getHoles().addShape(sd3);
                this.hep.updateList();
            }
        }
        if (this.bResizing) {
            if (this.resizingDirection != -1) {
                double x = mousePoint.getX();
                double y = mousePoint.getY();
                double xInc = x - this.iniX;
                double yInc = y - this.iniY;
                if (this.resizingDirection == 0) {
                    yInc = 0.0;
                } else if (this.resizingDirection == 1) {
                    xInc = 0.0;
                }
                this.hep.incDrawingArea(xInc, yInc);
            }
            this.bResizing = false;
        }
        this.current = (sd = this.getShapeData()) != null ? sd.getShape(this.hep.previewArea) : null;
        this.bSelectingArea = false;
        this.hep.repaint(0L);
        if (!this.creatingPolygon) {
            this.notifyShapeChanged();
        }
    }

    static {
        defaultSensibility = 1.5;
        cursors = null;
    }

    public class KeyHandler
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 127) {
                PolygonDrawPanel.this.deleteSelected(false);
                PolygonDrawPanel.this.hep.shapeChanged();
            }
        }
    }
}

