/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.Buildable;
import VASSAL.build.Widget;
import VASSAL.tools.ScrollPane;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListWidget
extends Widget
implements ListSelectionListener {
    private JPanel panel;
    private JSplitPane split;
    private JList list;
    private DefaultListModel widgets = new DefaultListModel();
    private CardLayout layout;
    private JPanel multiPanel;
    private int width;
    private int height;
    private int divider;
    private static final String DIVIDER = "divider";
    private Map<Object, String> keys = new HashMap<Object, String>();
    private int count = 0;

    public static String getConfigureTypeName() {
        return "Scrollable List";
    }

    @Override
    public Component getComponent() {
        if (this.panel == null) {
            this.rebuild();
            this.panel = new JPanel();
            this.split = new JSplitPane();
            this.split.setResizeWeight(1.0);
            this.list = new JList(this.widgets);
            this.layout = new CardLayout();
            this.multiPanel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 0));
            this.multiPanel.setLayout(this.layout);
            for (Buildable buildable : this.getBuildables()) {
                Widget widget = (Widget)buildable;
                this.multiPanel.add(this.getKey(widget), widget.getComponent());
            }
            this.list.setModel(this.widgets);
            this.list.addListSelectionListener(this);
            this.list.setCellRenderer(new Widget.MyCellRenderer());
            this.list.setFixedCellWidth(80);
            this.list.setVisibleRowCount(3);
            this.split.setLeftComponent(this.multiPanel);
            this.split.setRightComponent(new ScrollPane(this.list));
            if (this.width > 0 && this.height > 0) {
                this.split.setPreferredSize(new Dimension(this.width, this.height));
            }
            if (this.divider > 0) {
                this.split.setDividerLocation(this.divider);
            }
        }
        return this.split;
    }

    @Override
    public void add(Buildable buildable) {
        if (buildable instanceof Widget) {
            Widget widget = (Widget)buildable;
            this.widgets.addElement(widget);
            if (this.panel != null) {
                this.multiPanel.add(this.getKey(widget), widget.getComponent());
                this.list.revalidate();
            }
        }
        super.add(buildable);
    }

    @Override
    public void remove(Buildable buildable) {
        if (buildable instanceof Widget) {
            this.widgets.removeElement(buildable);
        }
        super.remove(buildable);
    }

    private String getKey(Object object) {
        String string = this.keys.get(object);
        if (string == null) {
            string = String.valueOf(this.count++);
            this.keys.put(object, string);
        }
        return string;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object e = this.list.getSelectedValue();
        if (e != null) {
            this.layout.show(this.multiPanel, this.getKey(e));
        }
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"entryName", "width", "height", DIVIDER};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if ("entryName".equals(string)) {
            this.setConfigureName((String)object);
        } else if ("width".equals(string)) {
            this.width = Integer.parseInt((String)object);
        } else if ("height".equals(string)) {
            this.height = Integer.parseInt((String)object);
        } else if (DIVIDER.equals(string)) {
            this.divider = Integer.parseInt((String)object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if ("entryName".equals(string)) {
            return this.getConfigureName();
        }
        if ("width".equals(string)) {
            return String.valueOf(this.split == null ? this.width : this.split.getWidth());
        }
        if ("height".equals(string)) {
            return String.valueOf(this.split == null ? this.height : this.split.getHeight());
        }
        if (DIVIDER.equals(string)) {
            return String.valueOf(this.split == null ? this.divider : this.split.getDividerLocation());
        }
        return null;
    }
}

