/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.GameModule;
import VASSAL.chat.LockableChatServerConnection;
import VASSAL.chat.LockableRoom;
import VASSAL.chat.Room;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.ui.PlayerActionFactory;
import VASSAL.i18n.Resources;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTree;

public class InviteAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private SimplePlayer invitee;
    private LockableChatServerConnection client;

    public InviteAction(LockableChatServerConnection lockableChatServerConnection, SimplePlayer simplePlayer) {
        super(Resources.getString("Chat.invite"));
        this.invitee = simplePlayer;
        this.client = lockableChatServerConnection;
        this.setEnabled(lockableChatServerConnection.isInvitable(simplePlayer));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isEnabled()) {
            this.client.sendInvite(this.invitee);
            GameModule.getGameModule().warn(Resources.getString("Chat.invite_sent", this.invitee.getName()));
        }
    }

    public static PlayerActionFactory factory(final LockableChatServerConnection lockableChatServerConnection) {
        return new PlayerActionFactory(){

            public Action getAction(SimplePlayer simplePlayer, JTree jTree) {
                Room room = lockableChatServerConnection.getRoom();
                if (room instanceof LockableRoom && !((LockableRoom)((Object)room)).isLocked()) {
                    return null;
                }
                return new InviteAction(lockableChatServerConnection, simplePlayer);
            }
        };
    }
}

