/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ErrorDialog;
import VASSAL.tools.SequenceEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertiesEncoder {
    private Properties prop;
    private String stringValue;

    public PropertiesEncoder(Properties properties) {
        this.prop = properties;
        this.stringValue = this.encode(properties);
    }

    public PropertiesEncoder(String string) throws IOException {
        this.stringValue = string;
        this.prop = this.decode(string);
    }

    private String encode(Properties properties) {
        Object object;
        String string = null;
        try {
            object = new ByteArrayOutputStream();
            properties.store((OutputStream)object, null);
            string = new String(((ByteArrayOutputStream)object).toByteArray(), "UTF-8");
        }
        catch (IOException iOException) {
            ErrorDialog.bug(iOException);
            return "";
        }
        object = new StringTokenizer(string, "\n\r", false);
        SequenceEncoder sequenceEncoder = new SequenceEncoder('|');
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string2 = ((StringTokenizer)object).nextToken();
            if (string2.startsWith("#")) continue;
            sequenceEncoder.append(string2);
        }
        return sequenceEncoder.getValue();
    }

    private Properties decode(String string) throws IOException {
        Properties properties = new Properties();
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '|');
        StringBuilder stringBuilder = new StringBuilder();
        while (decoder.hasMoreTokens()) {
            stringBuilder.append(decoder.nextToken());
            if (!decoder.hasMoreTokens()) continue;
            stringBuilder.append('\n');
        }
        properties.load(new ByteArrayInputStream(stringBuilder.toString().getBytes("UTF-8")));
        return properties;
    }

    public Properties getProperties() {
        return this.prop;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String toString() {
        return this.stringValue;
    }
}

