/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import VASSAL.tools.image.FileImageTypeConverter;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageTypeConverter;
import VASSAL.tools.image.MemoryImageTypeConverter;
import VASSAL.tools.io.TemporaryFileFactory;
import VASSAL.tools.lang.Reference;
import java.awt.image.BufferedImage;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FallbackImageTypeConverter
implements ImageTypeConverter {
    private static final Logger logger = LoggerFactory.getLogger(FallbackImageTypeConverter.class);
    protected final TemporaryFileFactory tfactory;
    protected final ImageTypeConverter memory_converter;
    protected final ImageTypeConverter file_converter;

    public FallbackImageTypeConverter(TemporaryFileFactory temporaryFileFactory) {
        this(temporaryFileFactory, new MemoryImageTypeConverter(), new FileImageTypeConverter(temporaryFileFactory));
    }

    FallbackImageTypeConverter(TemporaryFileFactory temporaryFileFactory, ImageTypeConverter imageTypeConverter, ImageTypeConverter imageTypeConverter2) {
        this.tfactory = temporaryFileFactory;
        this.memory_converter = imageTypeConverter;
        this.file_converter = imageTypeConverter2;
    }

    private boolean tryConvertingInMemory(Reference<BufferedImage> reference) {
        return !SystemUtils.IS_OS_MAC_OSX || !SystemUtils.IS_JAVA_1_6 && !SystemUtils.IS_JAVA_1_5 || (long)(4 * ((BufferedImage)reference.obj).getHeight() * ((BufferedImage)reference.obj).getWidth()) <= Runtime.getRuntime().maxMemory() / 4L;
    }

    @Override
    public BufferedImage convert(Reference<BufferedImage> reference, int n) throws ImageIOException {
        if (this.tryConvertingInMemory(reference)) {
            try {
                return this.memory_converter.convert(reference, n);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                logger.info("Switching to FileImageTypeConverter...");
            }
        }
        return this.file_converter.convert(reference, n);
    }
}

