/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.image.GeneralFilter;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.ScaleOpBitmapImpl;
import VASSAL.tools.imageop.SourceOp;
import VASSAL.tools.imageop.SourceOpDiskCacheBitmapImpl;
import VASSAL.tools.opcache.Op;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ScaleOpTiledBitmapImpl
extends ScaleOpBitmapImpl {
    public ScaleOpTiledBitmapImpl(ImageOp imageOp, double d) {
        this(imageOp, d, defaultHints);
    }

    public ScaleOpTiledBitmapImpl(ImageOp imageOp, double d, RenderingHints renderingHints) {
        super(imageOp, d, renderingHints);
    }

    protected ImageOp createTileOp(int n, int n2) {
        boolean bl;
        double d = 1.0 / this.scale;
        boolean bl2 = bl = Math.floor(d) == d && ((int)d & (int)d - 1) == 0;
        if (bl && this.sop instanceof SourceOp) {
            String string = ((SourceOp)this.sop).getName();
            return new SourceOpDiskCacheBitmapImpl(string, n, n2, this.scale);
        }
        return new TileOp(this, n, n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        ScaleOpTiledBitmapImpl scaleOpTiledBitmapImpl = (ScaleOpTiledBitmapImpl)object;
        return this.scale == scaleOpTiledBitmapImpl.scale && this.sop.equals(scaleOpTiledBitmapImpl.sop) && this.hints.equals(scaleOpTiledBitmapImpl.hints);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TileOp
    extends AbstractTileOpImpl {
        private final ImageOp rsop;
        private final ImageOp[] sop;
        private final int dx0;
        private final int dy0;
        private final int dx1;
        private final int dy1;
        private final int dw;
        private final int dh;
        private final int sx0;
        private final int sy0;
        private final int sx1;
        private final int sy1;
        private final int sw;
        private final int sh;
        private final Dimension dd;
        private final Dimension sd;
        private final double scale;
        private final float xscale;
        private final float yscale;
        private final int tx;
        private final int ty;
        private final RenderingHints hints;
        private final int hash;
        private static final GeneralFilter.Filter downFilter = new GeneralFilter.Lanczos3Filter();
        private static final GeneralFilter.Filter upFilter = new GeneralFilter.MitchellFilter();

        public TileOp(ScaleOpTiledBitmapImpl scaleOpTiledBitmapImpl, int n, int n2) {
            if (scaleOpTiledBitmapImpl == null) {
                throw new IllegalArgumentException();
            }
            if (n < 0 || n >= scaleOpTiledBitmapImpl.getNumXTiles() || n2 < 0 || n2 >= scaleOpTiledBitmapImpl.getNumYTiles()) {
                throw new IndexOutOfBoundsException();
            }
            this.tx = n;
            this.ty = n2;
            this.scale = scaleOpTiledBitmapImpl.getScale();
            this.hints = scaleOpTiledBitmapImpl.getHints();
            this.dd = scaleOpTiledBitmapImpl.getSize();
            this.dx0 = n * scaleOpTiledBitmapImpl.getTileWidth();
            this.dy0 = n2 * scaleOpTiledBitmapImpl.getTileHeight();
            this.dw = Math.min(scaleOpTiledBitmapImpl.getTileWidth(), this.dd.width - this.dx0);
            this.dh = Math.min(scaleOpTiledBitmapImpl.getTileHeight(), this.dd.height - this.dy0);
            this.dx1 = this.dx0 + this.dw - 1;
            this.dy1 = this.dy0 + this.dh - 1;
            this.size = new Dimension(this.dw, this.dh);
            if (this.scale >= 1.0) {
                this.rsop = scaleOpTiledBitmapImpl.sop;
            } else {
                double d = 1.0 / (double)(1 << (int)Math.floor(Math.log(1.0 / this.scale) / Math.log(2.0)));
                this.rsop = new ScaleOpTiledBitmapImpl(scaleOpTiledBitmapImpl.sop, d);
            }
            this.sd = this.rsop.getSize();
            this.xscale = this.sd.width == 1 ? (float)this.dd.width : (float)(this.dd.width - 1) / (float)(this.sd.width - 1);
            this.yscale = this.sd.height == 1 ? (float)this.dd.height : (float)(this.dd.height - 1) / (float)(this.sd.height - 1);
            float f = this.scale < 1.0 ? downFilter.getSamplingRadius() : upFilter.getSamplingRadius();
            this.sx0 = Math.max(0, (int)Math.floor(((float)this.dx0 - f) / this.xscale));
            this.sy0 = Math.max(0, (int)Math.floor(((float)this.dy0 - f) / this.yscale));
            this.sx1 = Math.min(this.sd.width - 1, (int)Math.ceil(((float)this.dx1 + f) / this.xscale));
            this.sy1 = Math.min(this.sd.height - 1, (int)Math.ceil(((float)this.dy1 + f) / this.yscale));
            this.sw = this.sx1 - this.sx0 + 1;
            this.sh = this.sy1 - this.sy0 + 1;
            Rectangle rectangle = new Rectangle(this.sx0, this.sy0, this.sw, this.sh);
            Point[] pointArray = this.rsop.getTileIndices(rectangle);
            this.sop = new ImageOp[pointArray.length];
            for (int i = 0; i < pointArray.length; ++i) {
                this.sop[i] = this.rsop.getTileOp(pointArray[i]);
            }
            this.hash = new HashCodeBuilder().append((Object[])this.sop).append(this.dx0).append(this.dy0).append(this.dw).append(this.dh).append(this.tx).append(this.ty).toHashCode();
        }

        @Override
        public List<Op<?>> getSources() {
            return Arrays.asList(this.sop);
        }

        @Override
        public BufferedImage eval() throws Exception {
            BufferedImage bufferedImage;
            if (this.dw < 1 || this.dh < 1) {
                return ImageUtils.NULL_IMAGE;
            }
            Point[] pointArray = this.rsop.getTileIndices(new Rectangle(this.sx0, this.sy0, this.sw, this.sh));
            int n = this.rsop.getTileWidth();
            int n2 = this.rsop.getTileHeight();
            boolean bl = ImageUtils.isTransparent(this.rsop.getTile(pointArray[0], null));
            switch (ImageUtils.getCompatibleImageType(this.rsop.getTile(pointArray[0], null))) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    bufferedImage = ImageUtils.createCompatibleImage(this.sw, this.sh, bl);
                    break;
                }
                default: {
                    bufferedImage = new BufferedImage(this.sw, this.sh, bl ? 3 : 1);
                }
            }
            Graphics2D graphics2D = bufferedImage.createGraphics();
            for (Point n3 : pointArray) {
                graphics2D.drawImage((Image)this.rsop.getTile(n3, null), n3.x * n - this.sx0, n3.y * n2 - this.sy0, null);
            }
            graphics2D.dispose();
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            WritableRaster writableRaster = bufferedImage.getColorModel().createCompatibleWritableRaster(this.dw, this.dh);
            int[] nArray2 = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
            int n3 = !bl ? 0 : (bufferedImage.isAlphaPremultiplied() ? 1 : 2);
            GeneralFilter.resample(nArray, true, this.sx0, this.sy0, this.sx1, this.sy1, this.sw, this.sh, n3, this.sd.width, this.sd.height, nArray2, this.dx0, this.dy0, this.dx1, this.dy1, this.dw, this.dh, this.dd.width, this.dd.height, this.xscale, this.yscale, this.scale < 1.0 ? downFilter : upFilter);
            return ImageUtils.toCompatibleImage(new BufferedImage(bufferedImage.getColorModel(), writableRaster, bufferedImage.isAlphaPremultiplied(), null));
        }

        @Override
        protected void fixSize() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            TileOp tileOp = (TileOp)object;
            return this.dx0 == tileOp.dx0 && this.dy0 == tileOp.dy0 && this.dw == tileOp.dw && this.dh == tileOp.dh && this.tx == tileOp.tx && this.ty == tileOp.ty && this.scale == tileOp.scale && Arrays.equals(this.sop, tileOp.sop);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.getClass().getName() + "[sop=" + Arrays.toString(this.sop) + ",scale=" + this.scale + ",dx0=" + this.dx0 + ",dy0=" + this.dy0 + ",dw=" + this.dw + ",dy=" + this.dh + "]";
        }
    }
}

