/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.tools.io.IOUtils;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;

public class DeobfuscatingInputStream
extends FilterInputStream {
    public DeobfuscatingInputStream(InputStream inputStream) throws IOException {
        super(null);
        byte[] byArray = new byte["!VCSK".length()];
        DeobfuscatingInputStream.readFully(inputStream, byArray, 0, byArray.length);
        if (new String(byArray, "UTF-8").equals("!VCSK")) {
            this.in = new DeobfuscatingInputStreamImpl(inputStream);
        } else {
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, byArray.length);
            pushbackInputStream.unread(byArray);
            this.in = pushbackInputStream;
        }
    }

    private static int readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n + n3, n2 - n3)) >= 0; n3 += n4) {
        }
        return n3;
    }

    public static void main(String[] stringArray) throws IOException {
        DeobfuscatingInputStream deobfuscatingInputStream = null;
        try {
            deobfuscatingInputStream = new DeobfuscatingInputStream(stringArray.length > 0 ? new FileInputStream(stringArray[0]) : System.in);
            IOUtils.copy((InputStream)deobfuscatingInputStream, (OutputStream)System.out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(deobfuscatingInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)deobfuscatingInputStream);
        System.exit(0);
    }

    private static class DeobfuscatingInputStreamImpl
    extends FilterInputStream {
        private final byte key;
        private final byte[] pair = new byte[2];

        public DeobfuscatingInputStreamImpl(InputStream inputStream) throws IOException {
            super(inputStream);
            DeobfuscatingInputStream.readFully(inputStream, this.pair, 0, 2);
            this.key = (byte)(this.unhex(this.pair[0]) << 4 | this.unhex(this.pair[1]));
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2 && (n3 = this.read()) >= 0) {
                byArray[n4++ + n] = (byte)n3;
            }
            return n3 == -1 && n4 == 0 ? -1 : n4;
        }

        public int read() throws IOException {
            switch (DeobfuscatingInputStream.readFully(this.in, this.pair, 0, 2)) {
                case 0: {
                    return -1;
                }
                case 1: {
                    throw new IOException();
                }
                case 2: {
                    return ((this.unhex(this.pair[0]) << 4 | this.unhex(this.pair[1])) ^ this.key) & 0xFF;
                }
            }
            throw new IOException();
        }

        private int unhex(int n) throws IOException {
            switch (n) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return n - 48;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    return n - 55;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    return n - 87;
                }
            }
            throw new IOException(String.valueOf(n));
        }
    }
}

