/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.Info;
import VASSAL.tools.IterableEnumeration;
import VASSAL.tools.concurrent.CountingReadWriteLock;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipArchive
implements FileArchive {
    private final File archiveFile;
    private ZipFile zipFile;
    private boolean modified = false;
    private boolean closed = true;
    private final Map<String, Entry> entries = new HashMap<String, Entry>();
    private final ReadWriteLock rwl = new CountingReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();

    public ZipArchive(String string) throws IOException {
        this(string, false);
    }

    public ZipArchive(File file) throws IOException {
        this(file, false);
    }

    public ZipArchive(String string, boolean bl) throws IOException {
        this(new File(string), bl);
    }

    public ZipArchive(File file, boolean bl) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.archiveFile = file;
        if (bl) {
            this.archiveFile.delete();
        }
    }

    public ZipArchive(FileArchive fileArchive, String string) throws IOException {
        this(fileArchive, new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipArchive(FileArchive fileArchive, File file) throws IOException {
        this(file, true);
        byte[] byArray = new byte[8192];
        for (String string : fileArchive.getFiles()) {
            InputStream inputStream = null;
            try {
                inputStream = fileArchive.getInputStream(string);
                OutputStream outputStream = null;
                try {
                    outputStream = this.getOutputStream(string);
                    IOUtils.copy(inputStream, outputStream, byArray);
                    outputStream.close();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)outputStream);
                }
                inputStream.close();
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        this.flush();
    }

    @Override
    public String getName() {
        return this.archiveFile.getPath();
    }

    @Override
    public File getFile() {
        return this.archiveFile;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public InputStream getInputStream(String string) throws IOException {
        this.r.lock();
        try {
            this.openIfClosed();
            Entry entry = this.entries.get(string);
            if (entry == null) {
                throw new FileNotFoundException(string + " not in archive");
            }
            InputStream inputStream = null;
            if (entry.file != null) {
                inputStream = new FileInputStream(entry.file);
            } else if (this.zipFile != null) {
                inputStream = this.zipFile.getInputStream(entry.ze);
            }
            if (inputStream == null) {
                throw new FileNotFoundException(string + " not in archive");
            }
            return new ZipArchiveInputStream(inputStream);
        }
        catch (IOException iOException) {
            this.r.unlock();
            throw iOException;
        }
    }

    @Override
    public OutputStream getOutputStream(String string) throws IOException {
        return this.getOutputStream(string, true);
    }

    public OutputStream getOutputStream(String string, boolean bl) throws IOException {
        this.w.lock();
        try {
            this.openIfClosed();
            this.modified = true;
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setMethod(bl ? 8 : 0);
            File file = File.createTempFile("zip", ".tmp", Info.getTempDir());
            Entry entry = new Entry(zipEntry, file);
            Entry entry2 = this.entries.put(string, entry);
            if (entry2 != null && entry2.file != null) {
                entry2.file.delete();
            }
            return new ZipArchiveOutputStream(new FileOutputStream(entry.file), new CRC32(), entry.ze);
        }
        catch (IOException iOException) {
            this.w.unlock();
            throw iOException;
        }
    }

    @Override
    public void add(String string, String string2) throws IOException {
        this.add(string, new File(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String string, File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.add(string, fileInputStream);
            fileInputStream.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
    }

    @Override
    public void add(String string, byte[] byArray) throws IOException {
        this.add(string, new ByteArrayInputStream(byArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String string, InputStream inputStream) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = this.getOutputStream(string);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.close();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String string) throws IOException {
        this.w.lock();
        try {
            this.openIfClosed();
            Entry entry = this.entries.remove(string);
            if (entry != null) {
                this.modified = true;
                if (entry.file != null) {
                    entry.file.delete();
                }
            }
            boolean bl = entry != null;
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void revert() throws IOException {
        this.w.lock();
        try {
            if (!this.modified) {
                return;
            }
            for (Entry entry : this.entries.values()) {
                if (entry == null || entry.file == null) continue;
                entry.file.delete();
            }
            this.modified = false;
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
        this.w.lock();
        try {
            if (this.modified) {
                this.writeToDisk();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.w.lock();
        try {
            if (this.closed) {
                return;
            }
            if (this.modified) {
                this.writeToDisk();
            } else if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
                this.closed = true;
                this.entries.clear();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void writeToDisk() throws IOException {
        Object object;
        Object object2;
        File file = File.createTempFile("tmp", ".zip", this.archiveFile.getParentFile());
        ZipOutputStream zipOutputStream = null;
        try {
            Object object3;
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            zipOutputStream.setLevel(9);
            object2 = new byte[8192];
            if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
                object = null;
                try {
                    ZipEntry zipEntry;
                    object = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.archiveFile)));
                    Object object4 = null;
                    while ((zipEntry = ((ZipInputStream)object).getNextEntry()) != null) {
                        void var5_10;
                        object3 = this.entries.get(zipEntry.getName());
                        if (object3 == null || ((Entry)object3).file != null) continue;
                        if (zipEntry.getMethod() == 8) {
                            ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
                            zipEntry2.setTime(zipEntry.getTime());
                            ZipEntry zipEntry3 = zipEntry2;
                        }
                        zipOutputStream.putNextEntry((ZipEntry)var5_10);
                        IOUtils.copy((InputStream)object, zipOutputStream, (byte[])object2);
                        this.entries.remove(var5_10.getName());
                    }
                    ((ZipInputStream)object).close();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(object);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)object);
            }
            for (Entry entry : this.entries.values()) {
                if (entry == null || entry.file == null) continue;
                object3 = null;
                try {
                    object3 = new FileInputStream(entry.file);
                    entry.ze.setTime(entry.file.lastModified());
                    zipOutputStream.putNextEntry(entry.ze);
                    IOUtils.copy((InputStream)object3, zipOutputStream, (byte[])object2);
                    ((FileInputStream)object3).close();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(object3);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)object3);
            }
            zipOutputStream.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zipOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)zipOutputStream);
        if (!file.renameTo(this.archiveFile)) {
            try {
                FileUtils.forceDelete((File)this.archiveFile);
                FileUtils.moveFile((File)file, (File)this.archiveFile);
            }
            catch (IOException iOException) {
                object = "Unable to overwrite " + this.archiveFile.getAbsolutePath() + ": ";
                if (!this.archiveFile.exists()) {
                    object = (String)object + " file does not exist.";
                } else if (!this.archiveFile.canWrite()) {
                    object = (String)object + " file is not writable.";
                } else if (!this.archiveFile.isFile()) {
                    object = (String)object + " not a normal file.";
                }
                object = (String)object + " Data written to " + file.getAbsolutePath() + " instead.";
                throw (IOException)new IOException((String)object).initCause(iOException);
            }
        }
        object2 = this.entries.values().iterator();
        while (object2.hasNext()) {
            object = (Entry)object2.next();
            if (object == null || ((Entry)object).file == null) continue;
            ((Entry)object).file.delete();
        }
        this.closed = true;
        this.modified = false;
        this.entries.clear();
    }

    @Override
    public boolean contains(String string) throws IOException {
        this.r.lock();
        try {
            this.openIfClosed();
            boolean bl = this.entries.containsKey(string);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize(String string) throws IOException {
        this.r.lock();
        try {
            this.openIfClosed();
            Entry entry = this.entries.get(string);
            if (entry == null) {
                throw new FileNotFoundException(string + " not in archive");
            }
            long l = entry.file == null ? entry.ze.getSize() : entry.file.length();
            return l;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMTime(String string) throws IOException {
        this.r.lock();
        try {
            this.openIfClosed();
            Entry entry = this.entries.get(string);
            if (entry == null) {
                throw new FileNotFoundException(string + " not in archive");
            }
            long l = entry.file == null ? entry.ze.getTime() : entry.file.lastModified();
            return l;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public List<String> getFiles() throws IOException {
        this.r.lock();
        try {
            this.openIfClosed();
            ArrayList<String> arrayList = new ArrayList<String>(this.entries.keySet());
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getFiles(String string) throws IOException {
        if (string.length() == 0) {
            return this.getFiles();
        }
        this.r.lock();
        try {
            this.openIfClosed();
            string = string + '/';
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : this.entries.keySet()) {
                if (!string2.startsWith(string)) continue;
                arrayList.add(string2);
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.r.unlock();
        }
    }

    private synchronized void readEntries() throws IOException {
        this.entries.clear();
        if (this.archiveFile.exists() && this.archiveFile.length() > 0L) {
            this.zipFile = new ZipFile(this.archiveFile);
            for (ZipEntry zipEntry : IterableEnumeration.iterate(this.zipFile.entries())) {
                this.entries.put(zipEntry.getName(), new Entry(zipEntry, null));
            }
        }
    }

    private synchronized void openIfClosed() throws IOException {
        if (this.closed) {
            this.readEntries();
            this.modified = false;
            this.closed = false;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        ZipArchive zipArchive = new ZipArchive("test.zip");
        zipArchive.add("NOTES", "NOTES");
        zipArchive.add("README.txt", "README.txt");
        zipArchive.flush();
        InputStream inputStream = null;
        try {
            inputStream = zipArchive.getInputStream("NOTES");
            IOUtils.copy((InputStream)inputStream, (OutputStream)System.out);
            inputStream.close();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        zipArchive.close();
    }

    private class ZipArchiveOutputStream
    extends CheckedOutputStream {
        private ZipEntry entry;
        private long count;
        private boolean closed;

        public ZipArchiveOutputStream(OutputStream outputStream, Checksum checksum, ZipEntry zipEntry) {
            super(outputStream, checksum);
            this.count = 0L;
            this.closed = false;
            if (outputStream == null) {
                throw new NullPointerException("out == null");
            }
            if (checksum == null) {
                throw new NullPointerException("cksum == null");
            }
            if (zipEntry == null) {
                throw new NullPointerException("e == null");
            }
            this.entry = zipEntry;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            super.write(byArray, n, n2);
            this.count += (long)n2;
        }

        public void write(int n) throws IOException {
            super.write(n);
            ++this.count;
        }

        public void flush() throws IOException {
            super.flush();
            this.entry.setSize(this.count);
            this.entry.setCrc(this.getChecksum().getValue());
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                super.close();
            }
            finally {
                ZipArchive.this.w.unlock();
                this.closed = true;
            }
        }
    }

    private class ZipArchiveInputStream
    extends FilterInputStream {
        private boolean closed;

        public ZipArchiveInputStream(InputStream inputStream) {
            super(inputStream);
            this.closed = false;
            if (inputStream == null) {
                throw new NullPointerException("in == null");
            }
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                super.close();
            }
            finally {
                ZipArchive.this.r.unlock();
                this.closed = true;
            }
        }
    }

    private static class Entry {
        public ZipEntry ze;
        public File file;

        public Entry(ZipEntry zipEntry, File file) {
            this.ze = zipEntry;
            this.file = file;
        }

        public String toString() {
            return this.getClass().getName() + "[file=\"" + this.file + "\", ze=\"" + this.ze + "\"]";
        }
    }
}

