/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.swing;

import VASSAL.i18n.Resources;
import VASSAL.tools.swing.EDT;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.event.EventListenerList;
import net.miginfocom.swing.MigLayout;

public class ProgressDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected final JLabel label;
    protected final JProgressBar progbar;
    protected final JButton cancel;
    protected final EventListenerList listeners = new EventListenerList();

    public ProgressDialog(Frame frame, String string, String string2) {
        super(frame, string, true);
        this.label = new JLabel(string2);
        this.progbar = new JProgressBar(0, 100);
        this.progbar.setStringPainted(true);
        this.progbar.setValue(0);
        this.cancel = new JButton(Resources.getString("General.cancel"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProgressDialog.this.fireCancelledEvent(new ActionEvent(ProgressDialog.this, 1001, "cancel"));
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressDialog.this.fireCancelledEvent(actionEvent);
            }
        });
        JPanel jPanel = new JPanel(new MigLayout("insets dialog, fill", "", "unrelated:push[]related[]unrelated:push[]"));
        jPanel.add((Component)this.progbar, "growx, wrap");
        jPanel.add((Component)this.label, "wmin 0, pad 0 0 2pt 0, wrap unrel:push");
        jPanel.add((Component)this.cancel, "tag cancel");
        this.add(jPanel);
        this.pack();
        this.setMinimumSize(new Dimension(300, this.getHeight()));
        this.pack();
    }

    protected void fireCancelledEvent(ActionEvent actionEvent) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setLabel(String string) {
        this.label.setText(string);
    }

    public boolean isIndeterminate() {
        return this.progbar.isIndeterminate();
    }

    public void setIndeterminate(boolean bl) {
        this.progbar.setIndeterminate(bl);
    }

    public int getProgress() {
        return this.progbar.getValue();
    }

    public void setProgress(int n) {
        this.progbar.setValue(n);
    }

    public boolean isStringPainted() {
        return this.progbar.isStringPainted();
    }

    public void setStringPainted(boolean bl) {
        this.progbar.setStringPainted(bl);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(ActionListener.class, actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listeners.getListeners(ActionListener.class);
    }

    public static ProgressDialog createOnEDT(final Frame frame, final String string, final String string2) {
        Future<ProgressDialog> future = EDT.submit(new Callable<ProgressDialog>(){

            @Override
            public ProgressDialog call() {
                return new ProgressDialog(frame, string, string2);
            }
        });
        try {
            return future.get();
        }
        catch (CancellationException cancellationException) {
            throw new IllegalStateException(cancellationException);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException(executionException);
        }
    }
}

