/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.Access;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.JaninoRuntimeException;
import org.codehaus.janino.MethodDescriptor;
import org.codehaus.janino.util.ClassFile;

public class ClassFileIClass
extends IClass {
    private static final boolean DEBUG = false;
    private final ClassFile classFile;
    private final IClassLoader iClassLoader;
    private final short accessFlags;
    private final Map resolvedFields = new HashMap();
    private final Map resolvedClasses = new HashMap();
    private final Map resolvedMethods = new HashMap();

    public ClassFileIClass(ClassFile classFile, IClassLoader iClassLoader) {
        this.classFile = classFile;
        this.iClassLoader = iClassLoader;
        this.accessFlags = classFile.accessFlags;
    }

    protected IClass.IConstructor[] getDeclaredIConstructors2() {
        ArrayList<IClass.IInvocable> iConstructors = new ArrayList<IClass.IInvocable>();
        Iterator it = this.classFile.methodInfos.iterator();
        while (it.hasNext()) {
            IClass.IInvocable ii;
            ClassFile.MethodInfo mi = (ClassFile.MethodInfo)it.next();
            try {
                ii = this.resolveMethod(mi);
            }
            catch (ClassNotFoundException ex) {
                throw new JaninoRuntimeException(ex.getMessage());
            }
            if (!(ii instanceof IClass.IConstructor)) continue;
            iConstructors.add(ii);
        }
        return iConstructors.toArray(new IClass.IConstructor[iConstructors.size()]);
    }

    protected IClass.IMethod[] getDeclaredIMethods2() {
        ArrayList<IClass.IInvocable> iMethods = new ArrayList<IClass.IInvocable>();
        Iterator it = this.classFile.methodInfos.iterator();
        while (it.hasNext()) {
            IClass.IInvocable ii;
            ClassFile.MethodInfo mi = (ClassFile.MethodInfo)it.next();
            if ((mi.getAccessFlags() & 0x1000) != 0) continue;
            try {
                ii = this.resolveMethod(mi);
            }
            catch (ClassNotFoundException ex) {
                throw new JaninoRuntimeException(ex.getMessage());
            }
            if (!(ii instanceof IClass.IMethod)) continue;
            iMethods.add(ii);
        }
        return iMethods.toArray(new IClass.IMethod[iMethods.size()]);
    }

    protected IClass.IField[] getDeclaredIFields2() {
        IClass.IField[] ifs = new IClass.IField[this.classFile.fieldInfos.size()];
        for (int i = 0; i < this.classFile.fieldInfos.size(); ++i) {
            try {
                ifs[i] = this.resolveField((ClassFile.FieldInfo)this.classFile.fieldInfos.get(i));
                continue;
            }
            catch (ClassNotFoundException ex) {
                throw new JaninoRuntimeException(ex.getMessage());
            }
        }
        return ifs;
    }

    protected IClass[] getDeclaredIClasses2() throws CompileException {
        ClassFile.InnerClassesAttribute ica = this.classFile.getInnerClassesAttribute();
        if (ica == null) {
            return new IClass[0];
        }
        List ices = ica.getEntries();
        ArrayList<IClass> res = new ArrayList<IClass>();
        Iterator it = ices.iterator();
        while (it.hasNext()) {
            ClassFile.InnerClassesAttribute.Entry e = (ClassFile.InnerClassesAttribute.Entry)it.next();
            if (e.outerClassInfoIndex != this.classFile.thisClass) continue;
            try {
                res.add(this.resolveClass(e.innerClassInfoIndex));
            }
            catch (ClassNotFoundException ex) {
                throw new CompileException(ex.getMessage(), null);
            }
        }
        return res.toArray(new IClass[res.size()]);
    }

    protected IClass getDeclaringIClass2() throws CompileException {
        ClassFile.InnerClassesAttribute ica = this.classFile.getInnerClassesAttribute();
        if (ica == null) {
            return null;
        }
        List ices = ica.getEntries();
        Iterator it = ices.iterator();
        while (it.hasNext()) {
            ClassFile.InnerClassesAttribute.Entry e = (ClassFile.InnerClassesAttribute.Entry)it.next();
            if (e.innerClassInfoIndex != this.classFile.thisClass) continue;
            if (e.outerClassInfoIndex == 0) {
                return null;
            }
            try {
                return this.resolveClass(e.outerClassInfoIndex);
            }
            catch (ClassNotFoundException ex) {
                throw new CompileException(ex.getMessage(), null);
            }
        }
        return null;
    }

    protected IClass getOuterIClass2() throws CompileException {
        ClassFile.InnerClassesAttribute ica = this.classFile.getInnerClassesAttribute();
        if (ica == null) {
            return null;
        }
        List ices = ica.getEntries();
        Iterator it = ices.iterator();
        while (it.hasNext()) {
            ClassFile.InnerClassesAttribute.Entry e = (ClassFile.InnerClassesAttribute.Entry)it.next();
            if (e.innerClassInfoIndex != this.classFile.thisClass) continue;
            if (e.outerClassInfoIndex == 0) {
                return null;
            }
            if ((e.innerClassAccessFlags & 8) != 0) {
                return null;
            }
            try {
                return this.resolveClass(e.outerClassInfoIndex);
            }
            catch (ClassNotFoundException ex) {
                throw new CompileException(ex.getMessage(), null);
            }
        }
        return null;
    }

    protected IClass getSuperclass2() throws CompileException {
        if (this.classFile.superclass == 0) {
            return null;
        }
        try {
            return this.resolveClass(this.classFile.superclass);
        }
        catch (ClassNotFoundException e) {
            throw new CompileException(e.getMessage(), null);
        }
    }

    public Access getAccess() {
        return ClassFileIClass.accessFlags2Access(this.accessFlags);
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    protected IClass[] getInterfaces2() throws CompileException {
        return this.resolveClasses(this.classFile.interfaces);
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    protected String getDescriptor2() {
        return Descriptor.fromClassName(this.classFile.getThisClassName());
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isPrimitiveNumeric() {
        return false;
    }

    protected IClass getComponentType2() {
        return null;
    }

    public void resolveHalf() throws ClassNotFoundException {
        int i;
        this.resolveClass(this.classFile.superclass);
        for (i = 0; i < this.classFile.interfaces.length; ++i) {
            this.resolveClass(this.classFile.interfaces[i]);
        }
        for (i = 0; i < this.classFile.methodInfos.size(); ++i) {
            this.resolveMethod((ClassFile.MethodInfo)this.classFile.methodInfos.get(i));
        }
        for (i = 0; i < this.classFile.fieldInfos.size(); ++i) {
            this.resolveField((ClassFile.FieldInfo)this.classFile.fieldInfos.get(i));
        }
    }

    public void resolveAllClasses() throws ClassNotFoundException {
        for (short i = 0; i < this.classFile.constantPool.size(); i = (short)(i + 1)) {
            ClassFile.ConstantPoolInfo cpi = this.classFile.getConstantPoolInfo(i);
            if (cpi instanceof ClassFile.ConstantClassInfo) {
                this.resolveClass(i);
                continue;
            }
            if (!(cpi instanceof ClassFile.ConstantNameAndTypeInfo)) continue;
            short descriptorIndex = ((ClassFile.ConstantNameAndTypeInfo)cpi).getDescriptorIndex();
            String descriptor = this.classFile.getConstantUtf8(descriptorIndex);
            if (descriptor.charAt(0) == '(') {
                MethodDescriptor md = new MethodDescriptor(descriptor);
                this.resolveClass(md.returnFD);
                for (int j = 0; j < md.parameterFDs.length; ++j) {
                    this.resolveClass(md.parameterFDs[j]);
                }
                continue;
            }
            this.resolveClass(descriptor);
        }
    }

    private IClass resolveClass(short index) throws ClassNotFoundException {
        return this.resolveClass(Descriptor.fromInternalForm(this.classFile.getConstantClassName(index)));
    }

    private IClass resolveClass(String descriptor) throws ClassNotFoundException {
        IClass result = (IClass)this.resolvedClasses.get(descriptor);
        if (result != null) {
            return result;
        }
        result = this.iClassLoader.loadIClass(descriptor);
        if (result == null) {
            throw new ClassNotFoundException(descriptor);
        }
        this.resolvedClasses.put(descriptor, result);
        return result;
    }

    private IClass[] resolveClasses(short[] ifs) throws CompileException {
        IClass[] result = new IClass[ifs.length];
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = this.resolveClass(ifs[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new CompileException(e.getMessage(), null);
            }
        }
        return result;
    }

    private IClass.IInvocable resolveMethod(final ClassFile.MethodInfo methodInfo) throws ClassNotFoundException {
        IClass.IInvocable result = (IClass.IInvocable)this.resolvedMethods.get(methodInfo);
        if (result != null) {
            return result;
        }
        final String name = this.classFile.getConstantUtf8(methodInfo.getNameIndex());
        MethodDescriptor md = new MethodDescriptor(this.classFile.getConstantUtf8(methodInfo.getDescriptorIndex()));
        final IClass returnType = this.resolveClass(md.returnFD);
        final IClass[] parameterTypes = new IClass[md.parameterFDs.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = this.resolveClass(md.parameterFDs[i]);
        }
        IClass[] tes = null;
        ClassFile.AttributeInfo[] ais = methodInfo.getAttributes();
        for (int i = 0; i < ais.length; ++i) {
            ClassFile.AttributeInfo ai = ais[i];
            if (!(ai instanceof ClassFile.ExceptionsAttribute)) continue;
            short[] teis = ((ClassFile.ExceptionsAttribute)ai).getExceptionIndexes();
            tes = new IClass[teis.length];
            for (int j = 0; j < teis.length; ++j) {
                tes[j] = this.resolveClass(teis[j]);
            }
        }
        final IClass[] thrownExceptions = tes == null ? new IClass[]{} : tes;
        final Access access = ClassFileIClass.accessFlags2Access(methodInfo.getAccessFlags());
        result = name.equals("<init>") ? new IClass.IConstructor(){

            public IClass[] getParameterTypes() throws CompileException {
                IClass outerIClass = ClassFileIClass.this.getOuterIClass();
                if (outerIClass != null) {
                    if (parameterTypes.length < 1) {
                        throw new JaninoRuntimeException("Inner class constructor lacks magic first parameter");
                    }
                    if (parameterTypes[0] != outerIClass) {
                        throw new JaninoRuntimeException("Magic first parameter of inner class constructor has type \"" + parameterTypes[0].toString() + "\" instead of that of its enclosing instance (\"" + outerIClass.toString() + "\")");
                    }
                    IClass[] tmp = new IClass[parameterTypes.length - 1];
                    System.arraycopy(parameterTypes, 1, tmp, 0, tmp.length);
                    return tmp;
                }
                return parameterTypes;
            }

            public IClass[] getThrownExceptions() throws CompileException {
                return thrownExceptions;
            }

            public Access getAccess() {
                return access;
            }
        } : new IClass.IMethod(){

            public String getName() {
                return name;
            }

            public IClass getReturnType() throws CompileException {
                return returnType;
            }

            public boolean isStatic() {
                return (methodInfo.getAccessFlags() & 8) != 0;
            }

            public boolean isAbstract() {
                return (methodInfo.getAccessFlags() & 0x400) != 0;
            }

            public IClass[] getParameterTypes() throws CompileException {
                return parameterTypes;
            }

            public IClass[] getThrownExceptions() throws CompileException {
                return thrownExceptions;
            }

            public Access getAccess() {
                return access;
            }
        };
        this.resolvedMethods.put(methodInfo, result);
        return result;
    }

    private IClass.IField resolveField(final ClassFile.FieldInfo fieldInfo) throws ClassNotFoundException {
        IClass.IField result = (IClass.IField)this.resolvedFields.get(fieldInfo);
        if (result != null) {
            return result;
        }
        final String name = this.classFile.getConstantUtf8(fieldInfo.getNameIndex());
        String descriptor = this.classFile.getConstantUtf8(fieldInfo.getDescriptorIndex());
        final IClass type = this.resolveClass(descriptor);
        ClassFile.ConstantValueAttribute cva = null;
        ClassFile.AttributeInfo[] ais = fieldInfo.getAttributes();
        for (int i = 0; i < ais.length; ++i) {
            ClassFile.AttributeInfo ai = ais[i];
            if (!(ai instanceof ClassFile.ConstantValueAttribute)) continue;
            cva = (ClassFile.ConstantValueAttribute)ai;
            break;
        }
        Object ocv = null;
        if (cva != null) {
            ClassFile.ConstantPoolInfo cpi = this.classFile.getConstantPoolInfo(cva.getConstantValueIndex());
            if (cpi instanceof ClassFile.ConstantValuePoolInfo) {
                ocv = ((ClassFile.ConstantValuePoolInfo)cpi).getValue(this.classFile);
            } else {
                throw new JaninoRuntimeException("Unexpected constant pool info type \"" + cpi.getClass().getName() + "\"");
            }
        }
        final Object optionalConstantValue = ocv;
        final Access access = ClassFileIClass.accessFlags2Access(fieldInfo.getAccessFlags());
        result = new IClass.IField(){

            public Object getConstantValue() throws CompileException {
                return optionalConstantValue;
            }

            public String getName() {
                return name;
            }

            public IClass getType() throws CompileException {
                return type;
            }

            public boolean isStatic() {
                return (fieldInfo.getAccessFlags() & 8) != 0;
            }

            public Access getAccess() {
                return access;
            }
        };
        this.resolvedFields.put(fieldInfo, result);
        return result;
    }

    private static Access accessFlags2Access(short accessFlags) {
        return (accessFlags & 1) != 0 ? Access.PUBLIC : ((accessFlags & 4) != 0 ? Access.PROTECTED : ((accessFlags & 2) != 0 ? Access.PRIVATE : Access.DEFAULT));
    }
}

