/*
 * Decompiled with CFR 0.152.
 */
package generator;

import generator.BackgroundGenerator;
import java.util.logging.Level;
import java.util.logging.Logger;
import sudoku.DifficultyLevel;
import sudoku.DifficultyType;
import sudoku.GameMode;
import sudoku.Options;
import sudoku.StepConfig;

public class BackgroundGeneratorThread
implements Runnable {
    private static final boolean DEBUG = false;
    private static BackgroundGeneratorThread instance = null;
    private BackgroundGenerator generator;
    private final Thread thread = new Thread(this);
    private boolean newRequest = false;
    private boolean threadStarted = false;

    private BackgroundGeneratorThread() {
        this.generator = new BackgroundGenerator();
    }

    public static BackgroundGeneratorThread getInstance() {
        if (instance == null) {
            instance = new BackgroundGeneratorThread();
        }
        return instance;
    }

    public synchronized String getSudoku(DifficultyLevel level, GameMode mode) {
        String[] puzzles = this.getPuzzleArray(level, mode);
        String newPuzzle = null;
        if (puzzles[0] != null) {
            newPuzzle = puzzles[0];
            for (int i = 1; i < puzzles.length; ++i) {
                puzzles[i - 1] = puzzles[i];
            }
            puzzles[puzzles.length - 1] = null;
        }
        this.startCreation();
        return newPuzzle;
    }

    private synchronized void setSudoku(DifficultyLevel level, GameMode mode, String sudoku) {
        String[] puzzles = this.getPuzzleArray(level, mode);
        for (int i = 0; i < puzzles.length; ++i) {
            if (puzzles[i] != null) continue;
            puzzles[i] = sudoku;
            break;
        }
    }

    public synchronized void resetAll() {
        String[][] puzzles = Options.getInstance().getNormalPuzzles();
        for (int i = 0; i < puzzles.length; ++i) {
            for (int j = 0; j < puzzles[i].length; ++j) {
                puzzles[i][j] = null;
            }
        }
        this.resetTrainingPractising();
    }

    public synchronized void resetTrainingPractising() {
        int i;
        String[] puzzles1 = Options.getInstance().getLearningPuzzles();
        for (i = 0; i < puzzles1.length; ++i) {
            puzzles1[i] = null;
        }
        puzzles1 = Options.getInstance().getPractisingPuzzles();
        for (i = 0; i < puzzles1.length; ++i) {
            puzzles1[i] = null;
        }
        this.startCreation();
    }

    public synchronized void setNewLevel(int newLevel) {
        int maxTrainingLevel = this.getTrainingLevel();
        if (maxTrainingLevel == -1 || newLevel < maxTrainingLevel) {
            return;
        }
        if (newLevel == Options.getInstance().getPractisingPuzzlesLevel()) {
            return;
        }
        String[] puzzles = Options.getInstance().getPractisingPuzzles();
        for (int i = 0; i < puzzles.length; ++i) {
            puzzles[i] = null;
        }
        Options.getInstance().setPractisingPuzzlesLevel(newLevel);
        this.startCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCreation() {
        if (this.thread == null) {
            return;
        }
        if (!this.threadStarted) {
            this.thread.start();
            this.threadStarted = true;
        }
        Thread thread = this.thread;
        synchronized (thread) {
            this.newRequest = true;
            this.thread.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block9: while (!this.thread.isInterrupted()) {
            try {
                Thread thread = this.thread;
                synchronized (thread) {
                    if (!this.newRequest) {
                        this.thread.wait();
                    }
                    if (!this.newRequest) {
                        continue;
                    }
                    this.newRequest = false;
                }
                DifficultyLevel level = null;
                GameMode mode = null;
                while (level == null && !this.thread.isInterrupted()) {
                    String puzzle;
                    BackgroundGeneratorThread backgroundGeneratorThread = this;
                    synchronized (backgroundGeneratorThread) {
                        int i;
                        String[][] puzzles = Options.getInstance().getNormalPuzzles();
                        for (int i2 = 0; i2 < puzzles.length; ++i2) {
                            for (int j = 0; j < puzzles[i2].length; ++j) {
                                if (puzzles[i2][j] != null) continue;
                                level = Options.getInstance().getDifficultyLevel(i2 + 1);
                                mode = GameMode.PLAYING;
                                break;
                            }
                            if (level != null) break;
                        }
                        int trLevel = this.getTrainingLevel();
                        String[] puzzles1 = Options.getInstance().getLearningPuzzles();
                        if (level == null && trLevel != -1) {
                            for (i = 0; i < puzzles1.length; ++i) {
                                if (puzzles1[i] != null) continue;
                                level = Options.getInstance().getDifficultyLevel(DifficultyType.EXTREME.ordinal());
                                mode = GameMode.LEARNING;
                                break;
                            }
                        }
                        if (trLevel != -1 && Options.getInstance().getPractisingPuzzlesLevel() == -1) {
                            this.setNewLevel(Options.getInstance().getActLevel());
                        }
                        puzzles1 = Options.getInstance().getPractisingPuzzles();
                        if (level == null && trLevel != -1 && Options.getInstance().getActLevel() >= trLevel) {
                            for (i = 0; i < puzzles1.length; ++i) {
                                if (puzzles1[i] != null) continue;
                                level = Options.getInstance().getDifficultyLevel(Options.getInstance().getPractisingPuzzlesLevel());
                                mode = GameMode.PRACTISING;
                                break;
                            }
                        }
                    }
                    if (level == null || (puzzle = this.generator.generate(level, mode)) == null) continue block9;
                    this.setSudoku(level, mode, puzzle);
                    level = null;
                    mode = null;
                }
            }
            catch (InterruptedException ex) {
                this.thread.interrupt();
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error checking progress", ex);
            }
        }
    }

    private String[] getPuzzleArray(DifficultyLevel level, GameMode mode) {
        String[] puzzles = null;
        switch (mode) {
            case PLAYING: {
                puzzles = Options.getInstance().getNormalPuzzles()[level.getOrdinal() - 1];
                break;
            }
            case LEARNING: {
                puzzles = Options.getInstance().getLearningPuzzles();
                break;
            }
            case PRACTISING: {
                puzzles = Options.getInstance().getPractisingPuzzles();
            }
        }
        return puzzles;
    }

    private int getTrainingLevel() {
        StepConfig[] conf = Options.getInstance().getOrgSolverSteps();
        int level = -1;
        for (StepConfig act : conf) {
            int actLevel;
            if (!act.isEnabledTraining() || (actLevel = act.getLevel()) <= level) continue;
            level = actLevel;
        }
        return level;
    }
}

