/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JList;
import javax.swing.JPanel;
import sudoku.ListDragAndDropChange;
import sudoku.StepConfig;

public class ListDragAndDrop
implements DragSourceListener,
DropTargetListener,
DragGestureListener {
    private static final DataFlavor stepConfigDataFlavor = new DataFlavor(StepConfig.class, "sudoku.StepConfig");
    private static final DataFlavor[] supportedFlavors = new DataFlavor[]{stepConfigDataFlavor};
    private DragSource dragSource;
    private DropTarget dropTarget;
    private int draggedIndex = -1;
    private StepConfig dropTargetCell;
    private JList list;
    private ListDragAndDropChange panel;
    private JPanel cPanel;

    public ListDragAndDrop(JList list, ListDragAndDropChange panel, JPanel cPanel) {
        this.list = list;
        this.panel = panel;
        this.cPanel = cPanel;
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(list, 2, this);
        this.dropTarget = new DropTarget(list, this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.dropTargetCell = null;
        this.draggedIndex = -1;
        this.panel.setDropLocation(-1, null);
        this.list.repaint();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (dtde.getSource() != this.dropTarget) {
            dtde.rejectDrag();
            this.panel.setDropLocation(-1, null);
        } else {
            dtde.acceptDrag(2);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (dtde.getSource() != this.dropTarget) {
            dtde.rejectDrag();
            this.panel.setDropLocation(-1, null);
            return;
        }
        Point dragPoint = dtde.getLocation();
        int index = this.list.locationToIndex(dragPoint);
        this.dropTargetCell = index == -1 ? null : (StepConfig)this.list.getModel().getElementAt(index);
        this.panel.setDropLocation(index, this.dropTargetCell);
        this.list.repaint();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (dtde.getSource() != this.dropTarget) {
            dtde.rejectDrop();
            this.panel.setDropLocation(-1, null);
            return;
        }
        Point dropPoint = dtde.getLocation();
        int index = this.list.locationToIndex(dropPoint);
        boolean dropped = false;
        if (index == -1 || index == this.draggedIndex) {
            dtde.rejectDrop();
            this.panel.setDropLocation(-1, null);
            return;
        }
        dtde.acceptDrop(2);
        this.panel.setDropLocation(-1, null);
        this.panel.moveStep(this.draggedIndex, index);
        dropped = true;
        dtde.dropComplete(dropped);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Point clickPoint = dge.getDragOrigin();
        int index = this.list.locationToIndex(clickPoint);
        if (index == -1) {
            return;
        }
        StepConfig target = (StepConfig)this.list.getModel().getElementAt(index);
        RJLTransferable trans = new RJLTransferable(target);
        this.draggedIndex = index;
        this.dragSource.startDrag(dge, Cursor.getDefaultCursor(), trans, this);
    }

    class RJLTransferable
    implements Transferable {
        private StepConfig object;

        RJLTransferable(StepConfig object) {
            this.object = object;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(stepConfigDataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(flavor)) {
                return this.object;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

