/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

final class CustomLevelDialog
extends JDialog {
    private int x;
    private int y;
    private JTextField rowsField;
    private JTextField colsField;
    private JTextField minesField;
    private Color fieldColor;

    CustomLevelDialog(MainFrame mainFrame, boolean bl) {
        super(mainFrame, "Custom level", bl);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Height (9...16)");
        JMines.setConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 25, 10, 10, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 16;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.getContentPane().add(jLabel);
        JLabel jLabel2 = new JLabel("Width (9...30)");
        JMines.setConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 25, 5, 10, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this.getContentPane().add(jLabel2);
        JLabel jLabel3 = new JLabel("Mines (10...99)");
        JMines.setConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 25, 5, 10, 10, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        this.getContentPane().add(jLabel3);
        LevelInputVerifier levelInputVerifier = new LevelInputVerifier();
        this.rowsField = new JTextField(String.valueOf(JMines.getConfig().read("game.custom.rows", JMines.getGamePanel().getRows())));
        this.rowsField.setHorizontalAlignment(4);
        this.rowsField.setInputVerifier(levelInputVerifier);
        JMines.setConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0, 10, 5, 5, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagLayout.setConstraints(this.rowsField, gridBagConstraints);
        this.getContentPane().add(this.rowsField);
        this.colsField = new JTextField(String.valueOf(JMines.getConfig().read("game.custom.cols", JMines.getGamePanel().getCols())));
        this.colsField.setHorizontalAlignment(4);
        this.colsField.setInputVerifier(levelInputVerifier);
        JMines.setConstraints(gridBagConstraints, 1, 1, 1, 1, 0, 0, 5, 5, 5, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.colsField, gridBagConstraints);
        this.getContentPane().add(this.colsField);
        this.minesField = new JTextField(String.valueOf(JMines.getConfig().read("game.custom.mines", JMines.getGamePanel().getMines())));
        this.minesField.setHorizontalAlignment(4);
        this.minesField.setInputVerifier(levelInputVerifier);
        JMines.setConstraints(gridBagConstraints, 1, 2, 1, 1, 0, 0, 5, 5, 10, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagLayout.setConstraints(this.minesField, gridBagConstraints);
        this.getContentPane().add(this.minesField);
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMines.getConfig().write("game.custom.rows", Integer.parseInt(CustomLevelDialog.this.rowsField.getText()));
                JMines.getConfig().write("game.custom.cols", Integer.parseInt(CustomLevelDialog.this.colsField.getText()));
                JMines.getConfig().write("game.custom.mines", Integer.parseInt(CustomLevelDialog.this.minesField.getText()));
                JMines.setLevel(3);
                JMines.startNewGame();
                CustomLevelDialog.this.writeLocation();
                CustomLevelDialog.this.setVisible(false);
            }
        });
        JMines.setConstraints(gridBagConstraints, 0, 3, 1, 1, 0, 25, 0, 10, 10, 10);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 16;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.getContentPane().add(jButton);
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomLevelDialog.this.writeLocation();
                CustomLevelDialog.this.setVisible(false);
            }
        });
        JMines.setConstraints(gridBagConstraints, 1, 3, 1, 1, 0, 0, 0, 10, 10, 10);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 14;
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        this.getContentPane().add(jButton2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CustomLevelDialog.this.writeLocation();
            }

            public void windowActivated(WindowEvent windowEvent) {
                CustomLevelDialog.this.rowsField.setText(String.valueOf(JMines.getConfig().read("game.custom.rows", JMines.getGamePanel().getRows())));
                CustomLevelDialog.this.colsField.setText(String.valueOf(JMines.getConfig().read("game.custom.cols", JMines.getGamePanel().getCols())));
                CustomLevelDialog.this.minesField.setText(String.valueOf(JMines.getConfig().read("game.custom.mines", JMines.getGamePanel().getMines())));
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                CustomLevelDialog.this.x = CustomLevelDialog.this.getX();
                CustomLevelDialog.this.y = CustomLevelDialog.this.getY();
            }
        });
        this.fieldColor = this.rowsField.getBackground();
        this.setResizable(false);
        this.readLocation();
        this.setLocation(this.x, this.y);
        this.pack();
    }

    private void writeLocation() {
        JMines.getConfig().write("level.dialog.xpos", this.x);
        JMines.getConfig().write("level.dialog.ypos", this.y);
    }

    private void readLocation() {
        this.x = JMines.getConfig().read("level.dialog.xpos", this.x);
        this.y = JMines.getConfig().read("level.dialog.ypos", this.y);
    }

    class LevelInputVerifier
    extends InputVerifier {
        LevelInputVerifier() {
        }

        public boolean shouldYieldFocus(JComponent jComponent) {
            if (this.verify(jComponent)) {
                jComponent.setBackground(CustomLevelDialog.this.fieldColor);
                return true;
            }
            Toolkit.getDefaultToolkit().beep();
            jComponent.setBackground(Color.red);
            return false;
        }

        public boolean verify(JComponent jComponent) {
            if (jComponent == CustomLevelDialog.this.rowsField) {
                return this.checkRowsField();
            }
            if (jComponent == CustomLevelDialog.this.colsField) {
                return this.checkColsField();
            }
            if (jComponent == CustomLevelDialog.this.minesField) {
                return this.checkMinesField();
            }
            return true;
        }

        private boolean checkRowsField() {
            int n;
            boolean bl = true;
            try {
                n = Integer.parseInt(CustomLevelDialog.this.rowsField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n < 9 || n > 16) {
                bl = false;
            }
            return bl;
        }

        private boolean checkColsField() {
            int n;
            boolean bl = true;
            try {
                n = Integer.parseInt(CustomLevelDialog.this.colsField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n < 9 || n > 30) {
                bl = false;
            }
            return bl;
        }

        private boolean checkMinesField() {
            int n;
            boolean bl = true;
            try {
                n = Integer.parseInt(CustomLevelDialog.this.minesField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            int n2 = Integer.parseInt(CustomLevelDialog.this.rowsField.getText()) * Integer.parseInt(CustomLevelDialog.this.colsField.getText());
            if (n < 10 || n > 99 || n > n2) {
                bl = false;
            }
            return bl;
        }
    }
}

