/*
 * Decompiled with CFR 0.152.
 */
package puzzle.edge;

import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import puzzle.edge.AbstractEdgeProducer;
import puzzle.storeage.JigsawPuzzleException;

public class ModernEdgeProducer
extends AbstractEdgeProducer {
    private int startDegree = 130;
    private int endDegree = 410;
    private int walks = -1;
    private static final int STEP = 10;

    @Override
    public void _init() {
        this.randomDegrees();
        this.actualPoints = new Point[2 + this.walks];
    }

    @Override
    public void produce() throws JigsawPuzzleException {
        int n;
        this.produceBaseline();
        this.produceCircle();
        this.recalculate();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(this.actualPoints[0].x, this.actualPoints[0].y);
        for (n = 1; n < this.actualPoints.length; ++n) {
            generalPath.lineTo(this.actualPoints[n].x, this.actualPoints[n].y);
        }
        n = this.actualPoints.length;
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(this.actualPoints[n - 1].x, this.actualPoints[n - 1].y);
        for (int i = n - 1; i >= 0; --i) {
            generalPath2.lineTo(this.actualPoints[i].x, this.actualPoints[i].y);
        }
        generalPath2.transform(AffineTransform.getRotateInstance(Math.toRadians(180.0), 0.0, 0.0));
        this.twoShapes = new Shape[2];
        this.twoShapes[0] = generalPath;
        this.twoShapes[1] = generalPath2;
    }

    private void randomDegrees() {
        this.startDegree = ModernEdgeProducer.randomlyGenerateDeviationAbs(this.startDegree, 2);
        this.endDegree = ModernEdgeProducer.randomlyGenerateDeviationAbs(this.endDegree, 2);
        this.walks = (this.endDegree - this.startDegree) / 10;
    }

    private void produceBaseline() {
        int n = this.sideLength / 2;
        this.actualPoints[0] = new Point(-n, 0);
        int n2 = this.actualPoints.length - 1;
        this.actualPoints[n2] = new Point(n, 0);
    }

    private void produceCircle() {
        int n = this.generateRandomNumberAround();
        int n2 = this.generateRandomNumberAround();
        int n3 = 0;
        int n4 = ModernEdgeProducer.randomlyGenerateDeviation(this.sideLength / 10, 50);
        int n5 = this.startDegree;
        while (n3 < this.walks) {
            double d = Math.toRadians(n5);
            int n6 = (int)(Math.cos(d) * (double)n);
            int n7 = (int)(Math.sin(d) * (double)n2);
            this.actualPoints[++n3] = new Point(n6, n7 -= n4);
            n5 += 10;
        }
    }

    private int generateRandomNumberAround() {
        int n = this.sideLength / 5;
        int n2 = (int)Math.round((double)n / 3.0);
        int n3 = rand.nextInt(n2 + 1);
        return n - n3;
    }

    public static int randomlyGenerateDeviation(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        boolean bl = rand.nextBoolean();
        double d = (double)rand.nextInt(n2 + 1) / 100.0;
        double d2 = bl ? 1.0 + d : 1.0 - d;
        return (int)Math.round(d2 * (double)n);
    }

    public static int randomlyGenerateDeviationAbs(int n, int n2) {
        int n3 = rand.nextInt(n2 * 2 + 1);
        return n + (n3 -= n2);
    }
}

