/*
 * Decompiled with CFR 0.152.
 */
package puzzle.edge;

import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import puzzle.edge.AbstractEdgeProducer;
import puzzle.storeage.JigsawPuzzleException;

public class StandardEdgeProducer
extends AbstractEdgeProducer {
    private float alphaLeft;
    private float alphaRight;
    private int neckGap;
    private int minimumSpaceFromVertex;

    @Override
    public void _init() {
        this.neckGap = (int)((double)this.sideLength / 2.5);
        this.actualPoints = new Point[12];
        this.minimumSpaceFromVertex = this.sideLength / 4;
    }

    @Override
    public void produce() throws JigsawPuzzleException {
        this.actualPoints[0] = new Point(-this.sideLength / 2, 0);
        this.actualPoints[11] = new Point(this.sideLength / 2, 0);
        this.generateRandomAlphas();
        this.produceBaseline();
        this.produceNeck();
        this.produceBubble();
        this.recalculate();
        this.generateShapes();
    }

    private void produceBaseline() throws JigsawPuzzleException {
        int n;
        int n2 = 0;
        int n3 = this.sideLength - this.neckGap - 2 * this.minimumSpaceFromVertex;
        int n4 = rand.nextInt(n3);
        int n5 = 2 * this.minimumSpaceFromVertex + n4 + (n = n3 - n4) + this.neckGap;
        if (n5 != this.sideLength) {
            throw new JigsawPuzzleException("inner logic is incorrect");
        }
        n5 = this.actualPoints[0].x + this.minimumSpaceFromVertex + n4;
        int n6 = this.actualPoints[11].x - this.minimumSpaceFromVertex - n;
        this.actualPoints[1] = new Point(n5, n2);
        this.actualPoints[10] = new Point(n6, n2);
    }

    private void produceNeck() {
        int n = this.sideLength / 20 * 3;
        int n2 = this.actualPoints[1].x + n;
        int n3 = this.actualPoints[10].x - n;
        int n4 = Math.round(this.alphaLeft);
        int n5 = Math.round(this.alphaRight);
        this.actualPoints[2] = new Point(n2, n4);
        this.actualPoints[9] = new Point(n3, n5);
    }

    private void produceBubble() throws JigsawPuzzleException {
        int n = Math.round(2.0f * this.alphaLeft);
        int n2 = Math.round(2.0f * this.alphaRight);
        int n3 = this.actualPoints[1].x - this.actualPoints[2].x;
        if (n3 > 0) {
            throw new JigsawPuzzleException("Must not be bigger than zero!");
        }
        int n4 = this.actualPoints[10].x - this.actualPoints[9].x;
        if (n4 < 0) {
            throw new JigsawPuzzleException("Must not be smaller than 0!");
        }
        this.actualPoints[3] = new Point(n3, n);
        this.actualPoints[8] = new Point(n4, n2);
        int n5 = Math.round(3.0f * this.alphaLeft);
        int n6 = Math.round(3.0f * this.alphaRight);
        float f = ((float)this.actualPoints[3].y - (float)this.actualPoints[2].y) / ((float)this.actualPoints[3].x - (float)this.actualPoints[2].x);
        float f2 = (float)this.actualPoints[3].y - f * (float)this.actualPoints[3].x;
        float f3 = ((float)this.actualPoints[10].y - (float)this.actualPoints[9].y) / ((float)this.actualPoints[10].x - (float)this.actualPoints[9].x);
        float f4 = (float)this.actualPoints[10].y - f3 * (float)this.actualPoints[10].x;
        int n7 = Math.round(((float)n5 - f2) / f);
        int n8 = Math.round(((float)n6 - f4) / f3);
        this.actualPoints[4] = new Point(n7, n5);
        this.actualPoints[7] = new Point(-n8, n6);
        int n9 = Math.round(4.0f * this.alphaLeft);
        int n10 = Math.round(4.0f * this.alphaRight);
        int n11 = this.actualPoints[2].x + this.sideLength / 20;
        int n12 = this.actualPoints[9].x + this.sideLength / 20;
        this.actualPoints[5] = new Point(n11, n9);
        this.actualPoints[6] = new Point(n12, n10);
    }

    private void generateRandomAlphas() {
        this.alphaRight = (float)(-1 * this.sideLength / 10) * (rand.nextFloat() / 2.0f + 0.8f);
        float f = (float)(this.sideLength / 10) * 1.3f;
        float f2 = 4.0f * this.alphaRight;
        boolean bl = rand.nextBoolean();
        float f3 = f + this.alphaRight;
        if (f3 < 1.0f) {
            f3 *= 10.0f;
        }
        if (f3 < 1.0f) {
            this.alphaLeft = this.alphaRight;
        } else {
            int n = rand.nextInt((int)f3);
            float f4 = n / 10;
            this.alphaLeft = bl ? (f2 + f4) / 4.0f : (f2 - f4) / 4.0f;
        }
    }

    private void generateShapes() {
        this.twoShapes = new Shape[2];
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(this.actualPoints[0].x, this.actualPoints[0].y);
        generalPath.lineTo(this.actualPoints[1].x, this.actualPoints[1].y);
        generalPath.quadTo(this.actualPoints[2].x, this.actualPoints[2].y, this.actualPoints[3].x, this.actualPoints[3].y);
        generalPath.quadTo(this.actualPoints[4].x, this.actualPoints[4].y, this.actualPoints[5].x, this.actualPoints[5].y);
        generalPath.lineTo(this.actualPoints[6].x, this.actualPoints[6].y);
        generalPath.quadTo(this.actualPoints[7].x, this.actualPoints[7].y, this.actualPoints[8].x, this.actualPoints[8].y);
        generalPath.quadTo(this.actualPoints[9].x, this.actualPoints[9].y, this.actualPoints[10].x, this.actualPoints[10].y);
        generalPath.lineTo(this.actualPoints[11].x, this.actualPoints[11].y);
        this.twoShapes[0] = generalPath;
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(this.actualPoints[11].x, this.actualPoints[11].y);
        generalPath2.lineTo(this.actualPoints[10].x, this.actualPoints[10].y);
        generalPath2.quadTo(this.actualPoints[9].x, this.actualPoints[9].y, this.actualPoints[8].x, this.actualPoints[8].y);
        generalPath2.quadTo(this.actualPoints[7].x, this.actualPoints[7].y, this.actualPoints[6].x, this.actualPoints[6].y);
        generalPath2.lineTo(this.actualPoints[5].x, this.actualPoints[5].y);
        generalPath2.quadTo(this.actualPoints[4].x, this.actualPoints[4].y, this.actualPoints[3].x, this.actualPoints[3].y);
        generalPath2.quadTo(this.actualPoints[2].x, this.actualPoints[2].y, this.actualPoints[1].x, this.actualPoints[1].y);
        generalPath2.lineTo(this.actualPoints[0].x, this.actualPoints[0].y);
        generalPath2.transform(AffineTransform.getRotateInstance(Math.toRadians(180.0), 0.0, 0.0));
        this.twoShapes[1] = generalPath2;
    }
}

