/*
 * Decompiled with CFR 0.152.
 */
package puzzle.pieces;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import puzzle.Offset;
import puzzle.edge.Edge;
import puzzle.pieces.PuzzlePiece;
import puzzle.pieces.ShapeUtil;
import puzzle.pieces.SinglePiece;
import puzzle.storeage.JigsawPuzzleException;
import puzzle.storeage.LoadGameException;
import puzzle.storeage.SaveGameException;
import puzzle.storeage.StorageUtil;

public class MultiPiece
extends PuzzlePiece {
    private static final Logger logger = Logger.getLogger(MultiPiece.class);
    private List<SinglePiece> singlePieces;
    final double[] passVariable = new double[6];

    public MultiPiece(SinglePiece singlePiece, SinglePiece singlePiece2) throws JigsawPuzzleException {
        if (singlePiece == null || singlePiece2 == null) {
            throw new JigsawPuzzleException("one piece null");
        }
        this.singlePieces = new Vector<SinglePiece>();
        this.edges = new ArrayList();
        this.addSinglePiece(singlePiece);
        this.addSinglePiece(singlePiece2);
    }

    public MultiPiece() {
        this.singlePieces = new Vector<SinglePiece>();
        this.edges = new ArrayList();
        this.puzzleShape = new Area();
    }

    @Override
    public boolean isHit(Point point) {
        for (SinglePiece singlePiece : this.singlePieces) {
            if (!singlePiece.isHit(point)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void renderFaceInClip(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        for (SinglePiece singlePiece : this.singlePieces) {
            singlePiece.renderFaceInClip(graphics2D, rectangle);
        }
    }

    @Override
    public List<Edge> getEdges(Edge.Type type) {
        List<Edge> list = this.getEdges();
        Vector<Edge> vector = new Vector<Edge>();
        for (Edge edge : list) {
            if (edge.getType() != type) continue;
            vector.add(edge);
        }
        return vector;
    }

    @Override
    public int getPieceCount() {
        return this.singlePieces.size();
    }

    protected Point[] getPoints(Shape shape) throws JigsawPuzzleException {
        Point point = null;
        Point point2 = null;
        PathIterator pathIterator = shape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(this.passVariable);
            if (n == 0) {
                if (point != null) {
                    throw new JigsawPuzzleException("this path has more than one moveTo");
                }
                point = new Point((int)this.passVariable[0], (int)this.passVariable[1]);
            } else if (n == 1) {
                point2 = new Point((int)this.passVariable[0], (int)this.passVariable[1]);
            }
            pathIterator.next();
        }
        if (point == null) {
            throw new JigsawPuzzleException("did not find the first point!");
        }
        if (point2 == null) {
            throw new JigsawPuzzleException("did not find the last point!");
        }
        return new Point[]{point, point2};
    }

    @Override
    protected void buildShape() throws JigsawPuzzleException {
        logger.info("buildShape - advanced version");
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        Area area = new Area();
        ArrayList<Edge> arrayList2 = new ArrayList<Edge>();
        arrayList2.addAll(this.getOpenEdges());
        while (arrayList2.size() != 0) {
            logger.debug("going to find an outline");
            Edge edge = (Edge)arrayList2.get(0);
            arrayList.add(edge.getShape());
            arrayList2.remove(edge);
            Point[] pointArray = this.getPoints(edge.getShape());
            Point point = pointArray[1];
            Point point2 = pointArray[0];
            boolean bl = false;
            block1: while (!bl) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    boolean bl2;
                    boolean bl3;
                    Edge edge2 = (Edge)arrayList2.get(i);
                    Point[] pointArray2 = this.getPoints(edge2.getShape());
                    Edge.Type type = edge.getType();
                    Edge.Type type2 = edge2.getType();
                    boolean bl4 = type == Edge.Type.RIGHT && type2 == Edge.Type.LEFT;
                    boolean bl5 = type == Edge.Type.LEFT && type2 == Edge.Type.RIGHT;
                    boolean bl6 = type == Edge.Type.TOP && type2 == Edge.Type.BOTTOM;
                    boolean bl7 = bl3 = type == Edge.Type.BOTTOM && type2 == Edge.Type.TOP;
                    if (bl4 || bl5 || bl6 || bl3) {
                        logger.debug("tried to connect LEFT-RIGHT or TOP-BOTTOM that's invalid");
                        continue;
                    }
                    boolean bl8 = point.equals(pointArray2[0]);
                    if (!(bl8 ^ (bl2 = point.equals(pointArray2[1])))) continue;
                    if (bl8) {
                        point = pointArray2[1];
                        arrayList.add(edge2.getShape());
                    } else if (bl2) {
                        point = pointArray2[0];
                        Shape shape = ShapeUtil.createReversed(edge2.getShape());
                        arrayList.add(shape);
                    }
                    logger.debug("found following pair current:" + edge.toString() + ", next:" + edge2.toString());
                    if (point2.equals(pointArray2[1]) || point2.equals(pointArray2[0])) {
                        logger.info("found the endpoint - one shape is done!");
                        bl = true;
                    }
                    arrayList2.remove(edge2);
                    edge = edge2;
                    continue block1;
                }
            }
            GeneralPath generalPath = new GeneralPath();
            for (int i = 0; i < arrayList.size(); ++i) {
                generalPath.append((Shape)arrayList.get(i), true);
            }
            arrayList.clear();
            area.exclusiveOr(new Area(generalPath));
        }
        this.puzzleShape = area;
        logger.info("end buildShape - advanced version");
    }

    protected void buildShape2() throws JigsawPuzzleException {
        logger.info("buildShape - simple version");
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        ArrayList<Edge> arrayList2 = new ArrayList<Edge>();
        arrayList2.addAll(this.getOpenEdges());
        Edge edge = (Edge)arrayList2.get(0);
        arrayList.add(edge.getShape());
        arrayList2.remove(edge);
        Point point = this.getPoints(edge.getShape())[1];
        block0: while (arrayList2.size() != 0) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                boolean bl;
                Edge edge2 = (Edge)arrayList2.get(i);
                Point[] pointArray = this.getPoints(edge2.getShape());
                boolean bl2 = point.equals(pointArray[0]);
                if (!(bl2 ^ (bl = point.equals(pointArray[1])))) continue;
                if (bl2) {
                    point = pointArray[1];
                    arrayList.add(edge2.getShape());
                } else if (bl) {
                    point = pointArray[0];
                    Shape shape = ShapeUtil.createReversed(edge2.getShape());
                    arrayList.add(shape);
                }
                arrayList2.remove(edge2);
                edge = edge2;
                continue block0;
            }
        }
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < arrayList.size(); ++i) {
            generalPath.append((Shape)arrayList.get(i), true);
        }
        this.puzzleShape = generalPath;
    }

    protected void buildShape_2() throws JigsawPuzzleException {
        GeneralPath generalPath = new GeneralPath();
        int n = 0;
        for (Edge edge : this.getOpenEdges()) {
            ++n;
            logger.info("openEdges: " + (Object)((Object)edge.getType()));
            generalPath.append(edge.getShape(), true);
        }
        this.puzzleShape = generalPath;
    }

    @Override
    public void move(Offset offset) {
        for (SinglePiece singlePiece : this.singlePieces) {
            singlePiece.move(offset);
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(offset.getX(), offset.getY());
        this.puzzleShape = affineTransform.createTransformedShape(this.puzzleShape);
    }

    private List<SinglePiece> getSinglePieces() {
        return this.singlePieces;
    }

    private void addSinglePiece(SinglePiece singlePiece) {
        this.singlePieces.add(singlePiece);
        this.edges.addAll(singlePiece.getEdges());
    }

    public void addPiece(PuzzlePiece puzzlePiece) throws JigsawPuzzleException {
        if (puzzlePiece instanceof SinglePiece) {
            this.addSinglePiece((SinglePiece)puzzlePiece);
        } else if (puzzlePiece instanceof MultiPiece) {
            for (SinglePiece singlePiece : ((MultiPiece)puzzlePiece).getSinglePieces()) {
                this.addSinglePiece(singlePiece);
            }
        }
        this.buildShape();
    }

    @Override
    public boolean isWithinRectangle(Rectangle rectangle) {
        for (SinglePiece singlePiece : this.singlePieces) {
            if (!singlePiece.isWithinRectangle(rectangle)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Rectangle getBoundingRectangle() throws JigsawPuzzleException {
        Rectangle rectangle = this.getShape().getBounds();
        return new Rectangle(rectangle.x - 5, rectangle.y - 5, rectangle.width + 10, rectangle.height + 10);
    }

    @Override
    public void turnDegrees(Point point, int n) {
        for (SinglePiece singlePiece : this.singlePieces) {
            singlePiece.turnDegrees(point, n);
        }
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(n), point.x, point.y);
        this.puzzleShape = affineTransform.createTransformedShape(this.puzzleShape);
    }

    @Override
    public void restore(Node node) throws LoadGameException {
        Node node2 = StorageUtil.findDirectChildNode(node, "MultiPiece");
        NodeList nodeList = node2.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node3 = nodeList.item(i);
            if (!node3.getNodeName().equals("MP-SP")) {
                throw new LoadGameException("irregular xml format");
            }
            SinglePiece singlePiece = new SinglePiece();
            singlePiece.restore(node3);
            this.addSinglePiece(singlePiece);
        }
        try {
            this.buildShape();
        }
        catch (JigsawPuzzleException jigsawPuzzleException) {
            logger.error("could not buildShape: " + jigsawPuzzleException.toString());
            throw new LoadGameException(jigsawPuzzleException);
        }
    }

    @Override
    public void store(Node node) throws SaveGameException {
        Document document = node.getOwnerDocument();
        Element element = document.createElement("MultiPiece");
        for (SinglePiece singlePiece : this.singlePieces) {
            Element element2 = document.createElement("MP-SP");
            singlePiece.store(element2);
            element.appendChild(element2);
        }
        node.appendChild(element);
    }
}

