/*
 * Decompiled with CFR 0.152.
 */
package datarep.common;

import datarep.common.CloseListener;
import java.awt.Button;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class GroupBoxPanel
extends Container
implements AdjustmentListener {
    String text = "";
    Insets insets = new Insets(0, 0, 0, 0);

    public GroupBoxPanel() {
        this("", new FlowLayout());
    }

    public GroupBoxPanel(String string) {
        this(string, new FlowLayout());
    }

    public GroupBoxPanel(String string, LayoutManager layoutManager) {
        this.setLayout(layoutManager);
        this.setText(string);
    }

    public void setText(String string) {
        if (string != null) {
            this.text = string;
            return;
        }
        this.text = "";
    }

    public String getText() {
        return this.text;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getFont() == null) {
            return dimension;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics.stringWidth(this.text) + 20 > dimension.width) {
            dimension.width = fontMetrics.stringWidth(this.text) + 20;
        }
        return dimension;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getAscent();
        int n2 = this.text.equals("") ? 0 : fontMetrics.stringWidth(this.text) + 4;
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(2, 2 + n * 3 / 5, 8, 2 + n * 3 / 5);
        graphics.drawLine(8 + n2, 2 + n * 3 / 5, dimension.width - 3, 2 + n * 3 / 5);
        graphics.drawLine(2, 2 + n * 3 / 5, 2, dimension.height - 3);
        graphics.drawLine(dimension.width - 1, 1 + n * 3 / 5, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(1, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(1, 1 + n * 3 / 5, 8, 1 + n * 3 / 5);
        graphics.drawLine(8 + n2, 1 + n * 3 / 5, dimension.width - 2, 1 + n * 3 / 5);
        graphics.drawLine(1, 1 + n * 3 / 5, 1, dimension.height - 2);
        graphics.drawLine(dimension.width - 2, 2 + n * 3 / 5, dimension.width - 2, dimension.height - 2);
        graphics.drawLine(2, dimension.height - 2, dimension.width - 2, dimension.height - 2);
        if (!this.text.equals("")) {
            graphics.setColor(this.getForeground());
            graphics.drawString(this.text, 10, 1 + n);
        }
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void addNotify() {
        super.addNotify();
        try {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.stringWidth("n");
            this.insets = new Insets(fontMetrics.getHeight() + 1, n, n, n);
            Container container = this;
            while (container != null) {
                if (!((container = container.getParent()) instanceof ScrollPane)) continue;
                ((ScrollPane)container).getHAdjustable().addAdjustmentListener(this);
                ((ScrollPane)container).getVAdjustable().addAdjustmentListener(this);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void removeNotify() {
        try {
            Container container = this;
            while (container != null) {
                if (!((container = container.getParent()) instanceof ScrollPane)) continue;
                ((ScrollPane)container).getHAdjustable().removeAdjustmentListener(this);
                ((ScrollPane)container).getVAdjustable().removeAdjustmentListener(this);
            }
        }
        catch (Exception exception) {}
        super.removeNotify();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.repaint();
    }

    public void validate() {
        super.validate();
        try {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.stringWidth("n");
            this.insets = new Insets(fontMetrics.getHeight() + n, n, n, n);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Test program for GroupBoxPanel");
        GroupBoxPanel groupBoxPanel = new GroupBoxPanel("Test");
        frame.add(groupBoxPanel);
        groupBoxPanel.setBackground(SystemColor.control);
        groupBoxPanel.add(new Button("Button"));
        frame.pack();
        frame.show();
        frame.addWindowListener(new CloseListener());
    }
}

