/*
 * Decompiled with CFR 0.152.
 */
package org.demarchi.jpeces.principal;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.demarchi.jpeces.comuns.Configuracio;
import org.demarchi.jpeces.comuns.Constants;
import org.demarchi.jpeces.principal.DadesFigura;
import org.demarchi.jpeces.principal.iconesArbreFigures;

public class ArbreFigures
extends JPanel
implements Constants,
TreeSelectionListener {
    private JTree Arbre;
    private DefaultTreeModel treeModel;
    public DefaultMutableTreeNode nodeArrel;
    public static final String CANVI_DE_FIGURA = "canvi_figura";
    public DadesFigura obj_dadesFigura;
    private Hashtable nomsFiguresTraduccio;
    private static ResourceBundle i18n = null;

    public ArbreFigures() {
        super(new GridLayout(1, 0));
        this.setSize(new Dimension(290, 550));
        this.setPreferredSize(new Dimension(290, 550));
        this.setMinimumSize(this.getPreferredSize());
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setOpaque(true);
        this.setVisible(true);
        if (i18n == null) {
            i18n = ResourceBundle.getBundle("org.demarchi.jpeces.locales.figures");
        }
        this.nodeArrel = new DefaultMutableTreeNode(new DadesFigura(i18n.getString("Figures"), null, 1, 1, false));
        this.firePropertyChange(CANVI_DE_FIGURA, false, false);
        this.nomsFiguresTraduccio = new Hashtable();
        this.construeix(this.nodeArrel);
    }

    private void construeix(DefaultMutableTreeNode nodeArrel) {
        this.treeModel = new DefaultTreeModel(nodeArrel);
        this.Arbre = new JTree(this.treeModel);
        this.Arbre.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.Arbre);
        this.Arbre.setCellRenderer(new iconesArbreFigures(1));
        this.Arbre.addTreeSelectionListener(this);
        JScrollPane treeView = new JScrollPane(this.Arbre);
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(treeView);
        this.add(splitPane);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode nus = (DefaultMutableTreeNode)this.Arbre.getLastSelectedPathComponent();
        if (nus == null) {
            return;
        }
        if (nus.isLeaf()) {
            this.obj_dadesFigura = (DadesFigura)nus.getUserObject();
            this.firePropertyChange(CANVI_DE_FIGURA, false, true);
        } else {
            this.firePropertyChange(CANVI_DE_FIGURA, true, false);
        }
    }

    public void construeix(RootPaneContainer contenidorArrel) {
        Container contenidor = contenidorArrel.getContentPane();
        contenidor.add(this);
    }

    private void creaNusos(DefaultMutableTreeNode nodeArrel, URL urlArxiu, Configuracio confApp, String nomArxiu) {
        DefaultMutableTreeNode nusFigura = null;
        this.nomsFiguresTraduccio.clear();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(urlArxiu.openStream()));
            try {
                while (true) {
                    String strNivell;
                    String nomFigura;
                    boolean bl = (nomFigura = br.readLine()) != null;
                    String str_dadesFigura = br.readLine();
                    if (!(bl & str_dadesFigura != null & (strNivell = br.readLine()) != null)) break;
                    Integer intPosDarrerPunt = nomFigura.lastIndexOf(".");
                    if (intPosDarrerPunt <= 0) {
                        intPosDarrerPunt = nomFigura.length();
                    }
                    Integer numFigura = this.nomsFiguresTraduccio.containsKey(nomFigura.substring(0, intPosDarrerPunt)) ? (Integer)this.nomsFiguresTraduccio.get(nomFigura.substring(0, intPosDarrerPunt)) : Integer.valueOf(1);
                    this.nomsFiguresTraduccio.put(nomFigura.substring(0, intPosDarrerPunt), numFigura + 1);
                    String cadena = numFigura.toString();
                    while (cadena.length() < 4) {
                        cadena = " " + cadena;
                    }
                    try {
                        nomFigura = i18n.getString(nomFigura.substring(0, intPosDarrerPunt));
                    }
                    catch (MissingResourceException ex) {
                        nomFigura = nomFigura.substring(0, intPosDarrerPunt);
                    }
                    nomFigura = nomFigura + cadena;
                    StringTokenizer st = new StringTokenizer(strNivell);
                    int nivell = Integer.parseInt(st.nextToken());
                    int dificultat = Integer.parseInt(st.nextToken());
                    int composta = strNivell.length() > 4 ? Integer.parseInt(st.nextToken()) : 0;
                    if (nivell > confApp.configuracioJoc.nivellJoc && confApp.configuracioJoc.nivellJoc != 3 || composta == 1 && confApp.configuracioJoc.nivellJoc == 4) continue;
                    nusFigura = new DefaultMutableTreeNode(new DadesFigura(nomFigura, str_dadesFigura, nivell, dificultat, confApp.configuracioJoc.comprovaFiguraResolta(nomFigura) > -1));
                    nodeArrel.insert(nusFigura, this.ordreNodes(nomFigura));
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            br.close();
        }
        catch (IOException ex) {
            confApp.configuracioJoc.origenDades = 2;
            this.llegeixArxiu(2, nomArxiu, confApp);
        }
    }

    private int ordreNodes(String nomFigura) {
        int index = -1;
        for (int i = 0; i <= this.treeModel.getChildCount(this.nodeArrel) - 1; ++i) {
            DefaultMutableTreeNode nus = (DefaultMutableTreeNode)this.treeModel.getChild(this.nodeArrel, i);
            DadesFigura objDadesFig = (DadesFigura)nus.getUserObject();
            if (!(objDadesFig.nomFigura.compareToIgnoreCase(nomFigura) > 0 & index == -1)) continue;
            index = i;
        }
        if (index == -1) {
            index = this.treeModel.getChildCount(this.nodeArrel);
        }
        return index;
    }

    public void llegeixArxiu(int tipus, String nomArxiu, Configuracio confApp) {
        if (nomArxiu != null) {
            this.nodeArrel.removeAllChildren();
            switch (tipus) {
                case 1: {
                    try {
                        File arxiu = confApp.directoriArxiusFiguresPersonals == null ? null : new File(confApp.directoriArxiusFiguresPersonals + System.getProperty("file.separator") + confApp.configuracioJoc.arxiuDadesFigures);
                        URI nomArxiuURI = arxiu.toURI();
                        this.creaNusos(this.nodeArrel, nomArxiuURI.toURL(), confApp, nomArxiu);
                    }
                    catch (IOException ex) {
                        confApp.configuracioJoc.origenDades = 2;
                        this.llegeixArxiu(2, nomArxiu, confApp);
                        ex.printStackTrace();
                    }
                    break;
                }
                case 2: {
                    URL url = ArbreFigures.class.getResource("/org/demarchi/jpeces/fig/" + nomArxiu);
                    this.creaNusos(this.nodeArrel, url, confApp, nomArxiu);
                    break;
                }
                case 3: {
                    try {
                        File arxiu = nomArxiu == null ? null : new File(nomArxiu);
                        URI nomArxiuURI = arxiu.toURI();
                        this.creaNusos(this.nodeArrel, nomArxiuURI.toURL(), confApp, nomArxiu);
                        break;
                    }
                    catch (IOException ex) {
                        confApp.configuracioJoc.origenDades = 2;
                        this.llegeixArxiu(2, nomArxiu, confApp);
                        ex.printStackTrace();
                    }
                }
            }
        }
        this.actualitzaNodeArrel(confApp);
    }

    public void actualitzaNodeArrel(Configuracio confApp) {
        this.nodeArrel.setUserObject(new DadesFigura(i18n.getString(confApp.configuracioJoc.nomJocArbreFigures) + " (" + this.treeModel.getChildCount(this.nodeArrel) + "). " + i18n.getString(confApp.configuracioJoc.nomNivellArbreFigures), null, 1, 1, false));
        this.treeModel.reload();
    }

    public int numeroDeFigures() {
        return this.treeModel.getChildCount(this.nodeArrel);
    }

    public String figuraResolta(boolean resolta) {
        DefaultMutableTreeNode nus = (DefaultMutableTreeNode)this.Arbre.getLastSelectedPathComponent();
        if (nus == null) {
            return null;
        }
        if (nus.isLeaf()) {
            DadesFigura objDadesFig = (DadesFigura)nus.getUserObject();
            objDadesFig.figuraResolta = resolta;
            nus.setUserObject(objDadesFig);
            return objDadesFig.nomFigura;
        }
        return null;
    }

    public boolean buscaNomFigura(String nomFigura) {
        boolean resultat = false;
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (int i = 0; i <= this.treeModel.getChildCount(this.nodeArrel) - 1; ++i) {
            DefaultMutableTreeNode nus = (DefaultMutableTreeNode)this.treeModel.getChild(this.nodeArrel, i);
            DadesFigura objDadesFig = (DadesFigura)nus.getUserObject();
            if (objDadesFig.nomFigura.equalsIgnoreCase(nomFigura)) {
                this.Arbre.setSelectionRow(i + 1);
                this.Arbre.scrollRowToVisible(i + 1);
                resultat = true;
                break;
            }
            if (!objDadesFig.nomFigura.contains(nomFigura)) continue;
            this.Arbre.setSelectionRow(i + 1);
            this.Arbre.scrollRowToVisible(i + 1);
            resultat = true;
            break;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        return resultat;
    }

    public void seleccionaFiguraAtzar() {
        Random c = new Random();
        int fig = c.nextInt(this.treeModel.getChildCount(this.nodeArrel) + 1);
        this.Arbre.setSelectionRow(fig);
        this.Arbre.scrollRowToVisible(fig);
    }

    public DefaultMutableTreeNode tornaNus() {
        DefaultMutableTreeNode nus = (DefaultMutableTreeNode)this.Arbre.getLastSelectedPathComponent();
        if (nus == null) {
            return null;
        }
        if (nus.isLeaf()) {
            return nus;
        }
        return null;
    }

    public void afegeixNus(DefaultMutableTreeNode nus, Configuracio confApp) {
        if (nus != null) {
            this.nodeArrel.add(nus);
            this.actualitzaNodeArrel(confApp);
        }
    }

    public void eliminaNus(DefaultMutableTreeNode nus, Configuracio confApp) {
        if (nus != null & !nus.isRoot()) {
            this.nodeArrel.remove(nus);
            this.actualitzaNodeArrel(confApp);
        }
    }
}

