/*
 * Decompiled with CFR 0.152.
 */
package puzzle.helper;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class PhotoRescaled
extends JComponent {
    private BufferedImage image;
    private double ratio;

    public PhotoRescaled(String imagePath) {
        this(imagePath, 0, 0);
    }

    public PhotoRescaled(String imagePath, int width, int height) {
        try {
            this.image = ImageIO.read(new File(imagePath));
        }
        catch (IOException ioe) {
            System.out.println("Chosen file does not exist \n" + ioe.getMessage());
        }
        if (width == 0 && height == 0) {
            this.ratio = 1.0;
        } else {
            double widthRatio = 1.0;
            if (this.image.getWidth() > width) {
                widthRatio = (double)width / (double)this.image.getWidth();
            }
            double heightRatio = 1.0;
            if (this.image.getHeight() > height) {
                heightRatio = (double)height / (double)this.image.getHeight();
            }
            this.ratio = Math.min(widthRatio, heightRatio);
        }
        Dimension dimension = new Dimension((int)((double)this.image.getWidth() * this.ratio), (int)((double)this.image.getHeight() * this.ratio));
        this.setPreferredSize(dimension);
    }

    public void paintComponent(Graphics g) {
        g.drawImage(this.image, 0, 0, (int)((double)this.image.getWidth(null) * this.ratio), (int)((double)this.image.getHeight(null) * this.ratio), 0, 0, this.image.getWidth(null), this.image.getHeight(null), this);
    }
}

