/*
 * Decompiled with CFR 0.152.
 */
package puzzle.model;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import puzzle.model.Photo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotoModel {
    private String difficultiesFilePath;
    private List<Photo> photos;

    public PhotoModel(String difficultiesFilePath) {
        this.difficultiesFilePath = difficultiesFilePath;
        this.photos = new ArrayList<Photo>();
        this.generatePhotos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePhotos() {
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            String line;
            fr = new FileReader(this.difficultiesFilePath);
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null && !line.isEmpty()) {
                String[] elements = line.split(":");
                ArrayList<String> elementsList = new ArrayList<String>(Arrays.asList(elements));
                List<String> difficulties = elementsList.subList(1, elementsList.size());
                String photoName = (String)elementsList.get(0);
                Photo nextPhoto = new Photo(photoName, difficulties);
                this.photos.add(nextPhoto);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        finally {
            try {
                fr.close();
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
        }
    }

    public List<Photo> getAllPhotos() {
        return this.photos;
    }

    public Photo getPhoto(String name) {
        Photo photo = null;
        for (Photo nextPhoto : this.photos) {
            if (!nextPhoto.getName().equals(name)) continue;
            photo = nextPhoto;
            break;
        }
        return photo;
    }

    public List<String> changeDifficulty(String name, String newDifficulty, String oldDifficulty) {
        Photo thisPhoto = this.getPhoto(name);
        List<String> currentDifficulties = thisPhoto.getDifficulties();
        List<String> newDifficulties = new ArrayList<String>();
        if (oldDifficulty != null && !currentDifficulties.contains(oldDifficulty) || newDifficulty != null && currentDifficulties.contains(newDifficulty)) {
            return newDifficulties;
        }
        if (oldDifficulty != null) {
            currentDifficulties.remove(oldDifficulty);
        }
        if (newDifficulty != null) {
            String[] newElements = newDifficulty.split("x");
            for (String thisDifficulty : currentDifficulties) {
                String[] thisElements = thisDifficulty.split("x");
                if (Integer.parseInt(newElements[0]) * Integer.parseInt(newElements[1]) > Integer.parseInt(thisElements[0]) * Integer.parseInt(thisElements[1])) continue;
                currentDifficulties.add(currentDifficulties.indexOf(thisDifficulty), newDifficulty);
                break;
            }
            if (!currentDifficulties.contains(newDifficulty)) {
                currentDifficulties.add(newDifficulty);
            }
        }
        newDifficulties = this.saveDifficulties(name, currentDifficulties);
        return newDifficulties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> saveDifficulties(String name, List<String> labels) {
        Photo thisPhoto = this.getPhoto(name);
        OutputStreamWriter fw = null;
        PrintWriter pw = null;
        try {
            thisPhoto.setDifficulties(labels);
            fw = new FileWriter(this.difficultiesFilePath, false);
            pw = new PrintWriter(fw);
            pw.println();
            fw = new FileWriter(this.difficultiesFilePath, true);
            pw = new PrintWriter(fw);
            for (Photo photo : this.photos) {
                List<String> difficulties = photo.getDifficulties();
                String line = photo.getName();
                for (String level : difficulties) {
                    line = line + ":" + level;
                }
                pw.print(line);
                pw.println();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
        }
        return thisPhoto.getDifficulties();
    }
}

