/*
 * Decompiled with CFR 0.152.
 */
package puzzle.model;

import java.io.File;
import java.io.IOException;
import java.util.List;
import puzzle.model.Photo;
import puzzle.model.PhotoModel;
import puzzle.model.Record;
import puzzle.model.RecordsModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PuzzleModel {
    private String difficultiesFilePath;
    private String moveRecordsDirectoryPath;
    private String timeRecordsDirectoryPath;

    public PuzzleModel(String difficultiesFilePath, String moveRecordsDirectoryPath, String timeRecordsDirectoryPath) {
        this.difficultiesFilePath = difficultiesFilePath;
        this.moveRecordsDirectoryPath = moveRecordsDirectoryPath;
        this.timeRecordsDirectoryPath = timeRecordsDirectoryPath;
    }

    public List<Record> getAllMoveRecords(String recordsFileName) {
        String moveRecordsFilePath = this.moveRecordsDirectoryPath + recordsFileName;
        String timeRecordsFilePath = this.timeRecordsDirectoryPath + recordsFileName;
        RecordsModel rm = new RecordsModel(moveRecordsFilePath, timeRecordsFilePath);
        return rm.getAllMoveRecords();
    }

    public List<Record> getAllTimeRecords(String recordsFileName) {
        String moveRecordsFilePath = this.moveRecordsDirectoryPath + recordsFileName;
        String timeRecordsFilePath = this.timeRecordsDirectoryPath + recordsFileName;
        RecordsModel rm = new RecordsModel(moveRecordsFilePath, timeRecordsFilePath);
        return rm.getAllTimeRecords();
    }

    public void clearRecords(String recordsFileName) {
        String moveRecordsFilePath = this.moveRecordsDirectoryPath + recordsFileName;
        String timeRecordsFilePath = this.timeRecordsDirectoryPath + recordsFileName;
        RecordsModel rm = new RecordsModel(moveRecordsFilePath, timeRecordsFilePath);
        rm.clearRecords();
    }

    public Record tryRecord(String recordsFileName, String name, double result, String type) {
        String moveRecordsFilePath = this.moveRecordsDirectoryPath + recordsFileName;
        String timeRecordsFilePath = this.timeRecordsDirectoryPath + recordsFileName;
        RecordsModel rm = new RecordsModel(moveRecordsFilePath, timeRecordsFilePath);
        return rm.tryRecord(name, result, type);
    }

    public List<Photo> getAllPhotos() {
        PhotoModel pm = new PhotoModel(this.difficultiesFilePath);
        return pm.getAllPhotos();
    }

    public Photo getPhoto(String name) {
        PhotoModel pm = new PhotoModel(this.difficultiesFilePath);
        return pm.getPhoto(name);
    }

    public List<String> changeDifficulty(String name, String newDifficulty, String oldDifficulty) {
        PhotoModel pm = new PhotoModel(this.difficultiesFilePath);
        List<String> labels = pm.changeDifficulty(name, newDifficulty, oldDifficulty);
        if (!labels.isEmpty()) {
            if (oldDifficulty != null) {
                this.manageRecordsFiles(name, oldDifficulty, false);
            }
            if (newDifficulty != null) {
                this.manageRecordsFiles(name, newDifficulty, true);
            }
        }
        return labels;
    }

    private void manageRecordsFiles(String imageName, String level, boolean create) {
        String recordsFileName = imageName + "_" + level + ".txt";
        String moveRecordsFilePath = this.moveRecordsDirectoryPath + recordsFileName;
        String timeRecordsFilePath = this.timeRecordsDirectoryPath + recordsFileName;
        File moveRecordsFile = new File(moveRecordsFilePath);
        File timeRecordsFile = new File(timeRecordsFilePath);
        try {
            if (create) {
                moveRecordsFile.createNewFile();
                timeRecordsFile.createNewFile();
            } else {
                moveRecordsFile.delete();
                timeRecordsFile.delete();
            }
        }
        catch (IOException ioe) {
            System.out.println("Error while Creating a file" + ioe);
        }
    }
}

