/*
 * Decompiled with CFR 0.152.
 */
package puzzle.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.Border;
import puzzle.helper.PhotoComponent;
import puzzle.helper.PhotoRescaled;
import puzzle.model.PuzzleModel;
import puzzle.model.Record;
import puzzle.view.StartPageGui;

public class PlayPuzzleGui
extends WindowAdapter {
    private JFrame f;
    private JTextField tf;
    private JPanel pSouth;
    private PuzzleModel pm;
    private String recordFileName;
    private String imagePath;
    private int xCoordinate;
    private int yCoordinate;
    private String playerName;
    private List<PhotoComponent> properList = new ArrayList<PhotoComponent>();
    private List<PhotoComponent> randomList = new ArrayList<PhotoComponent>();
    private Timer stopWatch;
    private int same;
    private int swaps;

    public PlayPuzzleGui(PuzzleModel pm, String recordFileName, String imagePath, int xCoordinate, int yCoordinate, String playerName) {
        this.pm = pm;
        this.recordFileName = recordFileName;
        this.imagePath = imagePath;
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        this.playerName = playerName;
        this.initializeListVariables();
        this.launchFrame();
    }

    private void initializeListVariables() {
        ArrayList<PhotoComponent> helperList = new ArrayList<PhotoComponent>();
        MouseClickedHandler mouseClickedHandler = new MouseClickedHandler();
        for (int j = 1; j <= this.yCoordinate; ++j) {
            for (int i = 1; i <= this.xCoordinate; ++i) {
                PhotoComponent pc = new PhotoComponent(this.imagePath, this.xCoordinate, this.yCoordinate, i, j);
                pc.addMouseListener(mouseClickedHandler);
                this.properList.add(pc);
                helperList.add(pc);
            }
        }
        while (helperList.size() > 2) {
            PhotoComponent properImage;
            int max = helperList.size();
            int randomNumber = (int)(Math.random() * (double)max);
            PhotoComponent randomImage = (PhotoComponent)helperList.get(randomNumber);
            if (randomImage.equals(properImage = this.properList.get(this.randomList.size()))) {
                helperList.remove(randomNumber);
                int secondRandomNumber = (int)(Math.random() * (double)(max - 1));
                PhotoComponent secondRandomImage = (PhotoComponent)helperList.get(secondRandomNumber);
                this.randomList.add(secondRandomImage);
                helperList.set(secondRandomNumber, randomImage);
                continue;
            }
            this.randomList.add(randomImage);
            helperList.remove(randomNumber);
        }
        int firstRandomNumber = (int)(Math.random() * 2.0);
        PhotoComponent firstRandomImage = (PhotoComponent)helperList.get(firstRandomNumber);
        helperList.remove(firstRandomNumber);
        PhotoComponent secondRandomImage = (PhotoComponent)helperList.get(0);
        PhotoComponent firstProperImage = this.properList.get(this.randomList.size());
        PhotoComponent secondProperImage = this.properList.get(this.randomList.size() + 1);
        if (firstRandomImage.equals(firstProperImage) || secondRandomImage.equals(secondProperImage)) {
            this.randomList.add(secondRandomImage);
            this.randomList.add(firstRandomImage);
            helperList.remove(0);
        } else {
            this.randomList.add(firstRandomImage);
            this.randomList.add(secondRandomImage);
            helperList.remove(0);
        }
    }

    private void launchFrame() {
        this.initializeFrameComponents();
        this.f = new JFrame("Puzzle - game");
        this.f.add((Component)this.tf, "North");
        this.f.add((Component)this.pSouth, "Center");
        this.f.pack();
        this.f.setResizable(false);
        this.f.setDefaultCloseOperation(2);
        this.f.setVisible(true);
        this.f.addWindowListener(this);
    }

    private void initializeFrameComponents() {
        this.tf = new JTextField();
        this.tf.setEditable(false);
        this.swaps = 0;
        this.same = 0;
        for (int i = 0; i < this.properList.size(); ++i) {
            if (!this.properList.get(i).equals(this.randomList.get(i))) continue;
            ++this.same;
        }
        final long startTime = System.currentTimeMillis();
        this.stopWatch = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SimpleDateFormat sdf = new SimpleDateFormat("mm.ss");
                long time = System.currentTimeMillis() - startTime;
                PlayPuzzleGui.this.tf.setText("Swaps: " + PlayPuzzleGui.this.swaps + "  Elements: " + PlayPuzzleGui.this.same + "/" + PlayPuzzleGui.this.xCoordinate * PlayPuzzleGui.this.yCoordinate + "  Time: " + sdf.format(time));
            }
        });
        this.stopWatch.start();
        this.pSouth = new JPanel();
        this.pSouth.setLayout(new GridLayout(this.yCoordinate, this.xCoordinate));
        for (PhotoComponent printedImage : this.randomList) {
            this.pSouth.add(printedImage);
        }
    }

    public void windowClosed(WindowEvent e) {
        this.pSouth.removeAll();
        this.randomList.clear();
        this.properList.clear();
    }

    class MouseClickedHandler
    extends MouseAdapter {
        PhotoComponent currentImage = null;
        PhotoComponent previousImage = null;
        boolean firstClick = true;

        MouseClickedHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            this.currentImage = (PhotoComponent)e.getSource();
            if (this.previousImage == null) {
                if (this.firstClick) {
                    this.firstClick = false;
                }
                Border blueBorder = null;
                blueBorder = BorderFactory.createLineBorder(Color.BLUE, 2);
                this.currentImage.setBorder(blueBorder);
                PlayPuzzleGui.this.pSouth.repaint();
                this.previousImage = this.currentImage;
                this.currentImage = null;
            } else if (PlayPuzzleGui.this.randomList.indexOf(this.previousImage) == PlayPuzzleGui.this.randomList.indexOf(this.currentImage)) {
                Border noBorder = null;
                this.previousImage.setBorder(noBorder);
                PlayPuzzleGui.this.pSouth.repaint();
                this.previousImage = null;
                this.currentImage = null;
            } else {
                Border noBorder = null;
                this.previousImage.setBorder(noBorder);
                int previousPosition = PlayPuzzleGui.this.randomList.indexOf(this.previousImage);
                int currentPosition = PlayPuzzleGui.this.randomList.indexOf(this.currentImage);
                PlayPuzzleGui.this.randomList.set(previousPosition, this.currentImage);
                PlayPuzzleGui.this.randomList.set(currentPosition, this.previousImage);
                for (PhotoComponent printedImage : PlayPuzzleGui.this.randomList) {
                    PlayPuzzleGui.this.pSouth.add(printedImage);
                }
                this.previousImage = null;
                this.currentImage = null;
                PlayPuzzleGui.this.swaps = PlayPuzzleGui.this.swaps + 1;
                PlayPuzzleGui.this.same = 0;
                for (int i = 0; i < PlayPuzzleGui.this.properList.size(); ++i) {
                    if (!((PhotoComponent)PlayPuzzleGui.this.properList.get(i)).equals(PlayPuzzleGui.this.randomList.get(i))) continue;
                    PlayPuzzleGui.this.same = PlayPuzzleGui.this.same + 1;
                }
                if (((Object)PlayPuzzleGui.this.properList).equals(PlayPuzzleGui.this.randomList)) {
                    PlayPuzzleGui.this.stopWatch.stop();
                    PlayPuzzleGui.this.properList.clear();
                    PlayPuzzleGui.this.randomList.clear();
                    String[] text = PlayPuzzleGui.this.tf.getText().split(" ");
                    String timeString = text[text.length - 1];
                    double timeTaken = Double.parseDouble(timeString);
                    PlayPuzzleGui.this.tf.setText("Swaps: " + PlayPuzzleGui.this.swaps + "   Elements: " + PlayPuzzleGui.this.same + "/" + PlayPuzzleGui.this.xCoordinate * PlayPuzzleGui.this.yCoordinate + "   Time: " + timeString);
                    PhotoRescaled photo = new PhotoRescaled(PlayPuzzleGui.this.imagePath);
                    PlayPuzzleGui.this.pSouth.removeAll();
                    PlayPuzzleGui.this.f.remove(PlayPuzzleGui.this.pSouth);
                    PlayPuzzleGui.this.f.add(photo);
                    Record newMoveRecord = PlayPuzzleGui.this.pm.tryRecord(PlayPuzzleGui.this.recordFileName, PlayPuzzleGui.this.playerName, PlayPuzzleGui.this.swaps, "move");
                    Record newTimeRecord = PlayPuzzleGui.this.pm.tryRecord(PlayPuzzleGui.this.recordFileName, PlayPuzzleGui.this.playerName, timeTaken, "time");
                    List<Record> moveRecordsList = PlayPuzzleGui.this.pm.getAllMoveRecords(PlayPuzzleGui.this.recordFileName);
                    List<Record> timeRecordsList = PlayPuzzleGui.this.pm.getAllTimeRecords(PlayPuzzleGui.this.recordFileName);
                    String noOfElements = PlayPuzzleGui.this.xCoordinate + "x" + PlayPuzzleGui.this.yCoordinate;
                    StartPageGui.displayRecords(PlayPuzzleGui.this.imagePath, moveRecordsList, timeRecordsList, noOfElements, newMoveRecord, newTimeRecord);
                }
            }
        }
    }
}

