package puzzle.helper;


import javax.imageio.ImageIO;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.image.BufferedImage;


// This class paints pieces of a given image.
public class PhotoComponent extends JComponent {
    
    private BufferedImage image;
    private int xCoordinate;
    private int yCoordinate;
    private int i;
    private int j;   
    
    
    public PhotoComponent(String imagePath, int xCoordinate, int yCoordinate, int i, int j) {
        
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        this.i = i;
        this.j = j;

        try {
            image = ImageIO.read(new File(imagePath));
        } catch (IOException ioe) {
            System.out.println("Chosen file does not exist \n" + ioe.getMessage());
        }
        
        Dimension dimension = new Dimension( image.getWidth()/xCoordinate , image.getHeight()/yCoordinate );
	setPreferredSize(dimension);
        
    }
    
    
    @Override
    public void paintComponent(Graphics g){
        g.drawImage(image, 0 , 0, image.getWidth(null)/xCoordinate , image.getHeight(null)/yCoordinate ,
                    image.getWidth(null)*(i-1)/xCoordinate , image.getHeight(null)*(j-1)/yCoordinate , 
                    image.getWidth(null)*i/xCoordinate , image.getHeight(null)*j/yCoordinate , null);
    }   
    
    
}