/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.GeneticCode;
import biogenesis.Messages;
import biogenesis.World;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class BioFileFilter
extends FileFilter {
    private String validExtension = "";
    public static final String WORLD_EXTENSION = "bgw";
    public static final String GENETIC_CODE_EXTENSION = "bgg";

    public BioFileFilter(String ext) {
        this.validExtension = ext;
    }

    public String getValidExtension() {
        return this.validExtension;
    }

    public BioFileFilter(Object obj) {
        if (obj instanceof World) {
            this.validExtension = WORLD_EXTENSION;
        }
        if (obj instanceof GeneticCode) {
            this.validExtension = GENETIC_CODE_EXTENSION;
        }
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            extension = s.substring(i + 1).toLowerCase();
        }
        return extension != null && extension.equals(this.validExtension);
    }

    @Override
    public String getDescription() {
        if (this.validExtension.equals(WORLD_EXTENSION)) {
            return Messages.getString("T_BIOGENESIS_WORLD_FILES");
        }
        if (this.validExtension.equals(GENETIC_CODE_EXTENSION)) {
            return Messages.getString("T_BIOGENESIS_GENETIC_CODE_FILES");
        }
        if (this.validExtension.equals("png")) {
            return Messages.getString("T_PNG_IMAGE_FILES");
        }
        return null;
    }
}

