/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.GeneticCode;
import biogenesis.InCorridor;
import biogenesis.MainWindow;
import biogenesis.Messages;
import biogenesis.NetSend;
import biogenesis.OutCorridor;
import biogenesis.Utils;
import java.net.InetAddress;
import java.util.Timer;
import java.util.TimerTask;

public class Connection {
    protected InetAddress remoteAddress;
    protected int remotePort;
    protected int state;
    protected int netCode;
    protected MainWindow mainWindow;
    private static final long CHECK_CONNECTION_TIME = 30000L;
    private long time;
    private Timer timer;
    protected InCorridor inCorridor;
    protected OutCorridor outCorridor;
    public static final int STATE_DISCONNECTED = 50;
    public static final int STATE_CONNECTED = 51;
    public static final int STATE_NOT_INITIALIZED = 52;

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public Connection(MainWindow app, InetAddress a, int p) {
        this.remotePort = p;
        this.remoteAddress = a;
        this.state = 52;
        this.netCode = Utils.random.nextInt();
        this.mainWindow = app;
        this.createCorridors();
    }

    public Connection(MainWindow app, InetAddress a, int p, int nCode) {
        this.remotePort = p;
        this.remoteAddress = a;
        this.state = 52;
        this.netCode = nCode;
        this.mainWindow = app;
        this.createCorridors();
    }

    private void createCorridors() {
        this.inCorridor = new InCorridor(this.mainWindow.getWorld());
        this.outCorridor = new OutCorridor(this.mainWindow.getWorld(), this);
    }

    public void send(int m) {
        NetSend n = new NetSend(this, m, null);
        n.start();
    }

    public void send(GeneticCode c) {
        NetSend n = new NetSend(this, 8, c);
        n.start();
    }

    public void setState(int newState) {
        if (this.state != newState) {
            if (newState == 51) {
                this.mainWindow.getWorld().addCorridors(this.inCorridor, this.outCorridor);
                this.keepAliveThread();
                this.mainWindow.setStatusMessage(Messages.getString("T_CONNECTION_STABLISHED", this.remoteAddress.toString()));
            }
            if (newState == 50) {
                if (this.timer != null) {
                    this.timer.cancel();
                }
                this.mainWindow.setStatusMessage(Messages.getString("T_CONNECTION_LOST", this.remoteAddress.toString()));
                this.mainWindow.getWorld().removeCorridors(this.inCorridor, this.outCorridor);
                this.mainWindow.serverThread.removeConnection(this);
            }
        }
        this.state = newState;
    }

    public int getState() {
        return this.state;
    }

    public void connect() {
        NetSend n = new NetSend(this, 1, null);
        n.start();
    }

    public void resetTime() {
        this.time = System.currentTimeMillis();
    }

    private void keepAliveThread() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.resetTime();
        this.timer = new Timer();
        TimerTask keepAliveTask = new TimerTask(){

            @Override
            public void run() {
                Connection.this.keepAlive();
            }
        };
        this.timer.schedule(keepAliveTask, 30000L, 30000L);
    }

    protected void keepAlive() {
        if (System.currentTimeMillis() - this.time > 30000L) {
            NetSend n = new NetSend(this, 13, null);
            n.start();
        }
    }
}

