/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.Connection;
import biogenesis.GeneticCode;
import biogenesis.MainWindow;
import biogenesis.Messages;
import biogenesis.Utils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NetServerThread
extends Thread {
    protected InetAddress address;
    protected int port;
    protected ServerSocket serverSocket;
    protected Socket listenSocket;
    protected int state;
    protected int netCode = 0;
    protected int receivedMessage;
    protected boolean isActive;
    protected GeneticCode code;
    protected List<Connection> connections = Collections.synchronizedList(new ArrayList());
    protected MainWindow mainWindow;
    private ObjectInputStream ois;
    private ObjectOutputStream oos;
    public static final int CONNECT = 1;
    public static final int CONNECTED = 2;
    public static final int ALREADY_CONNECTED = 3;
    public static final int TOO_MANY_CONNECTIONS = 4;
    public static final int DISCONNECT = 5;
    public static final int NOT_ACCEPTING_CONNECTIONS = 6;
    public static final int NOT_CONNECTED = 7;
    public static final int SEND_CODE = 8;
    public static final int WAITING_CODE = 9;
    public static final int CODE_RECEIVED = 10;
    public static final int TOO_MANY_CODES = 11;
    public static final int GAME_PAUSED = 12;
    public static final int KEEP_ALIVE = 13;
    public static final int ACK_KEEP_ALIVE = 14;
    public static final int DISCONNECTED = 15;
    public static final int INCOMPATIBLE_PROGRAM_VERSION = 16;
    public static final int STATE_DISCONNECTED = 50;
    public static final int STATE_CONNECTED = 51;

    public static String messageToString(int message) {
        switch (message) {
            case 1: {
                return "CONNECT";
            }
            case 2: {
                return "CONNECTED";
            }
            case 3: {
                return "ALREADY_CONNECTED";
            }
            case 4: {
                return "TOO_MANY_CONNECTIONS";
            }
            case 5: {
                return "DISCONNECT";
            }
            case 6: {
                return "NOT_ACCEPTING_CONNECTIONS";
            }
            case 7: {
                return "NOT_CONNECTED";
            }
            case 8: {
                return "SEND_CODE";
            }
            case 9: {
                return "WAITING_CODE";
            }
            case 10: {
                return "CODE_RECEIVED";
            }
            case 11: {
                return "TOO_MANY_CODES";
            }
            case 12: {
                return "GAME_PAUSED";
            }
            case 13: {
                return "KEEP_ALIVE";
            }
            case 14: {
                return "ACK_KEEP_ALIVE";
            }
            case 15: {
                return "DISCONNECTED";
            }
            case 16: {
                return "INCOMPATIBLE_PROGRAM_VERSION";
            }
        }
        return "Non existant code";
    }

    public boolean isActive() {
        return this.isActive;
    }

    public NetServerThread(MainWindow app) {
        this.mainWindow = app;
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public Connection newConnection(InetAddress remoteAddress, int remotePort) {
        this.address = remoteAddress;
        this.port = remotePort;
        Connection c = this.checkConnectionDuplicity();
        if (c != null) {
            return null;
        }
        c = new Connection(this.mainWindow, remoteAddress, remotePort);
        this.connections.add(c);
        return c;
    }

    private Connection newConnection() {
        Connection c = this.checkConnectionDuplicity();
        if (c != null) {
            return null;
        }
        c = new Connection(this.mainWindow, this.address, this.port, this.netCode);
        this.connections.add(c);
        return c;
    }

    public void removeConnection(Connection c) {
        this.connections.remove(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeServer() {
        this.isActive = false;
        List<Connection> list = this.connections;
        synchronized (list) {
            for (Connection c : this.connections) {
                c.send(5);
                c.setState(15);
            }
        }
        this.connections = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public void run() {
        this.isActive = true;
        try {
            this.serverSocket = new ServerSocket(Utils.LOCAL_PORT);
            this.mainWindow.setStatusMessage(Messages.getString("T_NET_SERVER_LISTENING_ON_PORT", Integer.toString(Utils.LOCAL_PORT)));
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                this.mainWindow.setStatusMessage(Messages.getString("T_PORT_ALREADY_IN_USE", Integer.toString(Utils.LOCAL_PORT)));
            } else {
                e.printStackTrace();
            }
            this.isActive = false;
        }
        while (this.isActive) {
            try {
                try {
                    this.listenSocket = this.serverSocket.accept();
                    this.ois = new ObjectInputStream(this.listenSocket.getInputStream());
                    this.oos = new ObjectOutputStream(this.listenSocket.getOutputStream());
                    this.receivedMessage = this.ois.readInt();
                    System.out.println(NetServerThread.messageToString(this.receivedMessage));
                    switch (this.receivedMessage) {
                        case 1: {
                            this.handleConnect();
                            break;
                        }
                        case 8: {
                            this.handleSendCode();
                            break;
                        }
                        case 13: {
                            this.handleKeepAlive();
                            break;
                        }
                        case 5: {
                            this.handleDisconnect();
                        }
                    }
                    this.ois.close();
                    this.oos.close();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                    if (this.listenSocket == null) continue;
                    try {
                        this.listenSocket.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (this.listenSocket != null) {
                    try {
                        this.listenSocket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (this.listenSocket == null) continue;
            try {
                this.listenSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleDisconnect() {
        block4: {
            Connection c = null;
            try {
                this.netCode = this.ois.readInt();
                c = this.checkConnectionNetCode();
                if (c != null && c.getState() == 51) {
                    this.oos.writeInt(15);
                    this.oos.flush();
                    System.out.println("->DISCONNECTED");
                    c.setState(50);
                } else {
                    System.out.println("->NOT_CONNECTED");
                    this.oos.writeInt(7);
                    this.oos.flush();
                }
            }
            catch (IOException e) {
                System.out.println("handleDisconnect: " + e.getMessage());
                if (c == null) break block4;
                c.setState(50);
                System.out.println("Connection closed with " + c.remoteAddress + ":" + c.remotePort);
            }
        }
    }

    private void handleKeepAlive() {
        block4: {
            Connection c = null;
            try {
                this.netCode = this.ois.readInt();
                c = this.checkConnectionNetCode();
                if (c != null && c.getState() == 51) {
                    this.oos.writeInt(14);
                    this.oos.flush();
                    System.out.println("->ACK_KEEP_ALIVE");
                } else {
                    System.out.println("->NOT_CONNECTED");
                    this.oos.writeInt(7);
                    this.oos.flush();
                }
            }
            catch (IOException e) {
                System.out.println("handleKeepAlive: " + e.getMessage());
                if (c == null) break block4;
                c.setState(50);
                System.out.println("Connection closed with " + c.remoteAddress + ":" + c.remotePort);
            }
        }
    }

    private void handleConnect() {
        try {
            int program_version = this.ois.readInt();
            this.port = this.ois.readInt();
            this.address = this.listenSocket.getInetAddress();
            this.netCode = this.ois.readInt();
            Connection c = this.checkConnectionNetCode();
            if (c != null) {
                this.oos.writeInt(3);
                this.oos.flush();
                System.out.println("->ALREADY_CONNECTED");
            } else if (this.mainWindow.isAcceptingConnections()) {
                if (this.connections.size() < Utils.MAX_CONNECTIONS) {
                    if (800 == program_version) {
                        Connection newConnection = this.newConnection();
                        if (newConnection != null) {
                            this.oos.writeInt(2);
                            newConnection.setState(51);
                            System.out.println("->CONNECTED");
                        } else {
                            this.oos.writeInt(3);
                            System.out.println("->ALREADY_CONNECTED");
                        }
                        this.oos.flush();
                    } else {
                        this.oos.writeInt(16);
                        this.oos.flush();
                        System.out.println("->INCOMPATIBLE_PROGRAM_VERSION");
                    }
                } else {
                    this.oos.writeInt(4);
                    this.oos.flush();
                    System.out.println("->TOO_MANY_CONNECTIONS");
                }
            } else {
                this.oos.writeInt(6);
                this.oos.flush();
                System.out.println("->NOT_ACCEPTING_CONNECTIONS");
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void handleSendCode() {
        block6: {
            Connection c = null;
            try {
                this.netCode = this.ois.readInt();
                c = this.checkConnectionNetCode();
                if (c != null && c.getState() == 51) {
                    this.oos.writeInt(9);
                    this.oos.flush();
                    System.out.println("->WAITING_CODE");
                    this.code = (GeneticCode)this.ois.readObject();
                    System.out.println("Genetic code");
                    this.oos.writeInt(10);
                    this.oos.flush();
                    System.out.println("->CODE_RECEIVED");
                    c.inCorridor.receiveOrganism(this.code);
                } else {
                    System.out.println("->NOT_CONNECTED");
                    this.oos.writeInt(7);
                    this.oos.flush();
                }
            }
            catch (IOException e) {
                System.out.println("handleSendCode: " + e.getMessage());
                if (c != null) {
                    c.setState(50);
                    System.out.println("Connection closed with " + c.remoteAddress + ":" + c.remotePort);
                }
            }
            catch (ClassNotFoundException e) {
                System.out.println("handleSendCode: " + e.getMessage());
                if (c == null) break block6;
                c.setState(50);
                System.out.println("Connection closed with " + c.remoteAddress + ":" + c.remotePort);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection checkConnectionNetCode() {
        List<Connection> list = this.connections;
        synchronized (list) {
            for (Connection c : this.connections) {
                if (c.netCode != this.netCode) continue;
                return c;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection checkConnectionDuplicity() {
        List<Connection> list = this.connections;
        synchronized (list) {
            for (Connection c : this.connections) {
                if (!c.remoteAddress.equals(this.address) || c.remotePort != this.port) continue;
                System.out.println("Duplicated connection");
                return c;
            }
        }
        return null;
    }
}

