/*
 * Decompiled with CFR 0.152.
 */
package life.v41d;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import life.v41d.DescribeBox;
import life.v41d.LifeButton;
import life.v41d.LifeCallback;
import life.v41d.LifeGUI;
import life.v41d.LifeGen;
import life.v41d.LifeQueue;
import life.v41d.LoadBox;
import life.v41d.OptionsBox;
import life.v41d.RuleBox;
import life.v41d.SpeedBox;

class Life
extends Panel
implements Runnable,
LifeCallback {
    private boolean initFlag;
    private boolean dragState;
    private int origX;
    private int origY;
    private LifeGUI f;
    private LifeGen u;
    private int drawX;
    private int drawY;
    private static final int REPAINT_DEFERRED = -2;
    private static final int REPAINT_UNEXPECTED = -1;
    private static final int REPAINT_FULL = 1;
    private static final int REPAINT_ONECELL = 2;
    private static final int REPAINT_UPDATE = 3;
    private int updateState = -1;
    private Thread twin;
    private Button goBtn = null;
    private Choice goHowFar = null;
    private Button clearBtn = null;
    private Button speedBtn = null;
    private Button rulesBtn = null;
    private Button optionsBtn = null;
    private Button openBtn = null;
    private Label zoomLabel = null;
    private Choice zoomChoice = null;
    private Label blankLabel = null;
    private Label blankLabel2 = null;
    private Button quitBtn = null;
    private int zoom;
    private Scrollbar hbar = null;
    private Scrollbar vbar = null;
    private int how_many;
    private int refresh_rate;
    private int skipping;
    private int default_refresh_rate;
    private int default_skipping;
    private String load_param;
    private String set_rules;
    private boolean new_rules;
    private boolean clearonload = true;
    private Vector description = null;
    private int descriptionlen = 0;
    private int descriptionwid = 0;
    private LoadBox openBx;
    private SpeedBox spdBx;
    private RuleBox rulBx;
    private OptionsBox optBx;
    private DescribeBox descBx = null;
    private LifeQueue lifeQueue = null;
    private boolean realGoFlag;
    private Image offscreenImage;
    private Graphics offscreenGraphics;
    private Image countImage;
    private Graphics countGraphics;
    private FontMetrics countMetrics;
    private int countSpot = 0;
    private int countWid = 60;
    private int countY = 0;
    private int countCY;
    private int countCH;
    private int countXOld = 0;
    private int countstrlenOld = 0;
    private boolean isCountThere = false;
    private boolean editable = true;
    private boolean describe = true;
    private int scrollValue = 0;
    public static Object mutex = new Object();
    private boolean gnoset = true;
    private int frameWidth;
    private int frameHeight;
    private int toolbarHeight = 25;
    private boolean grids = true;
    private String fgcolor;
    private String bgcolor;
    private String gridcolor;
    private int scrollbarwidth;
    private String toolbar;
    private String howfarChoices;

    Life() {
    }

    public void init() {
        this.zoom = LifeButton.zoom;
        this.load_param = LifeButton.load_param;
        this.refresh_rate = this.default_refresh_rate = LifeButton.refresh_rate;
        this.skipping = this.default_skipping = LifeButton.skipping;
        this.openBx = new LoadBox(this);
        this.openBx.setTitle("Patterns");
        this.set_rules = LifeButton.rules != null ? new String(LifeButton.rules) : null;
        this.rulBx = new RuleBox(this);
        this.rulBx.setTitle("Life Rules");
        this.rulBx.setResizable(false);
        this.spdBx = new SpeedBox(this);
        this.spdBx.setTitle("Life Speed");
        this.spdBx.setResizable(false);
        this.optBx = new OptionsBox(this);
        this.optBx.setTitle("Life Options");
        this.optBx.setResizable(false);
        this.fgcolor = LifeButton.fgcolor;
        this.bgcolor = "ffffff";
        this.gridcolor = LifeButton.gridcolor;
        this.scrollbarwidth = LifeButton.scrollbarwidth;
        this.toolbar = LifeButton.toolbar;
        if (this.toolbar.length() == 0) {
            this.toolbarHeight = 0;
        }
        this.grids = LifeButton.grids;
        this.editable = LifeButton.editable;
        this.describe = LifeButton.describe;
        this.realGoFlag = LifeButton.autostart;
        this.howfarChoices = LifeButton.howfarChoices;
        this.initFlag = true;
        this.origX = 0;
        this.origY = 0;
        this.setupGUIfromFrame(this.zoom);
        this.gnoset = false;
        this.twin = new Thread(this);
        this.twin.setPriority(10);
        this.twin.start();
    }

    private void setupGUIfromFrame(int n) {
        this.frameWidth = this.size().width;
        this.frameHeight = this.size().height;
        int n2 = this.frameWidth - this.scrollbarwidth;
        if (n2 < 0) {
            return;
        }
        int n3 = this.frameHeight - this.toolbarHeight - this.scrollbarwidth + 1;
        if (n3 < 0) {
            return;
        }
        n2 -= n2 % 32;
        n3 -= n3 % 32;
        this.f = new LifeGUI(n2, n3, n, this.toolbarHeight, this.grids);
        this.offscreenImage = this.createImage(n2 + 1, n3 + 1);
        this.offscreenGraphics = this.offscreenImage.getGraphics();
        this.f.setColors(this.fgcolor, this.bgcolor, this.gridcolor);
        this.f.setGraphicsContext(this.offscreenGraphics);
        this.drawComponents(this.toolbar, this.howfarChoices, this.scrollbarwidth, n);
    }

    public void paint(Graphics graphics) {
        if (!this.gnoset) {
            this.f.clear();
            if (this.frameWidth != this.size().width || this.frameHeight != this.size().height) {
                int n = this.f.getCenterX();
                int n2 = this.f.getCenterY();
                this.setupGUIfromFrame(this.f.getZoom());
                this.f.moveTo(n, n2);
            }
            this.f.drawGrid();
            if (this.u != null) {
                this.f.updateAll(this.u);
            }
            this.drawCount();
            graphics.drawImage(this.offscreenImage, 0, this.toolbarHeight, null);
            if (this.isCountThere) {
                graphics.drawImage(this.countImage, this.countSpot, 0, null);
            }
        }
    }

    public void removeAllComponents() {
        if (this.blankLabel2 != null) {
            this.remove(this.blankLabel2);
        }
        if (this.blankLabel != null) {
            this.remove(this.blankLabel);
        }
        if (this.zoomLabel != null) {
            this.remove(this.zoomLabel);
        }
        if (this.goHowFar != null) {
            this.remove(this.goHowFar);
        }
        if (this.zoomChoice != null) {
            this.remove(this.zoomChoice);
        }
        if (this.hbar != null) {
            this.remove(this.hbar);
        }
        if (this.vbar != null) {
            this.remove(this.vbar);
        }
        if (this.goBtn != null) {
            this.remove(this.goBtn);
        }
        if (this.clearBtn != null) {
            this.remove(this.clearBtn);
        }
        if (this.rulesBtn != null) {
            this.remove(this.rulesBtn);
        }
        if (this.speedBtn != null) {
            this.remove(this.speedBtn);
        }
        if (this.optionsBtn != null) {
            this.remove(this.optionsBtn);
        }
        if (this.openBtn != null) {
            this.remove(this.openBtn);
        }
        if (this.quitBtn != null) {
            this.remove(this.quitBtn);
        }
        this.zoomLabel = null;
        this.blankLabel = null;
        this.blankLabel2 = null;
        this.zoomChoice = null;
        this.goHowFar = null;
        this.vbar = null;
        this.hbar = null;
        this.quitBtn = null;
        this.openBtn = null;
        this.speedBtn = null;
        this.optionsBtn = null;
        this.rulesBtn = null;
        this.clearBtn = null;
        this.goBtn = null;
    }

    private void paintAsync(int n) {
        this.updateState = n;
        this.repaint();
    }

    private void paintLife(int n) {
        Object object = mutex;
        synchronized (object) {
            this.updateState = n;
            this.repaint();
            try {
                mutex.wait(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void update(Graphics graphics) {
        Object object = mutex;
        synchronized (object) {
            if (this.updateState < 0) {
                this.updateState = -2;
                mutex.notifyAll();
                return;
            }
            int n = this.updateState;
            this.updateState = -1;
            switch (n) {
                case 3: {
                    if (this.u != null) {
                        this.f.updateAll(this.u);
                    }
                    this.drawCount();
                    graphics.drawImage(this.offscreenImage, 0, this.toolbarHeight, null);
                    if (!this.isCountThere) break;
                    graphics.drawImage(this.countImage, this.countSpot, 0, null);
                    break;
                }
                case 1: {
                    this.paint(graphics);
                    break;
                }
                case 2: {
                    this.f.changeCell(this.drawX, this.drawY);
                    this.f.drawCell(this.drawX, this.drawY);
                    graphics.drawImage(this.offscreenImage, 0, this.toolbarHeight, null);
                }
            }
            mutex.notifyAll();
        }
    }

    private void drawCount() {
        if (this.isCountThere) {
            String string = new Integer(this.u == null ? 0 : this.u.gencount).toString();
            int n = this.countMetrics.stringWidth(string);
            int n2 = this.countWid - n - 1;
            this.countGraphics.clearRect(this.countXOld, this.countCY, this.countstrlenOld, this.countCH);
            this.countGraphics.drawString(string, n2, this.countY);
            this.countXOld = n2;
            this.countstrlenOld = n;
        }
    }

    private void drawComponents(String string, String string2, int n, int n2) {
        int n3;
        String string3;
        int n4 = this.f.oX;
        int n5 = this.f.oY;
        int n6 = this.f.getCellsAcross() * this.f.getPixelsPerCell();
        int n7 = this.f.getCellsDown() * this.f.getPixelsPerCell();
        int n8 = 80;
        int n9 = 56;
        int n10 = 48;
        this.removeAllComponents();
        this.setLayout(null);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n11 = 0;
        int n12 = 1;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.equals("Go")) {
                ++n12;
                continue;
            }
            if (string3.equals("HowFar")) {
                n11 += n8;
                continue;
            }
            if (string3.equals("Clear")) {
                ++n12;
                continue;
            }
            if (string3.equals("Rules")) {
                ++n12;
                continue;
            }
            if (string3.equals("Speed")) {
                ++n12;
                continue;
            }
            if (string3.equals("Options")) {
                ++n12;
                continue;
            }
            if (string3.equals("Open")) {
                ++n12;
                continue;
            }
            if (string3.equals("Zoom")) {
                n11 += n9 + n10;
                continue;
            }
            if (!string3.equals("Count")) continue;
            n11 += this.countWid;
        }
        int n13 = (n6 + n - n11) / n12;
        if (n13 < 40) {
            n13 = 40;
        }
        if (n13 > 100) {
            n13 = 100;
        }
        stringTokenizer = new StringTokenizer(string);
        int n14 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            int n15 = n13;
            if (string3.equals("Go")) {
                this.goBtn = this.realGoFlag ? this.newBtn("Stop", n14, n15) : this.newBtn(" Go ", n14, n15);
                if (this.u == null || this.u.isEmpty()) {
                    this.goBtn.disable();
                }
            } else if (string3.equals("HowFar")) {
                n15 = n8;
                this.goHowFar = new Choice();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
                while (stringTokenizer2.hasMoreTokens()) {
                    this.goHowFar.addItem(stringTokenizer2.nextToken());
                }
                this.addToToolbar(this.goHowFar, n14, n15);
            } else if (string3.equals("Clear")) {
                this.clearBtn = this.newBtn("Clear", n14, n15);
            } else if (string3.equals("Rules")) {
                this.rulesBtn = this.newBtn("Rules", n14, n15);
            } else if (string3.equals("Options")) {
                this.optionsBtn = this.newBtn("Options", n14, n15);
            } else if (string3.equals("Speed")) {
                this.speedBtn = this.newBtn("Speed", n14, n15);
            } else if (string3.equals("Open")) {
                this.openBtn = this.newBtn("Open", n14, n15);
            } else if (string3.equals("Zoom")) {
                n15 = n9 + n10;
                this.zoomLabel = new Label("Zoom:", 2);
                this.addToToolbar(this.zoomLabel, n14, n9);
                this.zoomChoice = new Choice();
                int n16 = 0;
                while (n16 < 6) {
                    this.zoomChoice.addItem(String.valueOf(n16));
                    ++n16;
                }
                this.zoomChoice.select(String.valueOf(n2));
                this.addToToolbar(this.zoomChoice, n14 + n9, n10);
            } else if (string3.equals("Count")) {
                n15 = 0;
                this.countSpot = n6 + n - this.countWid;
                this.countImage = this.createImage(this.countWid, this.toolbarHeight);
                this.countGraphics = this.countImage.getGraphics();
                this.countMetrics = this.countGraphics.getFontMetrics();
                this.countCH = this.countMetrics.getHeight();
                this.countY = (this.toolbarHeight + this.countCH) / 2 - 1;
                this.countCY = this.toolbarHeight - this.countY;
                this.isCountThere = true;
                this.drawCount();
            }
            n14 += n15;
        }
        this.quitBtn = this.newBtn("Quit", n14, n13);
        n14 += n13;
        if (this.goBtn == null) {
            this.realGoFlag = true;
        }
        if (n > 0) {
            this.hbar = new Scrollbar(0);
            this.hbar.setValues(0, 1, -15, 16);
            this.hbar.reshape(n4 - 1, n7 + n5 + this.toolbarHeight, n6 + 1, n - 1);
            this.add(this.hbar);
            this.vbar = new Scrollbar(1);
            this.vbar.setValues(0, 1, -15, 16);
            this.vbar.reshape(n6 + n4, n5 - 1 + this.toolbarHeight, n - 1, n7 + 1);
            this.add(this.vbar);
            this.blankLabel2 = new Label("");
            this.blankLabel2.reshape(n6 + n4, n7 + n5 + this.toolbarHeight, n - 1, n - 1);
            this.add(this.blankLabel2);
        }
        if ((n3 = n6 + n - n14 - (this.isCountThere ? this.countWid : 0)) > 0) {
            this.blankLabel = new Label("");
            this.addToToolbar(this.blankLabel, n14, n6 + n - n14 - (this.isCountThere ? this.countWid : 0));
        }
    }

    private Button newBtn(String string, int n, int n2) {
        Button button = new Button(string);
        this.addToToolbar(button, n, n2);
        return button;
    }

    private void addToToolbar(Component component, int n, int n2) {
        component.reshape(n, 0, n2 - 1, this.toolbarHeight - 1);
        this.add(component);
    }

    public void run() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.lifeQueue == null) {
            this.lifeQueue = new LifeQueue();
        }
        if (this.twin != null && this.initFlag) {
            this.u = new LifeGen(this.set_rules);
            if (this.load_param != null) {
                this.load(this.load_param);
            }
            this.u.setRefresh(1000 / this.refresh_rate);
            this.u.setSpeed(this.skipping);
            this.initFlag = false;
            this.paintLife(1);
        }
        this.u.goFlag = this.realGoFlag;
        while (this.twin != null) {
            if (this.new_rules) {
                this.u.setRules(this.set_rules);
                this.new_rules = false;
            }
            if (this.updateState == -2) {
                this.paintLife(1);
            }
            if (this.u.goFlag) {
                bl = this.u.generate(this.how_many, bl);
                if (this.how_many > 0) {
                    this.realGoFlag = false;
                }
                if (this.lifeQueue.length() == 0) {
                    this.paintLife(this.updateState == -2 ? 1 : 3);
                }
            } else {
                bl = false;
                if (this.goBtn != null) {
                    this.haltGoButton();
                    if (this.u != null) {
                        if (this.u.isEmpty()) {
                            this.goBtn.disable();
                        } else if (this.goHowFar != null && this.goHowFar.getSelectedItem().equals("-1") && !this.u.backCorrect) {
                            this.goBtn.disable();
                        } else {
                            this.goBtn.enable();
                        }
                    } else {
                        this.goBtn.disable();
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.processEvents();
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (!this.editable) {
            return true;
        }
        if (this.u == null || this.f == null) {
            return false;
        }
        this.requestFocus();
        int n3 = this.f.convertAppletToFieldX(n);
        int n4 = this.f.convertAppletToFieldY(n2);
        if (n3 < 0 || n3 >= this.f.getCellsAcross() || n4 < 0 || n4 >= this.f.getCellsDown()) {
            return true;
        }
        this.dragState = !this.f.cellState(n3, n4);
        this.u.changeCell(this.f.convertFieldToUniverseX(n3), this.f.convertFieldToUniverseY(n4), this.dragState);
        this.goBtn.enable();
        this.drawX = n3;
        this.drawY = n4;
        this.paintAsync(2);
        return true;
    }

    public void drawLifeLine(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        boolean bl;
        int n8 = Math.abs(n3 - n);
        boolean bl2 = bl = n8 > (n7 = Math.abs(n4 - n2));
        if (bl) {
            n6 = n7;
            n5 = n8;
        } else {
            n6 = n8;
            n5 = n7;
        }
        int n9 = n3 > n ? 1 : -1;
        int n10 = n4 > n2 ? 1 : -1;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n13 < n5) {
            int n14;
            int n15;
            if (bl) {
                n15 = n + n13 * n9;
                n14 = n2 + n11 * n10;
            } else {
                n15 = n + n11 * n9;
                n14 = n2 + n13 * n10;
            }
            if (this.dragState != this.f.cellState(n15, n14)) {
                this.u.changeCell(this.f.convertFieldToUniverseX(n15), this.f.convertFieldToUniverseY(n14), this.dragState);
            }
            if ((n12 += n6) >= n5) {
                n12 %= n5;
                ++n11;
            }
            ++n13;
        }
        this.goBtn.enable();
        this.paintAsync(3);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (!this.editable) {
            return true;
        }
        if (this.u == null || this.f == null) {
            return false;
        }
        int n3 = this.f.convertAppletToFieldX(n);
        int n4 = this.f.convertAppletToFieldY(n2);
        if (this.drawX == n3 && this.drawY == n4) {
            return true;
        }
        if (n3 < 0 || n3 >= this.f.getCellsAcross() || n4 < 0 || n4 >= this.f.getCellsDown()) {
            return true;
        }
        this.drawLifeLine(this.drawX, this.drawY, n3, n4);
        this.drawX = n3;
        this.drawY = n4;
        return true;
    }

    private void processEvents() {
        Event event;
        while ((event = (Event)this.lifeQueue.pull()) != null) {
            if (event.target instanceof Button) {
                if (event.id == 1001) {
                    this.processButton((String)event.arg);
                    continue;
                }
                this.u.goFlag = this.realGoFlag;
                continue;
            }
            if (event.target == this.zoomChoice) {
                if (this.f.setZoom(Integer.parseInt(this.zoomChoice.getSelectedItem()))) {
                    this.paintLife(1);
                }
                this.u.goFlag = this.realGoFlag;
                continue;
            }
            if (event.target == this.goHowFar) {
                this.u.goFlag = this.realGoFlag;
                continue;
            }
            if (!(event.target instanceof Scrollbar)) continue;
            int n = 0;
            switch (event.id) {
                case 601: {
                    n = -1;
                    break;
                }
                case 603: {
                    n = -this.f.getCellsDown() / 2;
                    if (n != 0) break;
                    n = 1;
                    break;
                }
                case 602: {
                    n = 1;
                    break;
                }
                case 604: {
                    n = this.f.getCellsDown() / 2;
                    if (n != 0) break;
                    n = 1;
                    break;
                }
                case 605: {
                    n = 0;
                    this.hbar.setValue(0);
                    this.vbar.setValue(0);
                }
            }
            if (n != 0) {
                if (event.target == this.hbar) {
                    this.origX += n;
                    this.hbar.setValue(0);
                } else {
                    this.origY += n;
                    this.vbar.setValue(0);
                }
                this.f.moveTo(this.origX, this.origY);
                this.u.freshenView();
                this.paintLife(1);
            }
            this.u.goFlag = this.realGoFlag;
        }
    }

    private void haltGoButton() {
        if (this.goBtn != null && !this.goBtn.getLabel().equals(" Go ")) {
            this.goBtn.setLabel(" Go ");
        }
        this.realGoFlag = false;
        if (this.u != null) {
            this.u.goFlag = false;
        }
    }

    private void processButton(String string) {
        if (string.equals(" Go ")) {
            if (this.goHowFar != null) {
                String string2 = this.goHowFar.getSelectedItem();
                if (string2.startsWith("+")) {
                    string2 = string2.substring(1);
                }
                try {
                    this.how_many = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.how_many = 0;
                }
            } else {
                this.how_many = 0;
            }
            if (this.how_many != 1 && this.how_many != -1) {
                this.goBtn.setLabel("Stop");
            }
            this.realGoFlag = true;
            this.u.goFlag = true;
        } else if (string.equals("Stop")) {
            this.haltGoButton();
            this.paintLife(3);
        } else if (string.equals("Clear")) {
            this.skipping = this.default_skipping;
            this.u.setSpeed(this.skipping);
            this.refresh_rate = this.default_refresh_rate;
            this.u.setRefresh(1000 / this.refresh_rate);
            this.clear();
        } else if (string.equals("Open")) {
            this.openBx.listURL(LifeButton.loaddir);
            this.haltAndShow(this.openBx);
        } else if (string.equals("Rules")) {
            this.rulBx.enterRules(this.u.getRules());
            this.haltAndShow(this.rulBx);
        } else if (string.equals("Speed")) {
            this.spdBx.enterData(this.refresh_rate, this.skipping);
            this.haltAndShow(this.spdBx);
        } else if (string.equals("Options")) {
            this.optBx.enterData(this.clearonload);
            this.haltAndShow(this.optBx);
        } else if (string.equals("Quit")) {
            this.quit();
        }
    }

    private void haltAndShow(Frame frame) {
        this.haltGoButton();
        frame.pack();
        frame.show();
    }

    public void clear() {
        this.haltGoButton();
        this.goBtn.disable();
        this.u.clear();
        this.origY = 0;
        this.origX = 0;
        this.f.moveTo(0, 0);
        if (this.descBx != null) {
            this.descBx.dispose();
        }
        this.descBx = null;
        this.paintLife(1);
    }

    public void quit() {
        if (this.openBx != null) {
            this.openBx.dispose();
        }
        if (this.rulBx != null) {
            this.rulBx.dispose();
        }
        if (this.spdBx != null) {
            this.spdBx.dispose();
        }
        if (this.optBx != null) {
            this.optBx.dispose();
        }
        if (this.descBx != null) {
            this.descBx.dispose();
        }
        ((Frame)this.getParent()).dispose();
        this.twin = null;
    }

    public boolean handleEvent(Event event) {
        if (this.lifeQueue == null) {
            this.lifeQueue = new LifeQueue();
        }
        if (event.target instanceof Scrollbar || event.target instanceof Choice || event.target instanceof Button) {
            this.lifeQueue.push(event);
            if (this.u != null) {
                this.u.goFlag = false;
            }
            return true;
        }
        if (event.target instanceof Frame && event.id == 201) {
            this.quit();
        }
        return super.handleEvent(event);
    }

    public void setRules(String string) {
        this.set_rules = new String(string);
        this.new_rules = true;
        this.haltGoButton();
        this.u.goFlag = false;
    }

    private boolean readLife105(DataInputStream dataInputStream) throws IOException {
        String string;
        int n = 0;
        int n2 = 0;
        String string2 = null;
        this.descriptionwid = 0;
        this.descriptionlen = 0;
        this.description = new Vector();
        while ((string = dataInputStream.readLine()) != null) {
            int n3;
            Object object;
            if (string.startsWith("#D")) {
                object = new StringTokenizer(string);
                ((StringTokenizer)object).nextToken();
                n3 = 2;
                while (n3 < string.length() && string.charAt(n3) == ' ') {
                    ++n3;
                }
                this.addDescriptionLine(string.substring(n3));
                continue;
            }
            if (string.startsWith("#P")) {
                object = new StringTokenizer(string);
                ((StringTokenizer)object).nextToken();
                n = Integer.parseInt(((StringTokenizer)object).nextToken()) + this.origX;
                n2 = Integer.parseInt(((StringTokenizer)object).nextToken()) + this.origY;
                continue;
            }
            if (string.startsWith(".") || string.startsWith("*") || string.startsWith("o") || string.startsWith("O")) {
                n3 = 0;
                while (n3 < string.length()) {
                    char c = string.charAt(n3);
                    if (c == '*' || c == 'o' || c == 'O') {
                        this.u.changeCell(n + n3, n2, true);
                    }
                    ++n3;
                }
                ++n2;
                continue;
            }
            if (string.startsWith("#N")) {
                string2 = new String("23/3");
                continue;
            }
            if (string.startsWith("#R")) {
                object = new StringTokenizer(string);
                ((StringTokenizer)object).nextToken();
                string2 = ((StringTokenizer)object).nextToken();
                continue;
            }
            if (!string.startsWith("#S")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            stringTokenizer.nextToken();
            object = stringTokenizer.nextToken();
            if (object == null) continue;
            this.skipping = Integer.parseInt((String)object);
            if (this.u == null) continue;
            this.u.setSpeed(this.skipping);
        }
        if (string2 != null && string2.length() > 0 && !string2.equals(this.set_rules)) {
            this.set_rules = string2;
            this.u.setRules(string2);
        }
        this.goBtn.enable();
        return true;
    }

    private boolean readRLE(String string, DataInputStream dataInputStream) throws IOException {
        String string2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string3 = "23/3";
        boolean bl = false;
        this.descriptionwid = 0;
        this.descriptionlen = 0;
        this.description = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "= ");
            String string5 = stringTokenizer2.nextToken();
            String string6 = stringTokenizer2.nextToken();
            if (string5.equals("x")) {
                n = n2 = this.origX - Integer.parseInt(string6) / 2;
                continue;
            }
            if (string5.equals("y")) {
                n3 = this.origY - Integer.parseInt(string6) / 2;
                continue;
            }
            if (string5.equals("rule") || string5.equals("rules")) {
                string3 = string6;
                continue;
            }
            if (string5.equals("skip")) {
                this.skipping = Integer.parseInt(string6);
                this.u.setSpeed(this.skipping);
                continue;
            }
            if (!string5.equals("fps")) continue;
            this.refresh_rate = Integer.parseInt(string6);
            this.u.setRefresh(1000 / this.refresh_rate);
        }
        while (!bl) {
            string2 = dataInputStream.readLine();
            if (string2 == null) break;
            int n4 = 0;
            while (n4 < string2.length()) {
                char c = string2.charAt(n4);
                int n5 = 0;
                while (c >= '0' && c <= '9' && n4 < string2.length()) {
                    n5 = n5 * 10 + (c - 48);
                    c = string2.charAt(++n4);
                }
                if (n5 == 0) {
                    n5 = 1;
                }
                if (c == 'b') {
                    n2 += n5;
                } else if (c == 'o') {
                    int n6 = 0;
                    while (n6 < n5) {
                        this.u.changeCell(n2 + n6, n3, true);
                        ++n6;
                    }
                    n2 += n5;
                } else if (c == '$') {
                    n2 = n;
                    n3 += n5;
                } else if (c == '!') {
                    bl = true;
                }
                ++n4;
            }
        }
        if (string3 != null && string3.length() > 0 && !string3.equals(this.set_rules)) {
            this.set_rules = string3;
            this.u.setRules(string3);
        }
        if (bl) {
            while ((string2 = dataInputStream.readLine()) != null) {
                this.addDescriptionLine(string2);
            }
        }
        this.goBtn.enable();
        return true;
    }

    private void addDescriptionLine(String string) {
        this.description.addElement(string);
        if (string.length() > this.descriptionwid) {
            this.descriptionwid = string.length();
        }
        ++this.descriptionlen;
    }

    public boolean load(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(uRL.openStream());
            String string2 = dataInputStream.readLine();
            if (string2.startsWith("#Life 1.05")) {
                this.readLife105(dataInputStream);
                this.paintLife(1);
                return true;
            }
            if (string2.startsWith("x")) {
                this.readRLE(string2, dataInputStream);
                this.paintLife(1);
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    public void callback(int n, Object object) {
        switch (n) {
            case 0: {
                boolean bl;
                if (this.clearonload) {
                    this.clear();
                }
                if (!(bl = this.load((String)object)) || !this.describe || this.descriptionlen <= 0) break;
                if (this.descBx != null) {
                    this.descBx.dispose();
                }
                this.descBx = new DescribeBox(this.descriptionlen + 1, this.descriptionwid + 1);
                int n2 = 0;
                while (n2 < this.descriptionlen) {
                    this.descBx.addLine(new String((String)this.description.elementAt(n2)));
                    ++n2;
                }
                this.descBx.addLine(new String(" "));
                this.descBx.pack();
                this.descBx.setTitle("Description of " + (String)object);
                this.descBx.show();
                break;
            }
            case 1: {
                this.setRules((String)object);
                break;
            }
            case 2: {
                try {
                    this.refresh_rate = Integer.parseInt((String)object);
                    if (this.u != null) {
                        this.u.setRefresh(1000 / this.refresh_rate);
                    }
                    this.default_refresh_rate = this.refresh_rate;
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 3: {
                try {
                    this.skipping = Integer.parseInt((String)object);
                    if (this.u != null) {
                        this.u.setSpeed(this.skipping);
                    }
                    this.default_skipping = this.skipping;
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 4: {
                try {
                    if (Integer.parseInt((String)object) == 0) break;
                    this.goHowFar.addItem((String)object);
                    this.goHowFar.select((String)object);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 5: {
                this.clearonload = (Boolean)object;
            }
        }
    }
}

