/*
 * Decompiled with CFR 0.152.
 */
package life.v41d;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Event;
import java.awt.Frame;
import java.awt.List;
import java.awt.Panel;
import java.io.DataInputStream;
import java.net.URL;
import life.v41d.LifeCallback;

class LoadBox
extends Frame {
    private List list;
    private Panel buttons;
    private String cwd;
    private Button okBtn;
    private Button cxBtn;
    private String choice = null;
    private LifeCallback cb;
    private boolean alreadyListed = false;

    LoadBox(LifeCallback lifeCallback) {
        this.cb = lifeCallback;
        this.list = new List(20, false);
        this.buttons = new Panel();
        this.okBtn = new Button("OK");
        this.buttons.add(this.okBtn);
        this.cxBtn = new Button("Cancel");
        this.buttons.add(this.cxBtn);
        this.setLayout(new BorderLayout());
        this.add("Center", this.list);
        this.add("South", this.buttons);
    }

    public void listURL(String string) {
        if (this.alreadyListed) {
            return;
        }
        this.pack();
        this.show();
        try {
            this.cwd = new String(string);
            if (!this.cwd.endsWith("/")) {
                this.cwd = this.cwd + "/";
            }
            URL uRL = new URL(this.cwd + "index.html");
            this.list.clear();
            this.list.addItem("Please wait...");
            DataInputStream dataInputStream = new DataInputStream(uRL.openStream());
            String string2 = dataInputStream.readLine();
            if (string2 != null) {
                this.list.delItem(0);
                this.list.addItem(string2);
            }
            while ((string2 = dataInputStream.readLine()) != null) {
                this.list.addItem(string2);
            }
        }
        catch (Exception exception) {
            this.list.addItem(exception.toString());
            return;
        }
        this.alreadyListed = true;
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.cxBtn && event.arg != null || event.id == 201) {
            this.dispose();
        } else if ((event.target == this.okBtn || event.id == 1001) && event.arg != null) {
            String string = this.list.getSelectedItem();
            if (string != null && string.length() > 0) {
                this.choice = this.cwd + this.list.getSelectedItem();
                if (!this.choice.toUpperCase().endsWith(".LIF")) {
                    this.choice = this.choice + ".lif";
                }
                this.cb.callback(0, this.choice);
            }
            this.dispose();
        }
        return super.handleEvent(event);
    }

    public synchronized void show() {
        int n = this.list.getSelectedIndex() - 8;
        if (n < 0) {
            n = 0;
        }
        this.list.makeVisible(n);
        super.show();
    }
}

